/*
 * Decompiled with CFR 0.152.
 */
package com.infinite.focus.server.studentstreak.helper;

import com.infinite.focus.server.client.StudentClient;
import com.infinite.focus.server.client.StudentPushNotificationClient;
import com.infinite.focus.server.configuration.repository.ConfigurationRepository;
import com.infinite.focus.server.streak.dto.StreakDTO;
import com.infinite.focus.server.streak.repository.StreakRepository;
import com.infinite.focus.server.student.dto.StudentCoreDTO;
import com.infinite.focus.server.student.request.GetByStudentIdRequest;
import com.infinite.focus.server.studentpushnotification.request.StreakReceivedNotification;
import com.infinite.focus.server.studentstreak.entity.StudentStreak;
import com.infinite.focus.server.studentstreak.repository.StudentStreakRepository;
import java.util.Date;
import org.springframework.stereotype.Component;

@Component
public class StreakHelper {
    private final StudentPushNotificationClient studentPushNotificationClient;
    private final StudentStreakRepository studentStreakRepository;
    private final StreakRepository streakRepository;
    private final ConfigurationRepository configurationRepository;
    private final StudentClient studentClient;

    public StreakHelper(StudentPushNotificationClient studentPushNotificationClient, StudentStreakRepository studentStreakRepository, StreakRepository streakRepository, ConfigurationRepository configurationRepository, StudentClient studentClient) {
        this.studentPushNotificationClient = studentPushNotificationClient;
        this.studentStreakRepository = studentStreakRepository;
        this.streakRepository = streakRepository;
        this.configurationRepository = configurationRepository;
        this.studentClient = studentClient;
    }

    public StreakDTO saveStudentStreak(long student_id, StreakDTO streak) {
        StudentCoreDTO student = this.studentClient.getByStudentId(GetByStudentIdRequest.builder().student_id(student_id).build());
        StudentStreak studentStreak = new StudentStreak();
        studentStreak.setStudent_id(student_id);
        studentStreak.setStreak_id(streak.getStreak_id());
        if (student.isDemo()) {
            long lastId = this.studentStreakRepository.findLastRecordId();
            studentStreak.setStudent_streak_id(lastId);
            studentStreak.setCreatedAt(new Date());
        } else {
            this.studentStreakRepository.save((Object)studentStreak);
        }
        StreakReceivedNotification streakReceivedNotification = StreakReceivedNotification.builder().student_id(student.getStudent_id()).account_id(student.getAccount_id()).demo(student.isDemo()).title(streak.getTitle()).title_es(streak.getTitle_es()).language(student.getLanguage()).build();
        this.studentPushNotificationClient.streakReceived(streakReceivedNotification);
        StreakDTO streakFromStreak = this.streakRepository.findByStreakId(streak.getStreak_id());
        streakFromStreak.setReceived(true);
        streakFromStreak.setImage(this.configurationRepository.getConfiguration().getBaseUrlApi() + streakFromStreak.getImage());
        streakFromStreak.setImage_es(this.configurationRepository.getConfiguration().getBaseUrlApi() + streakFromStreak.getImage_es());
        return streakFromStreak;
    }
}

