/*
 * Decompiled with CFR 0.152.
 */
package com.infinite.focus.server.student.service;

import com.infinite.focus.server.accesscode.dto.AccessCodeDTO;
import com.infinite.focus.server.accesscode.request.UpdateInstructorIdAndParentIdByStudentIdRequest;
import com.infinite.focus.server.account.dto.AccountDTO;
import com.infinite.focus.server.account.repository.AccountRepository;
import com.infinite.focus.server.account.request.GetEmailByAccountIdRequest;
import com.infinite.focus.server.account.view.AccountView;
import com.infinite.focus.server.auth.model.Status;
import com.infinite.focus.server.auth.util.KeyGenerator;
import com.infinite.focus.server.avatar.dto.AvatarDTO;
import com.infinite.focus.server.avatar.request.GetByAvatarIdRequest;
import com.infinite.focus.server.client.AccessCodeClient;
import com.infinite.focus.server.client.AccountClient;
import com.infinite.focus.server.client.AvatarClient;
import com.infinite.focus.server.client.InstructorClient;
import com.infinite.focus.server.client.ParentClient;
import com.infinite.focus.server.client.StandardClient;
import com.infinite.focus.server.client.StudentGroupClient;
import com.infinite.focus.server.client.WallPostClient;
import com.infinite.focus.server.group.entity.Class;
import com.infinite.focus.server.group.repository.ClassRepository;
import com.infinite.focus.server.group.view.ClassView;
import com.infinite.focus.server.instructor.dto.InstructorDTO;
import com.infinite.focus.server.instructor.entity.Instructor;
import com.infinite.focus.server.instructor.request.GetInstructorByIdRequest;
import com.infinite.focus.server.message.service.MessageService;
import com.infinite.focus.server.parent.dto.ParentCoreDTO;
import com.infinite.focus.server.parent.entity.Parent;
import com.infinite.focus.server.parent.request.CreateParentRequest;
import com.infinite.focus.server.parent.request.GetByParentIdRequest;
import com.infinite.focus.server.parent.request.UpdateParentRequest;
import com.infinite.focus.server.standard.dto.StandardDTO;
import com.infinite.focus.server.standard.repository.StandardJPARepository;
import com.infinite.focus.server.standard.request.GetByStandardIdRequest;
import com.infinite.focus.server.student.dto.StudentCoreDTO;
import com.infinite.focus.server.student.dto.StudentDTO;
import com.infinite.focus.server.student.entity.Student;
import com.infinite.focus.server.student.repository.StudentCoreRepository;
import com.infinite.focus.server.student.repository.StudentCriteriaRepository;
import com.infinite.focus.server.student.repository.StudentRepository;
import com.infinite.focus.server.student.request.GetByStudentIdRequest;
import com.infinite.focus.server.student.request.SearchStudentRequest;
import com.infinite.focus.server.student.service.StudentService;
import com.infinite.focus.server.student.wrapper.InstructorDetailWrapper;
import com.infinite.focus.server.student.wrapper.ParentDetailWrapper;
import com.infinite.focus.server.student.wrapper.StudentClassWrapper;
import com.infinite.focus.server.student.wrapper.StudentDetailWrapper;
import com.infinite.focus.server.student.wrapper.StudentIdAndStandardIdWrapper;
import com.infinite.focus.server.student.wrapper.StudentProfileWrapper;
import com.infinite.focus.server.studentgroup.request.GetStudentsByGroupIdsRequest;
import com.infinite.focus.server.toppicks.request.GetByIdRequest;
import com.infinite.focus.server.utils.AppUtils;
import com.infinite.focus.server.utils.DateUtils;
import com.infinite.focus.server.wallpost.request.SyncByStudentIdRequest;
import jakarta.persistence.EntityManager;
import jakarta.persistence.TypedQuery;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Join;
import jakarta.persistence.criteria.JoinType;
import jakarta.persistence.criteria.Predicate;
import jakarta.persistence.criteria.Root;
import jakarta.persistence.criteria.Subquery;
import java.math.BigInteger;
import java.sql.Date;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.stereotype.Service;
import org.springframework.web.server.ResponseStatusException;

@Service
public class StudentServiceImpl
implements StudentService {
    private final EntityManager entityManager;
    private final AccountRepository accountRepository;
    private final MessageService messageService;
    private final StandardJPARepository standardJPARepository;
    private final StudentRepository studentRepository;
    private final StudentCriteriaRepository studentCriteriaRepository;
    private final ClassRepository classRepository;
    private final AvatarClient avatarClient;
    private final StudentCoreRepository studentCoreRepository;
    private final NamedParameterJdbcTemplate namedParameterJdbcTemplate;
    private final AccountClient accountClient;
    private final InstructorClient instructorClient;
    private final ParentClient parentClient;
    private final AccessCodeClient accessCodeClient;
    private final StudentGroupClient studentGroupClient;
    private final StandardClient standardClient;
    private final WallPostClient wallPostClient;

    public StudentServiceImpl(EntityManager entityManager, AccountRepository accountRepository, MessageService messageService, StandardJPARepository standardJPARepository, StudentRepository studentRepository, StudentCriteriaRepository studentCriteriaRepository, ClassRepository classRepository, AvatarClient avatarClient, StudentCoreRepository studentCoreRepository, NamedParameterJdbcTemplate namedParameterJdbcTemplate, AccountClient accountClient, InstructorClient instructorClient, ParentClient parentClient, AccessCodeClient accessCodeClient, StudentGroupClient studentGroupClient, StandardClient standardClient, WallPostClient wallPostClient) {
        this.entityManager = entityManager;
        this.accountRepository = accountRepository;
        this.messageService = messageService;
        this.standardJPARepository = standardJPARepository;
        this.studentRepository = studentRepository;
        this.studentCriteriaRepository = studentCriteriaRepository;
        this.classRepository = classRepository;
        this.avatarClient = avatarClient;
        this.studentCoreRepository = studentCoreRepository;
        this.namedParameterJdbcTemplate = namedParameterJdbcTemplate;
        this.accountClient = accountClient;
        this.instructorClient = instructorClient;
        this.parentClient = parentClient;
        this.accessCodeClient = accessCodeClient;
        this.studentGroupClient = studentGroupClient;
        this.standardClient = standardClient;
        this.wallPostClient = wallPostClient;
    }

    public StudentCoreDTO getByToken(String token) {
        AccountDTO accountDTO = this.accountClient.getByToken(token);
        if (accountDTO == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, this.messageService.getMessage("student.is.not.found"));
        }
        return this.studentCoreRepository.findByAccountId(accountDTO.getAccount_id());
    }

    public StudentDetailWrapper getDetailByToken(String token) {
        AccountDTO accountDTO = this.accountClient.getByToken(token);
        if (accountDTO == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, this.messageService.getMessage("student.is.not.found"));
        }
        return StudentDetailWrapper.builder().account(accountDTO).student(this.studentCoreRepository.findByAccountId(accountDTO.getAccount_id())).build();
    }

    public void setLanguage(long student_id, String language) {
        this.studentCoreRepository.setLanguage(student_id, language);
    }

    public void setOSAndBrowser(long student_id, String os, String browser) {
        this.studentCoreRepository.setOSAndBrowser(student_id, os, browser);
    }

    public StudentCoreDTO getByCleverId(String clever_id) {
        return this.studentCoreRepository.findByCleverId(clever_id);
    }

    public StudentProfileWrapper getProfile(long student_id) {
        ParentCoreDTO parentDTO;
        StudentProfileWrapper studentProfileWrapper = new StudentProfileWrapper();
        StudentCoreDTO student = this.studentCoreRepository.findById(student_id);
        studentProfileWrapper.setStudent(student);
        AccountDTO account = this.accountClient.getById(GetEmailByAccountIdRequest.builder().account_id(student.getAccount_id()).build());
        studentProfileWrapper.setAccount(account);
        StandardDTO standardDTO = this.standardClient.getById(GetByStandardIdRequest.builder().standard_id(student.getStandard_id()).build());
        studentProfileWrapper.setStandard(standardDTO);
        InstructorDTO instructorDTO = this.instructorClient.getById(GetInstructorByIdRequest.builder().id(student.getInstructor_id()).build());
        if (instructorDTO != null) {
            studentProfileWrapper.setInstructor(InstructorDetailWrapper.builder().instructor_id(instructorDTO.getInstructor_id()).first_name(instructorDTO.getFirst_name()).last_name(instructorDTO.getLast_name()).registration_code(instructorDTO.getRegistration_code()).build());
        }
        if ((parentDTO = this.parentClient.getById(GetByParentIdRequest.builder().parent_id(student.getParent_id()).build())) != null) {
            studentProfileWrapper.setParent(ParentDetailWrapper.builder().parent_id(parentDTO.getParent_id()).first_name(parentDTO.getFirst_name()).last_name(parentDTO.getLast_name()).registration_code(parentDTO.getRegistration_code()).build());
        }
        return studentProfileWrapper;
    }

    public StudentCoreDTO saveProfile(long student_id, long school_id, long avatar_id, Date date_of_birth, String gender, String ethnicity, long standard_id, long instructor_id, long parent_id, boolean share_your_success) {
        StudentCoreDTO studentCoreDTO;
        InstructorDTO instructor;
        if (instructor_id == 0L && parent_id == 0L) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, this.messageService.getMessage("please.provide.a.valid.parent.or.instructor"));
        }
        if (date_of_birth != null) {
            DateUtils.isAgeInRange((java.util.Date)date_of_birth, (int)4, (int)19);
        }
        if ((instructor = this.instructorClient.getById(GetInstructorByIdRequest.builder().id(instructor_id).build())) != null) {
            if (school_id != instructor.getSchool_id()) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, this.messageService.getMessage("instructor.s.school.and.student.s.school.must.be.same"));
            }
        } else {
            instructor_id = 0L;
        }
        if ((studentCoreDTO = this.studentCoreRepository.saveProfile(student_id, school_id, avatar_id, date_of_birth, gender, ethnicity, standard_id, instructor_id, parent_id, share_your_success)) == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.CONFLICT, this.messageService.getMessage("student.detail.is.not.updated"));
        }
        try {
            this.accessCodeClient.updateInstructorIdAndParentIdByStudentId(UpdateInstructorIdAndParentIdByStudentIdRequest.builder().instructor_id(instructor_id).parent_id(parent_id).student_id(student_id).build());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            this.wallPostClient.syncByStudentId(SyncByStudentIdRequest.builder().student_id(student_id).instructor_id(instructor_id).parent_id(parent_id).build());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return studentCoreDTO;
    }

    public List<StudentCoreDTO> getAll() {
        return this.studentCoreRepository.findAll();
    }

    public Student getStudentById(long student_id) {
        return this.studentRepository.findByStudentId(Long.valueOf(student_id));
    }

    public void setNewNotifications(List<Long> student_ids, boolean new_notifications) {
        this.studentCoreRepository.setNewNotifications(student_ids, new_notifications);
    }

    public Student getStudentByCleverId(String clever_id) {
        return this.studentRepository.findByStudentCleverId(clever_id);
    }

    public Student getStudentByAccountId(long account_id) {
        return this.studentRepository.findByAccountId(Long.valueOf(account_id));
    }

    public List<Student> getStudentsByFirstNameAndLastName(String first_name, String last_name) {
        return this.studentRepository.findStudentByFirstNameAndLastName(first_name, last_name);
    }

    public Page<Object> searchStudentByInstructorAndDemographic(Instructor instructor, SearchStudentRequest request) {
        StringBuilder sql = new StringBuilder("SELECT DISTINCT s.student_id, s.").append(request.getSortBy()).append(" FROM student s ");
        sql.append("JOIN access_code ac ON s.student_id = ac.student_id ");
        if (AppUtils.isNotNullOrEmpty((String)request.getClass_name())) {
            sql.append("JOIN student_class sc ON s.student_id = sc.student_id ");
        }
        sql.append("JOIN account a ON s.account_id = a.account_id ");
        StringBuilder countSql = new StringBuilder("SELECT COUNT(DISTINCT s.student_id, s.").append(request.getSortBy()).append(") FROM student s ");
        countSql.append("JOIN access_code ac ON s.student_id = ac.student_id ");
        if (AppUtils.isNotNullOrEmpty((String)request.getClass_name())) {
            countSql.append("JOIN student_class sc ON s.student_id = sc.student_id ");
        }
        countSql.append("JOIN account a ON s.account_id = a.account_id ");
        HashMap<String, Object> params = new HashMap<String, Object>();
        sql.append("WHERE ac.status IN (:statuses) ");
        countSql.append("WHERE ac.status IN (:statuses) ");
        params.put("statuses", Arrays.asList(Status.ACCEPTED.name(), Status.REJECTED.name()));
        if (instructor != null) {
            sql.append("AND s.instructor_id = :instructorId ");
            countSql.append("AND s.instructor_id = :instructorId ");
            params.put("instructorId", instructor.getInstructor_id());
        }
        if (AppUtils.isNotNullOrEmpty((String)request.getFirst_name())) {
            sql.append("AND s.first_name LIKE :firstName ");
            countSql.append("AND s.first_name LIKE :firstName ");
            params.put("firstName", "%" + request.getFirst_name() + "%");
        }
        if (AppUtils.isNotNullOrEmpty((String)request.getLast_name())) {
            sql.append("AND s.last_name LIKE :lastName ");
            countSql.append("AND s.last_name LIKE :lastName ");
            params.put("lastName", "%" + request.getLast_name() + "%");
        }
        if (AppUtils.isNotNullOrEmpty((String)request.getEmail())) {
            sql.append("AND a.username LIKE :username ");
            countSql.append("AND a.username LIKE :username ");
            params.put("username", "%" + request.getEmail() + "%");
        }
        if (AppUtils.isNotNullOrEmpty((String)request.getClass_name())) {
            List classIds = this.classRepository.findClassIdsWhereClassNameLike(request.getClass_name());
            if (AppUtils.isNotNullOrEmpty((List)classIds)) {
                sql.append("AND sc.class_id IN (:classIds) ");
                countSql.append("AND sc.class_id IN (:classIds) ");
                params.put("classIds", classIds.stream().map(BigInteger::longValue).collect(Collectors.toList()));
            } else {
                sql.append("AND sc.class_id = -1 ");
                countSql.append("AND sc.class_id = -1 ");
            }
        }
        String orderBy = request.getOrderBy().equals("desc") ? "DESC" : "ASC";
        sql.append("ORDER BY s.").append(request.getSortBy()).append(" ").append(orderBy).append(", s.student_id ").append(orderBy);
        PageRequest pageable = PageRequest.of((int)request.getPageNo(), (int)request.getPageSize(), (Sort)(request.getOrderBy().equals("desc") ? Sort.by((String[])new String[]{request.getSortBy()}).descending() : Sort.by((String[])new String[]{request.getSortBy()}).ascending()));
        sql.append(" LIMIT :limit OFFSET :offset");
        params.put("limit", pageable.getPageSize());
        params.put("offset", pageable.getOffset());
        List results = this.namedParameterJdbcTemplate.queryForList(sql.toString(), params);
        Long count = (Long)this.namedParameterJdbcTemplate.queryForObject(countSql.toString(), params, Long.class);
        PageImpl pagedResult = new PageImpl(results, (Pageable)pageable, count.longValue());
        PageImpl pageWithFilteredData = new PageImpl(pagedResult.stream().map(result -> {
            LinkedList classViews;
            AccountView accountView;
            AccessCodeDTO accessCodeDTO;
            LinkedHashMap<String, Object> wrapper = new LinkedHashMap<String, Object>();
            Long studentId = ((Number)result.get("student_id")).longValue();
            StudentCoreDTO studentDTO = this.studentCoreRepository.findById(studentId.longValue());
            wrapper.put("student_id", studentDTO.getStudent_id());
            wrapper.put("instructor_id", studentDTO.getInstructor_id());
            wrapper.put("standard_id", studentDTO.getStandard_id());
            wrapper.put("first_name", studentDTO.getFirst_name());
            wrapper.put("last_name", studentDTO.getLast_name());
            wrapper.put("avatar_id", studentDTO.getAvatar_id());
            AvatarDTO avatarDTO = this.avatarClient.getById(GetByAvatarIdRequest.builder().avatar_id(studentDTO.getAvatar_id()).build());
            if (avatarDTO != null) {
                wrapper.put("avatar_url", avatarDTO.getPreview_url());
            }
            if ((accessCodeDTO = this.accessCodeClient.getByStudentId(GetByStudentIdRequest.builder().student_id(studentDTO.getStudent_id()).build())) != null) {
                wrapper.put("status", accessCodeDTO.getStatus());
            }
            if ((accountView = this.accountRepository.findAccountViewByAccountId(Long.valueOf(studentDTO.getAccount_id()))) != null) {
                wrapper.put("username", accountView.getUsername());
                wrapper.put("username2", accountView.getUsername2());
            }
            wrapper.put("parent_id", studentDTO.getParent_id());
            Parent parentView = this.parentClient.getParentById(GetByIdRequest.builder().id(studentDTO.getParent_id()).build());
            if (parentView != null) {
                LinkedHashMap<String, Object> wrapperParent = new LinkedHashMap<String, Object>();
                wrapperParent.put("parent_id", parentView.getParent_id());
                AccountView accountViewParent = this.accountRepository.findAccountViewByAccountId(Long.valueOf(parentView.getAccount_id()));
                if (accountViewParent != null) {
                    wrapperParent.put("username", accountViewParent.getUsername());
                }
                wrapperParent.put("registration_code", parentView.getFirst_name());
                wrapperParent.put("first_name", parentView.getFirst_name());
                wrapperParent.put("last_name", parentView.getLast_name());
                wrapperParent.put("phone", parentView.getPhone());
                wrapperParent.put("email", parentView.getEmail());
                wrapper.put("parent", wrapperParent);
            }
            if (!AppUtils.isNullOrEmpty((List)(classViews = this.classRepository.findClassViewByStudentId(studentDTO.getStudent_id())))) {
                LinkedList classes = new LinkedList();
                for (ClassView classView : classViews) {
                    LinkedHashMap<String, Object> wrapperClass = new LinkedHashMap<String, Object>();
                    wrapperClass.put("class_id", classView.getClass_id());
                    wrapperClass.put("class_name", classView.getClass_name());
                    classes.add(wrapperClass);
                }
                wrapper.put("classes", classes);
            }
            wrapper.put("clever_id", studentDTO.getClever_id());
            wrapper.put("verified", studentDTO.isVerified());
            return wrapper;
        }).collect(Collectors.toList()), pagedResult.getPageable(), pagedResult.getTotalElements());
        return pageWithFilteredData;
    }

    public List<Student> searchStudentByDemographicAndIds(SearchStudentRequest request, List<Long> studentIds) {
        Predicate genderPredicate;
        CriteriaBuilder qb = this.entityManager.getCriteriaBuilder();
        CriteriaQuery c = qb.createQuery(Student.class);
        Root s = c.from(Student.class);
        Join ac = s.join("account", JoinType.LEFT);
        ArrayList<Object> predicates = new ArrayList<Object>();
        if (AppUtils.isNotNullOrEmpty(studentIds)) {
            CriteriaBuilder.In classesPredicate = qb.in((Expression)s.get("student_id")).value(studentIds);
            predicates.add(classesPredicate);
        }
        if (AppUtils.isNotNullOrEmpty((String)request.getFirst_name())) {
            genderPredicate = qb.like((Expression)s.get("first_name"), "%" + request.getFirst_name() + "%");
            predicates.add(genderPredicate);
        }
        if (AppUtils.isNotNullOrEmpty((String)request.getLast_name())) {
            genderPredicate = qb.like((Expression)s.get("last_name"), "%" + request.getLast_name() + "%");
            predicates.add(genderPredicate);
        }
        if (AppUtils.isNotNullOrEmpty((String)request.getEmail())) {
            genderPredicate = qb.like((Expression)ac.get("username"), "%" + request.getEmail() + "%");
            predicates.add(genderPredicate);
        }
        if (AppUtils.isNotNullOrEmpty((String)request.getClass_name())) {
            List classIds = this.classRepository.findClassIdsWhereClassNameLike(request.getClass_name());
            if (AppUtils.isNotNullOrEmpty((List)classIds)) {
                ArrayList<Long> ids = new ArrayList<Long>();
                for (int i = 0; i < classIds.size(); ++i) {
                    ids.add(((BigInteger)classIds.get(i)).longValue());
                }
                Subquery sq = c.subquery(Long.class).select(qb.literal((Object)1L));
                Root sqRoot = sq.correlate(s);
                Join sqJoin = sqRoot.join("classes");
                sq.where((Expression)sqJoin.get("class_id").in(ids));
                predicates.add(qb.and(new Predicate[]{qb.exists(sq)}));
            } else {
                Subquery sq = c.subquery(Long.class).select(qb.literal((Object)1L));
                Root sqRoot = sq.correlate(s);
                Join sqJoin = sqRoot.join("classes");
                sq.where((Expression)sqJoin.get("class_id").in(new Object[]{-1}));
                predicates.add(qb.and(new Predicate[]{qb.exists(sq)}));
            }
        }
        c.where(predicates.toArray(new Predicate[0]));
        TypedQuery typedQuery = this.entityManager.createQuery(c);
        List students = typedQuery.getResultList();
        System.out.println("Student Count = " + students.size());
        return students;
    }

    public long getStudentsCountByInstructorId(long instructor_id) {
        return this.studentRepository.getStudentsCountByInstructorId(instructor_id);
    }

    public Student setParentDetail(long student_id, String country_code, String phone, String email) {
        if (AppUtils.isNotNullOrEmpty((String)email) && !AppUtils.isValidateEmail((String)email)) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.CONFLICT, this.messageService.getMessage("email.is.not.valid"));
        }
        Student student = this.getStudentById(student_id);
        if (student == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, this.messageService.getMessage("student.is.not.found"));
        }
        Parent parent = null;
        parent = student.getParent() == null ? this.parentClient.createParent(CreateParentRequest.builder().school_id(student.getSchool() != null ? student.getSchool().getSchool_id() : 0L).country_code(country_code).phone(phone).email(email).build()) : this.parentClient.updateParent(UpdateParentRequest.builder().parent_id(student.getParent().getParent_id()).country_code(country_code).phone(phone).email(email).build());
        if (student.getAccount().getUsername2() == null || student.getAccount().getUsername2().isEmpty()) {
            this.studentRepository.updateParentIdByStudentId(parent.getParent_id(), student.getStudent_id());
        } else {
            student.setParent(parent);
            this.studentRepository.save((Object)student);
        }
        return this.getStudentById(student_id);
    }

    public List<Student> getStudentsByInstructorId(long instructor_id) {
        return this.studentRepository.findFullStudentByInstructorId(Long.valueOf(instructor_id));
    }

    public List<Long> getStudentIdsByInstructorId(long instructor_id) {
        return this.studentCriteriaRepository.getStudentIdsByInstructorId(instructor_id);
    }

    public List<Long> getStudentIdsByInstructorIds(List<Long> instructor_ids) {
        return this.studentCriteriaRepository.getStudentIdsByInstructorIds(instructor_ids);
    }

    public Student save(Student student) {
        return (Student)this.studentRepository.save((Object)student);
    }

    public List<Student> saveAll(List<Student> student) {
        return this.studentRepository.saveAll(student);
    }

    public void updateClassIdByStudentId(long class_id, long student_id) {
        Student student = this.getStudentById(student_id);
        Class class_ = this.classRepository.findByClassId(class_id);
        if (class_ != null) {
            student.getClasses().add(class_);
        }
        this.save(student);
    }

    public void updateStandardIdAndGradeIdByStudentId(long standard_id, long grade_id, long student_id) {
        Student student = this.getStudentById(student_id);
        student.setStandard(this.standardJPARepository.findByStandardId(Long.valueOf(standard_id)));
        this.save(student);
    }

    public Student isValidStudent(long student_id) {
        Student student = this.getStudentById(student_id);
        if (student == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, this.messageService.getMessage("student.is.not.found"));
        }
        return student;
    }

    public Student setOperatingSystemAndBrowser(long student_id, String operating_system, String browser) {
        Student student = this.getStudentById(student_id);
        if (student == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, this.messageService.getMessage("student.is.not.found"));
        }
        student.setOperating_system(operating_system);
        student.setBrowser(browser);
        return (Student)this.studentRepository.save((Object)student);
    }

    public List<Student> getStudentsByCleverIdOrUserName(String clever_id, String username) {
        return this.studentRepository.findStudentsByCleverIdOrUserName(clever_id, username);
    }

    public List<Student> getStudentByCleverId2(String clever_id) {
        return this.studentRepository.findByCleverId2(clever_id);
    }

    public Student findByRegistrationCode(String possible_code) {
        return this.studentRepository.findByRegistrationCode(possible_code);
    }

    public Student generateRegistrationCodeForStudent(Student student) {
        try {
            if (AppUtils.isNullOrEmpty((String)student.getRegistration_code())) {
                boolean isUnique = false;
                while (!isUnique) {
                    String possible_code = "ST" + KeyGenerator.generateUniqueAuthCode();
                    Student x = this.findByRegistrationCode(possible_code);
                    if (x == null) {
                        isUnique = true;
                        student.setRegistration_code(possible_code);
                        continue;
                    }
                    isUnique = false;
                }
                student = this.save(student);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return student;
    }

    public List<Student> getStudentsByCleverId(List<String> students_clever_ids) {
        return this.studentRepository.findByCleverId(students_clever_ids);
    }

    public Student shouldShareWithInstructorAndParents(long student_id, boolean share_journal_with_instructor, boolean share_journal_with_parents) {
        Student student = this.getStudentById(student_id);
        student.setShare_journal_with_instructor(share_journal_with_instructor);
        student.setShare_journal_with_parents(share_journal_with_parents);
        return this.save(student);
    }

    public long getStudentsCountBySchoolId(long school_id) {
        return this.studentRepository.getStudentsCountBySchoolId(school_id);
    }

    public List<StudentDTO> getStudentsByInstructorIdAndStudentName(Long instructor_id, String student_name) {
        return this.studentCriteriaRepository.findByInstructorIdAndStudentName(instructor_id, student_name);
    }

    public List<Long> getStudentIdsBySchoolId(long school_id) {
        return this.studentCriteriaRepository.getStudentIdsBySchoolId(school_id);
    }

    public List<StudentCoreDTO> getStudentsByIds(List<Long> ids) {
        return this.studentCoreRepository.findByIds(ids);
    }

    public List<Long> getStudentIdsByDemographics(long school_id, String name, List<String> genders, List<Integer> ages, List<String> ethnicity, List<Long> gradeIds, List<Long> classIds) {
        HashSet<Long> student_ids_by_class_ids = new HashSet<Long>(this.studentGroupClient.getStudentIdsByGroupIds(GetStudentsByGroupIdsRequest.builder().group_ids(classIds).build()));
        if (!AppUtils.isNullOrEmpty(classIds) && AppUtils.isNullOrEmpty(student_ids_by_class_ids)) {
            student_ids_by_class_ids.add(-1L);
        }
        return this.studentCriteriaRepository.findStudentIdsByDemographics(school_id, name, genders, ages, ethnicity, gradeIds, student_ids_by_class_ids);
    }

    public List<StudentIdAndStandardIdWrapper> getStudentIdAndStandardIdByStudentIds(Set<Long> student_ids) {
        return this.studentCoreRepository.findStudentIdAndStandardIdByStudentIds(student_ids);
    }

    public StudentCoreDTO getByAccountId(long account_id) {
        return this.studentCoreRepository.findByAccountId(account_id);
    }

    public StudentCoreDTO getByStudentId(long student_id) {
        return this.studentCoreRepository.findById(student_id);
    }

    public List<StudentClassWrapper> getByInstructorIdAndStatus(long instructor_id, Set<String> status) {
        ArrayList<StudentClassWrapper> list = new ArrayList<StudentClassWrapper>();
        for (Student student : this.studentRepository.findIdsByInstructorIdAndStatus(instructor_id, status)) {
            StudentClassWrapper w = new StudentClassWrapper();
            w.setStudent(student);
            w.setParent(student.getParent());
            list.add(w);
        }
        return list;
    }

    public void setShouldForceSocioEmotionalAssessment(List<Long> student_ids, boolean should_force_socio_emotional_assessment) {
        this.studentCoreRepository.setShouldForceSocioEmotionalAssessment(student_ids, should_force_socio_emotional_assessment);
    }

    public List<StudentCoreDTO> getByInstructorId(long instructor_id) {
        return this.studentCoreRepository.findByInstructorId(instructor_id);
    }
}

