/*
 * Decompiled with CFR 0.152.
 */
package com.infinite.focus.server.dashboard.selanalytics.socialawareness;

import com.infinite.focus.server.assessment.model.AssessmentOccuranceAndCompetencyScore;
import com.infinite.focus.server.assessment.model.AssessmentOccurrence;
import com.infinite.focus.server.client.SocialAwarenessUpdateClient;
import com.infinite.focus.server.dashboard.helper.LabelAndDataHelper;
import com.infinite.focus.server.dashboard.model.LabelAndValue;
import com.infinite.focus.server.dashboard.model.TimeLine;
import com.infinite.focus.server.dashboard.request.GetDataDashBoardRequest;
import com.infinite.focus.server.dashboard.selanalytics.socialawareness.SocialAwarenessDataService;
import com.infinite.focus.server.ethnicity.entity.Ethnicity;
import com.infinite.focus.server.ethnicity.repository.EthnicityRepository;
import com.infinite.focus.server.gender.entity.Gender;
import com.infinite.focus.server.gender.repository.GenderRepository;
import com.infinite.focus.server.grade.repository.GradeRepository;
import com.infinite.focus.server.grade.view.GradeView;
import com.infinite.focus.server.language.Language;
import com.infinite.focus.server.responsibledecisionmaking.request.GetByStudentIdsAndFromDateAndToDateRequest;
import com.infinite.focus.server.socialawareness.entity.SocialAwarenessUpdate;
import com.infinite.focus.server.socialawareness.service.SocialAwarenessUpdateService;
import com.infinite.focus.server.socioemotionaltestanswer.entity.SocioEmotionalTestAnswer;
import com.infinite.focus.server.socioemotionaltestanswer.repository.SocioEmotionalTestAnswerRepository;
import com.infinite.focus.server.socioemotionaltestquestion.entity.SocioEmotionalTestQuestion;
import com.infinite.focus.server.socioemotionaltestquestion.repository.SocioEmotionalTestQuestionRepository;
import com.infinite.focus.server.socioemotionaltestquestionoption.entity.SocioEmotionalTestQuestionOption;
import com.infinite.focus.server.socioemotionaltestquestionoption.repository.SocioEmotionalTestQuestionOptionRepository;
import com.infinite.focus.server.socioemotionaltestresult.entity.SocioEmotionalTestResult;
import com.infinite.focus.server.socioemotionaltestresult.service.SocioEmotionalTestResultService;
import com.infinite.focus.server.student.dto.StudentDTO;
import com.infinite.focus.server.student.repository.StudentCriteriaRepository;
import com.infinite.focus.server.student.repository.StudentRepository;
import com.infinite.focus.server.test.wrapper.SocioEmotionalTestDataWrapper;
import com.infinite.focus.server.utils.AppUtils;
import com.infinite.focus.server.utils.DateUtils;
import com.infinite.focus.server.utils.DigitUtils;
import com.infinite.focus.server.utils.TimeUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TimeZone;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SocialAwarenessDataServiceImpl
implements SocialAwarenessDataService {
    @Autowired
    StudentCriteriaRepository studentCriteriaRepository;
    @Autowired
    StudentRepository studentRepository;
    @Autowired
    GradeRepository gradeRepository;
    @Autowired
    SocioEmotionalTestResultService socioEmotionalTestResultService;
    @Autowired
    SocioEmotionalTestQuestionOptionRepository socioEmotionalTestQuestionOptionRepository;
    @Autowired
    SocioEmotionalTestQuestionRepository socioEmotionalTestQuestionRepository;
    @Autowired
    SocioEmotionalTestAnswerRepository socioEmotionalTestAnswerRepository;
    @Autowired
    SocialAwarenessUpdateService socialAwarenessUpdateService;
    @Autowired
    GenderRepository genderRepository;
    @Autowired
    EthnicityRepository ethnicityRepository;
    private final SocialAwarenessUpdateClient socialAwarenessUpdateClient;

    public SocialAwarenessDataServiceImpl(SocialAwarenessUpdateClient socialAwarenessUpdateClient) {
        this.socialAwarenessUpdateClient = socialAwarenessUpdateClient;
    }

    public Object getSelfReportingData(GetDataDashBoardRequest request) {
        LinkedList values;
        List student_ids;
        GetDataDashBoardRequest getDataDashBoardRequest;
        Date fromDate = null;
        Date toDate = null;
        if (request.getFromDate() != null && request.getToDate() != null) {
            fromDate = request.getFromDate();
            toDate = request.getToDate();
        } else {
            Date firstStudentRegistredDate = this.studentRepository.getDateOfFirstRegistredStudent();
            System.out.println("firstStudentRegistredDate - " + firstStudentRegistredDate);
            fromDate = firstStudentRegistredDate == null ? DateUtils.setTimeToFromDate((Date)new Date()) : DateUtils.setTimeToFromDate((Date)firstStudentRegistredDate);
            toDate = DateUtils.setTimeToToDate((Date)new Date());
        }
        LinkedHashMap graphData_en = new LinkedHashMap();
        LinkedHashMap graphData_es = new LinkedHashMap();
        System.out.println("----------------------------- Gender------------------------------");
        if (AppUtils.isNotNullOrEmpty((List)request.getGenders())) {
            LinkedHashMap<String, LinkedList> genders_en = new LinkedHashMap<String, LinkedList>();
            LinkedHashMap<String, LinkedList> genders_es = new LinkedHashMap<String, LinkedList>();
            getDataDashBoardRequest = this.getGetDataDashBoardRequestWithReqeuest(request);
            getDataDashBoardRequest.getGenders().addAll(request.getGenders());
            student_ids = this.studentCriteriaRepository.getStudentsByDemographics(getDataDashBoardRequest, false, true);
            for (String gender : request.getGenders()) {
                Gender genderItem = this.genderRepository.findByGender(gender);
                System.out.println("----------------------------- " + gender + "------------------------------");
                values = this.getSelfReporting(student_ids.stream().filter(studentDTO -> studentDTO.getGender().equalsIgnoreCase(gender)).map(StudentDTO::getStudent_id).collect(Collectors.toList()), fromDate, toDate, getDataDashBoardRequest.getTimeZone());
                genders_en.put(gender, values);
                if (!Language.isSpanish()) continue;
                genders_es.put(genderItem.getGender_es(), values);
            }
            graphData_en.put("Gender", genders_en);
            if (Language.isSpanish()) {
                graphData_es.put("G\u00e9nero", genders_es);
            }
        }
        System.out.println("----------------------------- Age ------------------------------");
        if (AppUtils.isNotNullOrEmpty((List)request.getAges())) {
            LinkedHashMap<String, LinkedList> ages_en = new LinkedHashMap<String, LinkedList>();
            LinkedHashMap<String, LinkedList> ages_es = new LinkedHashMap<String, LinkedList>();
            getDataDashBoardRequest = this.getGetDataDashBoardRequestWithReqeuest(request);
            getDataDashBoardRequest.getAges().addAll(request.getAges());
            student_ids = this.studentCriteriaRepository.getStudentsByDemographics(getDataDashBoardRequest, false, true);
            for (Integer age : request.getAges()) {
                System.out.println("----------------------------- " + age + "------------------------------");
                LinkedList values2 = this.getSelfReporting(student_ids.stream().filter(studentDTO -> TimeUtils.getAge((Date)studentDTO.getDate_of_birth()) == age).map(StudentDTO::getStudent_id).collect(Collectors.toList()), fromDate, toDate, getDataDashBoardRequest.getTimeZone());
                ages_en.put(String.valueOf(age), values2);
                if (!Language.isSpanish()) continue;
                ages_es.put(String.valueOf(age), values2);
            }
            graphData_en.put("Age", ages_en);
            if (Language.isSpanish()) {
                graphData_es.put("Edad", ages_es);
            }
        }
        System.out.println("----------------------------- Ethnicity------------------------------");
        if (AppUtils.isNotNullOrEmpty((List)request.getEthnicity())) {
            LinkedHashMap<String, LinkedList> ethnicityMap_en = new LinkedHashMap<String, LinkedList>();
            LinkedHashMap<String, LinkedList> ethnicityMap_es = new LinkedHashMap<String, LinkedList>();
            getDataDashBoardRequest = this.getGetDataDashBoardRequestWithReqeuest(request);
            getDataDashBoardRequest.getEthnicity().addAll(request.getEthnicity());
            student_ids = this.studentCriteriaRepository.getStudentsByDemographics(getDataDashBoardRequest, false, true);
            for (String ethnicity : request.getEthnicity()) {
                Ethnicity ethnicityItem = this.ethnicityRepository.findByEthnicity(ethnicity);
                System.out.println("----------------------------- " + ethnicity + "------------------------------");
                values = this.getSelfReporting(student_ids.stream().filter(studentDTO -> studentDTO.getEthnicity().equalsIgnoreCase(ethnicityItem.getEthnicity())).map(StudentDTO::getStudent_id).collect(Collectors.toList()), fromDate, toDate, getDataDashBoardRequest.getTimeZone());
                ethnicityMap_en.put(ethnicity, values);
                if (!Language.isSpanish()) continue;
                ethnicityMap_es.put(ethnicityItem.getEthnicity_es(), values);
            }
            graphData_en.put("Ethnicity", ethnicityMap_en);
            if (Language.isSpanish()) {
                graphData_es.put("Etnia", ethnicityMap_es);
            }
        }
        System.out.println("----------------------------- Grade------------------------------");
        if (AppUtils.isNotNullOrEmpty((List)request.getGradeIds())) {
            LinkedHashMap<String, LinkedList> grades_en = new LinkedHashMap<String, LinkedList>();
            LinkedHashMap<String, LinkedList> grades_es = new LinkedHashMap<String, LinkedList>();
            getDataDashBoardRequest = this.getGetDataDashBoardRequestWithReqeuest(request);
            getDataDashBoardRequest.getGradeIds().addAll(request.getGradeIds());
            student_ids = this.studentCriteriaRepository.getStudentsByDemographics(getDataDashBoardRequest, false, true);
            for (Long grade_id : request.getGradeIds()) {
                GradeView gradeView = this.gradeRepository.findByGradeId(grade_id);
                System.out.println("-----------------------------" + grade_id + " -> " + gradeView.getGrade_name() + "------------------------------");
                values = this.getSelfReporting(student_ids.stream().filter(studentDTO -> Objects.equals(studentDTO.getGrade_id(), grade_id)).map(StudentDTO::getStudent_id).collect(Collectors.toList()), fromDate, toDate, getDataDashBoardRequest.getTimeZone());
                grades_en.put(gradeView.getGrade_name(), values);
                if (!Language.isSpanish()) continue;
                grades_es.put(gradeView.getGrade_name_es(), values);
            }
            graphData_en.put("Grade", grades_en);
            if (Language.isSpanish()) {
                graphData_es.put("Grado", grades_es);
            }
        }
        LinkedHashMap graphData = new LinkedHashMap();
        graphData.put("en", graphData_en);
        if (Language.isSpanish()) {
            graphData.put("es", graphData_es);
        }
        return graphData;
    }

    public Object getSelfReportingData2(GetDataDashBoardRequest request) {
        Date fromDate = null;
        Date toDate = null;
        if (request.getFromDate() != null && request.getToDate() != null) {
            fromDate = request.getFromDate();
            toDate = request.getToDate();
        } else {
            Date firstStudentRegistredDate = this.studentRepository.getDateOfFirstRegistredStudent();
            System.out.println("firstStudentRegistredDate - " + firstStudentRegistredDate);
            fromDate = firstStudentRegistredDate == null ? DateUtils.setTimeToFromDate((Date)new Date()) : DateUtils.setTimeToFromDate((Date)firstStudentRegistredDate);
            toDate = DateUtils.setTimeToToDate((Date)new Date());
        }
        List student_ids = this.studentCriteriaRepository.getStudentsByDemographics(request, false, true);
        List socialAwarenessUpdateList = this.socialAwarenessUpdateService.getSocialAwarenessUpdateByStudentIds(student_ids.stream().map(StudentDTO::getStudent_id).collect(Collectors.toList()), fromDate, toDate);
        LinkedHashMap moodUpdateMap = this.getMoodUpdateMapByTimeline(request.getTimeLine(), socialAwarenessUpdateList, Language.getLanguage());
        LinkedList<LabelAndValue> graphData_en = new LinkedList<LabelAndValue>();
        LinkedList<LabelAndValue> graphData_es = new LinkedList<LabelAndValue>();
        for (String[] keys : moodUpdateMap.keySet()) {
            LinkedHashSet<Long> ids = new LinkedHashSet<Long>();
            List values = (List)moodUpdateMap.get(keys);
            for (int i = 0; i < values.size(); ++i) {
                ids.add(((SocialAwarenessUpdate)values.get(i)).getSocial_awareness_update_id());
            }
            graphData_en.add(new LabelAndValue(keys[0], (double)ids.size()));
            if (!Language.isSpanish()) continue;
            graphData_es.add(new LabelAndValue(keys[1], (double)ids.size()));
        }
        LinkedHashMap<String, LinkedList<LabelAndValue>> graphData = new LinkedHashMap<String, LinkedList<LabelAndValue>>();
        graphData.put("en", graphData_en);
        if (Language.isSpanish()) {
            graphData.put("es", graphData_es);
        }
        return graphData;
    }

    public LinkedList<BigDecimal> getSelfReporting(List<Long> student_ids, Date fromDate, Date toDate, TimeZone timeZone) {
        List socialAwarenessUpdateList = this.socialAwarenessUpdateService.getSocialAwarenessUpdateByStudentIds(student_ids, fromDate, toDate);
        LinkedList<BigDecimal> reportings = new LinkedList<BigDecimal>();
        if (AppUtils.isNotNullOrEmpty((List)socialAwarenessUpdateList)) {
            Double size = socialAwarenessUpdateList.size();
            System.out.println("ResponsibleDecisionMakingUpdate List Size - " + size + " FromDate - " + DateUtils.dayWitTimeFormat.format(fromDate) + " ToDate - " + DateUtils.dayWitTimeFormat.format(toDate));
            System.out.println("----------------------------Daily---------------------------------");
            Double days = DateUtils.getDayCountByFromDateAndToDate((Date)fromDate, (Date)toDate, (TimeZone)timeZone);
            BigDecimal dailyReporting = DigitUtils.getAverageBigDecimal((Double)size, (Double)days);
            System.out.println("dailyReporting - " + dailyReporting + " = Size: " + size + " / Days: " + days);
            reportings.add(dailyReporting);
            System.out.println("----------------------------Weekly---------------------------------");
            Double weeks = DateUtils.getWeekCountByFromDateAndToDate((Date)fromDate, (Date)toDate, (TimeZone)timeZone);
            BigDecimal weeklyReporting = DigitUtils.getAverageBigDecimal((Double)size, (Double)weeks);
            System.out.println("weeklyReporting - " + weeklyReporting + " = Size: " + size + " / Weeks: " + weeks);
            reportings.add(weeklyReporting);
            System.out.println("----------------------------Monthly---------------------------------");
            Double months = DateUtils.getMonthCountByFromDateAndToDate((Date)fromDate, (Date)toDate, (TimeZone)timeZone);
            BigDecimal monthlyReporting = DigitUtils.getAverageBigDecimal((Double)size, (Double)months);
            System.out.println("monthlyReporting - " + monthlyReporting + " = Size: " + size + " / Months: " + months);
            reportings.add(monthlyReporting);
            System.out.println("----------------------------Yearly---------------------------------");
            Double years = DateUtils.getYearCountByFromDateAndToDate((Date)fromDate, (Date)toDate, (TimeZone)timeZone);
            BigDecimal yearlyReporting = DigitUtils.getAverageBigDecimal((Double)size, (Double)years);
            System.out.println("yearlyReporting - " + yearlyReporting + " = Size: " + size + " / Years: " + years);
            reportings.add(yearlyReporting);
        } else {
            reportings.add(DigitUtils.formateZeroToBigDecimal());
            reportings.add(DigitUtils.formateZeroToBigDecimal());
            reportings.add(DigitUtils.formateZeroToBigDecimal());
            reportings.add(DigitUtils.formateZeroToBigDecimal());
        }
        return reportings;
    }

    /*
     * Exception decompiling
     */
    public LinkedHashMap<String[], List<SocialAwarenessUpdate>> getMoodUpdateMapByTimeline(TimeLine timeLine, List<SocialAwarenessUpdate> studentList, String language) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:87)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredAssignment.rewriteExpressions(StructuredAssignment.java:146)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private LinkedHashMap<String[], List<SocialAwarenessUpdate>> fillMoodUpdateMap(List<String[]> keys) {
        LinkedHashMap<String[], List<SocialAwarenessUpdate>> map = new LinkedHashMap<String[], List<SocialAwarenessUpdate>>();
        for (String[] key : keys) {
            map.put(key, new ArrayList());
        }
        return map;
    }

    public Object getSocialAwarenessDemographicComparisonGraphData(GetDataDashBoardRequest request) {
        List student_ids = this.studentCriteriaRepository.getStudentIdsByDemographics(request, false, true);
        return this.socialAwarenessUpdateClient.getOccurrenceAndOccurrenceAverageByStudentIdsAndFromDateAndToDate(GetByStudentIdsAndFromDateAndToDateRequest.builder().student_ids(new HashSet(student_ids)).from_date(request.getFromDate()).to_date(request.getToDate()).build());
    }

    public Object getFriendshipAnalysisGraphData(GetDataDashBoardRequest request) {
        List student_ids = this.studentCriteriaRepository.getStudentIdsByDemographics(request, false, true);
        return this.socialAwarenessUpdateClient.getOccurrenceAndOccurrenceAverageByStudentIdsAndFromDateAndToDate(GetByStudentIdsAndFromDateAndToDateRequest.builder().student_ids(new HashSet(student_ids)).from_date(request.getFromDate()).to_date(request.getToDate()).build());
    }

    public Object getMostAndLeastReportedData(GetDataDashBoardRequest request) {
        LinkedHashMap values;
        LinkedHashMap graphData_en = new LinkedHashMap();
        LinkedHashMap graphData_es = new LinkedHashMap();
        GetDataDashBoardRequest getDataDashBoardRequest = this.getGetDataDashBoardRequestWithReqeuest(request);
        List student_ids = this.studentCriteriaRepository.getStudentsByDemographics(getDataDashBoardRequest, false, true);
        System.out.println("----------------------------- Gender ------------------------------");
        if (AppUtils.isNotNullOrEmpty((List)request.getGenders())) {
            LinkedHashMap<String, LinkedList> genderMap_en = new LinkedHashMap<String, LinkedList>();
            LinkedHashMap<String, LinkedList> genderMap_es = new LinkedHashMap<String, LinkedList>();
            for (String gender : request.getGenders()) {
                Gender genderItem = this.genderRepository.findByGender(gender);
                System.out.println("-----------------------------" + gender + "------------------------------");
                values = this.getMostAndLeast(student_ids.stream().filter(studentDTO -> !AppUtils.isNullOrEmpty((String)studentDTO.getGender()) && studentDTO.getGender().equals(gender)).map(StudentDTO::getStudent_id).collect(Collectors.toList()), request.getFromDate(), request.getToDate());
                genderMap_en.put(gender, (LinkedList)values.get("en"));
                if (!Language.isSpanish()) continue;
                genderMap_es.put(genderItem.getGender_es(), (LinkedList)values.get("es"));
            }
            graphData_en.put("Gender", genderMap_en);
            if (Language.isSpanish()) {
                graphData_es.put("G\u00e9nero", genderMap_es);
            }
        }
        System.out.println("----------------------------- Age ------------------------------");
        if (AppUtils.isNotNullOrEmpty((List)request.getAges())) {
            LinkedHashMap<String, LinkedList> ageMap_en = new LinkedHashMap<String, LinkedList>();
            LinkedHashMap<String, LinkedList> ageMap_es = new LinkedHashMap<String, LinkedList>();
            for (Integer age : request.getAges()) {
                System.out.println("-----------------------------" + age + "------------------------------");
                LinkedHashMap values2 = this.getMostAndLeast(student_ids.stream().filter(studentDTO -> TimeUtils.getAge((Date)studentDTO.getDate_of_birth()) == age).map(StudentDTO::getStudent_id).collect(Collectors.toList()), request.getFromDate(), request.getToDate());
                ageMap_en.put(String.valueOf(age), (LinkedList)values2.get("en"));
                if (!Language.isSpanish()) continue;
                ageMap_es.put(String.valueOf(age), (LinkedList)values2.get("es"));
            }
            graphData_en.put("Age", ageMap_en);
            if (Language.isSpanish()) {
                graphData_es.put("Edad", ageMap_es);
            }
        }
        System.out.println("---------------------------- Ethnicity ------------------------------");
        if (AppUtils.isNotNullOrEmpty((List)request.getEthnicity())) {
            LinkedHashMap<String, LinkedList> ethnicityMap_en = new LinkedHashMap<String, LinkedList>();
            LinkedHashMap<String, LinkedList> ethnicityMap_es = new LinkedHashMap<String, LinkedList>();
            for (String ethnicity : request.getEthnicity()) {
                Ethnicity ethnicityItem = this.ethnicityRepository.findByEthnicity(ethnicity);
                System.out.println("-----------------------------" + ethnicity + "------------------------------");
                values = this.getMostAndLeast(student_ids.stream().filter(studentDTO -> studentDTO.getEthnicity().equals(ethnicityItem.getEthnicity())).map(StudentDTO::getStudent_id).collect(Collectors.toList()), request.getFromDate(), request.getToDate());
                ethnicityMap_en.put(ethnicity, (LinkedList)values.get("en"));
                if (!Language.isSpanish()) continue;
                ethnicityMap_es.put(ethnicityItem.getEthnicity_es(), (LinkedList)values.get("es"));
            }
            graphData_en.put("Ethnicity", ethnicityMap_en);
            if (Language.isSpanish()) {
                graphData_es.put("Etnia", ethnicityMap_es);
            }
        }
        System.out.println("----------------------------- Grade ------------------------------");
        if (AppUtils.isNotNullOrEmpty((List)request.getGradeIds())) {
            LinkedHashMap<String, LinkedList> gradeMap_en = new LinkedHashMap<String, LinkedList>();
            LinkedHashMap<String, LinkedList> gradeMap_es = new LinkedHashMap<String, LinkedList>();
            for (Long grade_id : request.getGradeIds()) {
                GradeView gradeView = this.gradeRepository.findByGradeId(grade_id);
                System.out.println("-----------------------------" + grade_id + "------------------------------");
                values = this.getMostAndLeast(student_ids.stream().filter(studentDTO -> Objects.equals(studentDTO.getGrade_id(), grade_id)).map(StudentDTO::getStudent_id).collect(Collectors.toList()), request.getFromDate(), request.getToDate());
                gradeMap_en.put(gradeView.getGrade_name(), (LinkedList)values.get("en"));
                if (!Language.isSpanish()) continue;
                gradeMap_es.put(gradeView.getGrade_name_es(), (LinkedList)values.get("es"));
            }
            graphData_en.put("Grade", gradeMap_en);
            if (Language.isSpanish()) {
                graphData_es.put("Grado", gradeMap_es);
            }
        }
        System.out.println("----------------------------- Overall ------------------------------");
        LinkedHashMap values3 = this.getMostAndLeast(student_ids.stream().map(StudentDTO::getStudent_id).collect(Collectors.toList()), request.getFromDate(), request.getToDate());
        LinkedHashMap<String, LinkedList> overall_en = new LinkedHashMap<String, LinkedList>();
        overall_en.put("Overall", (LinkedList)values3.get("en"));
        LinkedHashMap<String, LinkedList> overall_es = new LinkedHashMap<String, LinkedList>();
        overall_es.put("En total", (LinkedList)values3.get("es"));
        graphData_en.put("Overall", overall_en);
        graphData_es.put("En total", overall_es);
        LinkedHashMap graphData = new LinkedHashMap();
        graphData.put("en", graphData_en);
        if (Language.isSpanish()) {
            graphData.put("es", graphData_es);
        }
        return graphData;
    }

    public Object getMostAndLeastReportedData2(GetDataDashBoardRequest request) {
        List student_ids = this.studentCriteriaRepository.getStudentsByDemographics(request, false, true);
        LinkedHashMap values = this.getMostAndLeast2(student_ids.stream().map(StudentDTO::getStudent_id).collect(Collectors.toList()), request.getFromDate(), request.getToDate());
        LinkedHashMap graphData = new LinkedHashMap();
        graphData.put("en", values.get("en"));
        if (Language.isSpanish()) {
            graphData.put("es", values.get("es"));
        }
        return graphData;
    }

    public LinkedHashMap<String, LinkedList<String>> getMostAndLeast(List<Long> student_ids, Date fromDate, Date toDate) {
        List socialAwarenessUpdateList = this.socialAwarenessUpdateService.getSocialAwarenessUpdateByStudentIds(student_ids, fromDate, toDate);
        LinkedList assessmentOccurances = this.removeAssessmentOccuranceWithZeroCountFromAssessmentOccuranceList(this.getFriendshipAnalysis(socialAwarenessUpdateList, true));
        LinkedList<Object> mostAndLeast_en = new LinkedList<Object>();
        LinkedList<Object> mostAndLeast_es = new LinkedList<Object>();
        if (AppUtils.isNotNullOrEmpty((List)assessmentOccurances)) {
            AssessmentOccurrence most = (AssessmentOccurrence)assessmentOccurances.get(0);
            AssessmentOccurrence least = (AssessmentOccurrence)assessmentOccurances.get(assessmentOccurances.size() - 1);
            if (most.getCount() > 0.0) {
                mostAndLeast_en.add(most.getText_to_display() + " ( " + most.getCount() + " ) ");
                if (Language.isSpanish()) {
                    mostAndLeast_es.add(most.getText_to_display_es() + " ( " + most.getCount() + " ) ");
                }
            } else {
                mostAndLeast_en.add(" ( " + least.getCount() + " ) ");
                if (Language.isSpanish()) {
                    mostAndLeast_es.add(" ( " + least.getCount() + " ) ");
                }
            }
            if (least.getCount() > 0.0) {
                mostAndLeast_en.add(least.getText_to_display() + " ( " + least.getCount() + " ) ");
                if (Language.isSpanish()) {
                    mostAndLeast_es.add(least.getText_to_display_es() + " ( " + least.getCount() + " ) ");
                }
            } else {
                mostAndLeast_en.add(" ( " + least.getCount() + " ) ");
                if (Language.isSpanish()) {
                    mostAndLeast_es.add(" ( " + least.getCount() + " ) ");
                }
            }
        } else {
            mostAndLeast_en.add("");
            mostAndLeast_en.add("");
            if (Language.isSpanish()) {
                mostAndLeast_es.add("");
                mostAndLeast_es.add("");
            }
        }
        LinkedHashMap<String, LinkedList<String>> graphData = new LinkedHashMap<String, LinkedList<String>>();
        graphData.put("en", mostAndLeast_en);
        if (Language.isSpanish()) {
            graphData.put("es", mostAndLeast_es);
        }
        return graphData;
    }

    public LinkedHashMap<String, LinkedList<String>> getMostAndLeast2(List<Long> student_ids, Date fromDate, Date toDate) {
        List socialAwarenessUpdateList = this.socialAwarenessUpdateService.getSocialAwarenessUpdateByStudentIds(student_ids, fromDate, toDate);
        LinkedList assessmentOccurances = this.removeAssessmentOccuranceWithZeroCountFromAssessmentOccuranceList(this.getFriendshipAnalysis(socialAwarenessUpdateList, true));
        LinkedList<Object> mostAndLeast_en = new LinkedList<Object>();
        LinkedList<Object> mostAndLeast_es = new LinkedList<Object>();
        if (AppUtils.isNotNullOrEmpty((List)assessmentOccurances)) {
            AssessmentOccurrence most = (AssessmentOccurrence)assessmentOccurances.get(0);
            AssessmentOccurrence least = (AssessmentOccurrence)assessmentOccurances.get(assessmentOccurances.size() - 1);
            if (most.getCount() > 0.0) {
                mostAndLeast_en.add(most.getText_to_display() + " : " + most.getCount());
                if (Language.isSpanish()) {
                    mostAndLeast_es.add(most.getText_to_display_es() + " : " + most.getCount());
                }
            } else {
                mostAndLeast_en.add(" : " + least.getCount());
                if (Language.isSpanish()) {
                    mostAndLeast_es.add(" : " + least.getCount());
                }
            }
            if (least.getCount() > 0.0) {
                mostAndLeast_en.add(least.getText_to_display() + " : " + least.getCount());
                if (Language.isSpanish()) {
                    mostAndLeast_es.add(least.getText_to_display_es() + " : " + least.getCount());
                }
            } else {
                mostAndLeast_en.add(" : " + least.getCount());
                if (Language.isSpanish()) {
                    mostAndLeast_es.add(" : " + least.getCount());
                }
            }
        } else {
            mostAndLeast_en.add("");
            mostAndLeast_en.add("");
            if (Language.isSpanish()) {
                mostAndLeast_es.add("");
                mostAndLeast_es.add("");
            }
        }
        LinkedHashMap<String, LinkedList<String>> graphData = new LinkedHashMap<String, LinkedList<String>>();
        graphData.put("en", mostAndLeast_en);
        if (Language.isSpanish()) {
            graphData.put("es", mostAndLeast_es);
        }
        return graphData;
    }

    private LinkedList<AssessmentOccurrence> removeAssessmentOccuranceWithZeroCountFromAssessmentOccuranceList(LinkedList<AssessmentOccurrence> list) {
        Iterator itr = list.iterator();
        while (itr.hasNext()) {
            AssessmentOccurrence x = (AssessmentOccurrence)itr.next();
            if (x.getCount() != 0.0) continue;
            itr.remove();
        }
        return list;
    }

    public Object getFriendshipAnalysisAndCompetencyScoreGraphData(GetDataDashBoardRequest request) {
        LinkedHashMap values;
        GetDataDashBoardRequest getDataDashBoardRequest;
        LinkedHashMap<String, LinkedHashMap> graphData_en = new LinkedHashMap<String, LinkedHashMap>();
        LinkedHashMap<String, LinkedHashMap> graphData_es = new LinkedHashMap<String, LinkedHashMap>();
        if (AppUtils.isNotNullOrEmpty((List)request.getGenders())) {
            getDataDashBoardRequest = this.getGetDataDashBoardRequestWithReqeuest(request);
            getDataDashBoardRequest.getGenders().addAll(request.getGenders());
            values = this.getFriendshipAnalysisAndCompetencyScore(getDataDashBoardRequest);
            graphData_en.put("Gender", (LinkedHashMap)values.get("en"));
            if (Language.isSpanish()) {
                graphData_es.put("G\u00e9nero", (LinkedHashMap)values.get("es"));
            }
        }
        if (AppUtils.isNotNullOrEmpty((List)request.getAges())) {
            getDataDashBoardRequest = this.getGetDataDashBoardRequestWithReqeuest(request);
            getDataDashBoardRequest.getAges().addAll(request.getAges());
            values = this.getFriendshipAnalysisAndCompetencyScore(getDataDashBoardRequest);
            graphData_en.put("Age", (LinkedHashMap)values.get("en"));
            if (Language.isSpanish()) {
                graphData_es.put("Edad", (LinkedHashMap)values.get("es"));
            }
        }
        if (AppUtils.isNotNullOrEmpty((List)request.getEthnicity())) {
            getDataDashBoardRequest = this.getGetDataDashBoardRequestWithReqeuest(request);
            getDataDashBoardRequest.getEthnicity().addAll(request.getEthnicity());
            values = this.getFriendshipAnalysisAndCompetencyScore(getDataDashBoardRequest);
            graphData_en.put("Ethnicity", (LinkedHashMap)values.get("en"));
            if (Language.isSpanish()) {
                graphData_es.put("Etnia", (LinkedHashMap)values.get("es"));
            }
        }
        if (AppUtils.isNotNullOrEmpty((List)request.getGradeIds())) {
            GetDataDashBoardRequest getSocioEmotionalDataAnalyticsRequest = this.getGetDataDashBoardRequestWithReqeuest(request);
            getSocioEmotionalDataAnalyticsRequest.getGradeIds().addAll(request.getGradeIds());
            values = this.getFriendshipAnalysisAndCompetencyScore(getSocioEmotionalDataAnalyticsRequest);
            graphData_en.put("Grade", (LinkedHashMap)values.get("en"));
            if (Language.isSpanish()) {
                graphData_es.put("Grado", (LinkedHashMap)values.get("es"));
            }
        }
        LinkedHashMap<String, Object> graphData = new LinkedHashMap<String, Object>();
        graphData.put("en", LabelAndDataHelper.getLabelsAndMultiDatasets(graphData_en));
        if (Language.isSpanish()) {
            graphData.put("es", LabelAndDataHelper.getLabelsAndMultiDatasets(graphData_es));
        }
        return graphData;
    }

    public LinkedHashMap<String, LinkedHashMap<String, LinkedList<Double>>> getFriendshipAnalysisAndCompetencyScore(GetDataDashBoardRequest request) {
        System.out.println("----------------------------FRIENDSHIP_ANALYSIS_AND_COMPETENCY_SCORE--------------------------------------");
        List student_ids = this.studentCriteriaRepository.getStudentIdsByDemographics(request, false, true);
        List socialAwarenessUpdateList = this.socialAwarenessUpdateService.getSocialAwarenessUpdateByStudentIds(student_ids, request.getFromDate(), request.getToDate());
        LinkedList assessmentOccuranceAndCompetencyScores = this.getFriendshipAnalysisCompetencyScore(socialAwarenessUpdateList, false);
        LinkedHashMap graphData_en = new LinkedHashMap();
        LinkedHashMap graphData_es = new LinkedHashMap();
        Long socio_emotional_test_question_type_id = request.getSocio_emotional_test_question_type_id();
        for (int i = 0; i < assessmentOccuranceAndCompetencyScores.size(); ++i) {
            if (((AssessmentOccuranceAndCompetencyScore)assessmentOccuranceAndCompetencyScores.get(i)).getCount() > 0L && AppUtils.isNotNullOrEmpty((LinkedHashSet)((AssessmentOccuranceAndCompetencyScore)assessmentOccuranceAndCompetencyScores.get(i)).getStudentIds())) {
                List values = this.socioEmotionalTestResultService.getSocioEmotionalTestResultByStudentIds(((AssessmentOccuranceAndCompetencyScore)assessmentOccuranceAndCompetencyScores.get(i)).getStudentIds(), request.getFromDate(), request.getToDate());
                if (socio_emotional_test_question_type_id == null) {
                    if (!values.isEmpty()) {
                        Double score = 0.0;
                        for (SocioEmotionalTestResult test : values) {
                            score = score + (double)test.getScore();
                        }
                        ((AssessmentOccuranceAndCompetencyScore)assessmentOccuranceAndCompetencyScores.get(i)).setScore(DigitUtils.formatDoubleInTwoDigit((Double)DigitUtils.getAverage((Double)score, (Double)Double.valueOf(values.size()))));
                    }
                } else {
                    SocioEmotionalTestDataWrapper s = new SocioEmotionalTestDataWrapper();
                    s.setOptions(this.socioEmotionalTestQuestionOptionRepository.findAll());
                    s.setQuestions(this.socioEmotionalTestQuestionRepository.findBySocioEmotionalTestQuestionTypeId(socio_emotional_test_question_type_id));
                    if (!values.isEmpty()) {
                        Double score = 0.0;
                        for (SocioEmotionalTestResult test : values) {
                            Double total_score = 0.0;
                            List socioEmotionalTestAnswers = this.socioEmotionalTestAnswerRepository.findBySocioEmotionalTestResultId(Long.valueOf(test.getSocio_emotional_test_result_id()));
                            for (int q = 0; q < s.getQuestions().size(); ++q) {
                                SocioEmotionalTestQuestion socioEmotionalTestQuestion = (SocioEmotionalTestQuestion)s.getQuestions().get(q);
                                block4: for (int a = 0; a < socioEmotionalTestAnswers.size(); ++a) {
                                    if (socioEmotionalTestQuestion.getSocio_emotional_test_question_id() != ((SocioEmotionalTestAnswer)socioEmotionalTestAnswers.get(a)).getSocio_emotional_test_question_id()) continue;
                                    SocioEmotionalTestAnswer socioEmotionalTestAnswer = (SocioEmotionalTestAnswer)socioEmotionalTestAnswers.get(a);
                                    for (int o = 0; o < s.getOptions().size(); ++o) {
                                        if (socioEmotionalTestAnswer.getSocio_emotional_test_question_option_id() != ((SocioEmotionalTestQuestionOption)s.getOptions().get(o)).getSocio_emotional_test_question_option_id()) continue;
                                        SocioEmotionalTestQuestionOption socioEmotionalTestQuestionOption = (SocioEmotionalTestQuestionOption)s.getOptions().get(o);
                                        total_score = socioEmotionalTestQuestion.isReversed() ? Double.valueOf(total_score + (double)socioEmotionalTestQuestionOption.getReverse_weight()) : Double.valueOf(total_score + (double)socioEmotionalTestQuestionOption.getWeight());
                                        System.out.println("total_score = " + total_score);
                                        continue block4;
                                    }
                                }
                            }
                            score = score + total_score;
                            System.out.println("test id " + test.getSocio_emotional_test_result_id() + "  score = " + score);
                        }
                        ((AssessmentOccuranceAndCompetencyScore)assessmentOccuranceAndCompetencyScores.get(i)).setScore(DigitUtils.formatDoubleInTwoDigit((Double)DigitUtils.getAverage((Double)score, (Double)Double.valueOf(values.size()))));
                    }
                }
            }
            LinkedList<Double> list = new LinkedList<Double>();
            list.add(DigitUtils.formatDoubleInTwoDigit((Double)((Object)((AssessmentOccuranceAndCompetencyScore)assessmentOccuranceAndCompetencyScores.get(i)).getCount())));
            list.add(DigitUtils.formatDoubleInTwoDigit((Double)((AssessmentOccuranceAndCompetencyScore)assessmentOccuranceAndCompetencyScores.get(i)).getScore()));
            graphData_en.put(((AssessmentOccuranceAndCompetencyScore)assessmentOccuranceAndCompetencyScores.get(i)).getText_to_display(), list);
            if (!Language.isSpanish()) continue;
            graphData_es.put(((AssessmentOccuranceAndCompetencyScore)assessmentOccuranceAndCompetencyScores.get(i)).getText_to_display_es(), list);
        }
        LinkedHashMap<String, LinkedHashMap<String, LinkedList<Double>>> graphData = new LinkedHashMap<String, LinkedHashMap<String, LinkedList<Double>>>();
        graphData.put("en", graphData_en);
        if (Language.isSpanish()) {
            graphData.put("es", graphData_es);
        }
        return graphData;
    }

    private GetDataDashBoardRequest getGetDataDashBoardRequestWithReqeuest(GetDataDashBoardRequest request) {
        GetDataDashBoardRequest getDataDashBoardRequest = new GetDataDashBoardRequest();
        getDataDashBoardRequest.setTimeLine(request.getTimeLine());
        getDataDashBoardRequest.setSocio_emotional_test_question_type_id(request.getSocio_emotional_test_question_type_id());
        getDataDashBoardRequest.setGraphType(request.getGraphType());
        getDataDashBoardRequest.setFromDate(request.getFromDate());
        getDataDashBoardRequest.setToDate(request.getToDate());
        getDataDashBoardRequest.setTimeZone(request.getTimeZone());
        return getDataDashBoardRequest;
    }

    public LinkedList<AssessmentOccuranceAndCompetencyScore> getFriendshipAnalysisCompetencyScore(List<SocialAwarenessUpdate> socialAwarenessUpdateList, boolean isSortData) {
        LinkedList<AssessmentOccuranceAndCompetencyScore> list = new LinkedList<AssessmentOccuranceAndCompetencyScore>();
        for (String[] text : this.socialAwarenessUpdateService.getTextList()) {
            list.add(new AssessmentOccuranceAndCompetencyScore(text[0], text[1], Long.valueOf(0L)));
        }
        for (SocialAwarenessUpdate socialAwarenessUpdate : socialAwarenessUpdateList) {
            for (AssessmentOccuranceAndCompetencyScore assessmentOccuranceAndCompetencyScore : list) {
                if (!assessmentOccuranceAndCompetencyScore.getText_to_display().toLowerCase().trim().equalsIgnoreCase(socialAwarenessUpdate.getText().toLowerCase().trim())) continue;
                for (AssessmentOccuranceAndCompetencyScore o : list) {
                    if (!o.getText_to_display().equals(assessmentOccuranceAndCompetencyScore.getText_to_display())) continue;
                    o.setCount(Long.valueOf(o.getCount() + 1L));
                    o.getStudentIds().add(socialAwarenessUpdate.getStudent_id());
                }
            }
        }
        if (isSortData) {
            Collections.sort(list, new /* Unavailable Anonymous Inner Class!! */);
        }
        return list;
    }

    public LinkedList<AssessmentOccurrence> getFriendshipAnalysis(List<SocialAwarenessUpdate> socialAwarenessUpdateList, boolean isSortData) {
        LinkedList<AssessmentOccurrence> list = new LinkedList<AssessmentOccurrence>();
        for (String[] text : this.socialAwarenessUpdateService.getTextList()) {
            list.add(new AssessmentOccurrence(0L, text[0], text[1], 0.0, 0L, 0.0, null));
        }
        for (SocialAwarenessUpdate socialAwarenessUpdate : socialAwarenessUpdateList) {
            for (AssessmentOccurrence assessmentOccurance : list) {
                if (!assessmentOccurance.getText_to_display().toLowerCase().trim().equalsIgnoreCase(socialAwarenessUpdate.getText().toLowerCase().trim())) continue;
                for (AssessmentOccurrence o : list) {
                    if (!o.getText_to_display().equals(assessmentOccurance.getText_to_display())) continue;
                    o.setCount(o.getCount() + 1.0);
                }
            }
        }
        if (isSortData) {
            Collections.sort(list, new /* Unavailable Anonymous Inner Class!! */);
        }
        return list;
    }

    private static /* synthetic */ String[] lambda$getMoodUpdateMapByTimeline$7(Map.Entry entry) {
        return new String[]{(String)entry.getKey(), (String)entry.getValue()};
    }

    private static /* synthetic */ String[] lambda$getMoodUpdateMapByTimeline$6(Map.Entry entry) {
        return new String[]{(String)entry.getKey(), (String)entry.getValue()};
    }

    private static /* synthetic */ String[] lambda$getMoodUpdateMapByTimeline$5(Map.Entry entry) {
        return new String[]{(String)entry.getKey(), (String)entry.getValue()};
    }
}

