/*
 * Decompiled with CFR 0.152.
 */
package com.infinite.focus.server.moodandcolor.controller;

import com.infinite.focus.server.auth.model.Message;
import com.infinite.focus.server.auth.service.AuthService;
import com.infinite.focus.server.moodandcolor.dto.MoodAndColorDTO;
import com.infinite.focus.server.moodandcolor.request.CreateMoodAndColorRequest;
import com.infinite.focus.server.moodandcolor.request.GetMoodAndColorByMoodIdRequest;
import com.infinite.focus.server.moodandcolor.service.MoodAndColorService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@CrossOrigin(origins={"http://localhost:8383"})
@RestController
@RequestMapping(value={"api/mood-and-color"})
public class MoodAndColorController {
    @Autowired
    private AuthService authService;
    @Autowired
    private MoodAndColorService moodAndColorService;

    @PostMapping
    public ResponseEntity<MoodAndColorDTO> create(@RequestBody CreateMoodAndColorRequest request) {
        return new ResponseEntity((Object)this.moodAndColorService.create(Long.valueOf(request.getMood_id()), request.getColor_primary(), request.getColor_secondary(), request.getColor_tertiary()), (HttpStatusCode)HttpStatus.CREATED);
    }

    @PostMapping(value={"/get-mood-and-color-by-mood-id"})
    public ResponseEntity<MoodAndColorDTO> getMoodAndColorByMoodId(@RequestBody GetMoodAndColorByMoodIdRequest request) {
        return new ResponseEntity((Object)this.moodAndColorService.getMoodAndColorByMoodId(request.getMood_id()), (HttpStatusCode)HttpStatus.OK);
    }

    @PostMapping(value={"/fill-mood-and-color"})
    public ResponseEntity<Message> fillMoodAndColor(@RequestHeader(value="Authorization") String token) {
        this.authService.isAdmin(token);
        this.moodAndColorService.create(Long.valueOf(1L), "#FFC200", "#FFE17F", "#FFF3CC");
        this.moodAndColorService.create(Long.valueOf(2L), "#F93E49", "#FC9FA4", "#FED8DB");
        this.moodAndColorService.create(Long.valueOf(3L), "#8F41A2", "#E0C1E8", "#FBE5FF");
        this.moodAndColorService.create(Long.valueOf(11L), "#2AA5F9", "#9FD7FC", "#DBF1FF");
        this.moodAndColorService.create(Long.valueOf(13L), "#CCCCCC", "#E5E5E5", "#F5F5F5");
        this.moodAndColorService.create(Long.valueOf(7L), "#F35CA1", "#FFAECE", "#FEE2F0");
        this.moodAndColorService.create(Long.valueOf(14L), "#FF6E01", "#FFAF74", "#FFE7D4");
        this.moodAndColorService.create(Long.valueOf(12L), "#3CAD77", "#95D5B3", "#D7F3DC");
        return new ResponseEntity((Object)new Message("Done"), (HttpStatusCode)HttpStatus.CREATED);
    }
}

