/*
 * Decompiled with CFR 0.152.
 */
package com.infinite.focus.server.organization.repository;

import com.infinite.focus.server.freetrial.model.OrganizationType;
import com.infinite.focus.server.organization.dto.OrganizationDTO;
import com.infinite.focus.server.organization.repository.OrganizationRepository;
import com.infinite.focus.server.organization.request.GetOrganizationsRequest;
import com.infinite.focus.server.utils.AppUtils;
import com.infinite.focus.server.utils.DateUtils;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Repository;

@Repository
public class OrganizationRepositoryImpl
implements OrganizationRepository {
    private final NamedParameterJdbcTemplate namedParameterJdbcTemplate;
    private final String ORGANIZATION = "(\n    SELECT\n        UUID() AS uuid,\n        organization_id,\n        name_of_organization,\n        organization_type,\n        license_key,\n        licence_key_added_date,\n        licence_key_expiry_date,\n        active,\n        deleted,\n        address,\n        city,\n        state,\n        number_of_youth,\n        focus_on,\n        email,\n        created_at\n    FROM (\n        SELECT\n            dist.district_id AS organization_id,\n            \"LARGE_ORGANIZATION\" As organization_type,\n            dist.district_name AS name_of_organization,\n            dist.license_key,\n            dist.licence_key_added_date,\n            dist.licence_key_expiry_date,\n            dist.active,\n            dist.deleted,\n            NULL as address,\n            dist.city AS city,\n            dist.state AS state,\n            dist.number_of_youth,\n            dist.focus_on,\n            acc.username AS email,\n            dist.created_at\n        FROM district dist\n        JOIN account acc ON dist.account_id = acc.account_id\n        UNION ALL\n        SELECT\n            sch.school_id AS organization_id,\n            \"ORGANIZATION\" AS organization_type,\n            sch.school_name AS name_of_organization,\n            sch.license_key,\n            sch.licence_key_added_date,\n            sch.licence_key_expiry_date,\n            sch.active,\n            sch.deleted,\n            sch.address as address,\n            NULL as city,\n            NULL as state,\n            sch.number_of_youth,\n            sch.focus_on,\n            acco.username AS email,\n            sch.created_at\n        FROM school sch\n        JOIN account acco ON sch.account_id = acco.account_id\n    ) AS organization\n)\n";

    public OrganizationRepositoryImpl(NamedParameterJdbcTemplate namedParameterJdbcTemplate) {
        this.namedParameterJdbcTemplate = namedParameterJdbcTemplate;
    }

    private RowMapper<OrganizationDTO> organizationRowMapper() {
        return (rs, rowNum) -> {
            OrganizationDTO organization = OrganizationDTO.builder().uuid(UUID.fromString(rs.getString("uuid"))).organization_id(rs.getLong("organization_id")).name_of_organization(rs.getString("name_of_organization")).organization_type(rs.getString("organization_type")).license_key(rs.getString("license_key")).licence_key_added_date((Date)rs.getDate("licence_key_added_date")).licence_key_expiry_date((Date)rs.getTimestamp("licence_key_expiry_date")).active(rs.getBoolean("active")).deleted(rs.getBoolean("deleted")).address(rs.getString("address")).city(rs.getString("city")).state(rs.getString("state")).number_of_youth(rs.getInt("number_of_youth")).focus_on(rs.getString("focus_on")).email(rs.getString("email")).createdAt((Date)rs.getDate("created_at")).build();
            return organization;
        };
    }

    public Page<OrganizationDTO> getActiveOrganizations(GetOrganizationsRequest request) {
        ArrayList<String> organizationTypes = new ArrayList<String>();
        for (String organization_type : request.getOrganization_types().split("\\s*,\\s*")) {
            if (organization_type.equals(OrganizationType.LARGE_ORGANIZATION.toString())) {
                organizationTypes.add(OrganizationType.LARGE_ORGANIZATION.toString());
            }
            if (!organization_type.equals(OrganizationType.ORGANIZATION.toString())) continue;
            organizationTypes.add(OrganizationType.ORGANIZATION.toString());
        }
        StringBuilder sql = new StringBuilder("SELECT * FROM (").append("(\n    SELECT\n        UUID() AS uuid,\n        organization_id,\n        name_of_organization,\n        organization_type,\n        license_key,\n        licence_key_added_date,\n        licence_key_expiry_date,\n        active,\n        deleted,\n        address,\n        city,\n        state,\n        number_of_youth,\n        focus_on,\n        email,\n        created_at\n    FROM (\n        SELECT\n            dist.district_id AS organization_id,\n            \"LARGE_ORGANIZATION\" As organization_type,\n            dist.district_name AS name_of_organization,\n            dist.license_key,\n            dist.licence_key_added_date,\n            dist.licence_key_expiry_date,\n            dist.active,\n            dist.deleted,\n            NULL as address,\n            dist.city AS city,\n            dist.state AS state,\n            dist.number_of_youth,\n            dist.focus_on,\n            acc.username AS email,\n            dist.created_at\n        FROM district dist\n        JOIN account acc ON dist.account_id = acc.account_id\n        UNION ALL\n        SELECT\n            sch.school_id AS organization_id,\n            \"ORGANIZATION\" AS organization_type,\n            sch.school_name AS name_of_organization,\n            sch.license_key,\n            sch.licence_key_added_date,\n            sch.licence_key_expiry_date,\n            sch.active,\n            sch.deleted,\n            sch.address as address,\n            NULL as city,\n            NULL as state,\n            sch.number_of_youth,\n            sch.focus_on,\n            acco.username AS email,\n            sch.created_at\n        FROM school sch\n        JOIN account acco ON sch.account_id = acco.account_id\n    ) AS organization\n)\n").append(") AS org WHERE ");
        StringBuilder countSql = new StringBuilder("SELECT COUNT(*) FROM (").append("(\n    SELECT\n        UUID() AS uuid,\n        organization_id,\n        name_of_organization,\n        organization_type,\n        license_key,\n        licence_key_added_date,\n        licence_key_expiry_date,\n        active,\n        deleted,\n        address,\n        city,\n        state,\n        number_of_youth,\n        focus_on,\n        email,\n        created_at\n    FROM (\n        SELECT\n            dist.district_id AS organization_id,\n            \"LARGE_ORGANIZATION\" As organization_type,\n            dist.district_name AS name_of_organization,\n            dist.license_key,\n            dist.licence_key_added_date,\n            dist.licence_key_expiry_date,\n            dist.active,\n            dist.deleted,\n            NULL as address,\n            dist.city AS city,\n            dist.state AS state,\n            dist.number_of_youth,\n            dist.focus_on,\n            acc.username AS email,\n            dist.created_at\n        FROM district dist\n        JOIN account acc ON dist.account_id = acc.account_id\n        UNION ALL\n        SELECT\n            sch.school_id AS organization_id,\n            \"ORGANIZATION\" AS organization_type,\n            sch.school_name AS name_of_organization,\n            sch.license_key,\n            sch.licence_key_added_date,\n            sch.licence_key_expiry_date,\n            sch.active,\n            sch.deleted,\n            sch.address as address,\n            NULL as city,\n            NULL as state,\n            sch.number_of_youth,\n            sch.focus_on,\n            acco.username AS email,\n            sch.created_at\n        FROM school sch\n        JOIN account acco ON sch.account_id = acco.account_id\n    ) AS organization\n)\n").append(") AS org WHERE ");
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        ArrayList<String> conditions = new ArrayList<String>();
        if (AppUtils.isNotNullOrEmpty((String)request.getName_of_organization())) {
            conditions.add("LOWER(org.name_of_organization) LIKE :name_of_organization");
            parameters.addValue("name_of_organization", (Object)("%" + request.getName_of_organization().toLowerCase() + "%"));
        }
        if (AppUtils.isNotNullOrEmpty((String)request.getOrganization_types())) {
            conditions.add("org.organization_type IN (:organization_types)");
            parameters.addValue("organization_types", organizationTypes);
        }
        conditions.add("NOT EXISTS (SELECT 1 FROM free_trial ft WHERE ft.organization_id = org.organization_id AND ft.organization_type = org.organization_type AND ft.deleted = false)");
        conditions.add("( (org.license_key IS NOT NULL AND org.license_key != '' AND org.licence_key_expiry_date >= :current_date) OR (org.license_key IS NULL AND org.licence_key_expiry_date IS NULL) OR (org.license_key IS NULL AND org.licence_key_expiry_date >= :current_date))");
        parameters.addValue("current_date", (Object)new Date());
        conditions.add("org.active = true");
        conditions.add("org.deleted = false");
        if (request.getFromDate() != null && request.getToDate() != null) {
            conditions.add("org.licence_key_expiry_date BETWEEN :from_date AND :to_date");
            parameters.addValue("from_date", (Object)request.getFromDate());
            parameters.addValue("to_date", (Object)request.getToDate());
        }
        sql.append(String.join((CharSequence)" AND ", conditions));
        countSql.append(String.join((CharSequence)" AND ", conditions));
        String sortBy = request.getSortBy();
        String orderBy = request.getOrderBy().equals("desc") ? "DESC" : "ASC";
        sql.append(" ORDER BY ").append(sortBy).append(" ").append(orderBy);
        PageRequest pageable = PageRequest.of((int)request.getPageNo(), (int)request.getPageSize(), (Sort)(request.getOrderBy().equals("desc") ? Sort.by((String[])new String[]{sortBy}).descending() : Sort.by((String[])new String[]{sortBy}).ascending()));
        sql.append(" LIMIT :limit OFFSET :offset");
        parameters.addValue("limit", (Object)pageable.getPageSize());
        parameters.addValue("offset", (Object)pageable.getOffset());
        List result = this.namedParameterJdbcTemplate.query(sql.toString(), (SqlParameterSource)parameters, this.organizationRowMapper());
        Long count = (Long)this.namedParameterJdbcTemplate.queryForObject(countSql.toString(), (SqlParameterSource)parameters, Long.class);
        return new PageImpl(result, (Pageable)pageable, count.longValue());
    }

    public Page<OrganizationDTO> getInactiveOrganizations(GetOrganizationsRequest request) {
        if (request.isMoreThan30Days()) {
            request.setFromDate(DateUtils.subtractDaysInDate((Date)request.getFromDate(), (int)30));
            request.setToDate(DateUtils.subtractDaysInDate((Date)request.getToDate(), (int)30));
        }
        ArrayList<String> organizationTypes = new ArrayList<String>();
        for (String organization_type : request.getOrganization_types().split("\\s*,\\s*")) {
            if (organization_type.equals(OrganizationType.LARGE_ORGANIZATION.toString())) {
                organizationTypes.add(OrganizationType.LARGE_ORGANIZATION.toString());
            }
            if (!organization_type.equals(OrganizationType.ORGANIZATION.toString())) continue;
            organizationTypes.add(OrganizationType.ORGANIZATION.toString());
        }
        StringBuilder sql = new StringBuilder("SELECT * FROM (").append("(\n    SELECT\n        UUID() AS uuid,\n        organization_id,\n        name_of_organization,\n        organization_type,\n        license_key,\n        licence_key_added_date,\n        licence_key_expiry_date,\n        active,\n        deleted,\n        address,\n        city,\n        state,\n        number_of_youth,\n        focus_on,\n        email,\n        created_at\n    FROM (\n        SELECT\n            dist.district_id AS organization_id,\n            \"LARGE_ORGANIZATION\" As organization_type,\n            dist.district_name AS name_of_organization,\n            dist.license_key,\n            dist.licence_key_added_date,\n            dist.licence_key_expiry_date,\n            dist.active,\n            dist.deleted,\n            NULL as address,\n            dist.city AS city,\n            dist.state AS state,\n            dist.number_of_youth,\n            dist.focus_on,\n            acc.username AS email,\n            dist.created_at\n        FROM district dist\n        JOIN account acc ON dist.account_id = acc.account_id\n        UNION ALL\n        SELECT\n            sch.school_id AS organization_id,\n            \"ORGANIZATION\" AS organization_type,\n            sch.school_name AS name_of_organization,\n            sch.license_key,\n            sch.licence_key_added_date,\n            sch.licence_key_expiry_date,\n            sch.active,\n            sch.deleted,\n            sch.address as address,\n            NULL as city,\n            NULL as state,\n            sch.number_of_youth,\n            sch.focus_on,\n            acco.username AS email,\n            sch.created_at\n        FROM school sch\n        JOIN account acco ON sch.account_id = acco.account_id\n    ) AS organization\n)\n").append(") AS org WHERE ");
        StringBuilder countSql = new StringBuilder("SELECT COUNT(*) FROM (").append("(\n    SELECT\n        UUID() AS uuid,\n        organization_id,\n        name_of_organization,\n        organization_type,\n        license_key,\n        licence_key_added_date,\n        licence_key_expiry_date,\n        active,\n        deleted,\n        address,\n        city,\n        state,\n        number_of_youth,\n        focus_on,\n        email,\n        created_at\n    FROM (\n        SELECT\n            dist.district_id AS organization_id,\n            \"LARGE_ORGANIZATION\" As organization_type,\n            dist.district_name AS name_of_organization,\n            dist.license_key,\n            dist.licence_key_added_date,\n            dist.licence_key_expiry_date,\n            dist.active,\n            dist.deleted,\n            NULL as address,\n            dist.city AS city,\n            dist.state AS state,\n            dist.number_of_youth,\n            dist.focus_on,\n            acc.username AS email,\n            dist.created_at\n        FROM district dist\n        JOIN account acc ON dist.account_id = acc.account_id\n        UNION ALL\n        SELECT\n            sch.school_id AS organization_id,\n            \"ORGANIZATION\" AS organization_type,\n            sch.school_name AS name_of_organization,\n            sch.license_key,\n            sch.licence_key_added_date,\n            sch.licence_key_expiry_date,\n            sch.active,\n            sch.deleted,\n            sch.address as address,\n            NULL as city,\n            NULL as state,\n            sch.number_of_youth,\n            sch.focus_on,\n            acco.username AS email,\n            sch.created_at\n        FROM school sch\n        JOIN account acco ON sch.account_id = acco.account_id\n    ) AS organization\n)\n").append(") AS org WHERE ");
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        ArrayList<CallSite> conditions = new ArrayList<CallSite>();
        ArrayList<String> predicate = new ArrayList<String>();
        ArrayList<String> predicate2 = new ArrayList<String>();
        ArrayList<String> predicate3 = new ArrayList<String>();
        if (AppUtils.isNotNullOrEmpty((String)request.getName_of_organization())) {
            predicate.add("LOWER(org.name_of_organization) LIKE :name_of_organization");
            predicate2.add("LOWER(org.name_of_organization) LIKE :name_of_organization");
            predicate3.add("LOWER(org.name_of_organization) LIKE :name_of_organization");
            parameters.addValue("name_of_organization", (Object)("%" + request.getName_of_organization().toLowerCase() + "%"));
        }
        if (AppUtils.isNotNullOrEmpty((String)request.getOrganization_types())) {
            predicate.add("org.organization_type IN (:organization_types)");
            predicate2.add("org.organization_type IN (:organization_types)");
            predicate3.add("org.organization_type IN (:organization_types)");
            parameters.addValue("organization_types", organizationTypes);
        }
        predicate.add("org.license_key IS NOT NULL");
        predicate.add("org.license_key != ''");
        predicate.add("org.licence_key_expiry_date <= :current_date");
        predicate.add("org.active = true");
        predicate.add("org.deleted = false");
        predicate2.add("org.license_key IS NOT NULL");
        predicate2.add("org.license_key != ''");
        predicate2.add("org.licence_key_expiry_date <= :current_date");
        predicate2.add("org.active = false");
        predicate2.add("org.deleted = false");
        predicate3.add("org.license_key IS NOT NULL");
        predicate3.add("org.license_key != ''");
        predicate3.add("org.licence_key_expiry_date >= :current_date");
        predicate3.add("org.active = false");
        predicate3.add("org.deleted = false");
        parameters.addValue("current_date", (Object)new Date());
        if (request.getFromDate() != null && request.getToDate() != null) {
            predicate.add("org.licence_key_expiry_date BETWEEN :from_date AND :to_date");
            predicate2.add("org.licence_key_expiry_date BETWEEN :from_date AND :to_date");
            predicate3.add("org.licence_key_expiry_date BETWEEN :from_date AND :to_date");
            parameters.addValue("from_date", (Object)request.getFromDate());
            parameters.addValue("to_date", (Object)request.getToDate());
        }
        conditions.add((CallSite)((Object)("(" + String.join((CharSequence)" AND ", predicate) + ")")));
        conditions.add((CallSite)((Object)("(" + String.join((CharSequence)" AND ", predicate2) + ")")));
        conditions.add((CallSite)((Object)("(" + String.join((CharSequence)" AND ", predicate3) + ")")));
        sql.append(String.join((CharSequence)" OR ", conditions));
        countSql.append(String.join((CharSequence)" OR ", conditions));
        String sortBy = request.getSortBy();
        String orderBy = request.getOrderBy().equals("desc") ? "DESC" : "ASC";
        sql.append(" ORDER BY ").append(sortBy).append(" ").append(orderBy);
        PageRequest pageable = PageRequest.of((int)request.getPageNo(), (int)request.getPageSize(), (Sort)(request.getOrderBy().equals("desc") ? Sort.by((String[])new String[]{sortBy}).descending() : Sort.by((String[])new String[]{sortBy}).ascending()));
        sql.append(" LIMIT :limit OFFSET :offset");
        parameters.addValue("limit", (Object)pageable.getPageSize());
        parameters.addValue("offset", (Object)pageable.getOffset());
        List result = this.namedParameterJdbcTemplate.query(sql.toString(), (SqlParameterSource)parameters, this.organizationRowMapper());
        Long count = (Long)this.namedParameterJdbcTemplate.queryForObject(countSql.toString(), (SqlParameterSource)parameters, Long.class);
        return new PageImpl(result, (Pageable)pageable, count.longValue());
    }
}

