/*
 * Decompiled with CFR 0.152.
 */
package com.infinite.focus.server.security.filter;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.infinite.focus.server.account.entity.Account;
import com.infinite.focus.server.account.model.AccountType;
import com.infinite.focus.server.account.repository.AccountRepository;
import com.infinite.focus.server.admin.entity.Admin;
import com.infinite.focus.server.auth.response.ValidationResponse;
import com.infinite.focus.server.auth.service.AuthService;
import com.infinite.focus.server.auth.service.ValidationService;
import com.infinite.focus.server.clever.service.data.CleverDataService;
import com.infinite.focus.server.configuration.repository.ConfigurationRepository;
import com.infinite.focus.server.converter.Converter;
import com.infinite.focus.server.converter.EncryptDecryptHelper;
import com.infinite.focus.server.corporate.entity.Corporate;
import com.infinite.focus.server.district.entity.District;
import com.infinite.focus.server.instructor.entity.Instructor;
import com.infinite.focus.server.message.service.MessageService;
import com.infinite.focus.server.parent.entity.Parent;
import com.infinite.focus.server.school.entity.School;
import com.infinite.focus.server.security.helper.JwtHelper;
import com.infinite.focus.server.student.entity.Student;
import com.infinite.focus.server.utils.AppUtils;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.userdetails.User;
import org.springframework.security.web.authentication.UsernamePasswordAuthenticationFilter;
import org.springframework.web.server.ResponseStatusException;
import org.springframework.web.servlet.HandlerExceptionResolver;

public class JWTAuthenticationFilter
extends UsernamePasswordAuthenticationFilter {
    private MessageService messageService;
    private AccountRepository accountRepository;
    private AuthenticationManager authenticationManager;
    private AuthService authService;
    private ValidationService validationService;
    private CleverDataService cleverDataService;
    private ConfigurationRepository configurationRepository;
    private JwtHelper jwtHelper;
    private HandlerExceptionResolver exceptionResolver;

    public JWTAuthenticationFilter(AuthenticationManager authenticationManager, AccountRepository accountRepository, AuthService authService, ValidationService validationService, CleverDataService cleverDataService, ConfigurationRepository configurationRepository, MessageService messageService, JwtHelper jwtHelper, HandlerExceptionResolver exceptionResolver) {
        this.authenticationManager = authenticationManager;
        this.accountRepository = accountRepository;
        this.authService = authService;
        this.validationService = validationService;
        this.cleverDataService = cleverDataService;
        this.configurationRepository = configurationRepository;
        this.messageService = messageService;
        this.jwtHelper = jwtHelper;
        this.exceptionResolver = exceptionResolver;
    }

    public Authentication attemptAuthentication(HttpServletRequest req, HttpServletResponse res) throws AuthenticationException {
        try {
            Account creds = (Account)new ObjectMapper().readValue(Converter.decrypt((InputStream)req.getInputStream(), (boolean)this.configurationRepository.getConfiguration().isEncrypted()), Account.class);
            return this.authenticationManager.authenticate((Authentication)new UsernamePasswordAuthenticationToken((Object)creds.getUsername(), (Object)creds.getPassword(), new ArrayList()));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected void successfulAuthentication(HttpServletRequest req, HttpServletResponse res, FilterChain chain, Authentication auth) throws IOException, ServletException {
        try {
            Account account;
            String token = this.jwtHelper.generateToken(((User)auth.getPrincipal()).getUsername());
            System.out.println("token is:-" + token);
            Admin admin = this.authService.getAdmin(token);
            Corporate corporate = this.authService.getCorporateByToken(token);
            Parent parent = this.authService.getParentByToken(token);
            Student student = this.authService.getStudentByToken(token);
            Instructor instructor = this.authService.getInstructorByToken(token);
            List schools = this.authService.getSchoolByToken(token);
            District district = this.authService.getDistrictByToken(token);
            ArrayList<String> accountTypes = new ArrayList<String>();
            ValidationResponse validationResponse = null;
            if (admin != null) {
                accountTypes.add(AccountType.ADMIN.toString());
            }
            if (corporate != null) {
                validationResponse = this.validationService.isValidCorporate(corporate.getCorporate_id());
                account = this.accountRepository.findByAccountId(corporate.getAccount_id());
                if (corporate.getOrganizationAdmin() != null) {
                    account = this.accountRepository.findByAccountId(corporate.getOrganizationAdmin().getAccount_id());
                    token = EncryptDecryptHelper.base64Encode((String)EncryptDecryptHelper.encrypt((String)(account.getAccount_id() + " " + corporate.getOrganizationAdmin().getOrganization_admin_id() + " " + account.getUsername())));
                } else {
                    token = EncryptDecryptHelper.base64Encode((String)EncryptDecryptHelper.encrypt((String)(account.getAccount_id() + " " + corporate.getCorporate_id() + " " + account.getUsername())));
                }
                accountTypes.add(AccountType.CORPORATE.toString());
            }
            if (parent != null) {
                validationResponse = this.validationService.isValidParent(parent.getParent_id());
                account = this.accountRepository.findByAccountId(parent.getAccount_id());
                if (parent.getOrganizationAdmin() != null) {
                    account = this.accountRepository.findByAccountId(parent.getOrganizationAdmin().getAccount_id());
                    token = EncryptDecryptHelper.base64Encode((String)EncryptDecryptHelper.encrypt((String)(account.getAccount_id() + " " + parent.getOrganizationAdmin().getOrganization_admin_id() + " " + account.getUsername())));
                } else {
                    token = EncryptDecryptHelper.base64Encode((String)EncryptDecryptHelper.encrypt((String)(account.getAccount_id() + " " + parent.getParent_id() + " " + account.getUsername())));
                }
                accountTypes.add(AccountType.PARENT.toString());
            }
            if (student != null) {
                if (!(AppUtils.isNullOrEmpty((String)student.getClever_id()) || (student = this.cleverDataService.syncStudent(student)) != null && student.getSchool() != null)) {
                    throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, this.messageService.getMessage("unable.to.access.clymb.right.now.please.try.after.some.time"));
                }
                validationResponse = this.validationService.isValidStudent(student.getStudent_id());
                if (validationResponse.isValid()) {
                    ValidationResponse validationResponse1 = this.validationService.isOverToNoOfYouthLimit(student);
                    if (!validationResponse1.isValid()) {
                        validationResponse.setValid(validationResponse1.isValid());
                        validationResponse.setMessage(validationResponse1.getMessage());
                    } else {
                        validationResponse.setFromCorporate(validationResponse1.isFromCorporate());
                        validationResponse.setFromDistrict(validationResponse1.isFromDistrict());
                        validationResponse.setFromSchool(validationResponse1.isFromSchool());
                    }
                }
                if (!AppUtils.isNullOrEmpty((String)student.getClever_id()) && student.getInstructor() == null) {
                    validationResponse.setValid(true);
                }
                account = this.accountRepository.findByAccountId(student.getAccount_id());
                token = EncryptDecryptHelper.base64Encode((String)EncryptDecryptHelper.encrypt((String)(account.getAccount_id() + " " + student.getStudent_id() + " " + account.getUsername())));
                accountTypes.add(AccountType.STUDENT.toString());
            }
            if (admin == null && instructor != null) {
                if (!AppUtils.isNullOrEmpty((String)instructor.getClever_id())) {
                    instructor = this.cleverDataService.syncInstructor(instructor);
                }
                if (!instructor.isArchived()) {
                    validationResponse = this.validationService.isValidInstructor(instructor.getInstructor_id());
                    accountTypes.add(AccountType.INSTRUCTOR.toString());
                }
            }
            if (!AppUtils.isNullOrEmpty((List)schools)) {
                ArrayList<ValidationResponse> validationResponses = new ArrayList<ValidationResponse>();
                for (School school : schools) {
                    validationResponses.add(this.validationService.isValidSchool(school.getSchool_id()));
                }
                List messages = validationResponses.stream().filter(item -> !item.isValid()).map(ValidationResponse::getMessage).collect(Collectors.toList());
                if (validationResponses.size() == messages.size()) {
                    throw new RuntimeException(String.join((CharSequence)",", messages));
                }
                validationResponse = (ValidationResponse)validationResponses.get(0);
                accountTypes.add(AccountType.SCHOOL.toString());
            }
            if (district != null) {
                validationResponse = this.validationService.isValidDistrict(district.getDistrict_id());
                accountTypes.add(AccountType.DISTRICT.toString());
            }
            if (admin == null && validationResponse != null && !validationResponse.isValid()) {
                throw new RuntimeException(validationResponse.getMessage());
            }
            if (!AppUtils.isNullOrEmpty(accountTypes)) {
                res.addHeader("AccountType", String.join((CharSequence)",", accountTypes));
                res.addHeader("Authorization", token);
                if (this.jwtHelper.isBearerToken(token).booleanValue()) {
                    String refreshToken = this.jwtHelper.generateRefreshToken(((User)auth.getPrincipal()).getUsername());
                    res.addHeader("Authorization_Refresh_Token", refreshToken);
                }
            } else if (!AppUtils.isNullOrEmpty((String)token) && AppUtils.isNullOrEmpty(accountTypes)) {
                throw new RuntimeException(this.messageService.getMessage("unable.to.access.clymb.right.now.please.try.after.some.time"));
            }
        }
        catch (Exception ex) {
            this.exceptionResolver.resolveException(req, res, null, ex);
        }
    }

    protected void unsuccessfulAuthentication(HttpServletRequest request, HttpServletResponse response, AuthenticationException exception) throws IOException, ServletException {
    }
}

