/*
 * Decompiled with CFR 0.152.
 */
package com.infinite.focus.server.student.repository;

import com.infinite.focus.server.student.entity.Student;
import com.infinite.focus.server.student.view.StudentView;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository
public interface StudentRepository
extends JpaRepository<Student, Long> {
    @Query(value="SELECT * FROM student WHERE account_id = ?1", nativeQuery=true)
    public Student findByAccountId(Long var1);

    @Query(value="SELECT * FROM student WHERE student_id = ?1", nativeQuery=true)
    public Student findByStudentId(Long var1);

    @Query(value="SELECT * FROM student WHERE clever_id = ?1", nativeQuery=true)
    public Student findByStudentCleverId(String var1);

    @Query(value="SELECT * FROM student WHERE instructor_id = ?1 ORDER BY first_name", nativeQuery=true)
    public List<StudentView> findByInstructorId(Long var1);

    @Query(value="SELECT * FROM student WHERE instructor_id = ?1 ORDER BY first_name", nativeQuery=true)
    public List<Student> findFullStudentByInstructorId(Long var1);

    @Query(value="SELECT * FROM student WHERE standard_id = ?1 ORDER BY first_name", nativeQuery=true)
    public List<StudentView> findByStandardId(Long var1);

    @Query(value="SELECT COUNT(*) FROM student WHERE instructor_id = ?1", nativeQuery=true)
    public long getStudentsCountByInstructorId(long var1);

    @Query(value="SELECT * FROM student ORDER BY student_id", nativeQuery=true)
    public List<StudentView> findAllOrderById();

    @Query(value="SELECT ac.created_at FROM student stu JOIN account ac ON stu.account_id = ac.account_id WHERE ac.username IS NOT NULL AND ac.username != '' ORDER BY student_id ASC LIMIT 0,1", nativeQuery=true)
    public Date getFirstStudentCreatedDate();

    @Query(value="SELECT * FROM student WHERE student_id in :ids ORDER BY student_id", nativeQuery=true)
    public List<StudentView> findByStudentIds(@Param(value="ids") List<Long> var1);

    @Query(value="SELECT * FROM student WHERE student_id IN(?1) ORDER BY student_id ASC", nativeQuery=true)
    public List<Student> findByStudentIdIn(List<Long> var1);

    @Query(value="SELECT COALESCE(stu.operating_system, 'N/A'), count(*), round((count(*) * 100 / (SELECT count(*) FROM student stud JOIN account acco ON stud.account_id = acco.account_id JOIN access_code acce ON stud.student_id = acce.student_id WHERE acco.username IS NOT NULL AND acco.username != '' AND acce.status = 'ACCEPTED' AND COALESCE (stud.operating_system, '') <> '')),2) as percentage FROM student stu JOIN account acc ON stu.account_id = acc.account_id JOIN access_code acces ON stu.student_id = acces.student_id WHERE acc.username IS NOT NULL AND acc.username != '' AND acces.status = 'ACCEPTED' AND COALESCE (stu.operating_system, '') <> '' group by stu.operating_system", nativeQuery=true)
    public List<Object[]> getStudentCountAndPercentageByUseOfOS();

    @Query(value="SELECT COALESCE(stu.operating_system, 'N/A'), count(*), round((count(*) * 100 / (SELECT count(*) FROM student stud JOIN account acco ON stud.account_id = acco.account_id JOIN access_code acce ON stud.student_id = acce.student_id WHERE acco.username IS NOT NULL AND acco.username != '' AND acce.status = 'ACCEPTED' AND COALESCE (stud.operating_system, '') <> '' AND acco.created_at BETWEEN ?1 AND ?2)),2) as percentage FROM student stu JOIN account acc ON stu.account_id = acc.account_id JOIN access_code acces ON stu.student_id = acces.student_id WHERE acc.username IS NOT NULL AND acc.username != '' AND acces.status = 'ACCEPTED' AND COALESCE (stu.operating_system, '') <> '' AND acc.created_at BETWEEN ?1 AND ?2 group by stu.operating_system", nativeQuery=true)
    public List<Object[]> getStudentCountAndPercentageByUseOfOSCreatedAtBetweenFromDateAndToDate(String var1, String var2);

    @Query(value="SELECT COALESCE(stu.browser, 'N/A'), count(*), round((count(*) * 100 / (SELECT count(*) FROM student stud JOIN account acco ON stud.account_id = acco.account_id JOIN access_code acce ON stud.student_id = acce.student_id WHERE acco.username IS NOT NULL AND acco.username != '' AND acce.status = 'ACCEPTED' AND COALESCE (stud.browser, '') <> '')),2) as percentage FROM student stu JOIN account acc ON stu.account_id = acc.account_id JOIN access_code acces ON stu.student_id = acces.student_id WHERE acc.username IS NOT NULL AND acc.username != '' AND acces.status = 'ACCEPTED' AND COALESCE (stu.browser, '') <> '' group by stu.browser", nativeQuery=true)
    public List<Object[]> getStudentCountAndPercentageByUseOfBrowser();

    @Query(value="SELECT COALESCE(stu.browser, 'N/A'), count(*), round((count(*) * 100 / (SELECT count(*) FROM student stud JOIN account acco ON stud.account_id = acco.account_id JOIN access_code acce ON stud.student_id = acce.student_id WHERE acco.username IS NOT NULL AND acco.username != '' AND acce.status = 'ACCEPTED' AND COALESCE (stud.browser, '') <> '' AND acco.created_at BETWEEN ?1 AND ?2)),2) as percentage FROM student stu JOIN account acc ON stu.account_id = acc.account_id JOIN access_code acces ON stu.student_id = acces.student_id WHERE acc.username IS NOT NULL AND acc.username != '' AND acces.status = 'ACCEPTED' AND COALESCE (stu.browser, '') <> '' AND acc.created_at BETWEEN ?1 AND ?2 group by stu.browser", nativeQuery=true)
    public List<Object[]> getStudentCountAndPercentageByUseOfBrowserCreatedAtBetweenFromDateAndToDate(String var1, String var2);

    @Query(value="SELECT * FROM student stu WHERE stu.first_name = ?1 AND stu.last_name = ?2 ORDER BY student_id ASC", nativeQuery=true)
    public List<Student> findStudentByFirstNameAndLastName(String var1, String var2);

    @Query(value="SELECT COUNT(*) FROM student stu JOIN account ac ON stu.account_id = ac.account_id join access_code acc on stu.student_id = acc.student_id WHERE ac.username IS NOT NULL AND ac.username != '' AND ac.created_at BETWEEN ?1 AND ?2 AND acc.status = 'ACCEPTED'", nativeQuery=true)
    public Long getCountByCreatedAtBetweenFromDateAndToDate(String var1, String var2);

    @Query(value="SELECT COUNT(*) FROM student stu JOIN account ac ON stu.account_id = ac.account_id join access_code acc on stu.student_id = acc.student_id WHERE ac.username IS NOT NULL AND ac.username != '' AND acc.status = 'ACCEPTED'", nativeQuery=true)
    public Long getCount();

    @Query(value="SELECT created_at FROM account acc WHERE acc.account_id = (SELECT account_id FROM student ORDER BY student_id ASC LIMIT 0,1)", nativeQuery=true)
    public Date getDateOfFirstRegistredStudent();

    @Transactional
    @Modifying
    @Query(value="UPDATE student SET parent_id = ?1 WHERE student_id = ?2", nativeQuery=true)
    public void updateParentIdByStudentId(long var1, long var3);

    @Query(value="SELECT * FROM student stu WHERE stu.parent_id = ?1 ORDER BY student_id ASC", nativeQuery=true)
    public List<Student> findStudentsByParentId(long var1);

    @Query(value="SELECT * FROM student ORDER BY student_id asc", nativeQuery=true)
    public List<StudentView> findAllOrderByIdAsc();

    @Modifying
    @Transactional
    @Query(value="DELETE FROM student WHERE student_id = ?1", nativeQuery=true)
    public void deleteByStudentId(long var1);

    @Transactional
    @Modifying
    @Query(value="UPDATE student SET instructor_id = ?1 WHERE student_id IN(?2)", nativeQuery=true)
    public void updateUpdateInstructorId(long var1, List<Long> var3);

    @Modifying
    @Transactional
    @Query(value="DELETE FROM student WHERE student_id IN(?1)", nativeQuery=true)
    public void deleteByStudentIds(List<Long> var1);

    @Query(value="SELECT stu.* FROM student stu JOIN account ac ON stu.account_id = ac.account_id JOIN access_code acc ON stu.student_id = acc.student_id WHERE ac.username IS NOT NULL AND ac.username != '' AND acc.status = 'ACCEPTED' AND stu.instructor_id = ?1 ORDER BY stu.first_name ASC", nativeQuery=true)
    public List<Student> findByInstructorIdWhichCompletedFirstLoginAndAccessCodeAcceptedOrderByFirstNameASC(Long var1);

    @Query(value="SELECT stu.* FROM student stu JOIN account ac ON stu.account_id = ac.account_id JOIN access_code acc ON stu.student_id = acc.student_id WHERE ac.username IS NOT NULL AND ac.username != '' AND acc.status = 'ACCEPTED' AND stu.parent_id = ?1 ORDER BY stu.first_name ASC", nativeQuery=true)
    public List<Student> findByParentIdWhichCompletedFirstLoginAndAccessCodeAcceptedOrderByFirstNameASC(Long var1);

    @Query(value="SELECT stu.* FROM student stu JOIN account ac ON stu.account_id = ac.account_id JOIN access_code acc ON stu.student_id = acc.student_id WHERE ac.username IS NOT NULL AND ac.username != '' AND acc.status = 'ACCEPTED' AND stu.student_id = ?1", nativeQuery=true)
    public Student findByStudentIdWhichCompletedFirstLoginAndAccessCodeAcceptedOrderByFirstNameASC(Long var1);

    @Query(value="SELECT * FROM student WHERE clever_id IN(?1) ORDER BY student_id ASC", nativeQuery=true)
    public List<Student> findByCleverId(List<String> var1);

    @Query(value="SELECT * FROM student WHERE clever_id = ?1 ORDER BY student_id ASC", nativeQuery=true)
    public List<Student> findByCleverId2(String var1);

    @Query(value="SELECT * FROM student WHERE school_id = ?1 ORDER BY student_id ASC", nativeQuery=true)
    public List<Student> findBySchoolIdOrderByStudentIdASC(Long var1);

    @Query(value="SELECT COUNT(*) FROM student WHERE school_id = ?1", nativeQuery=true)
    public long getStudentsCountBySchoolId(long var1);

    @Query(value="SELECT stu.* FROM student stu JOIN account ac ON stu.account_id = ac.account_id JOIN access_code acc ON stu.student_id = acc.student_id WHERE ac.username IS NOT NULL AND ac.username != '' AND acc.status = 'ACCEPTED' ORDER BY stu.first_name ASC", nativeQuery=true)
    public List<Student> findAllWhoCompletedFirstLogin();

    @Query(value="SELECT stu.* FROM student stu JOIN account ac ON stu.account_id = ac.account_id WHERE ac.username IS NOT NULL AND ac.username != '' AND stu.clever_id = ?1 OR ac.username = ?2 ORDER BY stu.student_id ASC", nativeQuery=true)
    public List<Student> findStudentsByCleverIdOrUserName(String var1, String var2);

    @Query(value="SELECT * FROM student WHERE registration_code = ?1 ORDER BY student_id ASC LIMIT 0,1", nativeQuery=true)
    public Student findByRegistrationCode(String var1);

    @Query(value="SELECT * FROM student WHERE registration_code = ?1 ORDER BY student_id ASC LIMIT 0,1", nativeQuery=true)
    public StudentView findStudentViewByRegistrationCode(String var1);

    @Query(value="SELECT stu.* FROM student stu JOIN account ac ON stu.account_id = ac.account_id JOIN access_code acc ON stu.student_id = acc.student_id WHERE stu.instructor_id = ?1 AND ac.username IS NOT NULL AND ac.username != '' AND acc.status = 'ACCEPTED' ORDER BY stu.first_name ASC", nativeQuery=true)
    public List<StudentView> findAllWhoCompletedFirstLoginByInstructorId(long var1);

    @Query(value="SELECT * FROM student WHERE student_id = ?1 LIMIT 0,1", nativeQuery=true)
    public StudentView findStudentViewByStudentId(Long var1);

    @Query(value="SELECT * FROM student", nativeQuery=true)
    public Page<Student> findAllStudents(Pageable var1);

    @Query(value="SELECT * FROM student WHERE first_name LIKE ?1 or last_name LIKE ?1", nativeQuery=true)
    public Page<Student> findByStudentByName(String var1, Pageable var2);

    @Query(value="SELECT s.* FROM student s JOIN access_code a ON s.student_id = a.student_id WHERE s.instructor_id = ?1 AND a.status IN(?2) ORDER BY s.student_id ASC ", nativeQuery=true)
    public List<Student> findIdsByInstructorIdAndStatus(long var1, Set<String> var3);
}

