/*
 * Decompiled with CFR 0.152.
 */
package com.infinite.focus.server.twilio.config;

import com.infinite.focus.server.twilio.config.TwilioConfiguration;
import com.infinite.focus.server.twilio.config.ValidPhoneNumber;
import com.infinite.focus.server.utils.AppUtils;
import com.twilio.Twilio;
import com.twilio.exception.ApiException;
import com.twilio.type.PhoneNumber;
import jakarta.validation.ConstraintValidator;
import jakarta.validation.ConstraintValidatorContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Configurable;

@Configurable
public class PhoneNumberValidator
implements ConstraintValidator<ValidPhoneNumber, String> {
    @Autowired
    TwilioConfiguration twilioConfiguration;

    public void initialize(ValidPhoneNumber constraintAnnotation) {
        Twilio.init((String)this.twilioConfiguration.getAccountSid(), (String)this.twilioConfiguration.getAuthToken());
    }

    public boolean isValid(String value, ConstraintValidatorContext context) {
        if (AppUtils.isNullOrEmpty((String)(value = value.replaceAll("[\\s()-]", "")))) {
            return true;
        }
        try {
            com.twilio.rest.lookups.v1.PhoneNumber.fetcher((String)String.valueOf(new PhoneNumber(value))).fetch();
            return true;
        }
        catch (ApiException e) {
            if (e.getStatusCode() == 404) {
                return false;
            }
            throw e;
        }
    }
}

