/*
 * Decompiled with CFR 0.152.
 */
package com.infinite.focus.server.activity.service;

import com.infinite.focus.server.activity.dto.ActivityDTO;
import com.infinite.focus.server.activity.entity.Activity;
import com.infinite.focus.server.activity.repository.ActivityCoreRepository;
import com.infinite.focus.server.activity.repository.ActivityRepository;
import com.infinite.focus.server.activity.service.ActivityService;
import com.infinite.focus.server.client.MoodClient;
import com.infinite.focus.server.dashboard.model.TimeLine;
import com.infinite.focus.server.dashboard.request.GetDataDashBoardRequest;
import com.infinite.focus.server.data.model.EmotionCountAndAverage;
import com.infinite.focus.server.data.model.EmotionsByStandards;
import com.infinite.focus.server.language.Language;
import com.infinite.focus.server.moodupdate.helper.MoodUpdateHelper;
import com.infinite.focus.server.utils.AppUtils;
import com.infinite.focus.server.utils.DateUtils;
import jakarta.persistence.EntityManager;
import jakarta.persistence.TypedQuery;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Join;
import jakarta.persistence.criteria.JoinType;
import jakarta.persistence.criteria.Order;
import jakarta.persistence.criteria.Predicate;
import jakarta.persistence.criteria.Root;
import jakarta.persistence.criteria.Subquery;
import java.math.BigInteger;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ActivityServiceImpl
implements ActivityService {
    @Autowired
    EntityManager entityManager;
    @Autowired
    ActivityRepository activityRepository;
    @Autowired
    private ActivityCoreRepository activityCoreRepository;
    private final MoodClient moodClient;
    String forwardSlash = "/";

    public ActivityServiceImpl(MoodClient moodClient) {
        this.moodClient = moodClient;
    }

    /*
     * Exception decompiling
     */
    public LinkedHashMap<String[], List<ActivityDTO>> getActivityMapByTimeLine(TimeLine timeLine, List<ActivityDTO> activityList, String language) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:87)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredAssignment.rewriteExpressions(StructuredAssignment.java:146)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private LinkedHashMap<String[], List<ActivityDTO>> fillActivityMap(List<String[]> keys) {
        LinkedHashMap<String[], List<ActivityDTO>> map = new LinkedHashMap<String[], List<ActivityDTO>>();
        for (String[] key : keys) {
            map.put(key, new ArrayList());
        }
        return map;
    }

    public List<Activity> getMoodInsight(GetDataDashBoardRequest request) {
        CriteriaBuilder qb = this.entityManager.getCriteriaBuilder();
        CriteriaQuery query = qb.createQuery(Activity.class);
        Root root = query.from(Activity.class);
        Join s = root.join("student", JoinType.LEFT);
        ArrayList<Object> predicates = new ArrayList<Object>();
        if (AppUtils.isNotNullOrEmpty((List)request.getGenders())) {
            CriteriaBuilder.In genderPredicate = qb.in((Expression)s.get("gender")).value((Object)request.getGenders());
            predicates.add(genderPredicate);
        }
        if (AppUtils.isNotNullOrEmpty((List)request.getAges())) {
            Expression year = qb.literal((Object)"YEAR");
            Expression timeInYears = qb.function("TIMESTAMPDIFF", Integer.class, new Expression[]{year, s.get("date_of_birth"), qb.literal((Object)Timestamp.valueOf(LocalDateTime.now()))});
            CriteriaBuilder.In inClause = qb.in(timeInYears);
            for (Integer age : request.getAges()) {
                inClause.value((Object)age);
            }
            predicates.add(inClause);
        }
        if (AppUtils.isNotNullOrEmpty((List)request.getEthnicity())) {
            CriteriaBuilder.In ethnicityPredicate = qb.in((Expression)s.get("ethnicity")).value((Object)request.getEthnicity());
            predicates.add(ethnicityPredicate);
        }
        if (AppUtils.isNotNullOrEmpty((List)request.getGradeIds())) {
            Predicate gradePredicate = s.get("standard").get("grade").get("grade_id").in((Collection)request.getGradeIds());
            predicates.add(gradePredicate);
        }
        if (AppUtils.isNotNullOrEmpty((List)request.getMood_update_before())) {
            CriteriaBuilder.In moodUpdateBeforePredicate = qb.in((Expression)root.get("mood_update_before")).value((Object)request.getMood_update_before());
            predicates.add(moodUpdateBeforePredicate);
        }
        if (AppUtils.isNotNullOrEmpty((List)request.getMood_update_after())) {
            CriteriaBuilder.In moodUpdateAfterPredicate = qb.in((Expression)root.get("mood_update_after")).value((Object)request.getMood_update_after());
            predicates.add(moodUpdateAfterPredicate);
        }
        if (request.getFromDate() != null && request.getToDate() != null) {
            System.out.println("getMoodInsightByInstructerId FromDate " + DateUtils.dailyDateFormat.format(request.getFromDate()) + " - ToDate " + DateUtils.dailyDateFormat.format(request.getToDate()));
            predicates.add(qb.between((Expression)root.get("start_date_time"), (Comparable)request.getFromDate(), (Comparable)request.getToDate()));
        }
        predicates.add(qb.isNotNull((Expression)s.get("account").get("username")));
        predicates.add(qb.notEqual((Expression)s.get("account").get("username"), (Object)""));
        predicates.add(qb.notEqual((Expression)s.get("student_id"), (Object)0L));
        predicates.add(qb.equal((Expression)root.get("activity_type_id"), (Object)2));
        query.where(predicates.toArray(new Predicate[0])).orderBy(new Order[]{qb.asc((Expression)root.get("end_date_time"))});
        TypedQuery typedQuery = this.entityManager.createQuery(query);
        List activities = typedQuery.getResultList();
        return activities;
    }

    public List<Activity> getMoodInsightByInstructerId(GetDataDashBoardRequest request) {
        CriteriaBuilder qb = this.entityManager.getCriteriaBuilder();
        CriteriaQuery query = qb.createQuery(Activity.class);
        Root root = query.from(Activity.class);
        Join s = root.join("student", JoinType.LEFT);
        ArrayList<Object> predicates = new ArrayList<Object>();
        if (AppUtils.isNotNullOrEmpty((List)request.getGenders())) {
            CriteriaBuilder.In genderPredicate = qb.in((Expression)s.get("gender")).value((Object)request.getGenders());
            predicates.add(genderPredicate);
        }
        if (AppUtils.isNotNullOrEmpty((List)request.getAges())) {
            Expression year = qb.literal((Object)"YEAR");
            Expression timeInYears = qb.function("TIMESTAMPDIFF", Integer.class, new Expression[]{year, s.get("date_of_birth"), qb.literal((Object)Timestamp.valueOf(LocalDateTime.now()))});
            CriteriaBuilder.In inClause = qb.in(timeInYears);
            for (Integer age : request.getAges()) {
                inClause.value((Object)age);
            }
            predicates.add(inClause);
        }
        if (AppUtils.isNotNullOrEmpty((List)request.getEthnicity())) {
            CriteriaBuilder.In ethnicityPredicate = qb.in((Expression)s.get("ethnicity")).value((Object)request.getEthnicity());
            predicates.add(ethnicityPredicate);
        }
        if (AppUtils.isNotNullOrEmpty((List)request.getGradeIds())) {
            Predicate gradePredicate = s.get("standard").get("grade").get("grade_id").in((Collection)request.getGradeIds());
            predicates.add(gradePredicate);
        }
        if (AppUtils.isNotNullOrEmpty((List)request.getMood_update_before())) {
            CriteriaBuilder.In moodUpdateBeforePredicate = qb.in((Expression)root.get("mood_update_before")).value((Object)request.getMood_update_before());
            predicates.add(moodUpdateBeforePredicate);
        }
        if (AppUtils.isNotNullOrEmpty((List)request.getMood_update_after())) {
            CriteriaBuilder.In moodUpdateAfterPredicate = qb.in((Expression)root.get("mood_update_after")).value((Object)request.getMood_update_after());
            predicates.add(moodUpdateAfterPredicate);
        }
        if (request.getFromDate() != null && request.getToDate() != null) {
            System.out.println("getMoodInsightByInstructerId FromDate " + DateUtils.dailyDateFormat.format(request.getFromDate()) + " - ToDate " + DateUtils.dailyDateFormat.format(request.getToDate()));
            predicates.add(qb.between((Expression)root.get("start_date_time"), (Comparable)request.getFromDate(), (Comparable)request.getToDate()));
        }
        predicates.add(qb.isNotNull((Expression)s.get("account").get("username")));
        predicates.add(qb.notEqual((Expression)s.get("account").get("username"), (Object)""));
        predicates.add(qb.notEqual((Expression)s.get("student_id"), (Object)0L));
        predicates.add(qb.equal((Expression)s.get("instructor").get("instructor_id"), (Object)request.getInstructor_id()));
        predicates.add(qb.equal((Expression)root.get("activity_type_id"), (Object)2));
        query.where(predicates.toArray(new Predicate[0])).orderBy(new Order[]{qb.asc((Expression)root.get("end_date_time"))});
        TypedQuery typedQuery = this.entityManager.createQuery(query);
        List activities = typedQuery.getResultList();
        return activities;
    }

    public List<Activity> getMoodInsightPostByInstructerId(GetDataDashBoardRequest request) {
        CriteriaBuilder qb = this.entityManager.getCriteriaBuilder();
        CriteriaQuery query = qb.createQuery(Activity.class);
        Root root = query.from(Activity.class);
        Join s = root.join("student", JoinType.LEFT);
        Join moodUpdateBeforeJoin = root.join("moodUpdateBefore", JoinType.LEFT);
        Join moodUpdateAfterJoin = root.join("moodUpdateAfter", JoinType.LEFT);
        ArrayList<Object> predicates = new ArrayList<Object>();
        if (AppUtils.isNotNullOrEmpty((List)request.getGenders())) {
            CriteriaBuilder.In genderPredicate = qb.in((Expression)s.get("gender")).value((Object)request.getGenders());
            predicates.add(genderPredicate);
        }
        if (AppUtils.isNotNullOrEmpty((List)request.getAges())) {
            Expression year = qb.literal((Object)"YEAR");
            Expression timeInYears = qb.function("TIMESTAMPDIFF", Integer.class, new Expression[]{year, s.get("date_of_birth"), qb.literal((Object)Timestamp.valueOf(LocalDateTime.now()))});
            CriteriaBuilder.In inClause = qb.in(timeInYears);
            for (Integer age : request.getAges()) {
                inClause.value((Object)age);
            }
            predicates.add(inClause);
        }
        if (AppUtils.isNotNullOrEmpty((List)request.getEthnicity())) {
            ArrayList ethnicityList = new ArrayList(request.getEthnicity());
            CriteriaBuilder.In ethnicityPredicate = qb.in((Expression)s.get("ethnicity")).value(ethnicityList);
            predicates.add(ethnicityPredicate);
        }
        if (AppUtils.isNotNullOrEmpty((List)request.getGradeIds())) {
            Predicate gradePredicate = s.get("standard").get("grade").get("grade_id").in((Collection)request.getGradeIds());
            predicates.add(gradePredicate);
        }
        if (AppUtils.isNotNullOrEmpty((List)request.getClassIds())) {
            Subquery sq = query.subquery(Long.class).select(qb.literal((Object)1L));
            Join sqRoot = sq.correlate(s);
            Join sqJoin = sqRoot.join("classes");
            sq.where((Expression)sqJoin.get("class_id").in((Collection)request.getClassIds()));
            predicates.add(qb.and(new Predicate[]{qb.exists(sq)}));
        }
        if (AppUtils.isNotNullOrEmpty((List)request.getMood_update_before())) {
            Predicate moodUpdateBeforePredicate = moodUpdateBeforeJoin.get("text").in((Collection)request.getMood_update_before());
            predicates.add(moodUpdateBeforePredicate);
        }
        if (AppUtils.isNotNullOrEmpty((List)request.getMood_update_after())) {
            Predicate moodUpdateAfterPredicate = moodUpdateAfterJoin.get("text").in((Collection)request.getMood_update_after());
            predicates.add(moodUpdateAfterPredicate);
        }
        if (request.getFromDate() != null && request.getToDate() != null) {
            System.out.println("getMoodInsightPost FromDate " + DateUtils.dailyDateFormat.format(request.getFromDate()) + " - ToDate " + DateUtils.dailyDateFormat.format(request.getToDate()));
            predicates.add(qb.between((Expression)root.get("start_date_time"), (Comparable)request.getFromDate(), (Comparable)request.getToDate()));
        }
        predicates.add(qb.isNotNull((Expression)s.get("account").get("username")));
        predicates.add(qb.notEqual((Expression)s.get("account").get("username"), (Object)""));
        predicates.add(qb.notEqual((Expression)s.get("student_id"), (Object)0L));
        predicates.add(qb.equal((Expression)s.get("instructor").get("instructor_id"), (Object)request.getInstructor_id()));
        predicates.add(qb.equal((Expression)root.get("activity_type_id"), (Object)4));
        query.where(predicates.toArray(new Predicate[0])).orderBy(new Order[]{qb.asc((Expression)root.get("end_date_time"))});
        TypedQuery typedQuery = this.entityManager.createQuery(query);
        List activities = typedQuery.getResultList();
        return activities;
    }

    public List<Activity> getMoodInsightPostByParentId(GetDataDashBoardRequest request) {
        CriteriaBuilder qb = this.entityManager.getCriteriaBuilder();
        CriteriaQuery query = qb.createQuery(Activity.class);
        Root root = query.from(Activity.class);
        Join s = root.join("student", JoinType.LEFT);
        ArrayList<Object> predicates = new ArrayList<Object>();
        if (AppUtils.isNotNullOrEmpty((List)request.getGenders())) {
            CriteriaBuilder.In genderPredicate = qb.in((Expression)s.get("gender")).value((Object)request.getGenders());
            predicates.add(genderPredicate);
        }
        if (AppUtils.isNotNullOrEmpty((List)request.getAges())) {
            Expression year = qb.literal((Object)"YEAR");
            Expression timeInYears = qb.function("TIMESTAMPDIFF", Integer.class, new Expression[]{year, s.get("date_of_birth"), qb.literal((Object)Timestamp.valueOf(LocalDateTime.now()))});
            CriteriaBuilder.In inClause = qb.in(timeInYears);
            for (Integer age : request.getAges()) {
                inClause.value((Object)age);
            }
            predicates.add(inClause);
        }
        if (AppUtils.isNotNullOrEmpty((List)request.getEthnicity())) {
            CriteriaBuilder.In ethnicityPredicate = qb.in((Expression)s.get("ethnicity")).value((Object)request.getEthnicity());
            predicates.add(ethnicityPredicate);
        }
        if (AppUtils.isNotNullOrEmpty((List)request.getGradeIds())) {
            Predicate gradePredicate = s.get("standard").get("grade").get("grade_id").in((Collection)request.getGradeIds());
            predicates.add(gradePredicate);
        }
        if (AppUtils.isNotNullOrEmpty((List)request.getMood_update_before())) {
            CriteriaBuilder.In moodUpdateBeforePredicate = qb.in((Expression)root.get("mood_update_before")).value((Object)request.getMood_update_before());
            predicates.add(moodUpdateBeforePredicate);
        }
        if (AppUtils.isNotNullOrEmpty((List)request.getMood_update_after())) {
            CriteriaBuilder.In moodUpdateAfterPredicate = qb.in((Expression)root.get("mood_update_after")).value((Object)request.getMood_update_after());
            predicates.add(moodUpdateAfterPredicate);
        }
        if (request.getFromDate() != null && request.getToDate() != null) {
            System.out.println("getMoodInsightPost FromDate " + DateUtils.dailyDateFormat.format(request.getFromDate()) + " - ToDate " + DateUtils.dailyDateFormat.format(request.getToDate()));
            predicates.add(qb.between((Expression)root.get("start_date_time"), (Comparable)request.getFromDate(), (Comparable)request.getToDate()));
        }
        predicates.add(qb.isNotNull((Expression)s.get("account").get("username")));
        predicates.add(qb.notEqual((Expression)s.get("account").get("username"), (Object)""));
        predicates.add(qb.notEqual((Expression)s.get("student_id"), (Object)0L));
        predicates.add(qb.equal((Expression)s.get("parent").get("parent_id"), (Object)request.getParent_id()));
        predicates.add(qb.equal((Expression)root.get("activity_type_id"), (Object)4));
        query.where(predicates.toArray(new Predicate[0])).orderBy(new Order[]{qb.asc((Expression)root.get("end_date_time"))});
        TypedQuery typedQuery = this.entityManager.createQuery(query);
        List activities = typedQuery.getResultList();
        return activities;
    }

    public List<BigInteger> getLoggedInStudentsByStudentIdsBetweenFromDateAndToDateAndBetweenFromTimeAndToTime(List<Long> student_ids, String fromDate, String toDate, TimeZone timeZone) {
        String fromTimeZone = DateUtils.getSystemTimeOffset((ZonedDateTime)new Date().toInstant().atZone(ZoneId.systemDefault()));
        String toTimeZone = DateUtils.getSystemTimeOffset((ZonedDateTime)new Date().toInstant().atZone(ZoneId.of(timeZone.getID())));
        System.out.println("FromDate " + fromDate + " ToDate " + toDate + " FromTimeZone " + fromTimeZone + " ToTimeZone " + toTimeZone);
        return this.activityRepository.getLoggedInStudentsByStudentIdsBetweenFromDateAndToDateAndBetweenFromTimeAndToTime(student_ids, fromDate, toDate, fromTimeZone, toTimeZone);
    }

    public Long getTotalTimeSpent(List<ActivityDTO> activities) {
        Long totalTimeSpent = 0L;
        for (int i = 0; i < activities.size(); ++i) {
            ActivityDTO activity = activities.get(i);
            long appUsedTime = activity.getEnd_date_time().getTime() - activity.getStart_date_time().getTime();
            totalTimeSpent = totalTimeSpent + appUsedTime;
        }
        return totalTimeSpent;
    }

    public Activity getLstCreatedActivity() {
        return this.activityRepository.getLstCreatedActivity();
    }

    public LinkedHashMap<String, Object> getMoodInsightsPostByStudentIdsAndBetweenFromDateAndToDate(List<Long> student_ids, Date fromDate, Date toDate, String language) {
        List emotionCountAndAveragesBefore = this.activityCoreRepository.findMoodInsightsPostBeforeByStudentIdsAndBetweenFromDateAndToDate(student_ids, fromDate, toDate, language);
        List emotionCountAndAveragesAfter = this.activityCoreRepository.findMoodInsightsPostAfterByStudentIdsAndBetweenFromDateAndToDate(student_ids, fromDate, toDate, language);
        LinkedHashMap beforeEnglish = new LinkedHashMap();
        LinkedHashMap beforeSpanish = new LinkedHashMap();
        LinkedHashMap afterEnglish = new LinkedHashMap();
        LinkedHashMap afterSpanish = new LinkedHashMap();
        for (EmotionCountAndAverage o : this.moodClient.getAllEmotionsAndSubEmotions()) {
            EmotionCountAndAverage emotionCountAndAverageBefore = emotionCountAndAveragesBefore.stream().filter(e -> e.getEmotion().equals(o.getEmotion())).findAny().orElse(null);
            LinkedList<Number> listBefore = new LinkedList<Number>();
            if (emotionCountAndAverageBefore != null) {
                listBefore.add(emotionCountAndAverageBefore.getCount());
                listBefore.add(emotionCountAndAverageBefore.getAverage());
            } else {
                listBefore.add(0);
                listBefore.add(0);
            }
            beforeEnglish.put(o.getEmotion(), listBefore);
            beforeSpanish.put(o.getEmotion_es(), listBefore);
            EmotionCountAndAverage emotionCountAndAverageAfter = emotionCountAndAveragesAfter.stream().filter(e -> e.getEmotion().equals(o.getEmotion())).findAny().orElse(null);
            LinkedList<Number> listAfter = new LinkedList<Number>();
            if (emotionCountAndAverageAfter != null) {
                listAfter.add(emotionCountAndAverageAfter.getCount());
                listAfter.add(emotionCountAndAverageAfter.getAverage());
            } else {
                listAfter.add(0);
                listAfter.add(0);
            }
            afterEnglish.put(o.getEmotion(), listAfter);
            afterSpanish.put(o.getEmotion_es(), listAfter);
        }
        LinkedHashMap beforeAfter = new LinkedHashMap();
        beforeAfter.put("before", Language.isSpanish((String)language) ? beforeSpanish : beforeEnglish);
        beforeAfter.put("after", Language.isSpanish((String)language) ? afterSpanish : afterEnglish);
        LinkedHashMap<String, Object> moodInSightsPosts = new LinkedHashMap<String, Object>();
        moodInSightsPosts.put(Language.isSpanish((String)language) ? "es" : "en", beforeAfter);
        return moodInSightsPosts;
    }

    public LinkedHashMap<String, EmotionsByStandards> getMoodInsightsPostByStudentIdsAndBetweenFromDateAndToDate2(List<Long> student_ids, Date fromDate, Date toDate, String language) {
        LinkedHashMap<String, EmotionsByStandards> beforeAfter = new LinkedHashMap<String, EmotionsByStandards>();
        EmotionsByStandards emotionCountAndAveragesBefore = this.moodClient.getAllEmotions();
        List moodUpdateDTOSBefore = this.activityCoreRepository.findMoodUpdateBeforeByStudentIdsAndBetweenFromDateAndEndDate(student_ids, fromDate, toDate);
        MoodUpdateHelper.setEmotions2((List)emotionCountAndAveragesBefore.get_k_2(), (List)moodUpdateDTOSBefore);
        MoodUpdateHelper.setEmotions2((List)emotionCountAndAveragesBefore.get_3_5(), (List)moodUpdateDTOSBefore);
        MoodUpdateHelper.setEmotions2((List)emotionCountAndAveragesBefore.get_6_12(), (List)moodUpdateDTOSBefore);
        beforeAfter.put("before", emotionCountAndAveragesBefore);
        EmotionsByStandards emotionCountAndAveragesAfter = this.moodClient.getAllEmotions();
        List moodUpdateDTOSAfter = this.activityCoreRepository.findMoodUpdateAfterByStudentIdsAndBetweenFromDateAndEndDate(student_ids, fromDate, toDate);
        MoodUpdateHelper.setEmotions2((List)emotionCountAndAveragesAfter.get_k_2(), (List)moodUpdateDTOSAfter);
        MoodUpdateHelper.setEmotions2((List)emotionCountAndAveragesAfter.get_3_5(), (List)moodUpdateDTOSAfter);
        MoodUpdateHelper.setEmotions2((List)emotionCountAndAveragesAfter.get_6_12(), (List)moodUpdateDTOSAfter);
        beforeAfter.put("after", emotionCountAndAveragesAfter);
        return beforeAfter;
    }

    private static /* synthetic */ String[] lambda$getActivityMapByTimeLine$3(Map.Entry entry) {
        return new String[]{(String)entry.getKey(), (String)entry.getValue()};
    }

    private static /* synthetic */ String[] lambda$getActivityMapByTimeLine$2(Map.Entry entry) {
        return new String[]{(String)entry.getKey(), (String)entry.getValue()};
    }

    private static /* synthetic */ String[] lambda$getActivityMapByTimeLine$1(Map.Entry entry) {
        return new String[]{(String)entry.getKey(), (String)entry.getValue()};
    }
}

