/*
 * Decompiled with CFR 0.152.
 */
package com.infinite.focus.server.clever.service.school;

import com.infinite.focus.server.accesscode.entity.AccessCode;
import com.infinite.focus.server.accesscode.service.AccessCodeService;
import com.infinite.focus.server.account.entity.Account;
import com.infinite.focus.server.account.repository.AccountRepository;
import com.infinite.focus.server.account.service.AccountService;
import com.infinite.focus.server.auth.model.Status;
import com.infinite.focus.server.clever.constant.CleverAppConstants;
import com.infinite.focus.server.clever.model.AccessToken;
import com.infinite.focus.server.clever.model.CleverInstructor;
import com.infinite.focus.server.clever.model.CleverRoleStudent;
import com.infinite.focus.server.clever.model.CleverSchool;
import com.infinite.focus.server.clever.model.CleverSection;
import com.infinite.focus.server.clever.model.CleverStudent;
import com.infinite.focus.server.clever.service.CleverService;
import com.infinite.focus.server.clever.service.school.CleverSchoolService;
import com.infinite.focus.server.clever.service.school.CleverSchoolSyncService;
import com.infinite.focus.server.district.entity.District;
import com.infinite.focus.server.district.repository.DistrictRepository;
import com.infinite.focus.server.group.entity.Class;
import com.infinite.focus.server.group.repository.ClassRepository;
import com.infinite.focus.server.group.service.ClassService;
import com.infinite.focus.server.instructor.entity.Instructor;
import com.infinite.focus.server.instructor.service.InstructorService;
import com.infinite.focus.server.instructorgroup.repository.InstructorGroupRepository;
import com.infinite.focus.server.language.Language;
import com.infinite.focus.server.message.service.MessageService;
import com.infinite.focus.server.school.entity.School;
import com.infinite.focus.server.school.repository.SchoolRepository;
import com.infinite.focus.server.socioemotionaltestresult.service.SocioEmotionalTestService;
import com.infinite.focus.server.standard.entity.Standard;
import com.infinite.focus.server.standard.service.StandardService;
import com.infinite.focus.server.student.entity.Student;
import com.infinite.focus.server.student.service.StudentService;
import com.infinite.focus.server.studentgroup.repository.StudentGroupRepository;
import com.infinite.focus.server.utils.AppUtils;
import com.infinite.focus.server.utils.DateUtils;
import com.infinite.focus.server.websocket.service.RealTimeMessageService;
import java.sql.Date;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.springframework.web.server.ResponseStatusException;

@Service
public class CleverSchoolSyncServiceImpl
implements CleverSchoolSyncService {
    private final AccountRepository accountRepository;
    private final SchoolRepository schoolRepository;
    private final DistrictRepository districtRepository;
    private final CleverService cleverService;
    private final CleverSchoolService cleverSchoolService;
    private final InstructorService instructorService;
    private final AccountService accountService;
    private final StudentService studentService;
    private final AccessCodeService accessCodeService;
    private final StandardService standardService;
    private final ClassService classService;
    private final ClassRepository classRepository;
    private final StudentGroupRepository studentGroupRepository;
    private final InstructorGroupRepository instructorGroupRepository;
    private final RealTimeMessageService realTimeMessageService;
    private final MessageService messageService;
    private final SocioEmotionalTestService socioEmotionalTestService;

    public CleverSchoolSyncServiceImpl(AccountRepository accountRepository, SchoolRepository schoolRepository, DistrictRepository districtRepository, CleverService cleverService, CleverSchoolService cleverSchoolService, InstructorService instructorService, AccountService accountService, StudentService studentService, AccessCodeService accessCodeService, StandardService standardService, ClassService classService, ClassRepository classRepository, StudentGroupRepository studentGroupRepository, InstructorGroupRepository instructorGroupRepository, RealTimeMessageService realTimeMessageService, MessageService messageService, SocioEmotionalTestService socioEmotionalTestService) {
        this.accountRepository = accountRepository;
        this.schoolRepository = schoolRepository;
        this.districtRepository = districtRepository;
        this.cleverService = cleverService;
        this.cleverSchoolService = cleverSchoolService;
        this.instructorService = instructorService;
        this.accountService = accountService;
        this.studentService = studentService;
        this.accessCodeService = accessCodeService;
        this.standardService = standardService;
        this.classService = classService;
        this.classRepository = classRepository;
        this.studentGroupRepository = studentGroupRepository;
        this.instructorGroupRepository = instructorGroupRepository;
        this.realTimeMessageService = realTimeMessageService;
        this.messageService = messageService;
        this.socioEmotionalTestService = socioEmotionalTestService;
    }

    @Async
    public void syncSchool(long school_id) {
        this.syncSchoolNonAsync(school_id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void syncSchoolNonAsync(long school_id) {
        School school = this.schoolRepository.findBySchoolId(Long.valueOf(school_id));
        if (school == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, this.messageService.getMessage("school.is.not.found"));
        }
        if (school.isSync_progressed()) {
            return;
        }
        school.setSync_progressed(true);
        this.schoolRepository.save((Object)school);
        try {
            System.out.println("School: " + school.toString());
            District district = this.districtRepository.findByDistrictId(Long.valueOf(school.getDistrict_id()));
            if (district == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, this.messageService.getMessage("district.is.not.found"));
            }
            if (AppUtils.isNullOrEmpty((String)school.getClever_id())) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, this.messageService.getMessage("school.has.no.clever.id"));
            }
            AccessToken accessToken = this.cleverService.getAccessTokenByDistrictCleverId(district.getClever_id());
            System.out.println("syncSchool " + accessToken.getAccess_token());
            CleverSchool cleverSchool = this.cleverSchoolService.getCleverSchoolById(accessToken.getAccess_token(), school.getClever_id());
            System.out.println("Clever_School: " + cleverSchool);
            school.setSchool_name(cleverSchool.getName());
            school.setClever_id(cleverSchool.getId());
            school.setLast_sync(new java.util.Date());
            school.setAddress(cleverSchool.getLocation().getAddress() + ", " + cleverSchool.getLocation().getCity() + ", " + cleverSchool.getLocation().getState() + " " + cleverSchool.getLocation().getZip());
            this.schoolRepository.save((Object)school);
            List standards = this.standardService.getAllStandardsOrderByStandardIdAsc();
            CompletableFuture<LinkedHashSet> cleverInstructorsCF = CompletableFuture.supplyAsync(() -> this.getCleverInstructors(school.getClever_id(), accessToken.getAccess_token(), null));
            CompletableFuture<LinkedHashSet> cleverStaffCF = CompletableFuture.supplyAsync(() -> this.getCleverStaff(school.getClever_id(), accessToken.getAccess_token(), null));
            CompletableFuture<LinkedHashSet> cleverStudentsCF = CompletableFuture.supplyAsync(() -> this.getCleverStudents(school.getClever_id(), accessToken.getAccess_token(), null).stream().filter(cleverStudent -> {
                if (cleverStudent.getRoles() != null && cleverStudent.getRoles().getStudent() != null && !AppUtils.isNullOrEmpty((String)cleverStudent.getRoles().getStudent().getGrade())) {
                    String grade = cleverStudent.getRoles().getStudent().getGrade();
                    if (this.getCleverGradeRelatedToK().contains(grade)) {
                        grade = "K";
                    }
                    String finalGrade = grade;
                    Standard standard = standards.stream().filter(item -> item.getStandard_name().equals(finalGrade)).findFirst().orElse(null);
                    return standard != null;
                }
                return false;
            }).collect(Collectors.toCollection(LinkedHashSet::new)));
            CompletableFuture<LinkedHashSet> cleverSectionsCF = CompletableFuture.supplyAsync(() -> this.getCleverSections(school.getClever_id(), accessToken.getAccess_token(), null));
            CompletableFuture.allOf(cleverSectionsCF, cleverStudentsCF, cleverSectionsCF).join();
            LinkedHashSet cleverInstructors = cleverInstructorsCF.join();
            System.out.println("Clever_Instructor: " + cleverInstructors.toString());
            Set instructors = this.syncInstructors(school.getSchool_id(), cleverInstructors);
            LinkedHashSet cleverStaff = cleverStaffCF.join().stream().filter(i -> i.getRoles() != null && i.getRoles().getTeacher() == null && i.getRoles().getStaff() != null).collect(Collectors.toCollection(LinkedHashSet::new));
            System.out.println("Clever_Staff: " + cleverStaff);
            Set staff = this.syncInstructors(school.getSchool_id(), cleverStaff);
            if (!staff.isEmpty()) {
                instructors.addAll(staff);
            }
            LinkedHashSet cleverStudents = cleverStudentsCF.join();
            System.out.println("Clever_Student: " + cleverStudents.toString());
            Set students = this.syncStudents(school.getSchool_id(), cleverStudents, standards);
            LinkedHashSet cleverSections = cleverSectionsCF.join();
            System.out.println("Clever_Section: " + cleverSections.toString());
            this.syncSections(school.getSchool_id(), cleverSections, instructors, students);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            school.setSync_progressed(false);
            this.schoolRepository.save((Object)school);
        }
        String message = this.messageService.getMessage("sync.completed.for.the.school");
        String json_message = "{\"type\":\"NOTIFICATION\",\"message\":\"" + message + "\"}";
        this.realTimeMessageService.sendMessage(school_id, json_message);
        System.out.println(school_id + " " + school.getSchool_name() + " " + message);
    }

    public Set<Instructor> syncInstructors(long school_id, LinkedHashSet<CleverInstructor> cleverInstructors) {
        System.out.println("Starting Thread instructor for school {} - " + school_id);
        ArrayList instructorUpdateList = new ArrayList();
        ArrayList instructorCreationList = new ArrayList();
        ArrayList accounts = new ArrayList();
        School school = this.schoolRepository.findBySchoolId(Long.valueOf(school_id));
        List instructorsBySchool = this.instructorService.getInstructorsBySchoolId(school.getSchool_id());
        cleverInstructors.stream().forEach(cleverInstructor -> {
            AtomicBoolean isNew = new AtomicBoolean(true);
            instructorsBySchool.stream().forEach(instructor -> {
                if (instructor.getAccount() != null && !AppUtils.isNullOrEmpty((String)instructor.getAccount().getUsername()) && (!AppUtils.isNullOrEmpty((String)instructor.getClever_id()) && instructor.getClever_id().equals(cleverInstructor.getId()) || instructor.getAccount().getUsername().equals(cleverInstructor.getEmail()))) {
                    isNew.set(false);
                    if (cleverInstructor.getName() != null) {
                        instructor.setFirst_name(cleverInstructor.getName().getFirst());
                        instructor.setLast_name(cleverInstructor.getName().getLast());
                    }
                    instructor.setClever_id(cleverInstructor.getId());
                    instructor.setLast_sync(new java.util.Date());
                    System.out.println("Clever instructor thread name:- " + Thread.currentThread().getName());
                    System.out.println("Updated instructor:-" + instructor.getClever_id());
                    instructorUpdateList.add(instructor);
                }
            });
            if (isNew.get() && !AppUtils.isNullOrEmpty((String)cleverInstructor.getEmail()) && this.accountService.getAccountByUsername(cleverInstructor.getEmail()) == null) {
                System.out.println("this is new instructor process here");
                Account account = this.accountRepository.findByUsername(cleverInstructor.getEmail());
                if (account == null) {
                    account = this.accountService.createCleverAccountByEmailAndPassword(cleverInstructor.getEmail(), "Clymb@123");
                    accounts.add(account);
                }
                Instructor instructor2 = new Instructor();
                instructor2.setAccount(account);
                instructor2.setSchool_id(school.getSchool_id());
                instructor2.setAuto_approve_wall_posts(school.isAuto_approve_wall_posts());
                instructor2.setLast_sync(new java.util.Date());
                if (cleverInstructor.getName() != null) {
                    instructor2.setFirst_name(cleverInstructor.getName().getFirst());
                    instructor2.setLast_name(cleverInstructor.getName().getLast());
                }
                instructor2.setClever_id(cleverInstructor.getId());
                instructor2.setRegistration_code(this.instructorService.generateRegistrationCodeForInstructor());
                instructor2.setLanguage(Language.getLanguage());
                System.out.println("New Instructor Added" + instructor2.getClever_id());
                instructorCreationList.add(instructor2);
            }
        });
        this.instructorService.saveAll(instructorUpdateList);
        System.out.println("instructor updated for school {} - " + school_id);
        try {
            this.instructorService.saveAll(instructorCreationList);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.accountRepository.deleteAll(accounts);
        }
        System.out.println("New instructor Added for school {} - " + school_id);
        System.out.println("This is End of Instructors");
        System.out.println("Exiting Thread - Processing instructor {} completed");
        HashSet<Instructor> instructors = new HashSet<Instructor>();
        instructors.addAll(instructorUpdateList);
        instructors.addAll(instructorCreationList);
        return instructors;
    }

    public Set<Student> syncStudents(long school_id, LinkedHashSet<CleverStudent> cleverStudents, List<Standard> standards) {
        System.out.println("Starting Thread Student for school {} -" + school_id);
        ArrayList studentUpdateList = new ArrayList();
        ArrayList studentCreationList = new ArrayList();
        ArrayList accounts = new ArrayList();
        School school = this.schoolRepository.findBySchoolId(Long.valueOf(school_id));
        cleverStudents.stream().forEach(cleverStudent -> {
            if (cleverStudent.getEmail() != null) {
                String gender;
                CleverRoleStudent cleverRoleStudent;
                boolean isNew = true;
                List students = this.studentService.getStudentByCleverId2(cleverStudent.getId());
                for (Student student : students) {
                    if (student.getAccount() == null || AppUtils.isNullOrEmpty((String)student.getAccount().getUsername()) || (AppUtils.isNullOrEmpty((String)student.getClever_id()) || !student.getClever_id().equals(cleverStudent.getId())) && !student.getAccount().getUsername().equals(cleverStudent.getEmail())) continue;
                    isNew = false;
                    if (cleverStudent.getName() != null) {
                        student.setFirst_name(cleverStudent.getName().getFirst());
                        student.setLast_name(cleverStudent.getName().getLast());
                    }
                    if (cleverStudent.getRoles() != null && cleverStudent.getRoles().getStudent() != null) {
                        cleverRoleStudent = cleverStudent.getRoles().getStudent();
                        gender = null;
                        if (cleverRoleStudent.getGender().equals("M")) {
                            gender = "Male";
                        } else if (cleverRoleStudent.getGender().equals("F")) {
                            gender = "Female";
                        }
                        student.setGender(gender);
                        String ethnicity = cleverRoleStudent.getRace();
                        if (cleverRoleStudent.getHispanic_ethnicity().equals("Y")) {
                            ethnicity = "Hispanic, Latino, or Spanish origin";
                        } else if ("Caucasian".equals(ethnicity)) {
                            ethnicity = "White/European";
                        } else if ("American Indian".equals(ethnicity)) {
                            ethnicity = "Native Americans/Alaska Natives";
                        } else if ("Black or African American".equals(ethnicity)) {
                            ethnicity = "Black/African American";
                        }
                        student.setEthnicity(ethnicity);
                        if (school != null && student.getSchool() != null && school.getSchool_id() != student.getSchool().getSchool_id()) {
                            student.setInstructor(null);
                        }
                        student.setSchool(school);
                        student.setLast_sync(new java.util.Date());
                        try {
                            java.util.Date date = DateUtils.MMDDYYYY_SLASH.parse(cleverRoleStudent.getDob());
                            Date bDate = new Date(date.getTime());
                            if (100 > DateUtils.getAge((java.util.Date)bDate)) {
                                student.setDate_of_birth(bDate);
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        student.setStandard((Standard)standards.stream().filter(item -> {
                            String cleverGrade = cleverRoleStudent.getGrade();
                            if (this.getCleverGradeRelatedToK().contains(cleverGrade)) {
                                cleverGrade = "K";
                            }
                            return item.getStandard_name().equals(cleverGrade);
                        }).findFirst().orElse(null));
                    }
                    student.setClever_id(cleverStudent.getId());
                    System.out.println("Clever student thread name:- " + Thread.currentThread().getName());
                    System.out.println("Updated Student:-" + student.getClever_id());
                    studentUpdateList.add(student);
                    break;
                }
                if (isNew && !AppUtils.isNullOrEmpty((String)cleverStudent.getEmail()) && this.accountService.getAccountByUsername(cleverStudent.getEmail()) == null) {
                    Student student;
                    System.out.println("Email is:-" + cleverStudent.getEmail());
                    Account account = this.accountRepository.findByUsername(cleverStudent.getEmail());
                    if (account == null) {
                        account = this.accountService.createCleverAccountByEmailAndPassword(cleverStudent.getEmail(), "Clymb@123");
                        accounts.add(account);
                    }
                    student = new Student();
                    student.setAccount(account);
                    if (cleverStudent.getName() != null) {
                        student.setFirst_name(cleverStudent.getName().getFirst());
                        student.setLast_name(cleverStudent.getName().getLast());
                    }
                    if (cleverStudent.getRoles() != null && cleverStudent.getRoles().getStudent() != null) {
                        cleverRoleStudent = cleverStudent.getRoles().getStudent();
                        gender = null;
                        if (cleverRoleStudent.getGender().equals("M")) {
                            gender = "Male";
                        } else if (cleverRoleStudent.getGender().equals("F")) {
                            gender = "Female";
                        }
                        student.setGender(gender);
                        student.setSchool(school);
                        student.setLast_sync(new java.util.Date());
                        student.setEthnicity(cleverRoleStudent.getRace());
                        try {
                            java.util.Date date = DateUtils.MMDDYYYY_SLASH.parse(cleverRoleStudent.getDob());
                            Date bDate = new Date(date.getTime());
                            if (100 > DateUtils.getAge((java.util.Date)bDate)) {
                                student.setDate_of_birth(bDate);
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        student.setStandard((Standard)standards.stream().filter(item -> item.getStandard_name().equals(cleverRoleStudent.getGrade())).findFirst().orElse(null));
                    }
                    student.setClever_id(cleverStudent.getId());
                    student.setLanguage(Language.getLanguage());
                    this.socioEmotionalTestService.setShould_auto_show_assessment(student);
                    System.out.println("New Student Added" + student.getClever_id());
                    studentCreationList.add(student);
                }
            }
        });
        this.studentService.saveAll(studentUpdateList);
        System.out.println("Student updated for school {} - " + school_id);
        try {
            AccessCode accessCode;
            this.studentService.saveAll(studentCreationList);
            ArrayList<AccessCode> accessCodes = new ArrayList<AccessCode>();
            for (Student student : studentCreationList) {
                accessCode = this.accessCodeService.getAccessCodeByStudentId(student.getStudent_id());
                if (accessCode == null) {
                    accessCode = new AccessCode(student, student.getInstructor(), student.getParent());
                }
                accessCode.setInstructor(student.getInstructor());
                accessCode.setParent(student.getParent());
                accessCode.setStatus(Status.ACCEPTED);
                accessCodes.add(accessCode);
            }
            for (Student student : studentUpdateList) {
                accessCode = this.accessCodeService.getAccessCodeByStudentId(student.getStudent_id());
                if (accessCode == null) {
                    accessCode = new AccessCode(student, student.getInstructor(), student.getParent());
                }
                accessCode.setInstructor(student.getInstructor());
                accessCode.setParent(student.getParent());
                accessCode.setStatus(Status.ACCEPTED);
                accessCodes.add(accessCode);
            }
            this.accessCodeService.saveAll(accessCodes);
            System.out.println("New Student Added for school {} - " + school_id);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.accountRepository.deleteAll(accounts);
        }
        System.out.println("This is End of Students");
        System.out.println("Exiting Thread - Processing Students {} completed");
        HashSet<Student> studentList = new HashSet<Student>();
        studentList.addAll(studentUpdateList);
        studentList.addAll(studentCreationList);
        return studentList;
    }

    public void syncSections(long school_id, LinkedHashSet<CleverSection> cleverSections, Set<Instructor> allInstructors, Set<Student> allStudents) {
        System.out.println("Starting Thread Section for school {} - " + school_id);
        ArrayList sectionUpdateList = new ArrayList();
        ArrayList sectionCreationList = new ArrayList();
        School school = this.schoolRepository.findBySchoolId(Long.valueOf(school_id));
        List classes = this.classService.getClassesBySchoolId(school.getSchool_id());
        if (!AppUtils.isNullOrEmpty((List)classes) && !AppUtils.isNullOrEmpty(cleverSections)) {
            List cleverClassIds = cleverSections.stream().map(CleverSection::getId).distinct().collect(Collectors.toList());
            ArrayList<Long> deletedFromClever = new ArrayList<Long>();
            for (Class _class : classes) {
                if (AppUtils.isNullOrEmpty((String)_class.getClever_id()) || cleverClassIds.contains(_class.getClever_id())) continue;
                deletedFromClever.add(_class.getClass_id());
            }
            if (!AppUtils.isNullOrEmpty(deletedFromClever)) {
                classes.removeIf(c -> deletedFromClever.contains(c.getClass_id()));
                this.classRepository.deleteByClassIds(deletedFromClever);
                this.studentGroupRepository.removeByGroupIds(deletedFromClever);
                this.instructorGroupRepository.removeByGroupIds(deletedFromClever);
            }
        }
        cleverSections.stream().forEach(cleverSection -> {
            try {
                System.out.println("    Class id: " + cleverSection.getId() + " name: " + cleverSection.getName());
                Instructor instructor = allInstructors.stream().filter(item -> item.getClever_id().equals(cleverSection.getTeacher())).findFirst().orElse(null);
                List instructors = allInstructors.stream().filter(item -> cleverSection.getTeachers().contains(item.getClever_id())).collect(Collectors.toList());
                boolean isNew = true;
                for (Class class_ : classes) {
                    if ((AppUtils.isNullOrEmpty((String)class_.getClever_id()) || AppUtils.isNullOrEmpty((String)cleverSection.getId()) || !class_.getClever_id().equals(cleverSection.getId())) && (!AppUtils.isNullOrEmpty((String)class_.getClever_id()) || AppUtils.isNullOrEmpty((String)class_.getClass_name()) || !class_.getClass_name().equals(cleverSection.getName()) || class_.getInstructor() == null || AppUtils.isNullOrEmpty((String)class_.getInstructor().getClever_id()) || instructor == null || AppUtils.isNullOrEmpty((String)instructor.getClever_id()) || !class_.getInstructor().getClever_id().equals(instructor.getClever_id()))) continue;
                    isNew = false;
                    class_.setClass_name(cleverSection.getName());
                    class_.setSubject(cleverSection.getSubject());
                    class_.setInstructor(instructor);
                    class_.getInstructors().addAll(instructors);
                    class_.setClever_id(cleverSection.getId());
                    class_.setLast_sync(new java.util.Date());
                    class_.setSchool(school);
                    class_.setStudents(new HashSet());
                    if (!AppUtils.isNullOrEmpty((Set)cleverSection.getStudents())) {
                        List students = allStudents.stream().filter(item -> cleverSection.getStudents().contains(item.getClever_id())).collect(Collectors.toList());
                        class_.setStudents(new HashSet(students));
                    }
                    System.out.println("Clever section thread name:- " + Thread.currentThread().getName());
                    System.out.println("Updated Section:-" + cleverSection.getId());
                    sectionUpdateList.add(class_);
                    break;
                }
                if (isNew && !AppUtils.isNullOrEmpty((String)cleverSection.getName()) && instructor != null) {
                    Class class_ = new Class();
                    class_.setClass_name(cleverSection.getName());
                    class_.setSubject(cleverSection.getSubject());
                    class_.setInstructor(instructor);
                    class_.getInstructors().addAll(instructors);
                    class_.setClever_id(cleverSection.getId());
                    class_.setLast_sync(new java.util.Date());
                    class_.setSchool(school);
                    class_.setStudents(new HashSet());
                    if (!AppUtils.isNullOrEmpty((Set)cleverSection.getStudents())) {
                        List students = allStudents.stream().filter(item -> cleverSection.getStudents().contains(item.getClever_id())).collect(Collectors.toList());
                        class_.setStudents(new HashSet(students));
                    }
                    System.out.println("New Section Added" + cleverSection.getId());
                    sectionCreationList.add(class_);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
        this.classService.saveAll(sectionUpdateList);
        System.out.println("Section updated for school" + school_id);
        this.classService.saveAll(sectionCreationList);
        System.out.println("New Section Added for school" + school_id);
        System.out.println("This is End of Section");
        System.out.println("Exiting Thread - Processing Section {} completed");
    }

    public LinkedHashSet<CleverInstructor> getCleverInstructors(String school_clever_id, String access_token, String starting_after) {
        LinkedHashSet<CleverInstructor> cleverInstructors = new LinkedHashSet<CleverInstructor>();
        while (starting_after == null || !starting_after.equals("END")) {
            LinkedHashSet cleverInstructorsFromClever = this.cleverSchoolService.getCleverInstructorsByCleverSchool(access_token, school_clever_id, CleverAppConstants.INSTRUCTOR_LIMIT, starting_after, null, "true");
            if (!AppUtils.isNullOrEmpty((LinkedHashSet)cleverInstructorsFromClever)) {
                cleverInstructors.addAll(cleverInstructorsFromClever);
            }
            if (AppUtils.isNullOrEmpty((LinkedHashSet)cleverInstructorsFromClever) || cleverInstructorsFromClever.size() < CleverAppConstants.INSTRUCTOR_LIMIT) {
                starting_after = "END";
                continue;
            }
            starting_after = ((CleverInstructor)AppUtils.getLastElement((Iterable)cleverInstructorsFromClever)).getId();
        }
        return cleverInstructors;
    }

    public LinkedHashSet<CleverInstructor> getCleverStaff(String school_clever_id, String access_token, String starting_after) {
        LinkedHashSet<CleverInstructor> cleverInstructors = new LinkedHashSet<CleverInstructor>();
        while (starting_after == null || !starting_after.equals("END")) {
            LinkedHashSet cleverInstructorsFromClever = this.cleverSchoolService.getCleverStaffByCleverSchool(access_token, school_clever_id, CleverAppConstants.INSTRUCTOR_LIMIT, starting_after, null, "true");
            if (!AppUtils.isNullOrEmpty((LinkedHashSet)cleverInstructorsFromClever)) {
                cleverInstructors.addAll(cleverInstructorsFromClever);
            }
            if (AppUtils.isNullOrEmpty((LinkedHashSet)cleverInstructorsFromClever) || cleverInstructorsFromClever.size() < CleverAppConstants.INSTRUCTOR_LIMIT) {
                starting_after = "END";
                continue;
            }
            starting_after = ((CleverInstructor)AppUtils.getLastElement((Iterable)cleverInstructorsFromClever)).getId();
        }
        return cleverInstructors;
    }

    public LinkedHashSet<CleverStudent> getCleverStudents(String school_clever_id, String access_token, String starting_after) {
        LinkedHashSet<CleverStudent> cleverStudents = new LinkedHashSet<CleverStudent>();
        while (starting_after == null || !starting_after.equals("END")) {
            LinkedHashSet cleverStudentsFromClever = this.cleverSchoolService.getCleverStudentsByCleverSchool(access_token, school_clever_id, CleverAppConstants.STUDENT_LIMIT, starting_after, null, "true");
            if (!AppUtils.isNullOrEmpty((LinkedHashSet)cleverStudentsFromClever)) {
                cleverStudents.addAll(cleverStudentsFromClever);
            }
            if (AppUtils.isNullOrEmpty((LinkedHashSet)cleverStudentsFromClever) || cleverStudentsFromClever.size() < CleverAppConstants.STUDENT_LIMIT) {
                starting_after = "END";
                continue;
            }
            starting_after = ((CleverStudent)AppUtils.getLastElement((Iterable)cleverStudentsFromClever)).getId();
        }
        return cleverStudents;
    }

    public LinkedHashSet<CleverSection> getCleverSections(String school_clever_id, String access_token, String starting_after) {
        LinkedHashSet<CleverSection> cleverSections = new LinkedHashSet<CleverSection>();
        while (starting_after == null || !starting_after.equals("END")) {
            LinkedHashSet cleverSectionsFromClever = this.cleverSchoolService.getCleverSectionsByCleverSchool(access_token, school_clever_id, CleverAppConstants.SECTIONS_LIMIT, starting_after, null);
            if (!AppUtils.isNullOrEmpty((LinkedHashSet)cleverSectionsFromClever)) {
                cleverSections.addAll(cleverSectionsFromClever);
            }
            if (AppUtils.isNullOrEmpty((LinkedHashSet)cleverSectionsFromClever) || cleverSectionsFromClever.size() < CleverAppConstants.SECTIONS_LIMIT) {
                starting_after = "END";
                continue;
            }
            starting_after = ((CleverSection)AppUtils.getLastElement((Iterable)cleverSectionsFromClever)).getId();
        }
        return cleverSections;
    }

    public List<String> getCleverGradeRelatedToK() {
        ArrayList<String> grades = new ArrayList<String>();
        grades.add("PreKindergarten");
        grades.add("TransitionalKindergarten");
        grades.add("Kindergarten");
        grades.add("InfantToddler");
        grades.add("Preschool");
        return grades;
    }
}

