/*
 * Decompiled with CFR 0.152.
 */
package com.infinite.focus.server.organization.service;

import com.infinite.focus.server.account.service.AccountService;
import com.infinite.focus.server.account.view.AccountView;
import com.infinite.focus.server.corporate.entity.Corporate;
import com.infinite.focus.server.corporate.service.CorporateService;
import com.infinite.focus.server.district.entity.District;
import com.infinite.focus.server.district.service.DistrictService;
import com.infinite.focus.server.freetrial.model.FocusOn;
import com.infinite.focus.server.freetrial.model.OrganizationType;
import com.infinite.focus.server.instructor.entity.Instructor;
import com.infinite.focus.server.instructor.service.InstructorService;
import com.infinite.focus.server.message.service.MessageService;
import com.infinite.focus.server.organization.dto.OrganizationDTO;
import com.infinite.focus.server.organization.model.OrganizationDetail;
import com.infinite.focus.server.organization.repository.OrganizationPagingAndSortingRepository;
import com.infinite.focus.server.organization.repository.OrganizationRepository;
import com.infinite.focus.server.organization.request.GetOrganizationsRequest;
import com.infinite.focus.server.organization.service.OrganizationService;
import com.infinite.focus.server.school.entity.School;
import com.infinite.focus.server.school.service.SchoolService;
import com.infinite.focus.server.utils.DateUtils;
import jakarta.persistence.EntityManager;
import java.util.Date;
import org.springframework.data.domain.Page;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.stereotype.Service;
import org.springframework.web.server.ResponseStatusException;

@Service
public class OrganizationServiceImpl
implements OrganizationService {
    private final EntityManager entityManager;
    private final OrganizationPagingAndSortingRepository organizationPagingAndSortingRepository;
    private final OrganizationRepository organizationRepository;
    private final DistrictService districtService;
    private final SchoolService schoolService;
    private final InstructorService instructorService;
    private final MessageService messageService;
    private final AccountService accountService;
    private final CorporateService corporateService;

    public OrganizationServiceImpl(EntityManager entityManager, OrganizationPagingAndSortingRepository organizationPagingAndSortingRepository, OrganizationRepository organizationRepository, DistrictService districtService, SchoolService schoolService, InstructorService instructorService, MessageService messageService, AccountService accountService, CorporateService corporateService) {
        this.entityManager = entityManager;
        this.organizationPagingAndSortingRepository = organizationPagingAndSortingRepository;
        this.organizationRepository = organizationRepository;
        this.districtService = districtService;
        this.schoolService = schoolService;
        this.instructorService = instructorService;
        this.messageService = messageService;
        this.accountService = accountService;
        this.corporateService = corporateService;
    }

    public Page<OrganizationDTO> getActiveOrganizations(GetOrganizationsRequest request) {
        return this.organizationRepository.getActiveOrganizations(request);
    }

    public Page<OrganizationDTO> getInactiveOrganizations(GetOrganizationsRequest request) {
        return this.organizationRepository.getInactiveOrganizations(request);
    }

    public District activeDeactiveLargeOrganization(long organization_id, boolean active) {
        return this.districtService.activeDeactiveDistrict(organization_id, active);
    }

    public School activeDeactiveOrganization(long organization_id, boolean active) {
        return this.schoolService.activeDeactiveSchool(organization_id, active);
    }

    public boolean isActiveInstructor(long instructor_id) {
        Instructor instructor = this.instructorService.getInstructorById(instructor_id);
        if (instructor == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.CONFLICT, this.messageService.getMessage("the.instructor.is.not.found"));
        }
        boolean isActive = this.isActiveSchool(instructor.getSchool_id());
        if (!isActive) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.CONFLICT, this.messageService.getMessage().getAdmin_deactivates());
        }
        return isActive;
    }

    public boolean isActiveSchool(long school_id) {
        School school = this.schoolService.getSchoolById(school_id);
        if (school == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.CONFLICT, this.messageService.getMessage("the.school.is.not.found"));
        }
        District district = this.districtService.getDistrictById(school.getDistrict_id());
        if (district == null) {
            if (school.getLicence_key_expiry_date() != null && DateUtils.checkDateTimeIsPassed((Date)school.getLicence_key_expiry_date())) {
                school = this.activeDeactiveOrganization(school.getSchool_id(), false);
            }
            return school.isActive();
        }
        boolean isActive = this.isActiveDistrict(district.getDistrict_id());
        if (!isActive) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.CONFLICT, this.messageService.getMessage().getAdmin_deactivates());
        }
        return isActive;
    }

    public boolean isActiveDistrict(long district_id) {
        District district = this.districtService.getDistrictById(district_id);
        if (district == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.CONFLICT, this.messageService.getMessage("the.district.is.not.found"));
        }
        if (district.getLicence_key_expiry_date() != null && DateUtils.checkDateTimeIsPassed((Date)district.getLicence_key_expiry_date())) {
            district = this.activeDeactiveLargeOrganization(district.getDistrict_id(), false);
        }
        return district.isActive();
    }

    public OrganizationDetail findByOrganizationTypeAndOrganizationId(String organizationType, long organization_id) {
        OrganizationDetail detail = null;
        if (organizationType.equals(OrganizationType.LARGE_ORGANIZATION.toString())) {
            District district = this.districtService.getDistrictById(organization_id);
            if (district == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, this.messageService.getMessage("the.large.organization.is.not.found"));
            }
            detail = new OrganizationDetail();
            detail.setOrganization_id(district.getDistrict_id());
            detail.setName_of_organization(district.getDistrict_name());
            detail.setOrganization_type(OrganizationType.LARGE_ORGANIZATION);
            detail.setLicense_key(district.getLicense_key());
            detail.setLicence_key_added_date(district.getLicence_key_added_date());
            detail.setLicence_key_expiry_date(district.getLicence_key_expiry_date());
            detail.setActive(district.isActive());
            detail.setAddress(null);
            detail.setCity(district.getCity());
            detail.setState(district.getState());
            detail.setFocus_on(district.getFocus_on());
            detail.setNumber_of_youth(district.getNumber_of_youth());
            AccountView accountView = this.accountService.findAccountById(district.getAccount_id());
            detail.setEmail(accountView.getUsername());
            detail.setCreatedAt(district.getCreatedAt());
        } else if (organizationType.equals(OrganizationType.ORGANIZATION.toString())) {
            School school = this.schoolService.getSchoolById(organization_id);
            if (school == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, this.messageService.getMessage("the.organization.is.not.found"));
            }
            detail = new OrganizationDetail();
            detail.setOrganization_id(school.getSchool_id());
            detail.setName_of_organization(school.getSchool_name());
            detail.setOrganization_type(OrganizationType.ORGANIZATION);
            detail.setLicense_key(school.getLicense_key());
            detail.setLicence_key_added_date(school.getLicence_key_added_date());
            detail.setLicence_key_expiry_date(school.getLicence_key_expiry_date());
            detail.setActive(school.isActive());
            detail.setAddress(school.getAddress());
            detail.setCity(null);
            detail.setState(null);
            detail.setFocus_on(school.getFocus_on());
            detail.setNumber_of_youth(school.getNumber_of_youth());
            AccountView accountView = this.accountService.findAccountById(school.getAccount_id());
            detail.setEmail(accountView.getUsername());
            detail.setCreatedAt(school.getCreatedAt());
        } else if (organizationType.equals(OrganizationType.CORPORATE.toString())) {
            Corporate corporate = this.corporateService.getCorporateById(organization_id);
            if (corporate == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, this.messageService.getMessage("the.corporate.is.not.found"));
            }
            detail = new OrganizationDetail();
            detail.setOrganization_id(corporate.getCorporate_id());
            detail.setName_of_organization(corporate.getCorporate_name());
            detail.setOrganization_type(OrganizationType.CORPORATE);
            detail.setLicense_key(corporate.getLicense_key());
            detail.setLicence_key_added_date(corporate.getLicence_key_added_date());
            detail.setLicence_key_expiry_date(corporate.getLicence_key_expiry_date());
            detail.setActive(corporate.isActive());
            detail.setAddress(corporate.getAddress());
            detail.setCity(null);
            detail.setState(null);
            detail.setFocus_on(corporate.getFocus_on());
            detail.setNumber_of_youth(corporate.getNumber_of_youth());
            AccountView accountView = this.accountService.findAccountById(corporate.getAccount_id());
            detail.setEmail(accountView.getUsername());
            detail.setCreatedAt(corporate.getCreatedAt());
        } else {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, this.messageService.getMessage("the.organization.type.is.not.found"));
        }
        return detail;
    }

    public District deleteLargeOrganization(long organization_id, boolean deleted) {
        return this.districtService.deleteDistrict(organization_id, deleted, false);
    }

    public School deleteOrganization(long organization_id, boolean deleted) {
        return this.schoolService.deleteSchool(organization_id, deleted, false);
    }

    public District editLargeOrganization(long organization_id, String name_of_organization, FocusOn focus_on, String email, String city, String state, long number_of_youth, Date licence_key_expiry_date) {
        return this.districtService.editDistrict(organization_id, name_of_organization, focus_on, email, city, state, number_of_youth, licence_key_expiry_date);
    }

    public School editOrganization(long organization_id, String name_of_organization, FocusOn focus_on, String email, String address, long number_of_youth, Date licence_key_expiry_date) {
        return this.schoolService.editSchool(organization_id, name_of_organization, focus_on, email, address, number_of_youth, licence_key_expiry_date);
    }

    public boolean isDeletedInstructor(long instructor_id) {
        Instructor instructor = this.instructorService.getInstructorById(instructor_id);
        if (instructor == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.CONFLICT, this.messageService.getMessage("the.instructor.is.not.found"));
        }
        boolean isDeleted = this.isDeletedSchool(instructor.getSchool_id());
        if (isDeleted) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.CONFLICT, this.messageService.getMessage().getAdmin_deletes());
        }
        return false;
    }

    public boolean isDeletedSchool(long school_id) {
        School school = this.schoolService.getSchoolById(school_id);
        if (school == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.CONFLICT, this.messageService.getMessage("the.school.is.not.found"));
        }
        District district = this.districtService.getDistrictById(school.getDistrict_id());
        if (district == null) {
            return school.isDeleted();
        }
        boolean isDeleted = this.isDeletedDistrict(district.getDistrict_id());
        if (isDeleted) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.CONFLICT, this.messageService.getMessage().getAdmin_deletes());
        }
        return false;
    }

    public boolean isDeletedDistrict(long district_id) {
        District district = this.districtService.getDistrictById(district_id);
        if (district == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.CONFLICT, this.messageService.getMessage("the.district.is.not.found"));
        }
        return district.isDeleted();
    }
}

