/*
 * Decompiled with CFR 0.152.
 */
package com.infinite.focus.server.submood.controller;

import com.infinite.focus.server.auth.service.AuthService;
import com.infinite.focus.server.submood.dto.SubMoodDTO;
import com.infinite.focus.server.submood.request.GetSubMoodsByMoodIdAndStandardIdRequest;
import com.infinite.focus.server.submood.service.SubMoodService;
import com.infinite.focus.server.submood.wrapper.SubMoodsAndColorWrapper;
import java.io.IOException;
import java.util.List;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@CrossOrigin(origins={"http://localhost:8383"})
@RestController
@RequestMapping(value={"api/sub-mood"})
public class SubMoodController {
    private final AuthService authService;
    private final SubMoodService subMoodService;

    public SubMoodController(AuthService authService, SubMoodService subMoodService) {
        this.authService = authService;
        this.subMoodService = subMoodService;
    }

    @PostMapping(value={"/get-sub-moods-by-mood-id-and-standard-id"})
    private ResponseEntity<SubMoodsAndColorWrapper> getSubMoodsByMoodIdAndStandardId(@RequestHeader(value="Authorization") String token, @RequestBody GetSubMoodsByMoodIdAndStandardIdRequest request) throws IOException {
        this.authService.isAuthenticated(token);
        return new ResponseEntity((Object)this.subMoodService.getSubMoodsByMoodIdAndStandardId(request.getMood_id(), request.getStandard_id()), (HttpStatusCode)HttpStatus.OK);
    }

    @PostMapping(value={"/get-all-sub-moods"})
    private ResponseEntity<List<SubMoodDTO>> getAllSubMoods(@RequestHeader(value="Authorization") String token) {
        return new ResponseEntity((Object)this.subMoodService.getAllSubMoods(), (HttpStatusCode)HttpStatus.OK);
    }
}

