/*
 * Decompiled with CFR 0.152.
 */
package com.infinite.focus.server.studentgroup.repository;

import com.infinite.focus.server.studentgroup.repository.StudentGroupRepository;
import com.infinite.focus.server.utils.AppUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Repository;

@Repository
public class StudentGroupRepositoryImpl
implements StudentGroupRepository {
    @Autowired
    private JdbcTemplate jdbcTemplate;

    public List<Long> findStudentIdsByGroupIds(List<Long> group_ids) {
        if (AppUtils.isNullOrEmpty(group_ids)) {
            return new ArrayList<Long>();
        }
        String inSql = String.join((CharSequence)",", Collections.nCopies(group_ids.size(), "?"));
        String SQL = "SELECT DISTINCT(student_id) FROM student_class WHERE class_id IN(%S)";
        try {
            List studentIds = this.jdbcTemplate.query(String.format(SQL, inSql), group_ids.toArray(), (rs, i) -> rs.getLong("student_id"));
            return studentIds;
        }
        catch (Exception e) {
            e.printStackTrace();
            return new ArrayList<Long>();
        }
    }

    public List<Long> findStudentIdsByGroupId(long group_id) {
        String SQL = "SELECT DISTINCT(student_id) FROM student_class WHERE class_id = ?";
        try {
            List studentIds = this.jdbcTemplate.query(SQL, (rs, i) -> rs.getLong("student_id"), new Object[]{group_id});
            return studentIds;
        }
        catch (Exception e) {
            e.printStackTrace();
            return new ArrayList<Long>();
        }
    }

    public void removeAllGroupsByStudentIds(List<Long> student_ids) {
        if (AppUtils.isNullOrEmpty(student_ids)) {
            return;
        }
        String inSql = String.join((CharSequence)",", Collections.nCopies(student_ids.size(), "?"));
        String SQL = "DELETE FROM student_class WHERE student_id IN(%S)";
        try {
            this.jdbcTemplate.update(String.format(SQL, inSql), student_ids.toArray());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void removeByGroupIds(List<Long> group_ids) {
        if (AppUtils.isNullOrEmpty(group_ids)) {
            return;
        }
        String inSql = String.join((CharSequence)",", Collections.nCopies(group_ids.size(), "?"));
        String SQL = "DELETE FROM student_class WHERE class_id IN(%S)";
        try {
            this.jdbcTemplate.update(String.format(SQL, inSql), group_ids.toArray());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public List<Long> addGroupByStudentId(long student_id, long group_id) {
        String INSERT_SQL = "INSERT INTO student_class (student_id, class_id) VALUES (?,?)";
        try {
            this.jdbcTemplate.update("INSERT INTO student_class (student_id, class_id) VALUES (?,?)", new Object[]{student_id, group_id});
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this.findByStudentId(student_id);
    }

    private List<Long> findByStudentId(long student_id) {
        String SQL = "SELECT DISTINCT(class_id) FROM student_class WHERE student_id = ?";
        try {
            List studentIds = this.jdbcTemplate.query(SQL, (rs, i) -> rs.getLong("class_id"), new Object[]{student_id});
            return studentIds;
        }
        catch (Exception e) {
            e.printStackTrace();
            return new ArrayList<Long>();
        }
    }
}

