/*
 * Decompiled with CFR 0.152.
 */
package com.infinite.focus.server.twilio.service;

import com.infinite.focus.server.twilio.config.TwilioSmsSender;
import com.infinite.focus.server.twilio.request.SmsRequest;
import com.infinite.focus.server.twilio.service.SmsService;
import com.infinite.focus.server.utils.AppUtils;
import com.twilio.exception.ApiException;
import com.twilio.type.PhoneNumber;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class SmsServiceImpl
implements SmsService {
    @Autowired
    TwilioSmsSender smsSender;
    @Value(value="${app.enablePhoneValidation:false}")
    private boolean enablePhoneValidation;

    public void sendSms(SmsRequest smsRequest) {
        this.smsSender.sendSms(smsRequest);
    }

    public boolean isValidPhone(String phoneNumber) {
        if (AppUtils.isNullOrEmpty((String)(phoneNumber = phoneNumber.replaceAll("[\\s()-]", "")))) {
            return true;
        }
        if (!this.enablePhoneValidation) {
            return true;
        }
        try {
            com.twilio.rest.lookups.v1.PhoneNumber.fetcher((String)String.valueOf(new PhoneNumber(phoneNumber))).fetch();
            return true;
        }
        catch (ApiException e) {
            e.printStackTrace();
            return false;
        }
    }
}

