/*
 * Decompiled with CFR 0.152.
 */
package com.infinite.focus.server.student.entity;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.infinite.focus.server.accesscode.entity.AccessCode;
import com.infinite.focus.server.account.entity.Account;
import com.infinite.focus.server.auth.model.Status;
import com.infinite.focus.server.avatar.entity.Avatar;
import com.infinite.focus.server.group.entity.Class;
import com.infinite.focus.server.instructor.entity.Instructor;
import com.infinite.focus.server.parent.entity.Parent;
import com.infinite.focus.server.school.entity.School;
import com.infinite.focus.server.standard.entity.Standard;
import com.infinite.focus.server.student.model.AppType;
import com.infinite.focus.server.utils.AppUtils;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.FetchType;
import jakarta.persistence.ForeignKey;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.JoinTable;
import jakarta.persistence.ManyToMany;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.OneToOne;
import jakarta.persistence.Table;
import jakarta.persistence.Transient;
import jakarta.persistence.UniqueConstraint;
import java.sql.Date;
import java.util.HashSet;
import java.util.Set;
import org.hibernate.annotations.NotFound;
import org.hibernate.annotations.NotFoundAction;

@Entity
@Table(uniqueConstraints={@UniqueConstraint(columnNames={"clever_id"})})
public class Student {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private long student_id;
    @Transient
    private long account_id;
    @Transient
    private long standard_id;
    @Transient
    private long instructor_id;
    private String first_name;
    private String last_name;
    private String gender;
    private String ethnicity;
    @Transient
    private long avatar_id;
    @JsonProperty(value="verified")
    private boolean is_verified = false;
    private boolean should_force_socio_emotional_assessment = false;
    private boolean should_auto_show_assessment = false;
    private boolean new_notificaitons = false;
    private boolean share_your_success = false;
    private boolean share_journal_with_instructor = false;
    private boolean share_journal_with_parents = false;
    @Transient
    public String username;
    @Transient
    public String username2;
    @Transient
    public String avatar_name;
    @Transient
    public String avatar_url;
    @Transient
    private Status status;
    public java.util.Date last_sync;
    @OneToOne(targetEntity=Standard.class, fetch=FetchType.LAZY)
    @JoinColumn(nullable=true, name="standard_id", foreignKey=@ForeignKey(name="none"))
    @JsonIgnoreProperties(value={"students"})
    private Standard standard;
    @OneToOne(targetEntity=Avatar.class, fetch=FetchType.LAZY)
    @NotFound(action=NotFoundAction.IGNORE)
    @JoinColumn(nullable=true, name="avatar_id", foreignKey=@ForeignKey(name="none"))
    @JsonIgnore
    private Avatar avatar;
    @OneToOne(targetEntity=Account.class, fetch=FetchType.EAGER)
    @NotFound(action=NotFoundAction.IGNORE)
    @JoinColumn(nullable=true, name="account_id", foreignKey=@ForeignKey(name="none"))
    @JsonIgnore
    private Account account;
    @OneToOne(targetEntity=Instructor.class, fetch=FetchType.LAZY)
    @JoinColumn(nullable=true, name="instructor_id", foreignKey=@ForeignKey(name="none"))
    @JsonIgnoreProperties(value={"classes", "standards"})
    private Instructor instructor;
    @Transient
    private long school_id;
    @OneToOne(targetEntity=School.class, fetch=FetchType.LAZY)
    @JoinColumn(nullable=true, name="school_id", foreignKey=@ForeignKey(name="none"))
    @JsonIgnore
    private School school;
    @OneToOne(fetch=FetchType.EAGER, mappedBy="student")
    @JsonIgnore
    private AccessCode accessCode;
    private String fcm_token;
    @Enumerated(value=EnumType.STRING)
    @Column(name="app_type", columnDefinition="enum('ANDROID','WEB')")
    private AppType appType;
    private Date date_of_birth;
    private String operating_system;
    private String browser;
    @Transient
    private long parent_id;
    @ManyToOne(targetEntity=Parent.class, fetch=FetchType.LAZY)
    @JoinColumn(nullable=true, name="parent_id", foreignKey=@ForeignKey(name="none"))
    @JsonIgnoreProperties(value={"students"})
    private Parent parent;
    @ManyToMany(targetEntity=Class.class, fetch=FetchType.LAZY)
    @JoinTable(name="student_class", joinColumns={@JoinColumn(name="student_id")}, inverseJoinColumns={@JoinColumn(name="class_id")})
    @JsonIgnoreProperties(value={"students", "instructor"})
    private Set<Class> classes = new HashSet();
    @Column(unique=true)
    private String clever_id;
    private boolean demo;
    private boolean archived;
    private boolean access_removed_by_parent = false;
    private String language = "en";
    private String registration_code;

    public java.util.Date getLast_sync() {
        return this.last_sync;
    }

    public void setLast_sync(java.util.Date last_sync) {
        this.last_sync = last_sync;
    }

    public long getStudent_id() {
        return this.student_id;
    }

    public void setStudent_id(long student_id) {
        this.student_id = student_id;
    }

    public long getAccount_id() {
        return this.account == null ? this.account_id : this.account.getAccount_id();
    }

    public void setAccount_id(long account_id) {
        this.account_id = account_id;
    }

    public Account getAccount() {
        return this.account;
    }

    public void setAccount(Account account) {
        this.account = account;
    }

    public long getStandard_id() {
        return this.standard == null ? this.standard_id : this.standard.getStandard_id();
    }

    public void setStandard_id(long standard_id) {
        this.standard_id = standard_id;
    }

    public Standard getStandard() {
        return this.standard;
    }

    public void setStandard(Standard standard) {
        this.standard = standard;
    }

    public AccessCode getAccessCode() {
        return this.accessCode;
    }

    public void setAccessCode(AccessCode accessCode) {
        this.accessCode = accessCode;
    }

    public Status getStatus() {
        return this.accessCode == null ? this.status : this.accessCode.getStatus();
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    public Instructor getInstructor() {
        return this.instructor;
    }

    public void setInstructor(Instructor instructor) {
        this.instructor = instructor;
    }

    public long getInstructor_id() {
        return this.instructor == null ? this.instructor_id : this.instructor.getInstructor_id();
    }

    public void setInstructor_id(long instructor_id) {
        this.instructor_id = instructor_id;
    }

    public String getFirst_name() {
        return this.first_name;
    }

    public void setFirst_name(String first_name) {
        this.first_name = first_name;
    }

    public String getLast_name() {
        return this.last_name;
    }

    public void setLast_name(String last_name) {
        this.last_name = last_name;
    }

    public long getAvatar_id() {
        return this.avatar == null ? this.avatar_id : this.avatar.getAvatar_id();
    }

    public void setAvatar_id(long avatar_id) {
        this.avatar_id = avatar_id;
    }

    public Avatar getAvatar() {
        return this.avatar;
    }

    public void setAvatar(Avatar avatar) {
        this.avatar = avatar;
    }

    public String getGender() {
        return this.gender;
    }

    public void setGender(String gender) {
        this.gender = gender;
    }

    public String getEthnicity() {
        return this.ethnicity;
    }

    public void setEthnicity(String ethnicity) {
        this.ethnicity = ethnicity;
    }

    public String getUsername() {
        return this.account == null ? this.username : this.account.getUsername();
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getUsername2() {
        return this.account == null ? this.username2 : this.account.getUsername2();
    }

    public void setUsername2(String username2) {
        this.username2 = username2;
    }

    public long getSchool_id() {
        return this.school == null ? this.school_id : this.school.getSchool_id();
    }

    public void setSchool_id(long school_id) {
        this.school_id = school_id;
    }

    public School getSchool() {
        return this.school;
    }

    public void setSchool(School school) {
        this.school = school;
    }

    public String getAvatar_name() {
        if (this.avatar != null) {
            return this.avatar.getAvatar_name();
        }
        return null;
    }

    public void setAvatar_name(String avatar_name) {
        this.avatar_name = avatar_name;
    }

    public String getAvatar_url() {
        if (this.avatar != null) {
            return this.avatar.getPreview_url();
        }
        return null;
    }

    public void setAvatar_url(String avatar_url) {
        this.avatar_url = avatar_url;
    }

    public boolean isVerified() {
        return this.is_verified;
    }

    public void setIsVerified(boolean is_verified) {
        this.is_verified = is_verified;
    }

    public String getFcm_token() {
        return this.fcm_token;
    }

    public void setFcm_token(String fcm_token) {
        this.fcm_token = fcm_token;
    }

    public boolean isShould_force_socio_emotional_assessment() {
        return this.should_force_socio_emotional_assessment;
    }

    public void setShould_force_socio_emotional_assessment(boolean should_force_socio_emotional_assessment) {
        this.should_force_socio_emotional_assessment = should_force_socio_emotional_assessment;
    }

    public boolean isShould_auto_show_assessment() {
        return this.should_auto_show_assessment;
    }

    public void setShould_auto_show_assessment(boolean should_auto_show_assessment) {
        this.should_auto_show_assessment = should_auto_show_assessment;
    }

    public boolean isNew_notificaitons() {
        return this.new_notificaitons;
    }

    public void setNew_notificaitons(boolean new_notificaitons) {
        this.new_notificaitons = new_notificaitons;
    }

    public boolean isShare_your_success() {
        return this.share_your_success;
    }

    public void setShare_your_success(boolean share_your_success) {
        this.share_your_success = share_your_success;
    }

    public boolean isShare_journal_with_instructor() {
        return this.share_journal_with_instructor;
    }

    public void setShare_journal_with_instructor(boolean share_journal_with_instructor) {
        this.share_journal_with_instructor = share_journal_with_instructor;
    }

    public boolean isShare_journal_with_parents() {
        return this.share_journal_with_parents;
    }

    public void setShare_journal_with_parents(boolean share_journal_with_parents) {
        this.share_journal_with_parents = share_journal_with_parents;
    }

    public AppType getAppType() {
        return this.appType;
    }

    public void setAppType(AppType appType) {
        this.appType = appType;
    }

    public Date getDate_of_birth() {
        return this.date_of_birth;
    }

    public void setDate_of_birth(Date date_of_birth) {
        this.date_of_birth = date_of_birth;
    }

    public String getOperating_system() {
        return this.operating_system;
    }

    public void setOperating_system(String operating_system) {
        this.operating_system = operating_system;
    }

    public String getBrowser() {
        return this.browser;
    }

    public void setBrowser(String browser) {
        this.browser = browser;
    }

    public long getParent_id() {
        return this.parent == null ? this.parent_id : this.parent.getParent_id();
    }

    public void setParent_id(long parent_id) {
        this.parent_id = parent_id;
    }

    public Parent getParent() {
        return this.parent;
    }

    public void setParent(Parent parent) {
        this.parent = parent;
    }

    public Set<Class> getClasses() {
        return this.classes;
    }

    public void setClasses(Set<Class> classes) {
        this.classes = classes;
    }

    public String getClever_id() {
        return this.clever_id;
    }

    public void setClever_id(String clever_id) {
        if (AppUtils.isNullOrEmpty((String)clever_id)) {
            clever_id = null;
        }
        this.clever_id = clever_id;
    }

    public boolean isDemo() {
        return this.demo;
    }

    public void setDemo(boolean demo) {
        this.demo = demo;
    }

    public boolean isArchived() {
        return this.archived;
    }

    public void setArchived(boolean archived) {
        this.archived = archived;
    }

    public boolean isAccess_removed_by_parent() {
        return this.access_removed_by_parent;
    }

    public void setAccess_removed_by_parent(boolean access_removed_by_parent) {
        this.access_removed_by_parent = access_removed_by_parent;
    }

    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public String getRegistration_code() {
        return this.registration_code;
    }

    public void setRegistration_code(String registration_code) {
        this.registration_code = registration_code;
    }
}

