/*
 * Decompiled with CFR 0.152.
 */
package com.infinite.focus.server.invoice.service;

import com.infinite.focus.server.account.entity.Account;
import com.infinite.focus.server.account.service.AccountService;
import com.infinite.focus.server.auth.model.Message;
import com.infinite.focus.server.configuration.service.ConfigurationService;
import com.infinite.focus.server.corporate.entity.Corporate;
import com.infinite.focus.server.corporate.service.CorporateService;
import com.infinite.focus.server.district.entity.District;
import com.infinite.focus.server.district.service.DistrictService;
import com.infinite.focus.server.email.service.EmailSenderService;
import com.infinite.focus.server.freetrial.model.OrganizationType;
import com.infinite.focus.server.invoice.dto.InvoiceItemDTO;
import com.infinite.focus.server.invoice.model.InvoiceStatus;
import com.infinite.focus.server.invoice.model.InvoiceType;
import com.infinite.focus.server.invoice.repository.InvoiceCoreRepository;
import com.infinite.focus.server.invoice.repository.InvoiceRepository;
import com.infinite.focus.server.invoice.request.GetInvoicesRequest;
import com.infinite.focus.server.invoice.request.MarkAsPaidRequest;
import com.infinite.focus.server.invoice.service.InvoiceService;
import com.infinite.focus.server.language.Language;
import com.infinite.focus.server.message.service.MessageService;
import com.infinite.focus.server.school.entity.School;
import com.infinite.focus.server.school.service.SchoolService;
import com.infinite.focus.server.template.service.TemplateService;
import com.infinite.focus.server.utils.AppUtils;
import com.stripe.Stripe;
import com.stripe.exception.StripeException;
import com.stripe.model.Customer;
import com.stripe.model.Invoice;
import com.stripe.model.InvoiceItem;
import com.stripe.model.StripeObject;
import com.stripe.param.InvoicePayParams;
import jakarta.mail.MessagingException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.util.HashMap;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.stereotype.Service;
import org.springframework.web.server.ResponseStatusException;

@Service
public class InvoiceServiceImpl
implements InvoiceService {
    @Autowired
    ConfigurationService configurationService;
    @Autowired
    InvoiceCoreRepository invoiceCoreRepository;
    @Autowired
    EmailSenderService emailSenderService;
    @Autowired
    TemplateService templateService;
    @Autowired
    AccountService accountService;
    @Autowired
    DistrictService districtService;
    @Autowired
    SchoolService schoolService;
    @Autowired
    InvoiceRepository invoiceRepository;
    @Autowired
    MessageService messageService;
    @Autowired
    CorporateService corporateService;

    public Page<InvoiceItemDTO> getInvoices(GetInvoicesRequest request) {
        return this.invoiceCoreRepository.getInvoices(request);
    }

    public com.infinite.focus.server.invoice.entity.Invoice createInvoice(long numberOfYouth, double amount, long organization_id, OrganizationType organization_type, String email_to_send_invoice, InvoiceType invoiceType) {
        if (amount <= 0.0) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.CONFLICT, this.messageService.getMessage("unfortunately.we.can.not.generate.an.invoice.with.zero.amount.please.modify.the.amount.field.and.generate.an.invoice"));
        }
        Stripe.apiKey = this.configurationService.getStripeApiKey();
        Account account = null;
        District district = null;
        School school = null;
        Corporate corporate = null;
        String name_of_organization = null;
        if (organization_type.equals((Object)OrganizationType.LARGE_ORGANIZATION)) {
            district = this.districtService.getDistrictById(organization_id);
            if (district != null) {
                account = this.accountService.getAccountById(district.getAccount_id());
                name_of_organization = district.getDistrict_name();
            }
        } else if (organization_type.equals((Object)OrganizationType.ORGANIZATION)) {
            school = this.schoolService.getSchoolById(organization_id);
            if (school != null) {
                account = this.accountService.getAccountById(school.getAccount_id());
                name_of_organization = school.getSchool_name();
            }
        } else if (organization_type.equals((Object)OrganizationType.CORPORATE) && (corporate = this.corporateService.getCorporateById(organization_id)) != null) {
            account = this.accountService.getAccountById(corporate.getAccount_id());
            name_of_organization = corporate.getCorporate_name();
        }
        if (district == null && school == null && corporate == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, this.messageService.getMessage("the.organization.corporate.is.not.found"));
        }
        if (account == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, this.messageService.getMessage("the.account.is.not.found"));
        }
        Customer customer = this.stripeCreateCustomer(organization_id, email_to_send_invoice, organization_type, name_of_organization, invoiceType);
        if (customer == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, this.messageService.getMessage("stripe.customer.is.not.created"));
        }
        String customerId = customer.getId();
        System.out.println("customerId : " + customerId);
        Invoice stripeInvoice = this.stripeCreateInvoice(customerId, invoiceType);
        if (stripeInvoice == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, this.messageService.getMessage("stripe.invoice.is.not.created"));
        }
        String stripeInvoiceId = stripeInvoice.getId();
        System.out.println("stripeInvoiceId : " + stripeInvoiceId);
        InvoiceItem invoiceItem = this.stripeCreateInvoiceItem(customerId, stripeInvoiceId, numberOfYouth, amount);
        if (invoiceItem == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, this.messageService.getMessage("stripe.invoice.item.is.not.created"));
        }
        String invoiceItemId = invoiceItem.getId();
        System.out.println("invoiceItemId : " + invoiceItemId);
        Invoice updatedInvoice = this.stripeFinalizeInvoice(stripeInvoiceId);
        if (updatedInvoice == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, this.messageService.getMessage("stripe.finalize.invoice.is.failed"));
        }
        String updatedInvoiceId = updatedInvoice.getId();
        System.out.println("updatedInvoiceId : " + updatedInvoiceId);
        com.infinite.focus.server.invoice.entity.Invoice invoice = new com.infinite.focus.server.invoice.entity.Invoice();
        invoice.setAmount(amount);
        invoice.setName_of_organization(name_of_organization);
        invoice.setOrganization_id(organization_id);
        invoice.setOrganization_type(organization_type);
        invoice.setStripe_customer_email(email_to_send_invoice);
        invoice.setStripe_customer_id(customerId);
        invoice.setStripe_invoice_id(updatedInvoiceId);
        invoice.setNumber_of_youth(numberOfYouth);
        if (!updatedInvoice.getPaid().booleanValue() && updatedInvoice.getStatus().equals("open")) {
            invoice.setInvoice_status(InvoiceStatus.PENDING);
        } else if (updatedInvoice.getPaid().booleanValue() && updatedInvoice.getStatus().equals("paid")) {
            invoice.setInvoice_status(InvoiceStatus.PAID);
        }
        if (invoiceType.equals((Object)InvoiceType.NEW) || district != null && AppUtils.isNullOrEmpty((String)district.getLicense_key()) || school != null && AppUtils.isNullOrEmpty((String)school.getLicense_key()) || corporate != null && AppUtils.isNullOrEmpty((String)corporate.getLicense_key())) {
            String license_key = this.getUniqueLicenseKey();
            invoice.setLicense_key(license_key);
        }
        invoice.setInvoice_type(invoiceType);
        return (com.infinite.focus.server.invoice.entity.Invoice)this.invoiceRepository.save((Object)invoice);
    }

    private Invoice stripeFinalizeInvoice(String stripeInvoiceId) {
        Stripe.apiKey = this.configurationService.getStripeApiKey();
        try {
            Invoice invoice = Invoice.retrieve((String)stripeInvoiceId);
            HashMap<String, Boolean> params = new HashMap<String, Boolean>();
            params.put("auto_advance", true);
            Invoice updatedInvoice = invoice.finalizeInvoice(params);
            System.out.println(updatedInvoice);
            return updatedInvoice;
        }
        catch (StripeException e) {
            e.printStackTrace();
            return null;
        }
    }

    private InvoiceItem stripeCreateInvoiceItem(String customerId, String stripeInvoiceId, long numberOfYouth, double amount) {
        Stripe.apiKey = this.configurationService.getStripeApiKey();
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("customer", customerId);
        params.put("invoice", stripeInvoiceId);
        params.put("currency", this.configurationService.getConfiguration().getStripe_invoice_currency());
        params.put("unit_amount_decimal", amount * 100.0);
        HashMap<String, Long> mataData = new HashMap<String, Long>();
        mataData.put("number_of_youth", numberOfYouth);
        params.put("metadata", mataData);
        try {
            InvoiceItem invoiceItem = InvoiceItem.create(params);
            System.out.println(invoiceItem);
            return invoiceItem;
        }
        catch (StripeException e) {
            e.printStackTrace();
            return null;
        }
    }

    private Invoice stripeCreateInvoice(String customerId, InvoiceType invoiceType) {
        Stripe.apiKey = this.configurationService.getStripeApiKey();
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("customer", customerId);
        params.put("pending_invoice_items_behavior", "exclude");
        params.put("collection_method", "send_invoice");
        params.put("days_until_due", 7);
        HashMap<String, String> mataData = new HashMap<String, String>();
        mataData.put("invoice_type", invoiceType.toString());
        params.put("metadata", mataData);
        try {
            Invoice invoice = Invoice.create(params);
            System.out.println(invoice);
            return invoice;
        }
        catch (StripeException e) {
            e.printStackTrace();
            return null;
        }
    }

    private Customer stripeCreateCustomer(long organization_id, String email, OrganizationType organization_type, String name_of_organization, InvoiceType invoiceType) {
        Stripe.apiKey = this.configurationService.getStripeApiKey();
        HashMap<String, Object> customerMap = new HashMap<String, Object>();
        customerMap.put("description", "Invoicing Customer");
        customerMap.put("email", email);
        HashMap<String, Object> mataData = new HashMap<String, Object>();
        if (invoiceType.equals((Object)InvoiceType.NEW)) {
            customerMap.put("name", name_of_organization);
            mataData.put("name", name_of_organization);
            mataData.put("organization_id", organization_id);
        } else {
            Corporate corporate;
            if (organization_type.equals((Object)OrganizationType.LARGE_ORGANIZATION)) {
                District district = this.districtService.getDistrictById(organization_id);
                if (district != null) {
                    customerMap.put("name", district.getDistrict_name());
                    mataData.put("name", district.getDistrict_name());
                }
            } else if (organization_type.equals((Object)OrganizationType.ORGANIZATION)) {
                School school = this.schoolService.getSchoolById(organization_id);
                if (school != null) {
                    customerMap.put("name", school.getSchool_name());
                    mataData.put("name", school.getSchool_name());
                }
            } else if (organization_type.equals((Object)OrganizationType.CORPORATE) && (corporate = this.corporateService.getCorporateById(organization_id)) != null) {
                customerMap.put("name", corporate.getCorporate_name());
                mataData.put("name", corporate.getCorporate_name());
            }
            mataData.put("organization_id", organization_id);
        }
        mataData.put("description", organization_type.toString());
        customerMap.put("metadata", mataData);
        try {
            Customer customer = Customer.create(customerMap);
            System.out.println(customer);
            return customer;
        }
        catch (StripeException e) {
            e.printStackTrace();
            return null;
        }
    }

    public com.infinite.focus.server.invoice.entity.Invoice markAsPaid(MarkAsPaidRequest request) {
        com.infinite.focus.server.invoice.entity.Invoice invoice = this.invoiceRepository.findByInvoiceId(Long.valueOf(request.getInvoice_id()));
        if (invoice == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, this.messageService.getMessage("invoice.is.not.found"));
        }
        Stripe.apiKey = this.configurationService.getStripeApiKey();
        try {
            InvoicePayParams params;
            Invoice updatedInvoice;
            Invoice stripeInvoice = Invoice.retrieve((String)invoice.getStripe_invoice_id());
            if (stripeInvoice == null || stripeInvoice.getStatus().equals("void")) {
                invoice.setInvoice_status(InvoiceStatus.VOID);
                invoice = (com.infinite.focus.server.invoice.entity.Invoice)this.invoiceRepository.save((Object)invoice);
                return invoice;
            }
            if (this.updateInvoiceIfAlreadyPaid(stripeInvoice) != null) {
                invoice = this.invoiceRepository.findByInvoiceId(Long.valueOf(request.getInvoice_id()));
            }
            if (invoice.getInvoice_status().equals((Object)InvoiceStatus.PENDING) && (updatedInvoice = stripeInvoice.pay(params = InvoicePayParams.builder().setPaidOutOfBand(Boolean.valueOf(true)).build())).getPaid().booleanValue() && updatedInvoice.getStatus().equals("paid")) {
                invoice.setInvoice_status(InvoiceStatus.PAID);
                this.invoiceRepository.save((Object)invoice);
            }
        }
        catch (StripeException e) {
            e.printStackTrace();
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.CONFLICT, e.getLocalizedMessage());
        }
        return invoice;
    }

    public com.infinite.focus.server.invoice.entity.Invoice invoicePaid(StripeObject stripeObject) {
        try {
            Invoice stripeInvoice = (Invoice)stripeObject;
            return this.updateInvoiceIfAlreadyPaid(stripeInvoice);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.CONFLICT, e.getLocalizedMessage());
        }
    }

    private com.infinite.focus.server.invoice.entity.Invoice updateInvoiceIfAlreadyPaid(Invoice stripeInvoice) {
        com.infinite.focus.server.invoice.entity.Invoice invoice = null;
        try {
            if (stripeInvoice.getPaid().booleanValue() && stripeInvoice.getStatus().equals("paid")) {
                invoice = this.invoiceRepository.findByStripeInvoiceId(stripeInvoice.getId());
                if (invoice == null) {
                    throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, this.messageService.getMessage("invoice.is.not.found.in.db"));
                }
                invoice.setInvoice_status(InvoiceStatus.PAID);
                this.invoiceRepository.save((Object)invoice);
                if (invoice.getInvoice_type().equals((Object)InvoiceType.NEW)) {
                    this.sendLicenseKeyEmail(invoice);
                } else if (invoice.getOrganization_type().equals((Object)OrganizationType.LARGE_ORGANIZATION)) {
                    this.districtService.updateSubscription(invoice);
                } else if (invoice.getOrganization_type().equals((Object)OrganizationType.ORGANIZATION)) {
                    this.schoolService.updateSubscription(invoice);
                } else if (invoice.getOrganization_type().equals((Object)OrganizationType.CORPORATE)) {
                    this.corporateService.updateSubscription(invoice);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.CONFLICT, e.getLocalizedMessage());
        }
        return invoice;
    }

    private File getLicenseKeyInTextFile(String license_key) {
        String filename = "licence-key.txt";
        File licenceKeyFile = new File(filename);
        String message = license_key;
        try {
            FileWriter writer = new FileWriter(licenceKeyFile);
            writer.append(message);
            writer.flush();
            writer.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.getLocalizedMessage();
        }
        return licenceKeyFile;
    }

    public void sendLicenseKeyEmail(com.infinite.focus.server.invoice.entity.Invoice invoice) {
        Corporate corporate;
        String language = null;
        if (invoice.getOrganization_type().equals((Object)OrganizationType.LARGE_ORGANIZATION)) {
            District district = this.districtService.getDistrictById(invoice.getOrganization_id());
            if (district != null) {
                language = district.getLanguage();
            }
        } else if (invoice.getOrganization_type().equals((Object)OrganizationType.ORGANIZATION)) {
            School school = this.schoolService.getSchoolById(invoice.getOrganization_id());
            if (school != null) {
                language = school.getLanguage();
            }
        } else if (invoice.getOrganization_type().equals((Object)OrganizationType.CORPORATE) && (corporate = this.corporateService.getCorporateById(invoice.getOrganization_id())) != null) {
            language = corporate.getLanguage();
        }
        try {
            this.emailSenderService.sendHtmlMail(invoice.getStripe_customer_email(), (String)(Language.isSpanish((String)language) ? "Bienvenido a Clymb, " : "Welcome to Clymb, " + this.getNameOfOrganizationByInvoice(invoice) + "!"), this.templateService.getSendLicenseKeyEmail(invoice.getLicense_key(), this.configurationService.getConfiguration().getLicense_key_email_get_started(), this.configurationService.getConfiguration().getLicense_key_email_heres(), language));
        }
        catch (MessagingException e) {
            e.printStackTrace();
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.CONFLICT, e.getLocalizedMessage());
        }
    }

    public String getNameOfOrganizationByInvoice(com.infinite.focus.server.invoice.entity.Invoice invoice) {
        String nameOfOrganization = null;
        if (invoice.getInvoice_type().equals((Object)InvoiceType.NEW)) {
            nameOfOrganization = invoice.getName_of_organization();
        } else if (invoice.getOrganization_type().equals((Object)OrganizationType.LARGE_ORGANIZATION)) {
            District district = this.districtService.getDistrictById(invoice.getOrganization_id());
            if (district == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, this.messageService.getMessage("the.large.organization.is.not.found"));
            }
            nameOfOrganization = district.getDistrict_name();
        } else if (invoice.getOrganization_type().equals((Object)OrganizationType.ORGANIZATION)) {
            School school = this.schoolService.getSchoolById(invoice.getOrganization_id());
            if (school == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, this.messageService.getMessage("the.organization.is.not.found"));
            }
            nameOfOrganization = school.getSchool_name();
        } else if (invoice.getOrganization_type().equals((Object)OrganizationType.CORPORATE)) {
            Corporate corporate = this.corporateService.getCorporateById(invoice.getOrganization_id());
            if (corporate == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, this.messageService.getMessage("the.corporate.is.not.found"));
            }
            nameOfOrganization = corporate.getCorporate_name();
        }
        return nameOfOrganization;
    }

    public com.infinite.focus.server.invoice.entity.Invoice getInvoiceByLicenseKey(String license_key) {
        return this.invoiceRepository.findByLicenseKey(license_key);
    }

    public com.infinite.focus.server.invoice.entity.Invoice getInvoiceByInvoiceId(long invoice_id) {
        return this.invoiceRepository.findByInvoiceId(Long.valueOf(invoice_id));
    }

    public com.infinite.focus.server.invoice.entity.Invoice createInvoiceForIncreasingYouthCapacity(long numberOfYouth, double amount, long organization_id, OrganizationType organization_type, String email_to_send_invoice) {
        return this.createInvoice(numberOfYouth, amount, organization_id, organization_type, email_to_send_invoice, InvoiceType.INCREASE_NO_OF_YOUTH);
    }

    public com.infinite.focus.server.invoice.entity.Invoice createInvoiceForSubscriptionRenewal(double amount, long organization_id, OrganizationType organization_type, String email_to_send_invoice) {
        return this.createInvoice(0L, amount, organization_id, organization_type, email_to_send_invoice, InvoiceType.RENEW_SUBSCRIPTION);
    }

    public com.infinite.focus.server.invoice.entity.Invoice createInvoiceForNewOrganization(long number_of_youth, double amount, String name_of_organization, OrganizationType organization_type, String email_to_send_invoice, InvoiceType invoiceType) {
        if (amount <= 0.0) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.CONFLICT, this.messageService.getMessage("unfortunately.we.can.not.generate.an.invoice.with.zero.amount.please.modify.the.amount.field.and.generate.an.invoice"));
        }
        Stripe.apiKey = this.configurationService.getStripeApiKey();
        Customer customer = this.stripeCreateCustomer(0L, email_to_send_invoice, organization_type, name_of_organization, invoiceType);
        if (customer == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, this.messageService.getMessage("stripe.customer.is.not.created"));
        }
        String customerId = customer.getId();
        System.out.println("customerId : " + customerId);
        Invoice stripeInvoice = this.stripeCreateInvoice(customerId, invoiceType);
        if (stripeInvoice == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, this.messageService.getMessage("stripe.invoice.is.not.created"));
        }
        String stripeInvoiceId = stripeInvoice.getId();
        System.out.println("stripeInvoiceId : " + stripeInvoiceId);
        InvoiceItem invoiceItem = this.stripeCreateInvoiceItem(customerId, stripeInvoiceId, number_of_youth, amount);
        if (invoiceItem == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, this.messageService.getMessage("stripe.invoice.item.is.not.created"));
        }
        String invoiceItemId = invoiceItem.getId();
        System.out.println("invoiceItemId : " + invoiceItemId);
        Invoice updatedInvoice = this.stripeFinalizeInvoice(stripeInvoiceId);
        if (updatedInvoice == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, this.messageService.getMessage("stripe.finalize.invoice.is.failed"));
        }
        String updatedInvoiceId = updatedInvoice.getId();
        System.out.println("updatedInvoiceId : " + updatedInvoiceId);
        com.infinite.focus.server.invoice.entity.Invoice invoice = new com.infinite.focus.server.invoice.entity.Invoice();
        invoice.setAmount(amount);
        invoice.setOrganization_id(0L);
        invoice.setName_of_organization(name_of_organization);
        invoice.setOrganization_type(organization_type);
        invoice.setStripe_customer_email(email_to_send_invoice);
        invoice.setStripe_customer_id(customerId);
        invoice.setStripe_invoice_id(updatedInvoiceId);
        invoice.setNumber_of_youth(number_of_youth);
        if (!updatedInvoice.getPaid().booleanValue() && updatedInvoice.getStatus().equals("open")) {
            invoice.setInvoice_status(InvoiceStatus.PENDING);
        } else if (updatedInvoice.getPaid().booleanValue() && updatedInvoice.getStatus().equals("paid")) {
            invoice.setInvoice_status(InvoiceStatus.PAID);
        }
        if (invoiceType.equals((Object)InvoiceType.NEW) || invoiceType.equals((Object)InvoiceType.EXISTING)) {
            String license_key = this.getUniqueLicenseKey();
            invoice.setLicense_key(license_key);
        }
        invoice.setInvoice_type(invoiceType);
        return (com.infinite.focus.server.invoice.entity.Invoice)this.invoiceRepository.save((Object)invoice);
    }

    public com.infinite.focus.server.invoice.entity.Invoice updateOrganizationIdByInvoiceId(long invoice_id, long organization_id) {
        com.infinite.focus.server.invoice.entity.Invoice invoice = this.getInvoiceByInvoiceId(invoice_id);
        invoice.setOrganization_id(organization_id);
        return (com.infinite.focus.server.invoice.entity.Invoice)this.invoiceRepository.save((Object)invoice);
    }

    public Message resendInvoice(long invoice_id) {
        Message message = new Message();
        com.infinite.focus.server.invoice.entity.Invoice invoice = this.getInvoiceByInvoiceId(invoice_id);
        Stripe.apiKey = this.configurationService.getStripeApiKey();
        try {
            Invoice invoiceStripe = Invoice.retrieve((String)invoice.getStripe_invoice_id());
            Invoice updatedInvoice = invoiceStripe.sendInvoice();
            message.setMessage(this.messageService.getMessage().getInvoice_resend_success().replace("<email_address>", updatedInvoice.getCustomerEmail()));
        }
        catch (StripeException e) {
            e.printStackTrace();
            message.setMessage(this.messageService.getMessage().getInvoice_resend_failed());
        }
        return message;
    }

    public String getUniqueLicenseKey() {
        String license_key = AppUtils.generateRandomCharsLicenceKey((String)"ABCDEFGHIJKLMNOPQRSTUVWXYZ1234567890", (int)16);
        com.infinite.focus.server.invoice.entity.Invoice invoice = this.invoiceRepository.findByLicenseKey(license_key);
        if (invoice != null) {
            license_key = this.getUniqueLicenseKey();
        }
        return license_key;
    }

    public Message deleteInvoice(long invoice_id) {
        Message message = new Message();
        com.infinite.focus.server.invoice.entity.Invoice invoice = this.getInvoiceByInvoiceId(invoice_id);
        if (invoice == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, this.messageService.getMessage("invoice.is.not.found"));
        }
        Stripe.apiKey = this.configurationService.getStripeApiKey();
        try {
            Invoice updatedInvoice;
            Invoice invoiceStripe = Invoice.retrieve((String)invoice.getStripe_invoice_id());
            if (invoiceStripe == null) {
                invoice.setInvoice_status(InvoiceStatus.VOID);
                this.invoiceRepository.save((Object)invoice);
                message.setMessage(this.messageService.getMessage().getInvoice_deleted());
                return message;
            }
            if (invoiceStripe.getPaid().booleanValue() && invoiceStripe.getStatus().equals("paid")) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.CONFLICT, this.messageService.getMessage("paid.invoice.can.not.be.delete"));
            }
            if (invoiceStripe.getStatus().equals("void")) {
                invoice.setInvoice_status(InvoiceStatus.VOID);
                this.invoiceRepository.save((Object)invoice);
                message.setMessage(this.messageService.getMessage().getInvoice_deleted());
                return message;
            }
            if (invoiceStripe.getStatus().equals("open")) {
                Invoice updatedInvoice2 = invoiceStripe.voidInvoice();
                if (updatedInvoice2.getStatus().equals("void")) {
                    invoice.setInvoice_status(InvoiceStatus.VOID);
                    this.invoiceRepository.save((Object)invoice);
                    message.setMessage(this.messageService.getMessage().getInvoice_deleted());
                    return message;
                }
            } else if (invoiceStripe.getStatus().equals("draft") && (updatedInvoice = invoiceStripe.delete()).getDeleted().booleanValue()) {
                invoice.setInvoice_status(InvoiceStatus.VOID);
                this.invoiceRepository.save((Object)invoice);
                message.setMessage(this.messageService.getMessage().getInvoice_deleted());
                return message;
            }
        }
        catch (StripeException e) {
            e.printStackTrace();
        }
        message.setMessage(this.messageService.getMessage("unable.to.access.delete.invoice.right.now.please.try.after.some.time"));
        return message;
    }

    public String getInvoicePdfLink(com.infinite.focus.server.invoice.entity.Invoice invoice) {
        Stripe.apiKey = this.configurationService.getStripeApiKey();
        try {
            Invoice invoiceStripe = Invoice.retrieve((String)invoice.getStripe_invoice_id());
            if (invoiceStripe == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, this.messageService.getMessage("invoice.is.not.found.on.stripe"));
            }
            return invoiceStripe.getInvoicePdf();
        }
        catch (StripeException e) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.CONFLICT, e.getLocalizedMessage());
        }
    }
}

