/*
 * Decompiled with CFR 0.152.
 */
package com.infinite.focus.server.shortenurl.service;

import com.google.common.hash.Hashing;
import com.infinite.focus.server.shortenurl.entity.ShortenUrl;
import com.infinite.focus.server.shortenurl.repository.ShortenUrlRepository;
import com.infinite.focus.server.shortenurl.request.ShortenUrlRequest;
import com.infinite.focus.server.shortenurl.service.ShortenUrlService;
import java.nio.charset.StandardCharsets;
import java.time.LocalDateTime;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ShortenUrlServiceImpl
implements ShortenUrlService {
    private static final Logger logger = LoggerFactory.getLogger(ShortenUrlServiceImpl.class);
    @Autowired
    private ShortenUrlRepository shortenUrlRepository;

    public ShortenUrl generateShortLink(ShortenUrlRequest shortenUrlRequest) {
        if (StringUtils.isNotEmpty((CharSequence)shortenUrlRequest.getUrl())) {
            String encodedUrl = this.encodeUrl(shortenUrlRequest.getUrl());
            ShortenUrl urlToPersist = new ShortenUrl();
            urlToPersist.setCreatedAt(new Date());
            urlToPersist.setUpdatedAt(new Date());
            urlToPersist.setOriginal_url(shortenUrlRequest.getUrl());
            urlToPersist.setShort_link(encodedUrl);
            urlToPersist.setStudent_profile_otp_id(shortenUrlRequest.getStudent_profile_otp_id());
            ShortenUrl urlToRet = this.persistShortLink(urlToPersist);
            if (urlToRet != null) {
                return urlToRet;
            }
            return null;
        }
        return null;
    }

    private String encodeUrl(String url) {
        String encodedUrl = "";
        LocalDateTime time = LocalDateTime.now();
        encodedUrl = Hashing.murmur3_32().hashString((CharSequence)url.concat(time.toString()), StandardCharsets.UTF_8).toString();
        return encodedUrl;
    }

    public ShortenUrl persistShortLink(ShortenUrl shortenUrl) {
        ShortenUrl urlToRet = (ShortenUrl)this.shortenUrlRepository.save((Object)shortenUrl);
        return urlToRet;
    }

    public ShortenUrl getEncodedUrl(String url) {
        ShortenUrl urlToRet = this.shortenUrlRepository.findByShortLink(url);
        return urlToRet;
    }

    public void deleteShortLink(ShortenUrl shortenUrl) {
        this.shortenUrlRepository.delete((Object)shortenUrl);
    }

    public List<ShortenUrl> getByStudentProfileOtpId(long student_profile_otp_id) {
        List shortenUrls = this.shortenUrlRepository.findByStudentProfileOtpId(student_profile_otp_id);
        return shortenUrls;
    }

    public void deleteByStudentProfileOtpId(long student_profile_otp_id) {
        List shortenUrls = this.shortenUrlRepository.findByStudentProfileOtpId(student_profile_otp_id);
        this.shortenUrlRepository.deleteAll((Iterable)shortenUrls);
    }
}

