/*
 * Decompiled with CFR 0.152.
 */
package com.infinite.focus.server.pvstate.repository;

import com.infinite.focus.server.pvstate.dto.PVStateDTO;
import com.infinite.focus.server.pvstate.model.PVState;
import com.infinite.focus.server.pvstate.repository.PVStateRepository;
import com.infinite.focus.server.utils.AppUtils;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Repository;

@Repository
public class PVStateRepositoryImpl
implements PVStateRepository {
    private final JdbcTemplate jdbcTemplate;

    public PVStateRepositoryImpl(JdbcTemplate jdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
    }

    private static PVStateDTO mapRow(ResultSet rs, int i) throws SQLException {
        return PVStateDTO.builder().pv_state_id(rs.getLong("pv_state_id")).pv_state(PVState.valueOfOrDefault((String)rs.getString("pv_state"))).score(rs.getDouble("score")).build();
    }

    public List<PVStateDTO> findAllOrderByPVStateId() {
        String SQL = "SELECT * FROM pv_state p ORDER BY p.pv_state_id ASC";
        List pvStateDTOS = this.jdbcTemplate.query(SQL, PVStateRepositoryImpl::mapRow);
        return pvStateDTOS;
    }

    public List<PVStateDTO> findByPVStates(List<PVState> pv_states) {
        if (AppUtils.isNullOrEmpty(pv_states)) {
            return null;
        }
        String inSql = String.join((CharSequence)",", Collections.nCopies(pv_states.size(), "?"));
        String SQL = "SELECT * FROM pv_state p WHERE p.pv_state IN(%s) ";
        List args = pv_states.stream().map(PVState::toString).collect(Collectors.toList());
        try {
            List pvStateDTO = this.jdbcTemplate.query(String.format(SQL, inSql), args.toArray(), PVStateRepositoryImpl::mapRow);
            return pvStateDTO;
        }
        catch (Exception e) {
            e.printStackTrace();
            return new ArrayList<PVStateDTO>();
        }
    }

    public PVStateDTO findByScore(double score) {
        String SQL = "SELECT * FROM pv_state p WHERE p.score = ROUND(?) ";
        try {
            PVStateDTO pvStateDTO = (PVStateDTO)this.jdbcTemplate.queryForObject(SQL, PVStateRepositoryImpl::mapRow, new Object[]{score});
            return pvStateDTO;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

