/*
 * Decompiled with CFR 0.152.
 */
package com.infinite.focus.server.auth.controller;

import com.infinite.focus.server.account.entity.Account;
import com.infinite.focus.server.account.model.AccountType;
import com.infinite.focus.server.account.repository.AccountRepository;
import com.infinite.focus.server.admin.entity.Admin;
import com.infinite.focus.server.auth.request.LoginRequest;
import com.infinite.focus.server.auth.response.ValidationResponse;
import com.infinite.focus.server.auth.service.AuthService;
import com.infinite.focus.server.auth.service.ValidationService;
import com.infinite.focus.server.clever.service.data.CleverDataService;
import com.infinite.focus.server.converter.EncryptDecryptHelper;
import com.infinite.focus.server.corporate.entity.Corporate;
import com.infinite.focus.server.district.entity.District;
import com.infinite.focus.server.instructor.entity.Instructor;
import com.infinite.focus.server.message.service.MessageService;
import com.infinite.focus.server.parent.entity.Parent;
import com.infinite.focus.server.school.entity.School;
import com.infinite.focus.server.security.helper.JwtHelper;
import com.infinite.focus.server.student.entity.Student;
import com.infinite.focus.server.utils.AppUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.server.ResponseStatusException;

@CrossOrigin(origins={"http://localhost:8383"})
@RestController
public class AuthController {
    private final AuthenticationManager authenticationManager;
    private final JwtHelper jwtHelper;
    private final AuthService authService;
    private final ValidationService validationService;
    private final AccountRepository accountRepository;
    private final MessageService messageService;
    private final CleverDataService cleverDataService;

    public AuthController(AuthenticationManager authenticationManager, JwtHelper jwtHelper, AuthService authService, ValidationService validationService, AccountRepository accountRepository, MessageService messageService, CleverDataService cleverDataService) {
        this.authenticationManager = authenticationManager;
        this.jwtHelper = jwtHelper;
        this.authService = authService;
        this.validationService = validationService;
        this.accountRepository = accountRepository;
        this.messageService = messageService;
        this.cleverDataService = cleverDataService;
    }

    @PostMapping(value={"/login"})
    public ResponseEntity<Void> login(@RequestBody LoginRequest loginRequest) {
        Authentication authentication = this.authenticationManager.authenticate((Authentication)new UsernamePasswordAuthenticationToken((Object)loginRequest.getUsername(), (Object)loginRequest.getPassword()));
        if (authentication.isAuthenticated()) {
            Account account;
            String token = this.jwtHelper.generateToken(loginRequest.getUsername());
            System.out.println("token is:-" + token);
            Admin admin = this.authService.getAdmin(token);
            Corporate corporate = this.authService.getCorporateByToken(token);
            Parent parent = this.authService.getParentByToken(token);
            Student student = this.authService.getStudentByToken(token);
            Instructor instructor = this.authService.getInstructorByToken(token);
            List schools = this.authService.getSchoolByToken(token);
            District district = this.authService.getDistrictByToken(token);
            ArrayList<String> accountTypes = new ArrayList<String>();
            ValidationResponse validationResponse = null;
            if (admin != null) {
                accountTypes.add(AccountType.ADMIN.toString());
            }
            if (corporate != null) {
                validationResponse = this.validationService.isValidCorporate(corporate.getCorporate_id());
                account = this.accountRepository.findByAccountId(corporate.getAccount_id());
                if (corporate.getOrganizationAdmin() != null) {
                    account = this.accountRepository.findByAccountId(corporate.getOrganizationAdmin().getAccount_id());
                    token = EncryptDecryptHelper.base64Encode((String)EncryptDecryptHelper.encrypt((String)(account.getAccount_id() + " " + corporate.getOrganizationAdmin().getOrganization_admin_id() + " " + account.getUsername())));
                } else {
                    token = EncryptDecryptHelper.base64Encode((String)EncryptDecryptHelper.encrypt((String)(account.getAccount_id() + " " + corporate.getCorporate_id() + " " + account.getUsername())));
                }
                accountTypes.add(AccountType.CORPORATE.toString());
            }
            if (parent != null) {
                validationResponse = this.validationService.isValidParent(parent.getParent_id());
                account = this.accountRepository.findByAccountId(parent.getAccount_id());
                if (parent.getOrganizationAdmin() != null) {
                    account = this.accountRepository.findByAccountId(parent.getOrganizationAdmin().getAccount_id());
                    token = EncryptDecryptHelper.base64Encode((String)EncryptDecryptHelper.encrypt((String)(account.getAccount_id() + " " + parent.getOrganizationAdmin().getOrganization_admin_id() + " " + account.getUsername())));
                } else {
                    token = EncryptDecryptHelper.base64Encode((String)EncryptDecryptHelper.encrypt((String)(account.getAccount_id() + " " + parent.getParent_id() + " " + account.getUsername())));
                }
                accountTypes.add(AccountType.PARENT.toString());
            }
            if (student != null) {
                if (!(AppUtils.isNullOrEmpty((String)student.getClever_id()) || (student = this.cleverDataService.syncStudent(student)) != null && student.getSchool() != null)) {
                    throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, this.messageService.getMessage("unable.to.access.clymb.right.now.please.try.after.some.time"));
                }
                validationResponse = this.validationService.isValidStudent(student.getStudent_id());
                if (validationResponse.isValid()) {
                    ValidationResponse validationResponse1 = this.validationService.isOverToNoOfYouthLimit(student);
                    if (!validationResponse1.isValid()) {
                        validationResponse.setValid(validationResponse1.isValid());
                        validationResponse.setMessage(validationResponse1.getMessage());
                    } else {
                        validationResponse.setFromCorporate(validationResponse1.isFromCorporate());
                        validationResponse.setFromDistrict(validationResponse1.isFromDistrict());
                        validationResponse.setFromSchool(validationResponse1.isFromSchool());
                    }
                }
                if (!AppUtils.isNullOrEmpty((String)student.getClever_id()) && student.getInstructor() == null) {
                    validationResponse.setValid(true);
                }
                account = this.accountRepository.findByAccountId(student.getAccount_id());
                token = EncryptDecryptHelper.base64Encode((String)EncryptDecryptHelper.encrypt((String)(account.getAccount_id() + " " + student.getStudent_id() + " " + account.getUsername())));
                accountTypes.add(AccountType.STUDENT.toString());
            }
            if (admin == null && instructor != null) {
                if (!AppUtils.isNullOrEmpty((String)instructor.getClever_id())) {
                    instructor = this.cleverDataService.syncInstructor(instructor);
                }
                if (!instructor.isArchived()) {
                    validationResponse = this.validationService.isValidInstructor(instructor.getInstructor_id());
                    accountTypes.add(AccountType.INSTRUCTOR.toString());
                }
            }
            if (!AppUtils.isNullOrEmpty((List)schools)) {
                ArrayList<ValidationResponse> validationResponses = new ArrayList<ValidationResponse>();
                for (School school : schools) {
                    validationResponses.add(this.validationService.isValidSchool(school.getSchool_id()));
                }
                List messages = validationResponses.stream().filter(item -> !item.isValid()).map(ValidationResponse::getMessage).collect(Collectors.toList());
                if (validationResponses.size() == messages.size()) {
                    throw new RuntimeException(String.join((CharSequence)",", messages));
                }
                validationResponse = (ValidationResponse)validationResponses.get(0);
                accountTypes.add(AccountType.SCHOOL.toString());
            }
            if (district != null) {
                validationResponse = this.validationService.isValidDistrict(district.getDistrict_id());
                accountTypes.add(AccountType.DISTRICT.toString());
            }
            if (admin == null && validationResponse != null && !validationResponse.isValid()) {
                throw new RuntimeException(validationResponse.getMessage());
            }
            HttpHeaders responseHeaders = new HttpHeaders();
            if (!AppUtils.isNullOrEmpty(accountTypes)) {
                responseHeaders.set("AccountType", String.join((CharSequence)",", accountTypes));
                responseHeaders.set("Authorization", token);
                if (this.jwtHelper.isBearerToken(token).booleanValue()) {
                    String refreshToken = this.jwtHelper.generateRefreshToken(loginRequest.getUsername());
                    responseHeaders.set("Authorization_Refresh_Token", refreshToken);
                }
            } else if (!AppUtils.isNullOrEmpty((String)token) && AppUtils.isNullOrEmpty(accountTypes)) {
                throw new RuntimeException(this.messageService.getMessage("unable.to.access.clymb.right.now.please.try.after.some.time"));
            }
            return new ResponseEntity((MultiValueMap)responseHeaders, (HttpStatusCode)HttpStatus.OK);
        }
        throw new UsernameNotFoundException("invalid user request !");
    }

    @GetMapping(value={"/refreshToken"})
    public ResponseEntity<Void> refreshToken(@RequestHeader(value="Authorization_Refresh_Token") String refreshToken) {
        String username = this.jwtHelper.extractUsernameForRefreshToken(refreshToken);
        HttpHeaders responseHeaders = new HttpHeaders();
        responseHeaders.set("Authorization", this.jwtHelper.generateToken(username));
        responseHeaders.set("Authorization_Refresh_Token", this.jwtHelper.generateRefreshToken(username));
        return new ResponseEntity((MultiValueMap)responseHeaders, (HttpStatusCode)HttpStatus.OK);
    }
}

