/*
 * Decompiled with CFR 0.152.
 */
package com.infinite.focus.server.group.controller;

import com.infinite.focus.server.auth.model.Message;
import com.infinite.focus.server.auth.request.NumberOfStudentsWhoDidClymbRequest;
import com.infinite.focus.server.auth.service.AuthService;
import com.infinite.focus.server.group.service.ClassAndStudentService;
import com.infinite.focus.server.group.service.ClassService;
import com.infinite.focus.server.instructor.entity.Instructor;
import com.infinite.focus.server.message.service.MessageService;
import com.infinite.focus.server.student.request.DeleteRequest;
import com.infinite.focus.server.utils.AppUtils;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.server.ResponseStatusException;

@CrossOrigin(origins={"http://localhost:8383"})
@RestController
@RequestMapping(value={"api/class"})
public class ClassController {
    @Autowired
    AuthService authService;
    @Autowired
    ClassAndStudentService classAndStudentService;
    @Autowired
    ClassService classService;
    @Autowired
    MessageService messageService;

    @PostMapping(value={"/delete-by-ids"})
    public ResponseEntity<Message> deleteByIds(@RequestHeader(value="Authorization") String token, @RequestBody DeleteRequest request) {
        List schools = this.authService.getSchoolByToken(token);
        Instructor instructor = this.authService.getInstructorByToken(token);
        if (AppUtils.isNullOrEmpty((List)schools) && instructor == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED);
        }
        if (AppUtils.isNullOrEmpty((List)request.getClassIds())) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, this.messageService.getMessage("the.class.ids.should.not.be.empty"));
        }
        this.classAndStudentService.deleteClassesByIds(request.getClassIds());
        Message message = new Message(this.messageService.getMessage("the.group.is.deleted.successfully"));
        if (request.getClassIds().size() > 1) {
            message.setMessage(this.messageService.getMessage("the.groups.are.deleted.successfully"));
        }
        return new ResponseEntity((Object)message, (HttpStatusCode)HttpStatus.OK);
    }

    @PostMapping(value={"/number-of-students-who-did-clymb"})
    public ResponseEntity<Message> numberOfStudentsWhoDidClymb(@RequestHeader(value="Authorization") String token, @RequestBody NumberOfStudentsWhoDidClymbRequest request) {
        this.authService.isAuthenticated(token);
        Message message = new Message(this.classService.outOfStudentWhoLoggedBetween(request.getClass_id(), request.getFromDate(), request.getToDate(), request.getTimeZone()));
        return new ResponseEntity((Object)message, (HttpStatusCode)HttpStatus.OK);
    }

    @PostMapping(value={"/sync-all-classes"})
    public ResponseEntity<Message> syncAllClasses(@RequestHeader(value="Authorization") String token) {
        this.authService.isAuthenticated(token);
        this.classService.syncAllClasses();
        Message message = new Message(this.messageService.getMessage("sync.in.progress"));
        return new ResponseEntity((Object)message, (HttpStatusCode)HttpStatus.OK);
    }
}

