/*
 * Decompiled with CFR 0.152.
 */
package com.infinite.focus.server.client.config;

import feign.Logger;
import feign.Request;
import feign.Response;
import feign.Util;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.time.LocalDateTime;

public class CustomFeignLogger
extends Logger {
    protected void log(String configKey, String format, Object ... args) {
        String timestamp = LocalDateTime.now().toString();
        String logLevel = "INFO";
        String methodName = configKey.split("#")[1];
        for (Object arg : args) {
            if (arg instanceof byte[]) {
                byte[] bytes = (byte[])arg;
                System.out.println(String.format("[%s] [%s] [%s] %s", timestamp, logLevel, methodName, new String(bytes, StandardCharsets.UTF_8)));
                continue;
            }
            System.out.println(String.format("[%s] [%s] [%s] %s", timestamp, logLevel, methodName, arg));
        }
    }

    protected void logRequest(String configKey, Logger.Level logLevel, Request request) {
        String timestamp = LocalDateTime.now().toString();
        String headers = request.headers().toString();
        String body = request.body() != null ? new String(request.body(), StandardCharsets.UTF_8) : "null";
        System.out.println(String.format("[%s] [%s] [%s] Request: %s %s\nHeaders: %s\nPayload: %s", timestamp, logLevel, configKey, request.httpMethod(), request.url(), headers, body));
    }

    protected Response logAndRebufferResponse(String configKey, Logger.Level logLevel, Response response, long elapsedTime) throws IOException {
        String timestamp = LocalDateTime.now().toString();
        String bodyData = response.body() != null ? Util.toString((Reader)response.body().asReader(StandardCharsets.UTF_8)) : "null";
        System.out.println(String.format("[%s] [%s] [%s] Response: %d %s (elapsed time: %d ms)", timestamp, logLevel, configKey, response.status(), bodyData, elapsedTime));
        return response.toBuilder().body(bodyData.getBytes(StandardCharsets.UTF_8)).build();
    }
}

