/*
 * Decompiled with CFR 0.152.
 */
package com.infinite.focus.server.client.config;

import com.fasterxml.jackson.core.StreamReadFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.infinite.focus.server.converter.EncryptDecryptHelper;
import feign.Logger;
import feign.Util;
import feign.codec.Decoder;
import java.io.Reader;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class FeignClientConfig {
    @Autowired
    private ObjectMapper objectMapper;

    @PostConstruct
    public void configureObjectMapper() {
        this.objectMapper.configure(StreamReadFeature.INCLUDE_SOURCE_IN_LOCATION.mappedFeature(), true);
    }

    @Bean
    Logger.Level feignLoggerLevel() {
        return Logger.Level.FULL;
    }

    @Bean
    public Decoder feignDecoder() {
        return (response, type) -> {
            String bodyStr = Util.toString((Reader)response.body().asReader(Util.UTF_8));
            JavaType javaType = TypeFactory.defaultInstance().constructType(type);
            String decrypt = EncryptDecryptHelper.decrypt((String)bodyStr);
            try {
                return this.objectMapper.readValue(decrypt, javaType);
            }
            catch (Exception e) {
                return null;
            }
        };
    }
}

