/*
 * Decompiled with CFR 0.152.
 */
package com.infinite.focus.server.school.service;

import com.infinite.focus.server.accesscode.repository.AccessCodeRepository;
import com.infinite.focus.server.accesscode.view.AccessCodeView;
import com.infinite.focus.server.account.entity.Account;
import com.infinite.focus.server.account.repository.AccountRepository;
import com.infinite.focus.server.account.request.GetEmailByAccountIdRequest;
import com.infinite.focus.server.account.response.GetEmailByAccountIdResponse;
import com.infinite.focus.server.account.service.AccountService;
import com.infinite.focus.server.account.view.AccountView;
import com.infinite.focus.server.activity.service.ActivityService;
import com.infinite.focus.server.auth.model.Status;
import com.infinite.focus.server.auth.util.KeyGenerator;
import com.infinite.focus.server.client.AccountClient;
import com.infinite.focus.server.client.InstructorClient;
import com.infinite.focus.server.client.StudentClient;
import com.infinite.focus.server.district.entity.District;
import com.infinite.focus.server.district.service.DistrictService;
import com.infinite.focus.server.freetrial.entity.FreeTrial;
import com.infinite.focus.server.freetrial.model.FocusOn;
import com.infinite.focus.server.freetrial.model.OrganizationType;
import com.infinite.focus.server.freetrial.service.FreeTrialService;
import com.infinite.focus.server.group.entity.Class;
import com.infinite.focus.server.group.repository.ClassRepository;
import com.infinite.focus.server.group.service.ClassService;
import com.infinite.focus.server.group.view.ClassView;
import com.infinite.focus.server.instructor.entity.Instructor;
import com.infinite.focus.server.instructor.repository.InstructorRepository;
import com.infinite.focus.server.instructor.request.GetInstructorByIdRequest;
import com.infinite.focus.server.instructor.service.InstructorService;
import com.infinite.focus.server.instructor.view.InstructorView;
import com.infinite.focus.server.invoice.entity.Invoice;
import com.infinite.focus.server.invoice.model.InvoiceType;
import com.infinite.focus.server.message.service.MessageService;
import com.infinite.focus.server.organizationadmin.entity.OrganizationAdmin;
import com.infinite.focus.server.organizationadmin.service.OrganizationAdminService;
import com.infinite.focus.server.school.entity.School;
import com.infinite.focus.server.school.repository.SchoolRepository;
import com.infinite.focus.server.school.request.GetStudentTestReportbySchoolRequest;
import com.infinite.focus.server.school.response.GetStudentTestReportbySchoolResponse;
import com.infinite.focus.server.school.service.GetStudentsBySchoolRequest;
import com.infinite.focus.server.school.service.SchoolService;
import com.infinite.focus.server.school.wrapper.SchoolSettingsWrapper;
import com.infinite.focus.server.standard.repository.StandardJPARepository;
import com.infinite.focus.server.standard.view.StandardView;
import com.infinite.focus.server.student.dto.StudentCoreDTO;
import com.infinite.focus.server.student.entity.Student;
import com.infinite.focus.server.student.repository.StudentCoreRepository;
import com.infinite.focus.server.student.request.GetStudentRequest;
import com.infinite.focus.server.student.service.StudentService;
import com.infinite.focus.server.student.view.StudentView;
import com.infinite.focus.server.utils.AppUtils;
import com.infinite.focus.server.utils.DateUtils;
import java.math.BigInteger;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.stereotype.Service;
import org.springframework.web.server.ResponseStatusException;

@Service
public class SchoolServiceImpl
implements SchoolService {
    @Autowired
    SchoolRepository schoolRepository;
    @Autowired
    AccountRepository accountRepository;
    @Autowired
    AccessCodeRepository accessCodeRepository;
    @Autowired
    InstructorRepository instructorRepository;
    @Autowired
    InstructorService instructorService;
    @Autowired
    StudentService studentService;
    @Autowired
    StudentCoreRepository studentCoreRepository;
    @Autowired
    DistrictService districtService;
    @Autowired
    FreeTrialService freeTrialService;
    @Autowired
    OrganizationAdminService organizationAdminService;
    @Autowired
    AccountService accountService;
    @Autowired
    ClassService classService;
    @Autowired
    ClassRepository classRepository;
    @Autowired
    ActivityService activityService;
    @Autowired
    MessageService messageService;
    @Autowired
    StandardJPARepository standardRepository;
    @Autowired
    private NamedParameterJdbcTemplate namedParameterJdbcTemplate;
    private final AccountClient accountClient;
    private final StudentClient studentClient;
    private final InstructorClient instructorClient;

    public SchoolServiceImpl(AccountClient accountClient, StudentClient studentClient, InstructorClient instructorClient) {
        this.accountClient = accountClient;
        this.studentClient = studentClient;
        this.instructorClient = instructorClient;
    }

    public SchoolSettingsWrapper getSettingsById(long schoolId) {
        School school = this.getSchoolById(schoolId);
        return SchoolSettingsWrapper.builder().enable_journal(school.isEnable_journal()).enable_wow(school.isEnable_wow()).should_update_clever_id(!AppUtils.isNullOrEmpty((String)school.getClever_id())).enable_auto_approve_wall_posts(school.isAuto_approve_wall_posts()).build();
    }

    public School getSchoolById(long school_id) {
        return this.schoolRepository.findBySchoolId(Long.valueOf(school_id));
    }

    public School getSchoolByCleverId(String clever_id) {
        return this.schoolRepository.findByCleverSchoolId(clever_id);
    }

    public List<School> getSchoolByAccountId(long account_id) {
        return this.findByAccountId(account_id);
    }

    public Page<School> getSchools(String schoolName, Integer pageNo, Integer pageSize, String sortBy, String orderBy) {
        PageRequest paging = PageRequest.of((int)pageNo, (int)pageSize, (Sort)(orderBy.equals("desc") ? Sort.by((String[])new String[]{sortBy}).descending() : Sort.by((String[])new String[]{sortBy}).ascending()));
        Page pagedResult = null;
        pagedResult = schoolName == null || schoolName.isEmpty() ? this.schoolRepository.findAllSchools((Pageable)paging) : this.schoolRepository.findBySchoolName(schoolName, (Pageable)paging);
        return pagedResult;
    }

    public List<School> getSchoolsByDistrictId(long district_id) {
        return this.schoolRepository.findByDistrictId(Long.valueOf(district_id));
    }

    public long getStudentsCountBySchoolId(long school_id) {
        return this.studentService.getStudentsCountBySchoolId(school_id);
    }

    public School activeDeactiveSchool(long school_id, boolean active) {
        School school = this.schoolRepository.findBySchoolId(Long.valueOf(school_id));
        if (school == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, this.messageService.getMessage("the.organization.is.not.found"));
        }
        school.setActive(active);
        return (School)this.schoolRepository.save((Object)school);
    }

    public School getSchoolByStudentId(long student_id) {
        Student student = this.studentClient.getStudentById(GetStudentRequest.builder().student_id(Long.valueOf(student_id)).build());
        Instructor instructor = this.instructorClient.getInstructorById(GetInstructorByIdRequest.builder().id(student.getInstructor_id()).build());
        return this.getSchoolById(instructor.getSchool_id());
    }

    public Date getRenewalDate(long school_id) {
        School school = this.schoolRepository.findBySchoolId(Long.valueOf(school_id));
        if (school == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, this.messageService.getMessage("the.organization.is.not.found"));
        }
        District district = this.districtService.getDistrictById(school.getDistrict_id());
        if (district != null) {
            if (AppUtils.isNotNullOrEmpty((String)district.getLicense_key())) {
                return district.getLicence_key_expiry_date();
            }
            return this.freeTrialService.getFreeTrialByDistrictId(district.getDistrict_id()).getTrial_end_date();
        }
        if (AppUtils.isNotNullOrEmpty((String)school.getLicense_key())) {
            return school.getLicence_key_expiry_date();
        }
        return this.freeTrialService.getFreeTrialBySchoolId(school.getSchool_id()).getTrial_end_date();
    }

    public List<School> findByAccountId(long account_id) {
        List schools = this.schoolRepository.findByAccountId(Long.valueOf(account_id));
        if (AppUtils.isNullOrEmpty((List)schools)) {
            List organizationAdmins = this.organizationAdminService.findByOrganizationTypeAndAccountId(OrganizationType.ORGANIZATION.toString(), account_id);
            for (OrganizationAdmin organizationAdmin : organizationAdmins) {
                schools.add(this.schoolRepository.findBySchoolId(Long.valueOf(organizationAdmin.getOrganization_id())));
            }
        }
        return schools;
    }

    public School deleteSchool(long school_id, boolean deleted, boolean isFromFreeTrial) {
        School school = this.schoolRepository.findBySchoolId(Long.valueOf(school_id));
        if (school == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, this.messageService.getMessage("the.organization.is.not.found"));
        }
        school.setDeleted(deleted);
        if (!isFromFreeTrial && school.getDistrict_id() == 0L && AppUtils.isNullOrEmpty((String)school.getLicense_key())) {
            FreeTrial freeTrial = this.freeTrialService.deleteFreeTrial(school.getSchool_id(), OrganizationType.ORGANIZATION, deleted);
        }
        return (School)this.schoolRepository.save((Object)school);
    }

    public School editSchool(long school_id, String school_name, FocusOn focus_on, String email, String address, long number_of_youth, Date licence_key_expiry_date) {
        School school = this.schoolRepository.findBySchoolId(Long.valueOf(school_id));
        if (school == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, this.messageService.getMessage("the.organization.is.not.found"));
        }
        if (AppUtils.isNullOrEmpty((String)school_name)) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, this.messageService.getMessage("school.name.is.null.or.empty"));
        }
        if (AppUtils.isNullOrEmpty((String)address)) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, this.messageService.getMessage("address.is.null.or.empty"));
        }
        Account account = this.accountService.changeEmail(school.getAccount_id(), email);
        school.setSchool_name(school_name);
        school.setFocus_on(focus_on);
        school.setAddress(address);
        school.setNumber_of_youth(number_of_youth);
        if (school.getDistrict_id() == 0L && AppUtils.isNullOrEmpty((String)school.getLicense_key())) {
            this.freeTrialService.editFreeTrial(school.getSchool_id(), OrganizationType.ORGANIZATION, school_name, focus_on, licence_key_expiry_date);
        } else {
            school.setLicence_key_expiry_date(licence_key_expiry_date);
        }
        return (School)this.schoolRepository.save((Object)school);
    }

    public Page<Object> getStudentsBySchool(long school_Id, GetStudentsBySchoolRequest request) {
        StringBuilder sql = new StringBuilder("SELECT DISTINCT s.student_id, s.").append(request.getSortBy()).append(" FROM student s ");
        sql.append("JOIN access_code ac ON s.student_id = ac.student_id ");
        if (AppUtils.isNotNullOrEmpty((String)request.getClass_name())) {
            sql.append("JOIN student_class sc ON s.student_id = sc.student_id ");
        }
        sql.append("JOIN account a ON s.account_id = a.account_id ");
        ArrayList instructorIds = new ArrayList();
        if (!AppUtils.isNullOrEmpty((String)request.getInstructor_name())) {
            instructorIds.addAll(this.instructorService.findInstructorIdsWhereInstructorNameLikeAndBySchoolId(request.getInstructor_name(), school_Id));
            if (!AppUtils.isNullOrEmpty(instructorIds)) {
                sql.append("JOIN instructor i ON s.instructor_id = i.instructor_id ");
            }
        }
        StringBuilder countSql = new StringBuilder("SELECT COUNT(DISTINCT s.student_id, s.").append(request.getSortBy()).append(") FROM student s ");
        countSql.append("JOIN access_code ac ON s.student_id = ac.student_id ");
        if (AppUtils.isNotNullOrEmpty((String)request.getClass_name())) {
            countSql.append("JOIN student_class sc ON s.student_id = sc.student_id ");
        }
        countSql.append("JOIN account a ON s.account_id = a.account_id ");
        if (!AppUtils.isNullOrEmpty(instructorIds)) {
            countSql.append("JOIN instructor i ON s.instructor_id = i.instructor_id ");
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        sql.append("WHERE ac.status IN (:statuses) ");
        countSql.append("WHERE ac.status IN (:statuses) ");
        params.put("statuses", Arrays.asList(Status.ACCEPTED.name(), Status.REJECTED.name()));
        if (AppUtils.isNotNullOrEmpty((String)request.getFirst_name())) {
            sql.append("AND s.first_name LIKE :firstName ");
            countSql.append("AND s.first_name LIKE :firstName ");
            params.put("firstName", "%" + request.getFirst_name() + "%");
        }
        if (AppUtils.isNotNullOrEmpty((String)request.getLast_name())) {
            sql.append("AND s.last_name LIKE :lastName ");
            countSql.append("AND s.last_name LIKE :lastName ");
            params.put("lastName", "%" + request.getLast_name() + "%");
        }
        if (AppUtils.isNotNullOrEmpty((String)request.getEmail())) {
            sql.append("AND a.username LIKE :username ");
            countSql.append("AND a.username LIKE :username ");
            params.put("username", "%" + request.getEmail() + "%");
        }
        if (AppUtils.isNotNullOrEmpty((String)request.getClass_name())) {
            List classIds = this.classRepository.findClassIdsWhereClassNameLike(request.getClass_name());
            if (AppUtils.isNotNullOrEmpty((List)classIds)) {
                sql.append("AND sc.class_id IN (:classIds) ");
                countSql.append("AND sc.class_id IN (:classIds) ");
                params.put("classIds", classIds.stream().map(BigInteger::longValue).collect(Collectors.toList()));
            } else {
                sql.append("AND sc.class_id = -1 ");
                countSql.append("AND sc.class_id = -1 ");
            }
        }
        if (!AppUtils.isNullOrEmpty(instructorIds)) {
            sql.append("AND i.instructor_id IN (:instructorIds) ");
            countSql.append("AND i.instructor_id IN (:instructorIds) ");
            params.put("instructorIds", instructorIds);
        } else {
            sql.append("AND s.school_id = :schoolId ");
            countSql.append("AND s.school_id = :schoolId ");
            params.put("schoolId", school_Id);
        }
        String orderBy = request.getOrderBy().equals("desc") ? "DESC" : "ASC";
        sql.append("ORDER BY s.").append(request.getSortBy()).append(" ").append(orderBy).append(", s.student_id ").append(orderBy);
        PageRequest pageable = PageRequest.of((int)request.getPageNo(), (int)request.getPageSize(), (Sort)(request.getOrderBy().equals("desc") ? Sort.by((String[])new String[]{request.getSortBy()}).descending() : Sort.by((String[])new String[]{request.getSortBy()}).ascending()));
        sql.append(" LIMIT :limit OFFSET :offset");
        params.put("limit", pageable.getPageSize());
        params.put("offset", pageable.getOffset());
        List results = this.namedParameterJdbcTemplate.queryForList(sql.toString(), params);
        Long count = (Long)this.namedParameterJdbcTemplate.queryForObject(countSql.toString(), params, Long.class);
        PageImpl pagedResult = new PageImpl(results, (Pageable)pageable, count.longValue());
        PageImpl pageWithFilteredData = new PageImpl(pagedResult.stream().map(result -> {
            LinkedHashMap<String, Object> wrapper = new LinkedHashMap<String, Object>();
            Long studentId = ((Number)result.get("student_id")).longValue();
            StudentCoreDTO studentDTO = this.studentCoreRepository.findById(studentId.longValue());
            wrapper.put("student_id", studentDTO.getStudent_id());
            wrapper.put("first_name", studentDTO.getFirst_name());
            wrapper.put("last_name", studentDTO.getLast_name());
            AccountView accountView = this.accountRepository.findAccountViewByAccountId(Long.valueOf(studentDTO.getAccount_id()));
            if (accountView != null) {
                wrapper.put("username", accountView.getUsername());
                wrapper.put("username2", accountView.getUsername2());
            } else {
                wrapper.put("username", null);
                wrapper.put("username2", null);
            }
            AccessCodeView accessCodeView = this.accessCodeRepository.findAccessCodeViewByStudentId(Long.valueOf(studentDTO.getStudent_id()));
            if (accessCodeView != null) {
                wrapper.put("status", accessCodeView.getStatus());
            } else {
                wrapper.put("status", null);
            }
            InstructorView instructorView = this.instructorRepository.findInstructorViewByInstructorId(Long.valueOf(studentDTO.getInstructor_id()));
            if (instructorView != null) {
                LinkedHashMap<String, Object> wrapperInstructor = new LinkedHashMap<String, Object>();
                wrapperInstructor.put("instructor_id", instructorView.getInstructor_id());
                wrapperInstructor.put("first_name", instructorView.getFirst_name());
                wrapperInstructor.put("last_name", instructorView.getLast_name());
                wrapper.put("instructor", wrapperInstructor);
            } else {
                wrapper.put("instructor", null);
            }
            StandardView standardView = this.standardRepository.findStandardViewByStandardId(Long.valueOf(studentDTO.getStandard_id()));
            if (standardView != null) {
                LinkedHashMap<String, Object> wrapperStandard = new LinkedHashMap<String, Object>();
                wrapperStandard.put("standard_id", standardView.getStandard_id());
                wrapperStandard.put("standard_name", standardView.getStandard_name());
                wrapperStandard.put("grade_id", standardView.getGrade_id());
                wrapper.put("standard", wrapperStandard);
            } else {
                wrapper.put("standard", null);
            }
            LinkedList classViews = this.classRepository.findClassViewByStudentId(studentDTO.getStudent_id());
            if (!AppUtils.isNullOrEmpty((List)classViews)) {
                LinkedList classes = new LinkedList();
                for (ClassView classView : classViews) {
                    LinkedHashMap<String, String> wrapperClass = new LinkedHashMap<String, String>();
                    wrapperClass.put("class_name", classView.getClass_name());
                    classes.add(wrapperClass);
                }
                wrapper.put("classes", classes);
            } else {
                wrapper.put("classes", new ArrayList());
            }
            return wrapper;
        }).collect(Collectors.toList()), pagedResult.getPageable(), pagedResult.getTotalElements());
        return pageWithFilteredData;
    }

    public String outOfStudentWhoLoggedBetween(long school_id, Date fromDate, Date toDate, TimeZone timeZone) {
        List instructorIds = this.instructorService.getInstructorIdsBySchoolId(school_id);
        if (AppUtils.isNullOrEmpty((List)instructorIds)) {
            return this.messageService.getMessage().getNumber_of_students_who_did_clymb().replace("<out_of>", "0").replace("<total>", "0");
        }
        ArrayList studentIds = new ArrayList(this.studentService.getStudentIdsByInstructorIds(instructorIds));
        if (AppUtils.isNullOrEmpty(studentIds)) {
            return this.messageService.getMessage().getNumber_of_students_who_did_clymb().replace("<out_of>", "0").replace("<total>", "0");
        }
        List activities = this.activityService.getLoggedInStudentsByStudentIdsBetweenFromDateAndToDateAndBetweenFromTimeAndToTime(studentIds, DateUtils.yearMonthDateHoursMinutesSecondsUTC.format(fromDate), DateUtils.yearMonthDateHoursMinutesSecondsUTC.format(toDate), timeZone);
        return this.messageService.getMessage().getNumber_of_students_who_did_clymb().replace("<out_of>", "" + activities.size()).replace("<total>", "" + studentIds.size());
    }

    public List<StudentView> getStudentsBySchoolId(long school_id) {
        List instructors = this.instructorService.findBySchoolId(school_id);
        ArrayList<StudentView> studentViews = new ArrayList<StudentView>();
        for (Instructor i : instructors) {
            List classes = this.classService.findByInstructorId(i.getInstructor_id());
            for (Class c : classes) {
                studentViews.addAll(this.classService.findStudentsByClassId(c.getClass_id()));
            }
        }
        return studentViews;
    }

    public List<StudentView> getStudentsForSELAnalyticsBySchoolId(long school_id) {
        List instructors = this.instructorService.findBySchoolId(school_id);
        ArrayList<StudentView> studentViews = new ArrayList<StudentView>();
        for (Instructor i : instructors) {
            List classes = this.classService.findByInstructorId(i.getInstructor_id());
            for (Class c : classes) {
                studentViews.addAll(this.classService.findStudentsByClassIdForSELAnalytics(c.getClass_id()));
            }
        }
        return studentViews;
    }

    public School updateNumberOfYouthBySchoolId(long school_id, long number_of_youth) {
        School school = this.schoolRepository.findBySchoolId(Long.valueOf(school_id));
        if (school == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, "The organization is not found!!!");
        }
        school.setNumber_of_youth(number_of_youth);
        return (School)this.schoolRepository.save((Object)school);
    }

    public School renewSubscriptionBySchoolId(long school_id) {
        School school = this.schoolRepository.findBySchoolId(Long.valueOf(school_id));
        if (school == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, "The organization is not found!!!");
        }
        school.setLicence_key_expiry_date(DateUtils.getNextYearDateFromToday());
        school.setActive(true);
        return (School)this.schoolRepository.save((Object)school);
    }

    public void addLicenseKey(Invoice invoice) {
        School school = this.getSchoolById(invoice.getOrganization_id());
        school.setLicense_key(invoice.getLicense_key());
        school.setLicence_key_added_date(new Date());
        school.setLicence_key_expiry_date(DateUtils.getNextYearDateFromToday());
        school.setActive(true);
        if (invoice.getInvoice_type().equals((Object)InvoiceType.INCREASE_NO_OF_YOUTH)) {
            school.setNumber_of_youth(invoice.getNumber_of_youth());
        }
        this.schoolRepository.save((Object)school);
        FreeTrial freeTrial = this.freeTrialService.findByOrganizationTypeAndOrganizationId(OrganizationType.ORGANIZATION.toString(), school.getSchool_id());
        if (freeTrial != null) {
            this.freeTrialService.deleteById(Long.valueOf(freeTrial.getFree_trial_id()));
        }
    }

    public void updateSubscription(Invoice invoice) {
        if (!AppUtils.isNullOrEmpty((String)invoice.getLicense_key())) {
            this.addLicenseKey(invoice);
        } else if (invoice.getInvoice_type().equals((Object)InvoiceType.INCREASE_NO_OF_YOUTH)) {
            this.updateNumberOfYouthBySchoolId(invoice.getOrganization_id(), invoice.getNumber_of_youth());
        } else if (invoice.getInvoice_type().equals((Object)InvoiceType.RENEW_SUBSCRIPTION)) {
            this.renewSubscriptionBySchoolId(invoice.getOrganization_id());
        }
    }

    public School getSchoolByRegistrationCode(String registration_code) {
        return this.schoolRepository.findByRegistrationCode(registration_code);
    }

    public School save(School school) {
        return (School)this.schoolRepository.save((Object)school);
    }

    public String generateRegistrationCodeForSchool() {
        String registrationCode = null;
        Boolean isUnique = false;
        while (!isUnique.booleanValue()) {
            String possible_code = "S" + KeyGenerator.generateUniqueAuthCode();
            School x = this.schoolRepository.findByRegistrationCode(possible_code);
            if (x == null) {
                isUnique = true;
                registrationCode = possible_code;
                continue;
            }
            isUnique = false;
        }
        return registrationCode;
    }

    public List<Instructor> getInstructorsBySchool(long school_id, GetStudentsBySchoolRequest request) {
        return this.instructorRepository.findBySchoolIdOrderByFirstNameASC(Long.valueOf(school_id));
    }

    public List<School> findAllSchoolsOrderBySchoolIdASC() {
        return this.schoolRepository.findAllSchoolsOrderBySchoolIdASC();
    }

    public String getSchoolEmailBySchoolId(long school_id, String token) {
        School school = this.schoolRepository.findBySchoolId(Long.valueOf(school_id));
        GetEmailByAccountIdResponse getEmailByAccountIdResponse = this.accountClient.getEmailByAccountId(token, GetEmailByAccountIdRequest.builder().account_id(school.getAccount_id()).build());
        return getEmailByAccountIdResponse.getEmail();
    }

    public Page<GetStudentTestReportbySchoolResponse> getStudentReportbySchool(GetStudentTestReportbySchoolRequest request) {
        Integer pageNumber = request.getPageNo() - 1;
        LocalDate startDate = null;
        LocalDate endDate = null;
        if (request.getFromDate() != null) {
            startDate = request.getFromDate().toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
        }
        if (request.getToDate() != null) {
            endDate = request.getToDate().toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
        }
        String studentIds = null;
        if (request.getStudents_id() != null && !request.getStudents_id().isEmpty()) {
            studentIds = request.getStudents_id().stream().map(String::valueOf).collect(Collectors.joining(","));
        }
        String schoolIds = null;
        if (request.getSchool_id() != null && !request.getSchool_id().isEmpty()) {
            schoolIds = request.getSchool_id().stream().map(String::valueOf).collect(Collectors.joining(","));
        }
        String genders = null;
        if (request.getGenders() != null && !request.getGenders().isEmpty()) {
            genders = String.join((CharSequence)",", request.getGenders());
        }
        String ages = null;
        if (request.getAges() != null && !request.getAges().isEmpty()) {
            ages = request.getAges().stream().map(String::valueOf).collect(Collectors.joining(","));
        }
        String ethnicities = null;
        if (request.getEthnicity() != null && !request.getEthnicity().isEmpty()) {
            ethnicities = String.join((CharSequence)",", request.getEthnicity());
        }
        String gradeIds = null;
        if (request.getGradeIds() != null && !request.getGradeIds().isEmpty()) {
            gradeIds = request.getGradeIds().stream().map(String::valueOf).collect(Collectors.joining(","));
        }
        List results = this.schoolRepository.getStudentTestReportSchool(startDate, endDate, studentIds, genders, ages, ethnicities, gradeIds, pageNumber, request.getPageSize(), request.getSortBy(), request.getOrderBy());
        List content = results.stream().map(GetStudentTestReportbySchoolResponse::new).collect(Collectors.toList());
        Long totalElements = this.schoolRepository.getStudentTestReportSchoolPageCount(startDate, endDate, studentIds, genders, ages, ethnicities, gradeIds);
        Sort.Direction direction = "desc".equalsIgnoreCase(request.getOrderBy()) ? Sort.Direction.DESC : Sort.Direction.ASC;
        Sort sort = Sort.by((Sort.Direction)direction, (String[])new String[]{request.getSortBy()});
        PageRequest pageable = PageRequest.of((int)pageNumber, (int)request.getPageSize(), (Sort)sort);
        return new PageImpl(content, (Pageable)pageable, totalElements.longValue());
    }

    public Page<GetStudentTestReportbySchoolResponse> getStudentReportbySchool32(GetStudentTestReportbySchoolRequest request) {
        Long totalElements;
        List results;
        boolean exportAll = request.getPageSize() != null && request.getPageSize() == -1;
        LocalDate startDate = null;
        LocalDate endDate = null;
        if (request.getFromDate() != null) {
            startDate = request.getFromDate().toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
        }
        if (request.getToDate() != null) {
            endDate = request.getToDate().toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
        }
        String studentIds = null;
        if (request.getStudents_id() != null && !request.getStudents_id().isEmpty()) {
            studentIds = request.getStudents_id().stream().map(String::valueOf).collect(Collectors.joining(","));
        }
        String genders = null;
        if (request.getGenders() != null && !request.getGenders().isEmpty()) {
            genders = String.join((CharSequence)",", request.getGenders());
        }
        String ages = null;
        if (request.getAges() != null && !request.getAges().isEmpty()) {
            ages = request.getAges().stream().map(String::valueOf).collect(Collectors.joining(","));
        }
        String ethnicities = null;
        if (request.getEthnicity() != null && !request.getEthnicity().isEmpty()) {
            ethnicities = String.join((CharSequence)"|", request.getEthnicity());
        }
        String gradeIds = null;
        if (request.getGradeIds() != null && !request.getGradeIds().isEmpty()) {
            gradeIds = request.getGradeIds().stream().flatMap(grade -> {
                if (grade == 1L) {
                    return Stream.of(1, 2, 3);
                }
                if (grade == 2L) {
                    return Stream.of(4, 5, 6);
                }
                if (grade == 3L) {
                    return Stream.of(7, 8, 9, 10, 11, 12, 13);
                }
                return Stream.of(grade);
            }).map(x$0 -> String.valueOf(x$0)).collect(Collectors.joining(","));
        }
        String schoolIds = null;
        if (request.getSchool_id() != null && !request.getSchool_id().isEmpty()) {
            schoolIds = request.getSchool_id().stream().map(String::valueOf).collect(Collectors.joining(","));
        }
        String groupIds = null;
        if (request.getGroups() != null && !request.getGroups().isEmpty()) {
            groupIds = request.getGroups().stream().map(String::valueOf).collect(Collectors.joining(","));
        }
        if (exportAll) {
            results = this.schoolRepository.getStudentTestReportSchool43(startDate, endDate, studentIds, genders, ages, ethnicities, gradeIds, schoolIds, groupIds, Integer.valueOf(1), Integer.valueOf(Integer.MAX_VALUE), request.getSortBy(), request.getOrderBy());
            totalElements = this.schoolRepository.getStudentTestReportSchoolPageCount43(startDate, endDate, studentIds, genders, ages, ethnicities, gradeIds, schoolIds, groupIds);
        } else {
            results = this.schoolRepository.getStudentTestReportSchool43(startDate, endDate, studentIds, genders, ages, ethnicities, gradeIds, schoolIds, groupIds, request.getPageNo(), request.getPageSize(), request.getSortBy(), request.getOrderBy());
            totalElements = this.schoolRepository.getStudentTestReportSchoolPageCount43(startDate, endDate, studentIds, genders, ages, ethnicities, gradeIds, schoolIds, groupIds);
        }
        List content = results.stream().map(result -> {
            int gradeIndex;
            Object[] transformedResult = (Object[])result.clone();
            if (transformedResult[gradeIndex = 21] != null) {
                int gradeValue = ((Number)transformedResult[gradeIndex]).intValue();
                transformedResult[gradeIndex] = gradeValue == 1 ? "K" : String.valueOf(gradeValue - 1);
            }
            return new GetStudentTestReportbySchoolResponse(transformedResult);
        }).collect(Collectors.toList());
        if (exportAll) {
            Pageable pageable = Pageable.unpaged();
            return new PageImpl(content, pageable, totalElements.longValue());
        }
        Sort.Direction direction = "desc".equalsIgnoreCase(request.getOrderBy()) ? Sort.Direction.DESC : Sort.Direction.ASC;
        Sort sort = Sort.by((Sort.Direction)direction, (String[])new String[]{request.getSortBy()});
        Integer pageNumber = request.getPageNo() - 1;
        PageRequest pageable = PageRequest.of((int)pageNumber, (int)request.getPageSize(), (Sort)sort);
        return new PageImpl(content, (Pageable)pageable, totalElements.longValue());
    }

    public List<Map<String, Object>> searchStudents(GetStudentTestReportbySchoolRequest request, Long schoolId) {
        List classIdsList = null;
        if (request.getGroups() != null && !request.getGroups().isEmpty()) {
            classIdsList = request.getGroups();
        } else {
            List groupResults = this.schoolRepository.getGroupsByNameAndSchoolsForStudentReport("", Collections.singletonList(schoolId));
            classIdsList = groupResults.stream().map(row -> ((Number)row[0]).longValue()).collect(Collectors.toList());
        }
        String genders = null;
        if (request.getGenders() != null && !request.getGenders().isEmpty()) {
            genders = String.join((CharSequence)",", request.getGenders());
        }
        String ages = null;
        if (request.getAges() != null && !request.getAges().isEmpty()) {
            ages = request.getAges().stream().map(String::valueOf).collect(Collectors.joining(","));
        }
        String ethnicities = null;
        if (request.getEthnicity() != null && !request.getEthnicity().isEmpty()) {
            ethnicities = String.join((CharSequence)",", request.getEthnicity());
        }
        String gradeIds = null;
        if (request.getGradeIds() != null && !request.getGradeIds().isEmpty()) {
            gradeIds = request.getGradeIds().stream().map(String::valueOf).collect(Collectors.joining(","));
        }
        String classIds = null;
        if (request.getGroups() != null && !request.getGroups().isEmpty()) {
            classIds = request.getGroups().stream().map(String::valueOf).collect(Collectors.joining(","));
        }
        String studentName = request.getStudent_name();
        List results = this.schoolRepository.searchStudentsSimple(studentName, genders, ages, ethnicities, gradeIds, String.valueOf(schoolId), classIds);
        return results.stream().map(row -> {
            HashMap<String, Object> student = new HashMap<String, Object>();
            student.put("studentId", row[0]);
            student.put("studentName", row[1]);
            student.put("schoolId", row[2]);
            return student;
        }).collect(Collectors.toList());
    }

    public List<Map<String, Object>> getGroupsByName(String groupName, List<Long> schools) {
        List<Long> schoolIds = schools;
        if (schoolIds == null || schoolIds.isEmpty()) {
            return new ArrayList<Map<String, Object>>();
        }
        List results = this.schoolRepository.getGroupsByNameAndSchoolsForStudentReport(groupName, schoolIds);
        return results.stream().map(row -> {
            HashMap<String, Object> group = new HashMap<String, Object>();
            group.put("groupId", row[0]);
            group.put("groupName", row[1]);
            group.put("schoolId", row[4]);
            return group;
        }).collect(Collectors.toList());
    }

    public Page<GetStudentTestReportbySchoolResponse> getStudentReportbySchoolOld(GetStudentTestReportbySchoolRequest request) {
        Integer pageNumber = request.getPageNo() - 1;
        LocalDate startDate = null;
        LocalDate endDate = null;
        if (request.getFromDate() != null) {
            startDate = request.getFromDate().toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
        }
        if (request.getToDate() != null) {
            endDate = request.getToDate().toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
        }
        String studentIds = null;
        if (request.getStudents_id() != null && !request.getStudents_id().isEmpty()) {
            studentIds = request.getStudents_id().stream().map(String::valueOf).collect(Collectors.joining(","));
        }
        String genders = null;
        if (request.getGenders() != null && !request.getGenders().isEmpty()) {
            genders = String.join((CharSequence)",", request.getGenders());
        }
        String ethnicities = null;
        if (request.getEthnicity() != null && !request.getEthnicity().isEmpty()) {
            ethnicities = String.join((CharSequence)",", request.getEthnicity());
        }
        List results = this.schoolRepository.getStudentTestReportSchoolOld(startDate, endDate, studentIds, genders, ethnicities, pageNumber, request.getPageSize());
        List content = results.stream().map(GetStudentTestReportbySchoolResponse::new).collect(Collectors.toList());
        Long totalElements = this.schoolRepository.getStudentTestReportSchoolPageCountOld(startDate, endDate, studentIds, genders, ethnicities);
        Sort.Direction direction = "desc".equalsIgnoreCase(request.getOrderBy()) ? Sort.Direction.DESC : Sort.Direction.ASC;
        Sort sort = Sort.by((Sort.Direction)direction, (String[])new String[]{request.getSortBy()});
        PageRequest pageable = PageRequest.of((int)pageNumber, (int)request.getPageSize(), (Sort)sort);
        return new PageImpl(content, (Pageable)pageable, totalElements.longValue());
    }
}

