/*
 * Decompiled with CFR 0.152.
 */
package com.infinite.focus.server.district.repository;

import com.infinite.focus.server.district.entity.District;
import java.time.LocalDate;
import java.util.List;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.stereotype.Repository;

@Repository
public interface DistrictRepository
extends JpaRepository<District, Long> {
    @Query(value="SELECT * FROM district WHERE account_id = ?1", nativeQuery=true)
    public District findByAccountId(Long var1);

    @Query(value="SELECT * FROM district WHERE district_id = ?1", nativeQuery=true)
    public District findByDistrictId(Long var1);

    @Query(value="SELECT * FROM district WHERE clever_id = ?1", nativeQuery=true)
    public District findByDistrictCleverId(String var1);

    @Query(value="SELECT * FROM district WHERE registration_code = ?1", nativeQuery=true)
    public District findByRegistrationCode(String var1);

    @Query(value="SELECT * FROM district WHERE license_key = ?1", nativeQuery=true)
    public List<District> findByLicenseKey(String var1);

    @Query(value="SELECT distr.* FROM district distr JOIN account acc ON distr.account_id = acc.account_id WHERE acc.username IS NOT NULL AND acc.username != ''", nativeQuery=true)
    public List<District> getAllDistricts();

    @Query(value="SELECT school_id FROM school WHERE district_id = ?1", nativeQuery=true)
    public List<Long> getSchoolIdsByDistrictId(Long var1);

    @Query(value="SELECT * FROM district", nativeQuery=true)
    public Page<District> findAllDistricts(Pageable var1);

    @Query(value="SELECT * FROM district WHERE district_name LIKE ?1", nativeQuery=true)
    public Page<District> findByDistrictName(String var1, Pageable var2);

    @Query(value="SELECT school_id, school_name FROM school WHERE district_id = ?2 AND (?1 IS NULL OR ?1 = '' OR school_name LIKE CONCAT('%', ?1, '%'))", nativeQuery=true)
    public List<Object[]> getSchoolsByNameForReport(String var1, Long var2);

    @Query(value="SELECT * FROM class WHERE school_id IN (?2) AND class_name LIKE CONCAT('%', ?1, '%')", nativeQuery=true)
    public List<Object[]> getGroupsByNameAndSchoolsForStudentReport(String var1, List<Long> var2);

    @Query(value="CALL sp_SearchStudentsSimple(?1, ?2, ?3, ?4, ?5, ?6, ?7)", nativeQuery=true)
    public List<Object[]> searchStudentsSimple(String var1, String var2, String var3, String var4, String var5, String var6, String var7);

    @Query(value="CALL GetSocioEmotionalTestReport101(?1, ?2, ?3, ?4, ?5, ?6, ?7, ?8, ?9, ?10, ?11, ?12, ?13)", nativeQuery=true)
    public List<Object[]> getStudentTestReportDistrict43(LocalDate var1, LocalDate var2, String var3, String var4, String var5, String var6, String var7, String var8, String var9, Integer var10, Integer var11, String var12, String var13);

    @Query(value="CALL GetSocioEmotionalTestReportCount101(?1, ?2, ?3, ?4, ?5, ?6, ?7, ?8, ?9)", nativeQuery=true)
    public Long getStudentTestReportDistrictPageCount43(LocalDate var1, LocalDate var2, String var3, String var4, String var5, String var6, String var7, String var8, String var9);
}

