/*
 * Decompiled with CFR 0.152.
 */
package com.infinite.focus.server.auth;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.http.HttpStatus;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;
import org.springframework.web.server.ResponseStatusException;

/*
 * Exception performing whole class analysis ignored.
 */
public class ChangePasswordRequest {
    private String oldPassword;
    private String newPassword;

    public String getOldPassword() {
        return this.oldPassword;
    }

    public void setOldPassword(String oldPassword) {
        this.oldPassword = oldPassword;
    }

    public String getNewPassword() {
        return this.newPassword;
    }

    public void setNewPassword(String newPassword) {
        this.newPassword = newPassword;
    }

    public boolean validatePassword(BCryptPasswordEncoder bCryptPasswordEncoder, String password) throws ResponseStatusException {
        if (this.oldPassword == null) {
            throw new ResponseStatusException(HttpStatus.CONFLICT, "The old password does not found.");
        }
        if (this.oldPassword.trim().isEmpty()) {
            throw new ResponseStatusException(HttpStatus.CONFLICT, "The old password is empty.");
        }
        if (this.newPassword == null) {
            throw new ResponseStatusException(HttpStatus.CONFLICT, "The new password does not found.");
        }
        if (this.newPassword.trim().isEmpty()) {
            throw new ResponseStatusException(HttpStatus.CONFLICT, "The new password is empty.");
        }
        ChangePasswordRequest.isValidPassword((String)this.newPassword);
        boolean isValidPassword = bCryptPasswordEncoder.matches((CharSequence)this.oldPassword, password);
        if (!isValidPassword) {
            throw new ResponseStatusException(HttpStatus.CONFLICT, "The old password does not match.");
        }
        return isValidPassword;
    }

    public static boolean isValidPassword(String password) {
        String regex = "^(?=.*[A-Z])(?=.*[a-z])(?=.*[@$!%*?&#^()\\[\\]<>;:.,~\\-_=\\/|{}\"'`+\\\\])[A-Za-z\\d@$!%*?&#^()\\[\\]<>;:.,~\\-_=\\/|{}\"'`+\\\\]{6,25}$";
        Pattern p = Pattern.compile(regex);
        if (password == null || password.isEmpty()) {
            return false;
        }
        Matcher m = p.matcher(password);
        boolean isValid = m.matches();
        if (!isValid) {
            throw new ResponseStatusException(HttpStatus.CONFLICT, "The password must contain 6-25 characters, including at least 1 upper case, lower case alphabets and a special character.");
        }
        return isValid;
    }
}

