/*
 * Decompiled with CFR 0.152.
 */
package com.infinite.focus.server.auth;

import com.infinite.focus.server.auth.Account;
import java.util.Date;
import java.util.UUID;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.OneToOne;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;

@Entity
public class ConfirmationToken {
    @Id
    @GeneratedValue(strategy=GenerationType.AUTO)
    @Column(name="token_id")
    private long tokenid;
    @Column(name="confirmation_token")
    private String confirmationToken;
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date createdDate;
    @OneToOne(targetEntity=Account.class, fetch=FetchType.EAGER)
    @JoinColumn(nullable=false, name="account_id")
    private Account account;

    public ConfirmationToken() {
    }

    public ConfirmationToken(Account account) {
        this.account = account;
        this.createdDate = new Date();
        this.confirmationToken = UUID.randomUUID().toString();
    }

    public String getConfirmationToken() {
        return this.confirmationToken;
    }

    public void setConfirmationToken(String confirmationToken) {
        this.confirmationToken = confirmationToken;
    }

    public Date getCreatedDate() {
        return this.createdDate;
    }

    public void setCreatedDate(Date createdDate) {
        this.createdDate = createdDate;
    }

    public Account getAccount() {
        return this.account;
    }

    public void setAccount(Account account) {
        this.account = account;
    }

    public long getTokenid() {
        return this.tokenid;
    }

    public void setTokenid(long tokenid) {
        this.tokenid = tokenid;
    }
}

