/*
 * Decompiled with CFR 0.152.
 */
package com.infinite.focus.server.auth;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.infinite.focus.server.auth.Account;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.SignatureAlgorithm;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.userdetails.User;
import org.springframework.security.web.authentication.UsernamePasswordAuthenticationFilter;

public class JWTAuthenticationFilter
extends UsernamePasswordAuthenticationFilter {
    private AuthenticationManager authenticationManager;

    public JWTAuthenticationFilter(AuthenticationManager authenticationManager) {
        this.authenticationManager = authenticationManager;
    }

    public Authentication attemptAuthentication(HttpServletRequest req, HttpServletResponse res) throws AuthenticationException {
        try {
            Account creds = (Account)new ObjectMapper().readValue((InputStream)req.getInputStream(), Account.class);
            return this.authenticationManager.authenticate((Authentication)new UsernamePasswordAuthenticationToken((Object)creds.getUsername(), (Object)creds.getPassword(), new ArrayList()));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected void successfulAuthentication(HttpServletRequest req, HttpServletResponse res, FilterChain chain, Authentication auth) throws IOException, ServletException {
        String token = Jwts.builder().setSubject(((User)auth.getPrincipal()).getUsername()).setExpiration(new Date(System.currentTimeMillis() + 864000000L)).signWith(SignatureAlgorithm.HS512, "SecretKeyToGenJWTs").compact();
        res.addHeader("Authorization", "Bearer " + token);
    }

    protected void unsuccessfulAuthentication(HttpServletRequest request, HttpServletResponse response, AuthenticationException exception) throws IOException, ServletException {
    }
}

