/*
 * Decompiled with CFR 0.152.
 */
package com.infinite.focus.server.dashboard;

import com.infinite.focus.server.activity.ActivityRepository;
import com.infinite.focus.server.activity.ActivityTypeRepository;
import com.infinite.focus.server.auth.AccountRepository;
import com.infinite.focus.server.auth.AvatarRepository;
import com.infinite.focus.server.auth.Instructor;
import com.infinite.focus.server.auth.InstructorRepository;
import com.infinite.focus.server.auth.StudentRepository;
import com.infinite.focus.server.dashboard.DashboardController;
import com.infinite.focus.server.dashboard.DropDownsForAnalyticsDataWrapper;
import com.infinite.focus.server.dashboard.GetDataDashBoardRequest;
import com.infinite.focus.server.dashboard.LabelAndData;
import com.infinite.focus.server.dashboard.LabelAndValue;
import com.infinite.focus.server.dashboard.LabelsAndDatasets;
import com.infinite.focus.server.dashboard.TimeLine;
import com.infinite.focus.server.dashboard.features.FeaturesService;
import com.infinite.focus.server.dashboard.mooddata.MoodDataService;
import com.infinite.focus.server.dashboard.socioemotionalassessment.SocioEmotionalAssessmentService;
import com.infinite.focus.server.dashboard.stats.StatsService;
import com.infinite.focus.server.dashboard.userstats.UserStatsService;
import com.infinite.focus.server.grade.Grade;
import com.infinite.focus.server.grade.GradeRepository;
import com.infinite.focus.server.home.DailyAppreciationRepository;
import com.infinite.focus.server.home.MoodUpdateRepository;
import com.infinite.focus.server.home.QuoteRepository;
import com.infinite.focus.server.lessons.LessonRecordRepository;
import com.infinite.focus.server.lessons.LessonRepository;
import com.infinite.focus.server.standard.StandardRepository;
import com.infinite.focus.server.students.Class;
import com.infinite.focus.server.students.ClassRepository;
import com.infinite.focus.server.tests.AnswerRepository;
import com.infinite.focus.server.tests.CorrectAnswerRepository;
import com.infinite.focus.server.tests.MultipleChoiceOptionRepository;
import com.infinite.focus.server.tests.QuestionRepository;
import com.infinite.focus.server.tests.SocioEmotionalTestAnswerRepository;
import com.infinite.focus.server.tests.SocioEmotionalTestQuestionOptionRepository;
import com.infinite.focus.server.tests.SocioEmotionalTestQuestionRepository;
import com.infinite.focus.server.tests.SocioEmotionalTestQuestionTypeRepository;
import com.infinite.focus.server.tests.SocioEmotionalTestResultRepository;
import com.infinite.focus.server.tests.TestRepository;
import com.infinite.focus.server.tests.TestResultGradeRepository;
import com.infinite.focus.server.tests.TestResultRepository;
import com.infinite.focus.server.utils.AppUtils;
import com.infinite.focus.server.utils.DateUtils;
import com.infinite.focus.server.utils.DigitUtils;
import com.infinite.focus.server.wall.WallPostAttachmentRepository;
import com.infinite.focus.server.wall.WallPostRepository;
import com.infinite.focus.server.wall.WallPostRequestRepository;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import javax.persistence.EntityManager;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@CrossOrigin(origins={"http://localhost:8383"})
@RestController
@RequestMapping(value={"api/dashboard"})
public class DashboardController {
    @Autowired
    EntityManager entityManager;
    @Autowired
    UserStatsService userStatsService;
    @Autowired
    StatsService statsService;
    @Autowired
    SocioEmotionalAssessmentService socioEmotionalAssessmentService;
    @Autowired
    MoodDataService moodDataService;
    @Autowired
    FeaturesService featuresService;
    private AccountRepository accountRepository;
    private StudentRepository studentRepository;
    private InstructorRepository instructorRepository;
    private AvatarRepository avatarRepository;
    private BCryptPasswordEncoder bCryptPasswordEncoder;
    private WallPostRepository wallPostRepository;
    private WallPostAttachmentRepository wallPostAttachmentRepository;
    private WallPostRequestRepository wallPostRequestRepository;
    private QuoteRepository qouteRepository;
    private MoodUpdateRepository moodUpdateRepository;
    private DailyAppreciationRepository dailyAppreciationRepository;
    private ClassRepository classRepository;
    private TestRepository testRepository;
    private QuestionRepository questionRepository;
    private CorrectAnswerRepository correctAnswerRepository;
    private MultipleChoiceOptionRepository multipleChoiceOptionRepository;
    private AnswerRepository answerRepository;
    private TestResultRepository testResultRepository;
    private TestResultGradeRepository testResultGradeRepository;
    private LessonRepository lessonRepository;
    private GradeRepository gradeRepository;
    private StandardRepository standardRepository;
    private LessonRecordRepository lessonRecordRepository;
    private SocioEmotionalTestResultRepository socioEmotionalTestResultRepository;
    private SocioEmotionalTestQuestionTypeRepository socioEmotionalTestQuestionTypeRepository;
    private SocioEmotionalTestQuestionRepository socioEmotionalTestQuestionRepository;
    private SocioEmotionalTestQuestionOptionRepository socioEmotionalTestQuestionOptionRepository;
    private SocioEmotionalTestAnswerRepository socioEmotionalTestAnswerRepository;
    private ActivityRepository activityRepository;
    private ActivityTypeRepository activityTypeRepository;
    private List<Integer> ages = Arrays.asList(4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19);

    public DashboardController(SocioEmotionalTestResultRepository socioEmotionalTestResultRepository, LessonRecordRepository lessonRecordRepository, LessonRepository lessonRepository, TestResultGradeRepository testResultGradeRepository, TestResultRepository testResultRepository, AnswerRepository answerRepository, TestRepository testRepository, QuestionRepository questionRepository, CorrectAnswerRepository correctAnswerRepository, MultipleChoiceOptionRepository multipleChoiceOptionRepository, ClassRepository classRepository, DailyAppreciationRepository dailyAppreciationRepository, MoodUpdateRepository moodUpdateRepository, QuoteRepository qouteRepository, WallPostRepository wallPostRepository, WallPostAttachmentRepository wallPostAttachmentRepository, WallPostRequestRepository wallPostRequestRepository, AvatarRepository avatarRepository, InstructorRepository instructorRepository, StudentRepository studentRepository, AccountRepository accountRepository, GradeRepository gradeRepository, StandardRepository standardRepository, SocioEmotionalTestQuestionTypeRepository socioEmotionalTestQuestionTypeRepository, SocioEmotionalTestQuestionRepository socioEmotionalTestQuestionRepository, SocioEmotionalTestQuestionOptionRepository socioEmotionalTestQuestionOptionRepository, SocioEmotionalTestAnswerRepository socioEmotionalTestAnswerRepository, ActivityRepository activityRepository, ActivityTypeRepository activityTypeRepository, BCryptPasswordEncoder bCryptPasswordEncoder) {
        this.socioEmotionalTestResultRepository = socioEmotionalTestResultRepository;
        this.lessonRecordRepository = lessonRecordRepository;
        this.testResultRepository = testResultRepository;
        this.answerRepository = answerRepository;
        this.testRepository = testRepository;
        this.lessonRepository = lessonRepository;
        this.questionRepository = questionRepository;
        this.correctAnswerRepository = correctAnswerRepository;
        this.multipleChoiceOptionRepository = multipleChoiceOptionRepository;
        this.testResultGradeRepository = testResultGradeRepository;
        this.gradeRepository = gradeRepository;
        this.standardRepository = standardRepository;
        this.classRepository = classRepository;
        this.qouteRepository = qouteRepository;
        this.wallPostRepository = wallPostRepository;
        this.wallPostAttachmentRepository = wallPostAttachmentRepository;
        this.wallPostRequestRepository = wallPostRequestRepository;
        this.avatarRepository = avatarRepository;
        this.bCryptPasswordEncoder = bCryptPasswordEncoder;
        this.instructorRepository = instructorRepository;
        this.studentRepository = studentRepository;
        this.accountRepository = accountRepository;
        this.moodUpdateRepository = moodUpdateRepository;
        this.dailyAppreciationRepository = dailyAppreciationRepository;
        this.socioEmotionalTestQuestionTypeRepository = socioEmotionalTestQuestionTypeRepository;
        this.socioEmotionalTestQuestionRepository = socioEmotionalTestQuestionRepository;
        this.socioEmotionalTestQuestionOptionRepository = socioEmotionalTestQuestionOptionRepository;
        this.socioEmotionalTestAnswerRepository = socioEmotionalTestAnswerRepository;
        this.activityRepository = activityRepository;
        this.activityTypeRepository = activityTypeRepository;
    }

    @GetMapping(value={"/get/dropDownsForAnalyticsData"})
    public ResponseEntity<DropDownsForAnalyticsDataWrapper> getDropDownsForAnalyticsData() {
        return new ResponseEntity((Object)this.getDropDownsForAnalyticsDataWrapper(), HttpStatus.OK);
    }

    @PostMapping(value={"/get/socioEmotionalDataAnalytics"})
    public ResponseEntity<Object> getSocioEmotionalDataAnalytics(@RequestBody GetDataDashBoardRequest request) {
        if (request.getToDate() != null) {
            Calendar cal = Calendar.getInstance();
            cal.setTime(request.getFromDate());
            cal.set(11, 0);
            cal.set(12, 0);
            cal.set(13, 0);
            cal.set(14, 0);
            Date fromDate = cal.getTime();
            request.setFromDate(fromDate);
            cal.setTime(request.getToDate());
            cal.set(11, 23);
            cal.set(12, 59);
            cal.set(13, 59);
            cal.set(14, 999);
            Date toDate = cal.getTime();
            request.setToDate(toDate);
        }
        switch (1.$SwitchMap$com$infinite$focus$server$dashboard$GraphType[request.getGraphType().ordinal()]) {
            case 1: {
                return new ResponseEntity((Object)this.userStatsService.getOverall(request), HttpStatus.OK);
            }
            case 2: {
                return new ResponseEntity((Object)this.userStatsService.getTeachers(request), HttpStatus.OK);
            }
            case 3: {
                return new ResponseEntity((Object)this.userStatsService.getStudents(this.getDefaultGetDataDashBoardRequest(request)), HttpStatus.OK);
            }
            case 4: {
                GetDataDashBoardRequest defaultRequest = this.getDefaultGetDataDashBoardRequest(request);
                return new ResponseEntity((Object)this.userStatsService.getStudentsAndDemographicStrands(defaultRequest), HttpStatus.OK);
            }
            case 5: {
                return new ResponseEntity((Object)this.userStatsService.getLogiAttemptsStudentsData(request), HttpStatus.OK);
            }
            case 6: {
                LinkedHashMap graphData = this.userStatsService.getLogiAttemptsTeachersData(this.getDefaultGetDataDashBoardRequest(request));
                return new ResponseEntity((Object)this.getLabelsAndDatasets(request, graphData), HttpStatus.OK);
            }
            case 7: {
                return new ResponseEntity((Object)this.userStatsService.getAverageLoginAttemptTeachers(this.getDefaultGetDataDashBoardRequest(request)), HttpStatus.OK);
            }
            case 8: {
                return new ResponseEntity((Object)this.userStatsService.getPercentageByGrades(this.getDefaultGetDataDashBoardRequest(request)), HttpStatus.OK);
            }
            case 9: {
                return new ResponseEntity((Object)this.statsService.getTimeSpentByStudents(this.getDefaultGetDataDashBoardRequest(request)), HttpStatus.OK);
            }
            case 10: {
                return new ResponseEntity((Object)this.statsService.getTimeSpentByTeachers(this.getDefaultGetDataDashBoardRequest(request)), HttpStatus.OK);
            }
            case 11: {
                LinkedHashMap graphData = this.statsService.getTimeSpentByDemographicsData(request);
                return new ResponseEntity((Object)this.getLabelsAndDatasets(request, graphData), HttpStatus.OK);
            }
            case 12: {
                GetDataDashBoardRequest defaultRequest = this.getDefaultGetDataDashBoardRequest(request);
                return new ResponseEntity((Object)this.statsService.getTimeSpentByDemographicData(defaultRequest), HttpStatus.OK);
            }
            case 13: {
                LinkedHashMap graphData = this.statsService.getTimeSpentByGradesData(this.getDefaultGetDataDashBoardRequest(request));
                return new ResponseEntity((Object)this.getLabelsAndDatasets(request, graphData), HttpStatus.OK);
            }
            case 14: {
                return new ResponseEntity((Object)this.statsService.getTimeSpentByGradeData(this.getDefaultGetDataDashBoardRequest(request)), HttpStatus.OK);
            }
            case 15: {
                return new ResponseEntity(this.statsService.getVideoViewList(request), HttpStatus.OK);
            }
            case 16: {
                return new ResponseEntity((Object)this.statsService.getVideosDemographicData(request), HttpStatus.OK);
            }
            case 17: {
                return new ResponseEntity((Object)this.socioEmotionalAssessmentService.getSELStrandsGraphData(request), HttpStatus.OK);
            }
            case 18: {
                LinkedHashMap graphData = this.socioEmotionalAssessmentService.getSingleDemographicComparisonGraphData(request);
                return new ResponseEntity((Object)this.getLabelsAndDatasets(request, graphData), HttpStatus.OK);
            }
            case 19: {
                LinkedHashMap graphData = this.socioEmotionalAssessmentService.getDemographicComparisonGraphData(request);
                return new ResponseEntity((Object)this.getLabelsAndDatasets(request, graphData), HttpStatus.OK);
            }
            case 20: {
                return new ResponseEntity((Object)this.socioEmotionalAssessmentService.getTimeSpentAndSELStrandsGraphData(request), HttpStatus.OK);
            }
            case 21: {
                return new ResponseEntity((Object)this.moodDataService.getSelfReportingData(this.getDefaultGetDataDashBoardRequest(request)), HttpStatus.OK);
            }
            case 22: {
                return new ResponseEntity((Object)this.moodDataService.getMoodUpdateDemographicComparisonGraphData(request), HttpStatus.OK);
            }
            case 23: {
                return new ResponseEntity((Object)this.moodDataService.getMoodAnalysisGraphData(request), HttpStatus.OK);
            }
            case 24: {
                return new ResponseEntity((Object)this.moodDataService.getMostAndLeastReportedData(this.getDefaultGetDataDashBoardRequest(request)), HttpStatus.OK);
            }
            case 25: {
                return new ResponseEntity((Object)this.moodDataService.getMoodAnalysisAndCompetencyScoreGraphData(request), HttpStatus.OK);
            }
            case 26: {
                return new ResponseEntity((Object)this.featuresService.getByStudentsDemographicsData(this.getDefaultGetDataDashBoardRequest(request)), HttpStatus.OK);
            }
            case 27: {
                return new ResponseEntity((Object)this.featuresService.getByTeachersGradesData(this.getDefaultGetDataDashBoardRequest(request)), HttpStatus.OK);
            }
            case 28: {
                return new ResponseEntity((Object)this.moodDataService.getMoodInsightByInstructerId(request), HttpStatus.OK);
            }
            case 29: {
                return new ResponseEntity((Object)this.userStatsService.getPercentageByOSForStudent(request), HttpStatus.OK);
            }
            case 30: {
                return new ResponseEntity((Object)this.userStatsService.getPercentageByBrowserForStudent(request), HttpStatus.OK);
            }
            case 31: {
                return new ResponseEntity((Object)this.userStatsService.getPercentageByOSForInstructor(request), HttpStatus.OK);
            }
            case 32: {
                return new ResponseEntity((Object)this.userStatsService.getPercentageByBrowserForInstructor(request), HttpStatus.OK);
            }
            case 33: {
                return new ResponseEntity((Object)this.featuresService.getPagePerformanceAnalyticsOrderByScreenId(), HttpStatus.OK);
            }
        }
        return new ResponseEntity(new Object(), HttpStatus.OK);
    }

    private LabelsAndDatasets getLabelsAndDatasets(GetDataDashBoardRequest request, LinkedHashMap<String, List<LabelAndValue>> graphData) {
        LabelsAndDatasets labelsAndDatasets = new LabelsAndDatasets();
        LinkedList labels = new LinkedList();
        labels.addAll(DateUtils.getLabelsByTimeLine((TimeLine)request.getTimeLine()));
        labelsAndDatasets.setLabels(labels);
        LinkedList<LabelAndData> dataset = new LinkedList<LabelAndData>();
        for (String key : graphData.keySet()) {
            List<LabelAndValue> values = graphData.get(key);
            LinkedList<Double> data = new LinkedList<Double>();
            if (AppUtils.isNotNullOrEmpty(values)) {
                for (int i = 0; i < values.size(); ++i) {
                    data.add(DigitUtils.formatDoubleInTwoDigit((Double)values.get(i).getValue()));
                }
            }
            LabelAndData labelAndData = new LabelAndData(key, data);
            dataset.add(labelAndData);
        }
        labelsAndDatasets.setDataset(dataset);
        return labelsAndDatasets;
    }

    private GetDataDashBoardRequest getDefaultGetDataDashBoardRequest(GetDataDashBoardRequest request) {
        DropDownsForAnalyticsDataWrapper dropDownsForAnalyticsDataWrapper = this.getDropDownsForAnalyticsDataWrapper();
        request.setGenders(dropDownsForAnalyticsDataWrapper.getGenders());
        request.setAges(this.ages);
        request.setEthnicity(dropDownsForAnalyticsDataWrapper.getEthnicity());
        for (Grade grade : dropDownsForAnalyticsDataWrapper.getGrades()) {
            request.getGradeIds().add(grade.getGrade_id());
        }
        for (Class class_ : dropDownsForAnalyticsDataWrapper.getClasses()) {
            request.getClassIds().add(class_.getClass_id());
        }
        return request;
    }

    private DropDownsForAnalyticsDataWrapper getDropDownsForAnalyticsDataWrapper() {
        DropDownsForAnalyticsDataWrapper dropDownsForAnalyticsDataWrapper = new DropDownsForAnalyticsDataWrapper();
        dropDownsForAnalyticsDataWrapper.setQuestion_types(this.socioEmotionalTestQuestionTypeRepository.findAll());
        dropDownsForAnalyticsDataWrapper.setGrades(this.gradeRepository.findAll());
        ArrayList<Class> classes = new ArrayList<Class>();
        for (Class class_ : this.classRepository.findAll()) {
            Class newClass = new Class();
            newClass.setClass_id(class_.getClass_id());
            newClass.setClass_name(class_.getClass_name());
            newClass.setInstructor_id(class_.getInstructor_id());
            newClass.setCreatedAt(class_.getCreatedAt());
            classes.add(newClass);
        }
        if (AppUtils.isNotNullOrEmpty(classes)) {
            for (int i = 0; i < classes.size(); ++i) {
                Instructor instructor = (Instructor)this.instructorRepository.getOne((Object)((Class)classes.get(i)).getInstructor_id());
                ((Class)classes.get(i)).setClass_name(((Class)classes.get(i)).getClass_name().trim() + " (" + instructor.getFirst_name().trim() + " " + instructor.getLast_name().trim() + ")");
            }
        }
        dropDownsForAnalyticsDataWrapper.setClasses(classes);
        return dropDownsForAnalyticsDataWrapper;
    }

    public static String getClassNameWithInstructorFullName(Long class_id, ClassRepository classRepository, InstructorRepository instructorRepository) {
        Class class_ = (Class)classRepository.getOne((Object)class_id);
        Instructor instructor = (Instructor)instructorRepository.getOne((Object)class_.getInstructor_id());
        String class_name = class_.getClass_name().trim() + " (" + instructor.getFirst_name().trim() + " " + instructor.getLast_name().trim() + ")";
        return class_name;
    }
}

