/*
 * Decompiled with CFR 0.152.
 */
package com.infinite.focus.server.dashboard.features;

import com.infinite.focus.server.activity.Activity;
import com.infinite.focus.server.activity.ActivityRepository;
import com.infinite.focus.server.activity.screen.Screen;
import com.infinite.focus.server.activity.screen.ScreenRepository;
import com.infinite.focus.server.activity.service.ActivityService;
import com.infinite.focus.server.auth.AccountRepository;
import com.infinite.focus.server.auth.InstructorRepository;
import com.infinite.focus.server.auth.StudentRepository;
import com.infinite.focus.server.dashboard.DashboardController;
import com.infinite.focus.server.dashboard.GetDataDashBoardRequest;
import com.infinite.focus.server.dashboard.features.FeatureAndTime;
import com.infinite.focus.server.dashboard.features.FeaturesService;
import com.infinite.focus.server.dashboard.features.PageAndPerformance;
import com.infinite.focus.server.grade.Grade;
import com.infinite.focus.server.grade.GradeRepository;
import com.infinite.focus.server.standard.StandardRepository;
import com.infinite.focus.server.students.ClassRepository;
import com.infinite.focus.server.students.service.StudentService;
import com.infinite.focus.server.utils.AppUtils;
import com.infinite.focus.server.utils.TimeUtils;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import javax.persistence.EntityManager;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class FeaturesServiceImpl
implements FeaturesService {
    @Autowired
    EntityManager entityManager;
    @Autowired
    AccountRepository accountRepository;
    @Autowired
    GradeRepository gradeRepository;
    @Autowired
    StandardRepository standardRepository;
    @Autowired
    StudentRepository studentRepository;
    @Autowired
    InstructorRepository instructorRepository;
    @Autowired
    ClassRepository classRepository;
    @Autowired
    ActivityRepository activityRepository;
    @Autowired
    ActivityService activityService;
    @Autowired
    StudentService studentService;
    @Autowired
    ScreenRepository screenRepository;
    String forwardSlash = "/";

    public LinkedHashMap<String, LinkedHashMap<String, LinkedList<String>>> getByStudentsDemographicsData(GetDataDashBoardRequest request) {
        GetDataDashBoardRequest getDataDashBoardRequest;
        LinkedHashMap<String, LinkedHashMap<String, LinkedList<String>>> graphData = new LinkedHashMap<String, LinkedHashMap<String, LinkedList<String>>>();
        System.out.println("----------------------------- Gender ------------------------------");
        if (AppUtils.isNotNullOrEmpty((List)request.getGenders())) {
            LinkedHashMap<String, LinkedList> genderMap = new LinkedHashMap<String, LinkedList>();
            for (String gender : request.getGenders()) {
                System.out.println("-----------------------------" + gender + "------------------------------");
                getDataDashBoardRequest = this.getGetDataDashBoardRequestWithReqeuest(request);
                getDataDashBoardRequest.getGenders().add(gender);
                genderMap.put(gender, this.getFeatureAndTimeMostAndLeast(this.activityService.getAllStudentActivitiesByActivityType(getDataDashBoardRequest, Long.valueOf(3L))));
            }
            graphData.put("Gender", genderMap);
        }
        System.out.println("----------------------------- Age ------------------------------");
        if (AppUtils.isNotNullOrEmpty((List)request.getAges())) {
            LinkedHashMap<String, LinkedList> ageMap = new LinkedHashMap<String, LinkedList>();
            for (Integer age : request.getAges()) {
                System.out.println("-----------------------------" + age + "------------------------------");
                getDataDashBoardRequest = this.getGetDataDashBoardRequestWithReqeuest(request);
                getDataDashBoardRequest.getAges().add(age);
                ageMap.put(String.valueOf(age), this.getFeatureAndTimeMostAndLeast(this.activityService.getAllStudentActivitiesByActivityType(getDataDashBoardRequest, Long.valueOf(3L))));
            }
            graphData.put("Age", ageMap);
        }
        System.out.println("---------------------------- Ethnicity ------------------------------");
        if (AppUtils.isNotNullOrEmpty((List)request.getEthnicity())) {
            LinkedHashMap<String, LinkedList> ethnicityMap = new LinkedHashMap<String, LinkedList>();
            for (String ethnicity : request.getEthnicity()) {
                System.out.println("-----------------------------" + ethnicity + "------------------------------");
                getDataDashBoardRequest = this.getGetDataDashBoardRequestWithReqeuest(request);
                getDataDashBoardRequest.getEthnicity().add(ethnicity);
                ethnicityMap.put(ethnicity, this.getFeatureAndTimeMostAndLeast(this.activityService.getAllStudentActivitiesByActivityType(getDataDashBoardRequest, Long.valueOf(3L))));
            }
            graphData.put("Ethnicity", ethnicityMap);
        }
        System.out.println("----------------------------- Grade ------------------------------");
        if (AppUtils.isNotNullOrEmpty((List)request.getGradeIds())) {
            LinkedHashMap<String, LinkedList> gradeMap = new LinkedHashMap<String, LinkedList>();
            for (Long grade_id : request.getGradeIds()) {
                System.out.println("-----------------------------" + grade_id + "------------------------------");
                getDataDashBoardRequest = this.getGetDataDashBoardRequestWithReqeuest(request);
                getDataDashBoardRequest.getGradeIds().add(grade_id);
                gradeMap.put(((Grade)this.gradeRepository.getOne((Object)grade_id)).getGrade_name(), this.getFeatureAndTimeMostAndLeast(this.activityService.getAllStudentActivitiesByActivityType(getDataDashBoardRequest, Long.valueOf(3L))));
            }
            graphData.put("Grade", gradeMap);
        }
        System.out.println("----------------------------- Class ------------------------------");
        if (AppUtils.isNotNullOrEmpty((List)request.getClassIds())) {
            LinkedHashMap<String, LinkedList> classroomMap = new LinkedHashMap<String, LinkedList>();
            for (Long class_id : request.getClassIds()) {
                System.out.println("-----------------------------" + class_id + "------------------------------");
                getDataDashBoardRequest = this.getGetDataDashBoardRequestWithReqeuest(request);
                getDataDashBoardRequest.getClassIds().add(class_id);
                classroomMap.put(DashboardController.getClassNameWithInstructorFullName((Long)class_id, (ClassRepository)this.classRepository, (InstructorRepository)this.instructorRepository), this.getFeatureAndTimeMostAndLeast(this.activityService.getAllStudentActivitiesByActivityType(getDataDashBoardRequest, Long.valueOf(3L))));
            }
            graphData.put("Classroom", classroomMap);
        }
        System.out.println("----------------------------- Overall ------------------------------");
        GetDataDashBoardRequest getDataDashBoardRequest2 = this.getGetDataDashBoardRequestWithReqeuest(request);
        LinkedHashMap<String, LinkedList> overall = new LinkedHashMap<String, LinkedList>();
        overall.put("Overall", this.getFeatureAndTimeMostAndLeast(this.activityService.getAllStudentActivitiesByActivityType(getDataDashBoardRequest2, Long.valueOf(3L))));
        graphData.put("Overall", overall);
        return graphData;
    }

    public LinkedList<String> getFeatureAndTimeMostAndLeast(List<Activity> activities) {
        LinkedHashMap<Long, Long> featuresMap = new LinkedHashMap<Long, Long>();
        for (int i = 0; i < activities.size(); ++i) {
            Activity activity = activities.get(i);
            long key = activity.getEntity_id();
            long differnce = activity.getEnd_date_time().getTime() - activity.getStart_date_time().getTime();
            if (featuresMap.containsKey(key)) {
                long appUsedTime = differnce + (Long)featuresMap.get(key);
                featuresMap.put(key, appUsedTime);
                continue;
            }
            featuresMap.put(key, differnce);
        }
        LinkedList<FeatureAndTime> featureAndTimeList = new LinkedList<FeatureAndTime>();
        for (Long key : featuresMap.keySet()) {
            FeatureAndTime featureAndTime = new FeatureAndTime();
            featureAndTime.setFeature(((Screen)this.screenRepository.getOne((Object)key)).getName());
            featureAndTime.setTime((Long)featuresMap.get(key));
            featureAndTimeList.add(featureAndTime);
        }
        Collections.sort(featureAndTimeList, new /* Unavailable Anonymous Inner Class!! */);
        LinkedList<String> mostAndLeast = new LinkedList<String>();
        if (AppUtils.isNotNullOrEmpty(featureAndTimeList)) {
            FeatureAndTime most = (FeatureAndTime)featureAndTimeList.get(0);
            FeatureAndTime least = (FeatureAndTime)featureAndTimeList.get(featureAndTimeList.size() - 1);
            mostAndLeast.add(most.getFeature() + " (" + TimeUtils.getTimeInString((long)most.getTime()) + ")");
            mostAndLeast.add(least.getFeature() + " (" + TimeUtils.getTimeInString((long)least.getTime()) + ")");
        } else {
            mostAndLeast.add("");
            mostAndLeast.add("");
        }
        return mostAndLeast;
    }

    public LinkedHashMap<String, LinkedHashMap<String, LinkedList<String>>> getByTeachersGradesData(GetDataDashBoardRequest request) {
        LinkedHashMap<String, LinkedHashMap<String, LinkedList<String>>> graphData = new LinkedHashMap<String, LinkedHashMap<String, LinkedList<String>>>();
        System.out.println("----------------------------- Grade ------------------------------");
        if (AppUtils.isNotNullOrEmpty((List)request.getGradeIds())) {
            LinkedHashMap<String, LinkedList> gradeMap = new LinkedHashMap<String, LinkedList>();
            for (Long grade_id : request.getGradeIds()) {
                System.out.println("-----------------------------" + grade_id + "------------------------------");
                GetDataDashBoardRequest getDataDashBoardRequest = this.getGetDataDashBoardRequestWithReqeuest(request);
                getDataDashBoardRequest.getGradeIds().add(grade_id);
                gradeMap.put(((Grade)this.gradeRepository.getOne((Object)grade_id)).getGrade_name(), this.getFeatureAndTimeMostAndLeast(this.activityService.getAllInstructorActivitiesByActivityType(getDataDashBoardRequest, Long.valueOf(3L))));
            }
            graphData.put("Grade", gradeMap);
        }
        System.out.println("----------------------------- Overall ------------------------------");
        GetDataDashBoardRequest getDataDashBoardRequest = this.getGetDataDashBoardRequestWithReqeuest(request);
        LinkedHashMap<String, LinkedList> overall = new LinkedHashMap<String, LinkedList>();
        overall.put("Overall", this.getFeatureAndTimeMostAndLeast(this.activityService.getAllInstructorActivitiesByActivityType(getDataDashBoardRequest, Long.valueOf(3L))));
        graphData.put("Overall", overall);
        return graphData;
    }

    private GetDataDashBoardRequest getGetDataDashBoardRequestWithReqeuest(GetDataDashBoardRequest request) {
        GetDataDashBoardRequest getDataDashBoardRequest = new GetDataDashBoardRequest();
        getDataDashBoardRequest.setTimeLine(request.getTimeLine());
        getDataDashBoardRequest.setSocio_emotional_test_question_type_id(request.getSocio_emotional_test_question_type_id());
        getDataDashBoardRequest.setGraphType(request.getGraphType());
        getDataDashBoardRequest.setFromDate(request.getFromDate());
        getDataDashBoardRequest.setToDate(request.getToDate());
        return getDataDashBoardRequest;
    }

    public LinkedList<PageAndPerformance> getPagePerformanceAnalyticsOrderByScreenId() {
        List pageAndPerformanceResult = this.activityRepository.getPagePerformanceAnalyticsOrderByScreenId();
        LinkedList<PageAndPerformance> pageAndPerformanceList = new LinkedList<PageAndPerformance>();
        for (Object[] item : pageAndPerformanceResult) {
            PageAndPerformance pageAndPerformance = new PageAndPerformance();
            pageAndPerformance.setPage_name(item[1]);
            pageAndPerformance.setViews(item[2]);
            pageAndPerformance.setAvg_time(item[5]);
            pageAndPerformanceList.add(pageAndPerformance);
        }
        return pageAndPerformanceList;
    }
}

