/*
 * Decompiled with CFR 0.152.
 */
package com.infinite.focus.server.dashboard.mooddata;

import com.infinite.focus.server.activity.Activity;
import com.infinite.focus.server.activity.service.ActivityService;
import com.infinite.focus.server.auth.InstructorRepository;
import com.infinite.focus.server.auth.Student;
import com.infinite.focus.server.auth.StudentRepository;
import com.infinite.focus.server.dashboard.DashboardController;
import com.infinite.focus.server.dashboard.GetDataDashBoardRequest;
import com.infinite.focus.server.dashboard.LabelAndValue;
import com.infinite.focus.server.dashboard.MoodInsight;
import com.infinite.focus.server.dashboard.MoodOccuranceAndCompetencyScore;
import com.infinite.focus.server.dashboard.mooddata.MoodDataService;
import com.infinite.focus.server.data.MoodOccurance;
import com.infinite.focus.server.grade.Grade;
import com.infinite.focus.server.grade.GradeRepository;
import com.infinite.focus.server.home.MoodUpdate;
import com.infinite.focus.server.home.MoodUpdateRepository;
import com.infinite.focus.server.lessons.Lesson;
import com.infinite.focus.server.lessons.LessonRepository;
import com.infinite.focus.server.standard.StandardRepository;
import com.infinite.focus.server.students.ClassRepository;
import com.infinite.focus.server.students.service.StudentService;
import com.infinite.focus.server.tests.SocioEmotionalTestAnswer;
import com.infinite.focus.server.tests.SocioEmotionalTestAnswerRepository;
import com.infinite.focus.server.tests.SocioEmotionalTestDataWrapper;
import com.infinite.focus.server.tests.SocioEmotionalTestQuestion;
import com.infinite.focus.server.tests.SocioEmotionalTestQuestionOption;
import com.infinite.focus.server.tests.SocioEmotionalTestQuestionOptionRepository;
import com.infinite.focus.server.tests.SocioEmotionalTestQuestionRepository;
import com.infinite.focus.server.tests.SocioEmotionalTestResult;
import com.infinite.focus.server.utils.AppUtils;
import com.infinite.focus.server.utils.DateUtils;
import com.infinite.focus.server.utils.DigitUtils;
import com.infinite.focus.server.utils.MoodUpdateUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Order;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MoodDataServiceImpl
implements MoodDataService {
    @Autowired
    EntityManager entityManager;
    @Autowired
    SocioEmotionalTestQuestionOptionRepository socioEmotionalTestQuestionOptionRepository;
    @Autowired
    SocioEmotionalTestQuestionRepository socioEmotionalTestQuestionRepository;
    @Autowired
    SocioEmotionalTestAnswerRepository socioEmotionalTestAnswerRepository;
    @Autowired
    GradeRepository gradeRepository;
    @Autowired
    StandardRepository standardRepository;
    @Autowired
    StudentRepository studentRepository;
    @Autowired
    StudentService studentService;
    @Autowired
    InstructorRepository instructorRepository;
    @Autowired
    ClassRepository classRepository;
    @Autowired
    MoodUpdateRepository moodUpdateRepository;
    @Autowired
    LessonRepository lessonRepository;
    @Autowired
    ActivityService activityService;
    String forwardSlash = "/";

    public LinkedHashMap<String, LinkedHashMap<String, LinkedList<Double>>> getSelfReportingData(GetDataDashBoardRequest request) {
        GetDataDashBoardRequest getDataDashBoardRequest;
        GetDataDashBoardRequest getDataDashBoardRequest2;
        List students = this.studentRepository.findAllOrderById();
        System.out.println("Students - " + students.size());
        Date fromDate = AppUtils.isNullOrEmpty((List)students) ? DateUtils.setTimeToFromDate((Date)new Date()) : DateUtils.setTimeToFromDate((Date)((Student)students.get(0)).getAccount().getCreatedAt());
        Date toDate = DateUtils.setTimeToToDate((Date)new Date());
        LinkedHashMap<String, LinkedHashMap<String, LinkedList<Double>>> graphData = new LinkedHashMap<String, LinkedHashMap<String, LinkedList<Double>>>();
        System.out.println("----------------------------- Gender------------------------------");
        if (AppUtils.isNotNullOrEmpty((List)request.getGenders())) {
            LinkedHashMap<String, LinkedList> genders = new LinkedHashMap<String, LinkedList>();
            for (String gender : request.getGenders()) {
                System.out.println("----------------------------- " + gender + "------------------------------");
                getDataDashBoardRequest2 = this.getGetDataDashBoardRequestWithReqeuest(request);
                getDataDashBoardRequest2.getGenders().add(gender);
                genders.put(gender, this.getSelfReporting(getDataDashBoardRequest2, fromDate, toDate));
            }
            graphData.put("Gender", genders);
        }
        System.out.println("----------------------------- Age ------------------------------");
        if (AppUtils.isNotNullOrEmpty((List)request.getAges())) {
            LinkedHashMap<String, LinkedList> ages = new LinkedHashMap<String, LinkedList>();
            for (Integer age : request.getAges()) {
                System.out.println("----------------------------- " + age + "------------------------------");
                getDataDashBoardRequest2 = this.getGetDataDashBoardRequestWithReqeuest(request);
                getDataDashBoardRequest2.getAges().add(age);
                ages.put(String.valueOf(age), this.getSelfReporting(getDataDashBoardRequest2, fromDate, toDate));
            }
            graphData.put("Age", ages);
        }
        System.out.println("----------------------------- Ethnicity------------------------------");
        if (AppUtils.isNotNullOrEmpty((List)request.getEthnicity())) {
            LinkedHashMap<String, LinkedList> ethnicityMap = new LinkedHashMap<String, LinkedList>();
            for (String ethnicity : request.getEthnicity()) {
                System.out.println("----------------------------- " + ethnicity + "------------------------------");
                getDataDashBoardRequest2 = this.getGetDataDashBoardRequestWithReqeuest(request);
                getDataDashBoardRequest2.getEthnicity().add(ethnicity);
                ethnicityMap.put(ethnicity, this.getSelfReporting(getDataDashBoardRequest2, fromDate, toDate));
            }
            graphData.put("Ethnicity", ethnicityMap);
        }
        System.out.println("----------------------------- Grade------------------------------");
        if (AppUtils.isNotNullOrEmpty((List)request.getGradeIds())) {
            LinkedHashMap<String, LinkedList> grades = new LinkedHashMap<String, LinkedList>();
            for (Long grade_id : request.getGradeIds()) {
                String grade_name = ((Grade)this.gradeRepository.getOne((Object)grade_id)).getGrade_name();
                System.out.println("-----------------------------" + grade_id + " -> " + grade_name + "------------------------------");
                getDataDashBoardRequest = this.getGetDataDashBoardRequestWithReqeuest(request);
                getDataDashBoardRequest.getGradeIds().add(grade_id);
                grades.put(grade_name, this.getSelfReporting(getDataDashBoardRequest, fromDate, toDate));
            }
            graphData.put("Grade", grades);
        }
        System.out.println("----------------------------- Classroom ------------------------------");
        if (AppUtils.isNotNullOrEmpty((List)request.getClassIds())) {
            LinkedHashMap<String, LinkedList> classrooms = new LinkedHashMap<String, LinkedList>();
            for (Long class_id : request.getClassIds()) {
                String class_name = DashboardController.getClassNameWithInstructorFullName((Long)class_id, (ClassRepository)this.classRepository, (InstructorRepository)this.instructorRepository);
                System.out.println("-----------------------------" + class_id + " -> " + class_name + "------------------------------");
                getDataDashBoardRequest = this.getGetDataDashBoardRequestWithReqeuest(request);
                getDataDashBoardRequest.getClassIds().add(class_id);
                classrooms.put(class_name, this.getSelfReporting(getDataDashBoardRequest, fromDate, toDate));
            }
            graphData.put("Classroom", classrooms);
        }
        return graphData;
    }

    public LinkedList<LabelAndValue> getMoodUpdateDemographicComparisonGraphData(GetDataDashBoardRequest request) {
        List student_ids = this.studentService.getStudentByDemographics(request);
        List moodUpdateList = this.getMoodUpdateByStudentIds(student_ids, request.getFromDate(), request.getToDate());
        LinkedList moodOccurances = this.getMoodAnalysis(moodUpdateList, false);
        LinkedList<LabelAndValue> graphData = new LinkedList<LabelAndValue>();
        for (int i = 0; i < moodOccurances.size(); ++i) {
            graphData.add(new LabelAndValue(((MoodOccurance)moodOccurances.get(i)).getMood(), (double)((MoodOccurance)moodOccurances.get(i)).getCount().intValue()));
        }
        return graphData;
    }

    public LinkedHashMap<String, LinkedList<Double>> getMoodAnalysisGraphData(GetDataDashBoardRequest request) {
        System.out.println("----------------------------MOOD_ANALYSIS--------------------------------------");
        List student_ids = this.studentService.getStudentByDemographics(request);
        List moodUpdateList = this.getMoodUpdateByStudentIds(student_ids, request.getFromDate(), request.getToDate());
        LinkedList moodOccurances = this.getMoodAnalysis(moodUpdateList, false);
        Double totalCount = 0.0;
        for (int i = 0; i < moodOccurances.size(); ++i) {
            totalCount = totalCount + (double)((MoodOccurance)moodOccurances.get(i)).getCount().intValue();
            System.out.println(((MoodOccurance)moodOccurances.get(i)).getMood() + " - " + ((MoodOccurance)moodOccurances.get(i)).getCount());
        }
        System.out.println("-------------------------------------------------------------------");
        System.out.println("Total occournce " + totalCount);
        String forwordSlash = "/";
        System.out.println("------------------------Percentage = (Value " + forwordSlash + " Total Value) \ufffd 100-------------------------------------------");
        LinkedHashMap<String, LinkedList<Double>> graphData = new LinkedHashMap<String, LinkedList<Double>>();
        double percentageTotal = 0.0;
        for (int i = 0; i < moodOccurances.size(); ++i) {
            LinkedList<Double> list = new LinkedList<Double>();
            String mood = ((MoodOccurance)moodOccurances.get(i)).getMood();
            Double count = (double)((MoodOccurance)moodOccurances.get(i)).getCount();
            Double percentage = DigitUtils.getPercentage((Double)count, (Double)totalCount);
            percentageTotal += percentage.doubleValue();
            System.out.println(mood + "\t=\t( Value\t" + count + "\t" + forwordSlash + "\tTotal Value\t" + totalCount + " ) X 100 =\tpercentage\t" + percentage);
            list.add(DigitUtils.formatDoubleInTwoDigit((Double)count));
            list.add(DigitUtils.formatDoubleInTwoDigit((Double)percentage));
            graphData.put(((MoodOccurance)moodOccurances.get(i)).getMood(), list);
        }
        System.out.println("-----------------------------------------------------------------------------------------------------------------------------");
        System.out.println("\t\t( Value\t" + totalCount + "\t" + forwordSlash + "\tTotal Value\t" + totalCount + " ) X 100 =\tpercentage\t" + percentageTotal);
        return graphData;
    }

    public LinkedHashMap<String, LinkedHashMap<String, LinkedList<String>>> getMostAndLeastReportedData(GetDataDashBoardRequest request) {
        GetDataDashBoardRequest getDataDashBoardRequest;
        LinkedHashMap<String, LinkedHashMap<String, LinkedList<String>>> graphData = new LinkedHashMap<String, LinkedHashMap<String, LinkedList<String>>>();
        System.out.println("----------------------------- Gender ------------------------------");
        if (AppUtils.isNotNullOrEmpty((List)request.getGenders())) {
            LinkedHashMap<String, LinkedList> genderMap = new LinkedHashMap<String, LinkedList>();
            for (String gender : request.getGenders()) {
                System.out.println("-----------------------------" + gender + "------------------------------");
                getDataDashBoardRequest = this.getGetDataDashBoardRequestWithReqeuest(request);
                getDataDashBoardRequest.getGenders().add(gender);
                genderMap.put(gender, this.getMostAndLeast(getDataDashBoardRequest));
            }
            graphData.put("Gender", genderMap);
        }
        System.out.println("----------------------------- Age ------------------------------");
        if (AppUtils.isNotNullOrEmpty((List)request.getAges())) {
            LinkedHashMap<String, LinkedList> ageMap = new LinkedHashMap<String, LinkedList>();
            for (Integer age : request.getAges()) {
                System.out.println("-----------------------------" + age + "------------------------------");
                getDataDashBoardRequest = this.getGetDataDashBoardRequestWithReqeuest(request);
                getDataDashBoardRequest.getAges().add(age);
                ageMap.put(String.valueOf(age), this.getMostAndLeast(getDataDashBoardRequest));
            }
            graphData.put("Age", ageMap);
        }
        System.out.println("---------------------------- Ethnicity ------------------------------");
        if (AppUtils.isNotNullOrEmpty((List)request.getEthnicity())) {
            LinkedHashMap<String, LinkedList> ethnicityMap = new LinkedHashMap<String, LinkedList>();
            for (String ethnicity : request.getEthnicity()) {
                System.out.println("-----------------------------" + ethnicity + "------------------------------");
                getDataDashBoardRequest = this.getGetDataDashBoardRequestWithReqeuest(request);
                getDataDashBoardRequest.getEthnicity().add(ethnicity);
                ethnicityMap.put(ethnicity, this.getMostAndLeast(getDataDashBoardRequest));
            }
            graphData.put("Ethnicity", ethnicityMap);
        }
        System.out.println("----------------------------- Grade ------------------------------");
        if (AppUtils.isNotNullOrEmpty((List)request.getGradeIds())) {
            LinkedHashMap<String, LinkedList> gradeMap = new LinkedHashMap<String, LinkedList>();
            for (Long grade_id : request.getGradeIds()) {
                System.out.println("-----------------------------" + grade_id + "------------------------------");
                getDataDashBoardRequest = this.getGetDataDashBoardRequestWithReqeuest(request);
                getDataDashBoardRequest.getGradeIds().add(grade_id);
                gradeMap.put(((Grade)this.gradeRepository.getOne((Object)grade_id)).getGrade_name(), this.getMostAndLeast(getDataDashBoardRequest));
            }
            graphData.put("Grade", gradeMap);
        }
        System.out.println("----------------------------- Class ------------------------------");
        if (AppUtils.isNotNullOrEmpty((List)request.getClassIds())) {
            LinkedHashMap<String, LinkedList> classroomMap = new LinkedHashMap<String, LinkedList>();
            for (Long class_id : request.getClassIds()) {
                System.out.println("-----------------------------" + class_id + "------------------------------");
                getDataDashBoardRequest = this.getGetDataDashBoardRequestWithReqeuest(request);
                getDataDashBoardRequest.getClassIds().add(class_id);
                classroomMap.put(DashboardController.getClassNameWithInstructorFullName((Long)class_id, (ClassRepository)this.classRepository, (InstructorRepository)this.instructorRepository), this.getMostAndLeast(getDataDashBoardRequest));
            }
            graphData.put("Classroom", classroomMap);
        }
        System.out.println("----------------------------- Overall ------------------------------");
        GetDataDashBoardRequest getDataDashBoardRequest2 = this.getGetDataDashBoardRequestWithReqeuest(request);
        LinkedHashMap<String, LinkedList> overall = new LinkedHashMap<String, LinkedList>();
        overall.put("Overall", this.getMostAndLeast(getDataDashBoardRequest2));
        graphData.put("Overall", overall);
        return graphData;
    }

    public LinkedList<String> getMostAndLeast(GetDataDashBoardRequest request) {
        List student_ids = this.studentService.getStudentByDemographics(request);
        List moodUpdateList = this.getMoodUpdateByStudentIds(student_ids, request.getFromDate(), request.getToDate());
        LinkedList moodOccurances = this.removeMoodOccuranceWithZeroCountFromMoodOccuranceList(this.getMoodAnalysis(moodUpdateList, true));
        LinkedList<String> mostAndLeast = new LinkedList<String>();
        if (AppUtils.isNotNullOrEmpty((List)moodOccurances)) {
            MoodOccurance most = (MoodOccurance)moodOccurances.get(0);
            MoodOccurance least = (MoodOccurance)moodOccurances.get(moodOccurances.size() - 1);
            if (most.getCount() > 0) {
                mostAndLeast.add(most.getMood() + " ( " + most.getCount() + " ) ");
            } else {
                mostAndLeast.add(" ( " + least.getCount() + " ) ");
            }
            if (least.getCount() > 0) {
                mostAndLeast.add(least.getMood() + " ( " + least.getCount() + " ) ");
            } else {
                mostAndLeast.add(" ( " + least.getCount() + " ) ");
            }
        } else {
            mostAndLeast.add("");
            mostAndLeast.add("");
        }
        return mostAndLeast;
    }

    private LinkedList<MoodOccurance> removeMoodOccuranceWithZeroCountFromMoodOccuranceList(LinkedList<MoodOccurance> list) {
        Iterator itr = list.iterator();
        while (itr.hasNext()) {
            MoodOccurance x = (MoodOccurance)itr.next();
            if (x.getCount() != 0) continue;
            itr.remove();
        }
        return list;
    }

    public LinkedHashMap<String, LinkedHashMap<String, LinkedList<Double>>> getMoodAnalysisAndCompetencyScoreGraphData(GetDataDashBoardRequest request) {
        GetDataDashBoardRequest getDataDashBoardRequest;
        LinkedHashMap<String, LinkedHashMap<String, LinkedList<Double>>> graphData = new LinkedHashMap<String, LinkedHashMap<String, LinkedList<Double>>>();
        if (AppUtils.isNotNullOrEmpty((List)request.getGenders())) {
            getDataDashBoardRequest = this.getGetDataDashBoardRequestWithReqeuest(request);
            getDataDashBoardRequest.getGenders().addAll(request.getGenders());
            graphData.put("Gender", this.getMoodAnalysisAndCompetencyScore(getDataDashBoardRequest));
        }
        if (AppUtils.isNotNullOrEmpty((List)request.getAges())) {
            getDataDashBoardRequest = this.getGetDataDashBoardRequestWithReqeuest(request);
            getDataDashBoardRequest.getAges().addAll(request.getAges());
            graphData.put("Age", this.getMoodAnalysisAndCompetencyScore(getDataDashBoardRequest));
        }
        if (AppUtils.isNotNullOrEmpty((List)request.getEthnicity())) {
            getDataDashBoardRequest = this.getGetDataDashBoardRequestWithReqeuest(request);
            getDataDashBoardRequest.getEthnicity().addAll(request.getEthnicity());
            graphData.put("Ethnicity", this.getMoodAnalysisAndCompetencyScore(getDataDashBoardRequest));
        }
        if (AppUtils.isNotNullOrEmpty((List)request.getGradeIds())) {
            GetDataDashBoardRequest getSocioEmotionalDataAnalyticsRequest = this.getGetDataDashBoardRequestWithReqeuest(request);
            getSocioEmotionalDataAnalyticsRequest.getGradeIds().addAll(request.getGradeIds());
            graphData.put("Grade", this.getMoodAnalysisAndCompetencyScore(getSocioEmotionalDataAnalyticsRequest));
        }
        if (AppUtils.isNotNullOrEmpty((List)request.getClassIds())) {
            getDataDashBoardRequest = this.getGetDataDashBoardRequestWithReqeuest(request);
            getDataDashBoardRequest.getClassIds().addAll(request.getClassIds());
            graphData.put("Classroom", this.getMoodAnalysisAndCompetencyScore(getDataDashBoardRequest));
        }
        return graphData;
    }

    public LinkedHashMap<String, LinkedList<Double>> getMoodAnalysisAndCompetencyScore(GetDataDashBoardRequest request) {
        System.out.println("----------------------------MODD_ANALYSIS_AND_COMPETENCY_SCORE--------------------------------------");
        List student_ids = this.studentService.getStudentByDemographics(request);
        List moodUpdateList = this.getMoodUpdateByStudentIds(student_ids, request.getFromDate(), request.getToDate());
        LinkedList moodOccurances = this.getMoodAnalysisCompetencyScore(moodUpdateList, false);
        LinkedHashMap<String, LinkedList<Double>> graphData = new LinkedHashMap<String, LinkedList<Double>>();
        Long socio_emotional_test_question_type_id = request.getSocio_emotional_test_question_type_id();
        for (int i = 0; i < moodOccurances.size(); ++i) {
            if (((MoodOccuranceAndCompetencyScore)moodOccurances.get(i)).getCount() > 0 && AppUtils.isNotNullOrEmpty((LinkedHashSet)((MoodOccuranceAndCompetencyScore)moodOccurances.get(i)).getStudentIds())) {
                List values = this.getSocioEmotionalTestResultByStudentIds(((MoodOccuranceAndCompetencyScore)moodOccurances.get(i)).getStudentIds(), request.getFromDate(), request.getToDate());
                if (socio_emotional_test_question_type_id == null) {
                    if (!values.isEmpty()) {
                        Double score = 0.0;
                        for (SocioEmotionalTestResult test : values) {
                            score = score + (double)test.getScore();
                        }
                        ((MoodOccuranceAndCompetencyScore)moodOccurances.get(i)).setScore(DigitUtils.formatDoubleInTwoDigit((Double)DigitUtils.getAverage((Double)score, (Double)Double.valueOf(values.size()))));
                    }
                } else {
                    SocioEmotionalTestDataWrapper s = new SocioEmotionalTestDataWrapper();
                    s.setOptions(this.socioEmotionalTestQuestionOptionRepository.findAll());
                    s.setQuestions(this.socioEmotionalTestQuestionRepository.findBySocioEmotionalTestQuestionTypeId(socio_emotional_test_question_type_id));
                    if (!values.isEmpty()) {
                        Double score = 0.0;
                        for (SocioEmotionalTestResult test : values) {
                            Double total_score = 0.0;
                            List socioEmotionalTestAnswers = this.socioEmotionalTestAnswerRepository.findBySocioEmotionalTestResultId(Long.valueOf(test.getSocio_emotional_test_result_id()));
                            for (int q = 0; q < s.getQuestions().size(); ++q) {
                                SocioEmotionalTestQuestion socioEmotionalTestQuestion = (SocioEmotionalTestQuestion)s.getQuestions().get(q);
                                block4: for (int a = 0; a < socioEmotionalTestAnswers.size(); ++a) {
                                    if (socioEmotionalTestQuestion.getSocio_emotional_test_question_id() != ((SocioEmotionalTestAnswer)socioEmotionalTestAnswers.get(a)).getSocio_emotional_test_question_id()) continue;
                                    SocioEmotionalTestAnswer socioEmotionalTestAnswer = (SocioEmotionalTestAnswer)socioEmotionalTestAnswers.get(a);
                                    for (int o = 0; o < s.getOptions().size(); ++o) {
                                        if (socioEmotionalTestAnswer.getSocio_emotional_test_question_option_id() != ((SocioEmotionalTestQuestionOption)s.getOptions().get(o)).getSocio_emotional_test_question_option_id()) continue;
                                        SocioEmotionalTestQuestionOption socioEmotionalTestQuestionOption = (SocioEmotionalTestQuestionOption)s.getOptions().get(o);
                                        total_score = socioEmotionalTestQuestion.isReversed() ? Double.valueOf(total_score + (double)socioEmotionalTestQuestionOption.getReverse_weight()) : Double.valueOf(total_score + (double)socioEmotionalTestQuestionOption.getWeight());
                                        System.out.println("total_score = " + total_score);
                                        continue block4;
                                    }
                                }
                            }
                            score = score + total_score;
                            System.out.println("test id " + test.getSocio_emotional_test_result_id() + "  score = " + score);
                        }
                        ((MoodOccuranceAndCompetencyScore)moodOccurances.get(i)).setScore(DigitUtils.formatDoubleInTwoDigit((Double)DigitUtils.getAverage((Double)score, (Double)Double.valueOf(values.size()))));
                    }
                }
            }
            LinkedList<Double> list = new LinkedList<Double>();
            list.add(DigitUtils.formatDoubleInTwoDigit((Double)((Object)((MoodOccuranceAndCompetencyScore)moodOccurances.get(i)).getCount())));
            list.add(DigitUtils.formatDoubleInTwoDigit((Double)((MoodOccuranceAndCompetencyScore)moodOccurances.get(i)).getScore()));
            graphData.put(((MoodOccuranceAndCompetencyScore)moodOccurances.get(i)).getMood(), list);
        }
        return graphData;
    }

    public LinkedList<MoodOccuranceAndCompetencyScore> getMoodAnalysisCompetencyScore(List<MoodUpdate> moodUpdateList, boolean isSortData) {
        LinkedList<MoodOccuranceAndCompetencyScore> list = new LinkedList<MoodOccuranceAndCompetencyScore>();
        list.add(new MoodOccuranceAndCompetencyScore("happy", Integer.valueOf(0)));
        list.add(new MoodOccuranceAndCompetencyScore("angry", Integer.valueOf(0)));
        list.add(new MoodOccuranceAndCompetencyScore("sad", Integer.valueOf(0)));
        list.add(new MoodOccuranceAndCompetencyScore("mad", Integer.valueOf(0)));
        list.add(new MoodOccuranceAndCompetencyScore("scared", Integer.valueOf(0)));
        list.add(new MoodOccuranceAndCompetencyScore("annoyed", Integer.valueOf(0)));
        list.add(new MoodOccuranceAndCompetencyScore("shy", Integer.valueOf(0)));
        list.add(new MoodOccuranceAndCompetencyScore("silly", Integer.valueOf(0)));
        list.add(new MoodOccuranceAndCompetencyScore("excited", Integer.valueOf(0)));
        for (MoodUpdate m : moodUpdateList) {
            if (MoodUpdateUtils.containsMood((String)"excited", (String)m.getText())) {
                for (MoodOccuranceAndCompetencyScore o : list) {
                    if (!o.getMood().equals("excited")) continue;
                    o.setCount(Integer.valueOf(o.getCount() + 1));
                    o.getStudentIds().add(m.getStudent_id());
                }
            }
            if (MoodUpdateUtils.containsMood((String)"shy", (String)m.getText())) {
                for (MoodOccuranceAndCompetencyScore o : list) {
                    if (!o.getMood().equals("shy")) continue;
                    o.setCount(Integer.valueOf(o.getCount() + 1));
                    o.getStudentIds().add(m.getStudent_id());
                }
            }
            if (MoodUpdateUtils.containsMood((String)"mad", (String)m.getText())) {
                for (MoodOccuranceAndCompetencyScore o : list) {
                    if (!o.getMood().equals("mad")) continue;
                    o.setCount(Integer.valueOf(o.getCount() + 1));
                    o.getStudentIds().add(m.getStudent_id());
                }
            }
            if (MoodUpdateUtils.containsMood((String)"annoyed", (String)m.getText())) {
                for (MoodOccuranceAndCompetencyScore o : list) {
                    if (!o.getMood().equals("annoyed")) continue;
                    o.setCount(Integer.valueOf(o.getCount() + 1));
                    o.getStudentIds().add(m.getStudent_id());
                }
            }
            if (MoodUpdateUtils.containsMood((String)"scared", (String)m.getText())) {
                for (MoodOccuranceAndCompetencyScore o : list) {
                    if (!o.getMood().equals("scared")) continue;
                    o.setCount(Integer.valueOf(o.getCount() + 1));
                    o.getStudentIds().add(m.getStudent_id());
                }
            }
            if (MoodUpdateUtils.containsMood((String)"silly", (String)m.getText())) {
                for (MoodOccuranceAndCompetencyScore o : list) {
                    if (!o.getMood().equals("silly")) continue;
                    o.setCount(Integer.valueOf(o.getCount() + 1));
                    o.getStudentIds().add(m.getStudent_id());
                }
            }
            if (MoodUpdateUtils.containsMood((String)"happy", (String)m.getText())) {
                for (MoodOccuranceAndCompetencyScore o : list) {
                    if (!o.getMood().equals("happy")) continue;
                    o.setCount(Integer.valueOf(o.getCount() + 1));
                    o.getStudentIds().add(m.getStudent_id());
                }
            }
            if (MoodUpdateUtils.containsMood((String)"sad", (String)m.getText())) {
                for (MoodOccuranceAndCompetencyScore o : list) {
                    if (!o.getMood().equals("sad")) continue;
                    o.setCount(Integer.valueOf(o.getCount() + 1));
                    o.getStudentIds().add(m.getStudent_id());
                }
            }
            if (!MoodUpdateUtils.containsMood((String)"angry", (String)m.getText())) continue;
            for (MoodOccuranceAndCompetencyScore o : list) {
                if (!o.getMood().equals("angry")) continue;
                o.setCount(Integer.valueOf(o.getCount() + 1));
                o.getStudentIds().add(m.getStudent_id());
            }
        }
        if (isSortData) {
            Collections.sort(list, new /* Unavailable Anonymous Inner Class!! */);
        }
        return list;
    }

    public LinkedList<MoodOccurance> getMoodAnalysis(List<MoodUpdate> moodUpdateList, boolean isSortData) {
        LinkedList<MoodOccurance> list = new LinkedList<MoodOccurance>();
        list.add(new MoodOccurance("happy", Integer.valueOf(0)));
        list.add(new MoodOccurance("angry", Integer.valueOf(0)));
        list.add(new MoodOccurance("sad", Integer.valueOf(0)));
        list.add(new MoodOccurance("mad", Integer.valueOf(0)));
        list.add(new MoodOccurance("scared", Integer.valueOf(0)));
        list.add(new MoodOccurance("annoyed", Integer.valueOf(0)));
        list.add(new MoodOccurance("shy", Integer.valueOf(0)));
        list.add(new MoodOccurance("silly", Integer.valueOf(0)));
        list.add(new MoodOccurance("excited", Integer.valueOf(0)));
        for (MoodUpdate m : moodUpdateList) {
            if (MoodUpdateUtils.containsMood((String)"excited", (String)m.getText())) {
                for (MoodOccurance o : list) {
                    if (!o.getMood().equals("excited")) continue;
                    o.setCount(Integer.valueOf(o.getCount() + 1));
                }
            }
            if (MoodUpdateUtils.containsMood((String)"shy", (String)m.getText())) {
                for (MoodOccurance o : list) {
                    if (!o.getMood().equals("shy")) continue;
                    o.setCount(Integer.valueOf(o.getCount() + 1));
                }
            }
            if (MoodUpdateUtils.containsMood((String)"mad", (String)m.getText())) {
                for (MoodOccurance o : list) {
                    if (!o.getMood().equals("mad")) continue;
                    o.setCount(Integer.valueOf(o.getCount() + 1));
                }
            }
            if (MoodUpdateUtils.containsMood((String)"annoyed", (String)m.getText())) {
                for (MoodOccurance o : list) {
                    if (!o.getMood().equals("annoyed")) continue;
                    o.setCount(Integer.valueOf(o.getCount() + 1));
                }
            }
            if (MoodUpdateUtils.containsMood((String)"scared", (String)m.getText())) {
                for (MoodOccurance o : list) {
                    if (!o.getMood().equals("scared")) continue;
                    o.setCount(Integer.valueOf(o.getCount() + 1));
                }
            }
            if (MoodUpdateUtils.containsMood((String)"silly", (String)m.getText())) {
                for (MoodOccurance o : list) {
                    if (!o.getMood().equals("silly")) continue;
                    o.setCount(Integer.valueOf(o.getCount() + 1));
                }
            }
            if (MoodUpdateUtils.containsMood((String)"happy", (String)m.getText())) {
                for (MoodOccurance o : list) {
                    if (!o.getMood().equals("happy")) continue;
                    o.setCount(Integer.valueOf(o.getCount() + 1));
                }
            }
            if (MoodUpdateUtils.containsMood((String)"sad", (String)m.getText())) {
                for (MoodOccurance o : list) {
                    if (!o.getMood().equals("sad")) continue;
                    o.setCount(Integer.valueOf(o.getCount() + 1));
                }
            }
            if (!MoodUpdateUtils.containsMood((String)"angry", (String)m.getText())) continue;
            for (MoodOccurance o : list) {
                if (!o.getMood().equals("angry")) continue;
                o.setCount(Integer.valueOf(o.getCount() + 1));
            }
        }
        if (isSortData) {
            Collections.sort(list, new /* Unavailable Anonymous Inner Class!! */);
        }
        return list;
    }

    public LinkedList<Double> getSelfReporting(GetDataDashBoardRequest request, Date fromDate, Date toDate) {
        List student_ids = this.studentService.getStudentByDemographics(request);
        List moodUpdateList = this.getMoodUpdateByStudentIds(student_ids, null, null);
        LinkedList<Double> reportings = new LinkedList<Double>();
        if (AppUtils.isNotNullOrEmpty((List)moodUpdateList)) {
            Double size = moodUpdateList.size();
            System.out.println("MoodUpdate List Size - " + size + " FromDate - " + DateUtils.dayWitTimeFormat.format(fromDate) + " ToDate - " + DateUtils.dayWitTimeFormat.format(toDate));
            System.out.println("----------------------------Daily---------------------------------");
            Double days = DateUtils.getDayCountByFromDateAndToDate((Date)fromDate, (Date)toDate);
            Double dailyReporting = DigitUtils.getAverage((Double)size, (Double)days);
            System.out.println("dailyReporting - " + dailyReporting + " = Size: " + size + " / Days: " + days);
            reportings.add(dailyReporting);
            System.out.println("----------------------------Weekly---------------------------------");
            Double weeks = DateUtils.getWeekCountByFromDateAndToDate((Date)fromDate, (Date)toDate);
            Double weeklyReporting = DigitUtils.getAverage((Double)size, (Double)weeks);
            System.out.println("weeklyReporting - " + weeklyReporting + " = Size: " + size + " / Weeks: " + weeks);
            reportings.add(weeklyReporting);
            System.out.println("----------------------------Monthly---------------------------------");
            Double months = DateUtils.getMonthCountByFromDateAndToDate((Date)fromDate, (Date)toDate);
            Double monthlyReporting = DigitUtils.getAverage((Double)size, (Double)months);
            System.out.println("monthlyReporting - " + monthlyReporting + " = Size: " + size + " / Months: " + months);
            reportings.add(monthlyReporting);
            System.out.println("----------------------------Yearly---------------------------------");
            Double years = DateUtils.getYearCountByFromDateAndToDate((Date)fromDate, (Date)toDate);
            Double yearlyReporting = DigitUtils.getAverage((Double)size, (Double)years);
            System.out.println("yearlyReporting - " + yearlyReporting + " = Size: " + size + " / Years: " + years);
            reportings.add(yearlyReporting);
        } else {
            reportings.add(0.0);
            reportings.add(0.0);
            reportings.add(0.0);
            reportings.add(0.0);
        }
        return reportings;
    }

    private List<MoodUpdate> getMoodUpdateByStudentIds(List<Long> student_ids, Date fromDate, Date toDate) {
        CriteriaBuilder criteriaBuilder = this.entityManager.getCriteriaBuilder();
        CriteriaQuery query = criteriaBuilder.createQuery(MoodUpdate.class);
        Root root = query.from(MoodUpdate.class);
        ArrayList<Object> predicates = new ArrayList<Object>();
        if (!AppUtils.isNotNullOrEmpty(student_ids)) {
            return new ArrayList<MoodUpdate>();
        }
        CriteriaBuilder.In genderPredicate = criteriaBuilder.in((Expression)root.get("student_id")).value(student_ids);
        predicates.add(genderPredicate);
        if (fromDate != null && toDate != null) {
            System.out.println("getMoodUpdateByStudentIds FromDate " + DateUtils.dailyDateFormat.format(fromDate) + " - ToDate " + DateUtils.dailyDateFormat.format(toDate));
            predicates.add(criteriaBuilder.between((Expression)root.get("createdAt"), (Comparable)fromDate, (Comparable)toDate));
        }
        query.where(predicates.toArray(new Predicate[0])).orderBy(new Order[]{criteriaBuilder.asc((Expression)root.get("createdAt"))});
        TypedQuery typedQuery = this.entityManager.createQuery(query);
        List moodUpdateList = typedQuery.getResultList();
        System.out.println("MoodUpdate Count = " + moodUpdateList.size());
        return moodUpdateList;
    }

    private List<SocioEmotionalTestResult> getSocioEmotionalTestResultByStudentIds(LinkedHashSet<Long> student_ids, Date fromDate, Date toDate) {
        CriteriaBuilder criteriaBuilder = this.entityManager.getCriteriaBuilder();
        CriteriaQuery query = criteriaBuilder.createQuery(SocioEmotionalTestResult.class);
        Root root = query.from(SocioEmotionalTestResult.class);
        ArrayList<Object> predicates = new ArrayList<Object>();
        if (AppUtils.isNotNullOrEmpty(student_ids)) {
            CriteriaBuilder.In genderPredicate = criteriaBuilder.in((Expression)root.get("student_id")).value(student_ids);
            predicates.add(genderPredicate);
        }
        if (fromDate != null && toDate != null) {
            System.out.println("getSocioEmotionalTestResultByStudentIds FromDate " + DateUtils.dailyDateFormat.format(fromDate) + " - ToDate " + DateUtils.dailyDateFormat.format(toDate));
            predicates.add(criteriaBuilder.between((Expression)root.get("createdAt"), (Comparable)fromDate, (Comparable)toDate));
        }
        query.where(predicates.toArray(new Predicate[0]));
        TypedQuery typedQuery = this.entityManager.createQuery(query);
        List socioEmotionalTestResultList = typedQuery.getResultList();
        System.out.println("SocioEmotionalTestResult Count = " + socioEmotionalTestResultList.size());
        return socioEmotionalTestResultList;
    }

    private GetDataDashBoardRequest getGetDataDashBoardRequestWithReqeuest(GetDataDashBoardRequest request) {
        GetDataDashBoardRequest getDataDashBoardRequest = new GetDataDashBoardRequest();
        getDataDashBoardRequest.setTimeLine(request.getTimeLine());
        getDataDashBoardRequest.setSocio_emotional_test_question_type_id(request.getSocio_emotional_test_question_type_id());
        getDataDashBoardRequest.setGraphType(request.getGraphType());
        getDataDashBoardRequest.setFromDate(request.getFromDate());
        getDataDashBoardRequest.setToDate(request.getToDate());
        return getDataDashBoardRequest;
    }

    public LinkedList<MoodInsight> getMoodInsightByInstructerId(GetDataDashBoardRequest request) {
        LinkedList<MoodInsight> moodInsightList = new LinkedList<MoodInsight>();
        List activities = this.activityService.getMoodInsightByInstructerId(request);
        for (Activity activity : activities) {
            MoodInsight moodInsight = new MoodInsight();
            if (activity.getStudent() != null) {
                moodInsight.setStudent_name(activity.getStudent().getFirst_name() + " " + activity.getStudent().getLast_name());
            }
            moodInsight.setMood_before(this.getNAIfNull(activity.getMood_update_before()) + " (" + activity.getLevel_of_focus_before() + ")");
            Lesson lesson = this.lessonRepository.findByLessonId(Long.valueOf(activity.getEntity_id()));
            if (lesson != null) {
                moodInsight.setVideo_watched(lesson.getVideo_url());
            }
            moodInsight.setMood_after(this.getNAIfNull(activity.getMood_update_after()) + " (" + activity.getLevel_of_focus_after() + ")");
            moodInsightList.add(moodInsight);
        }
        return moodInsightList;
    }

    private String getNAIfNull(String strValue) {
        if (strValue == null) {
            return "N/A";
        }
        return strValue;
    }
}

