/*
 * Decompiled with CFR 0.152.
 */
package com.infinite.focus.server.dashboard.socioemotionalassessment;

import com.infinite.focus.server.activity.Activity;
import com.infinite.focus.server.activity.service.ActivityService;
import com.infinite.focus.server.auth.InstructorRepository;
import com.infinite.focus.server.auth.StudentRepository;
import com.infinite.focus.server.dashboard.GetDataDashBoardRequest;
import com.infinite.focus.server.dashboard.LabelAndValue;
import com.infinite.focus.server.dashboard.LabelAndValueScore;
import com.infinite.focus.server.dashboard.TimeLine;
import com.infinite.focus.server.dashboard.socioemotionalassessment.SocioEmotionalAssessmentService;
import com.infinite.focus.server.dashboard.socioemotionalassessment.SocioEmotionalAssessmentServiceImpl;
import com.infinite.focus.server.grade.Grade;
import com.infinite.focus.server.grade.GradeRepository;
import com.infinite.focus.server.standard.StandardRepository;
import com.infinite.focus.server.students.Class;
import com.infinite.focus.server.students.ClassRepository;
import com.infinite.focus.server.students.service.StudentService;
import com.infinite.focus.server.tests.SocioEmotionalTestAnswer;
import com.infinite.focus.server.tests.SocioEmotionalTestAnswerRepository;
import com.infinite.focus.server.tests.SocioEmotionalTestDataWrapper;
import com.infinite.focus.server.tests.SocioEmotionalTestQuestion;
import com.infinite.focus.server.tests.SocioEmotionalTestQuestionOption;
import com.infinite.focus.server.tests.SocioEmotionalTestQuestionOptionRepository;
import com.infinite.focus.server.tests.SocioEmotionalTestQuestionRepository;
import com.infinite.focus.server.tests.SocioEmotionalTestResult;
import com.infinite.focus.server.utils.AppUtils;
import com.infinite.focus.server.utils.DateUtils;
import com.infinite.focus.server.utils.DigitUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SocioEmotionalAssessmentServiceImpl
implements SocioEmotionalAssessmentService {
    @Autowired
    EntityManager entityManager;
    @Autowired
    ActivityService activityService;
    @Autowired
    SocioEmotionalTestQuestionOptionRepository socioEmotionalTestQuestionOptionRepository;
    @Autowired
    SocioEmotionalTestQuestionRepository socioEmotionalTestQuestionRepository;
    @Autowired
    SocioEmotionalTestAnswerRepository socioEmotionalTestAnswerRepository;
    @Autowired
    GradeRepository gradeRepository;
    @Autowired
    StandardRepository standardRepository;
    @Autowired
    StudentRepository studentRepository;
    @Autowired
    StudentService studentService;
    @Autowired
    InstructorRepository instructorRepository;
    @Autowired
    ClassRepository classRepository;
    String forwardSlash = "/";

    public List<LabelAndValue> getSELStrandsGraphData(GetDataDashBoardRequest request) {
        List student_ids = this.studentService.getStudentByDemographics(request);
        List socioEmotionalTestResultList = this.getSocioEmotionalTestResultByStudentIds(student_ids, request.getTimeLine());
        LinkedHashMap testResultMap = this.getSocioEmotionalTestResultMapByTimeLine(request.getTimeLine(), socioEmotionalTestResultList);
        Long socio_emotional_test_question_type_id = request.getSocio_emotional_test_question_type_id();
        ArrayList<LabelAndValue> labelAndValues = new ArrayList<LabelAndValue>();
        if (socio_emotional_test_question_type_id == null) {
            for (String key : testResultMap.keySet()) {
                List values = (List)testResultMap.get(key);
                if (!values.isEmpty()) {
                    double score = 0.0;
                    for (SocioEmotionalTestResult test : values) {
                        System.out.println("test id " + test.getSocio_emotional_test_result_id() + " test score " + test.getScore() + " score = " + (score += (double)test.getScore()));
                    }
                    double avgScore = score / (double)values.size();
                    System.out.println("Key" + key + "avgScore  " + avgScore + "  score = " + score + " size (count) = " + values.size());
                    labelAndValues.add(new LabelAndValue(key, DigitUtils.formatDoubleInTwoDigit((Double)avgScore).doubleValue()));
                    continue;
                }
                labelAndValues.add(new LabelAndValue(key, 0.0));
            }
        } else {
            SocioEmotionalTestDataWrapper s = new SocioEmotionalTestDataWrapper();
            s.setOptions(this.socioEmotionalTestQuestionOptionRepository.findAll());
            s.setQuestions(this.socioEmotionalTestQuestionRepository.findBySocioEmotionalTestQuestionTypeId(socio_emotional_test_question_type_id));
            for (String key : testResultMap.keySet()) {
                List values = (List)testResultMap.get(key);
                if (!values.isEmpty()) {
                    double score = 0.0;
                    for (SocioEmotionalTestResult test : values) {
                        int total_score = 0;
                        List socioEmotionalTestAnswers = this.socioEmotionalTestAnswerRepository.findBySocioEmotionalTestResultId(Long.valueOf(test.getSocio_emotional_test_result_id()));
                        for (int q = 0; q < s.getQuestions().size(); ++q) {
                            SocioEmotionalTestQuestion socioEmotionalTestQuestion = (SocioEmotionalTestQuestion)s.getQuestions().get(q);
                            block5: for (int a = 0; a < socioEmotionalTestAnswers.size(); ++a) {
                                if (socioEmotionalTestQuestion.getSocio_emotional_test_question_id() != ((SocioEmotionalTestAnswer)socioEmotionalTestAnswers.get(a)).getSocio_emotional_test_question_id()) continue;
                                SocioEmotionalTestAnswer socioEmotionalTestAnswer = (SocioEmotionalTestAnswer)socioEmotionalTestAnswers.get(a);
                                for (int o = 0; o < s.getOptions().size(); ++o) {
                                    if (socioEmotionalTestAnswer.getSocio_emotional_test_question_option_id() != ((SocioEmotionalTestQuestionOption)s.getOptions().get(o)).getSocio_emotional_test_question_option_id()) continue;
                                    SocioEmotionalTestQuestionOption socioEmotionalTestQuestionOption = (SocioEmotionalTestQuestionOption)s.getOptions().get(o);
                                    if (socioEmotionalTestQuestion.isReversed()) {
                                        System.out.println("score = " + socioEmotionalTestQuestionOption.getReverse_weight() + " total_score = " + (total_score += socioEmotionalTestQuestionOption.getReverse_weight()));
                                        continue block5;
                                    }
                                    System.out.println("score = " + socioEmotionalTestQuestionOption.getWeight() + " total_score = " + (total_score += socioEmotionalTestQuestionOption.getWeight()));
                                    continue block5;
                                }
                            }
                        }
                        System.out.println("test id " + test.getSocio_emotional_test_result_id() + "  score = " + (score += (double)total_score));
                    }
                    double avgScore = score / (double)values.size();
                    System.out.println("Key" + key + "avgScore  " + avgScore + "  score = " + score + " size (count) = " + values.size());
                    labelAndValues.add(new LabelAndValue(key, DigitUtils.formatDoubleInTwoDigit((Double)avgScore).doubleValue()));
                    continue;
                }
                labelAndValues.add(new LabelAndValue(key, DigitUtils.formatDoubleInTwoDigit((Double)0.0).doubleValue()));
            }
        }
        return labelAndValues;
    }

    public LinkedHashMap<String, List<LabelAndValue>> getSingleDemographicComparisonGraphData(GetDataDashBoardRequest request) {
        LinkedHashMap<String, List<LabelAndValue>> graphData;
        block6: {
            block9: {
                block8: {
                    block7: {
                        block5: {
                            graphData = new LinkedHashMap<String, List<LabelAndValue>>();
                            if (!AppUtils.isNotNullOrEmpty((List)request.getGenders())) break block5;
                            for (String gender : request.getGenders()) {
                                GetDataDashBoardRequest getDataDashBoardRequest = this.getGetDataDashBoardRequestWithReqeuest(request);
                                getDataDashBoardRequest.getGenders().add(gender);
                                graphData.put(gender, this.getSELStrandsGraphData(getDataDashBoardRequest));
                            }
                            break block6;
                        }
                        if (!AppUtils.isNotNullOrEmpty((List)request.getAges())) break block7;
                        for (Integer age : request.getAges()) {
                            GetDataDashBoardRequest getDataDashBoardRequest = this.getGetDataDashBoardRequestWithReqeuest(request);
                            getDataDashBoardRequest.getAges().add(age);
                            graphData.put(String.valueOf(age), this.getSELStrandsGraphData(getDataDashBoardRequest));
                        }
                        break block6;
                    }
                    if (!AppUtils.isNotNullOrEmpty((List)request.getEthnicity())) break block8;
                    for (String ethnicity : request.getEthnicity()) {
                        GetDataDashBoardRequest getDataDashBoardRequest = this.getGetDataDashBoardRequestWithReqeuest(request);
                        getDataDashBoardRequest.getEthnicity().add(ethnicity);
                        graphData.put(ethnicity, this.getSELStrandsGraphData(getDataDashBoardRequest));
                    }
                    break block6;
                }
                if (!AppUtils.isNotNullOrEmpty((List)request.getGradeIds())) break block9;
                for (Long grade_id : request.getGradeIds()) {
                    GetDataDashBoardRequest getDataDashBoardRequest = this.getGetDataDashBoardRequestWithReqeuest(request);
                    getDataDashBoardRequest.getGradeIds().add(grade_id);
                    graphData.put(((Grade)this.gradeRepository.getOne((Object)grade_id)).getGrade_name(), this.getSELStrandsGraphData(getDataDashBoardRequest));
                }
                break block6;
            }
            if (!AppUtils.isNotNullOrEmpty((List)request.getClassIds())) break block6;
            for (Long class_id : request.getClassIds()) {
                GetDataDashBoardRequest getDataDashBoardRequest = this.getGetDataDashBoardRequestWithReqeuest(request);
                getDataDashBoardRequest.getClassIds().add(class_id);
                graphData.put(((Class)this.classRepository.getOne((Object)class_id)).getClass_name(), this.getSELStrandsGraphData(getDataDashBoardRequest));
            }
        }
        return graphData;
    }

    public LinkedHashMap<String, List<LabelAndValue>> getDemographicComparisonGraphData(GetDataDashBoardRequest request) {
        GetDataDashBoardRequest getDataDashBoardRequest;
        LinkedHashMap<String, List<LabelAndValue>> graphData = new LinkedHashMap<String, List<LabelAndValue>>();
        if (AppUtils.isNotNullOrEmpty((List)request.getGenders())) {
            getDataDashBoardRequest = this.getGetDataDashBoardRequestWithReqeuest(request);
            getDataDashBoardRequest.getGenders().addAll(request.getGenders());
            graphData.put("Gender", this.getSELStrandsGraphData(getDataDashBoardRequest));
        }
        if (AppUtils.isNotNullOrEmpty((List)request.getAges())) {
            getDataDashBoardRequest = this.getGetDataDashBoardRequestWithReqeuest(request);
            getDataDashBoardRequest.getAges().addAll(request.getAges());
            graphData.put("Age", this.getSELStrandsGraphData(getDataDashBoardRequest));
        }
        if (AppUtils.isNotNullOrEmpty((List)request.getEthnicity())) {
            getDataDashBoardRequest = this.getGetDataDashBoardRequestWithReqeuest(request);
            getDataDashBoardRequest.getEthnicity().addAll(request.getEthnicity());
            graphData.put("Ethnicity", this.getSELStrandsGraphData(getDataDashBoardRequest));
        }
        if (AppUtils.isNotNullOrEmpty((List)request.getGradeIds())) {
            GetDataDashBoardRequest getSocioEmotionalDataAnalyticsRequest = this.getGetDataDashBoardRequestWithReqeuest(request);
            getSocioEmotionalDataAnalyticsRequest.getGradeIds().addAll(request.getGradeIds());
            graphData.put("Grade", this.getSELStrandsGraphData(getSocioEmotionalDataAnalyticsRequest));
        }
        if (AppUtils.isNotNullOrEmpty((List)request.getClassIds())) {
            getDataDashBoardRequest = this.getGetDataDashBoardRequestWithReqeuest(request);
            getDataDashBoardRequest.getClassIds().addAll(request.getClassIds());
            graphData.put("Classroom", this.getSELStrandsGraphData(getDataDashBoardRequest));
        }
        return graphData;
    }

    public List<LabelAndValueScore> getTimeSpentAndSELStrandsGraphData(GetDataDashBoardRequest request) {
        List student_ids = this.studentService.getStudentByDemographics(request);
        List activityList = this.activityService.getTimeSpentByStudentIds(student_ids, request.getTimeLine());
        LinkedHashMap activityMap = this.activityService.getActivityMapByTimeLine(request.getTimeLine(), activityList);
        List labelAndValueList = this.getSELStrandsGraphData(request);
        ArrayList<LabelAndValueScore> labelAndValueScoreList = new ArrayList<LabelAndValueScore>();
        int tempInt = 100;
        for (String key : activityMap.keySet()) {
            List values = (List)activityMap.get(key);
            if (!values.isEmpty()) {
                double appUsedTime = 0.0;
                for (Activity activity : values) {
                    double differnce = (activity.getEnd_date_time().getTime() - activity.getStart_date_time().getTime()) / 1000L;
                    if (!(differnce >= 1.0)) continue;
                    appUsedTime += differnce;
                }
                if (appUsedTime >= 1.0 && AppUtils.isNotNullOrEmpty((List)student_ids)) {
                    System.out.println("key " + key + " App Used Time in seconds " + appUsedTime + " in minutes " + appUsedTime / 60.0 + " Student Size " + student_ids.size() + " AVG Time " + appUsedTime / 60.0 / (double)student_ids.size());
                    labelAndValueScoreList.add(new LabelAndValueScore(key, DigitUtils.formatDoubleInTwoDigit((Double)DigitUtils.getAverage((Double)DigitUtils.getAverage((Double)appUsedTime, (Double)60.0), (Double)Double.valueOf(student_ids.size()))), 0.0));
                } else {
                    labelAndValueScoreList.add(new LabelAndValueScore(key, DigitUtils.formatDoubleInTwoDigit((Double)0.0), 0.0));
                }
            } else {
                labelAndValueScoreList.add(new LabelAndValueScore(key, DigitUtils.formatDoubleInTwoDigit((Double)0.0), 0.0));
            }
            tempInt += 100;
        }
        for (int i = 0; i < labelAndValueScoreList.size(); ++i) {
            LabelAndValueScore labelAndValueScore = (LabelAndValueScore)labelAndValueScoreList.get(i);
            for (int j = 0; j < labelAndValueList.size(); ++j) {
                LabelAndValue labelAndValue = (LabelAndValue)labelAndValueList.get(j);
                if (!labelAndValueScore.getxLabel().equals(labelAndValue.getxLabel())) continue;
                labelAndValueScore.setScore(DigitUtils.formatDoubleInTwoDigit((Double)labelAndValue.getValue()).doubleValue());
            }
        }
        return labelAndValueScoreList;
    }

    private List<SocioEmotionalTestResult> getSocioEmotionalTestResultByStudentIds(List<Long> student_ids, TimeLine timeLine) {
        CriteriaBuilder criteriaBuilder = this.entityManager.getCriteriaBuilder();
        CriteriaQuery query = criteriaBuilder.createQuery(SocioEmotionalTestResult.class);
        Root root = query.from(SocioEmotionalTestResult.class);
        ArrayList<Object> predicates = new ArrayList<Object>();
        if (AppUtils.isNotNullOrEmpty(student_ids)) {
            CriteriaBuilder.In genderPredicate = criteriaBuilder.in((Expression)root.get("student_id")).value(student_ids);
            predicates.add(genderPredicate);
        }
        Date toDate = DateUtils.getToDateByTimeLine((TimeLine)timeLine);
        System.out.println(timeLine.toString() + " - ToDate " + DateUtils.dailyDateFormat.format(toDate) + " - FromDate " + DateUtils.dailyDateFormat.format(new Date()));
        predicates.add(criteriaBuilder.greaterThan((Expression)root.get("createdAt"), (Comparable)toDate));
        query.where(predicates.toArray(new Predicate[0]));
        TypedQuery typedQuery = this.entityManager.createQuery(query);
        List socioEmotionalTestResultList = typedQuery.getResultList();
        System.out.println("SocioEmotionalTestResult Count = " + socioEmotionalTestResultList.size());
        return socioEmotionalTestResultList;
    }

    private LinkedHashMap<String, List<SocioEmotionalTestResult>> getSocioEmotionalTestResultMapByTimeLine(TimeLine timeLine, List<SocioEmotionalTestResult> socioEmotionalTestResultList) {
        LinkedHashMap testResultMap = null;
        switch (1.$SwitchMap$com$infinite$focus$server$dashboard$TimeLine[timeLine.ordinal()]) {
            case 1: {
                testResultMap = this.fillSocioEmotionalTestResultMap(DateUtils.getDailyLabels());
                for (SocioEmotionalTestResult testResult : socioEmotionalTestResultList) {
                    String key = DateUtils.dailyDateFormat.format(testResult.getCreatedAt());
                    AppUtils.addValueTotMap((LinkedHashMap)testResultMap, (String)key, (Object)testResult);
                }
                break;
            }
            case 2: {
                testResultMap = this.fillSocioEmotionalTestResultMap(DateUtils.getWeeklyLabels());
                for (SocioEmotionalTestResult testResult : socioEmotionalTestResultList) {
                    String key = DateUtils.getWeekendByDate((Date)testResult.getCreatedAt());
                    AppUtils.addValueTotMap((LinkedHashMap)testResultMap, (String)key, (Object)testResult);
                }
                break;
            }
            case 3: {
                testResultMap = this.fillSocioEmotionalTestResultMap(DateUtils.getMonthlyLabels());
                for (SocioEmotionalTestResult testResult : socioEmotionalTestResultList) {
                    String key = DateUtils.monthlyDateFormat.format(testResult.getCreatedAt());
                    AppUtils.addValueTotMap((LinkedHashMap)testResultMap, (String)key, (Object)testResult);
                }
                break;
            }
            case 4: {
                testResultMap = this.fillSocioEmotionalTestResultMap(DateUtils.getYearlyLabels());
                for (SocioEmotionalTestResult testResult : socioEmotionalTestResultList) {
                    String key = DateUtils.yearlyDateFormat.format(testResult.getCreatedAt());
                    AppUtils.addValueTotMap((LinkedHashMap)testResultMap, (String)key, (Object)testResult);
                }
                break;
            }
        }
        return testResultMap;
    }

    private LinkedHashMap<String, List<SocioEmotionalTestResult>> fillSocioEmotionalTestResultMap(List<String> keys) {
        LinkedHashMap<String, List<SocioEmotionalTestResult>> map = new LinkedHashMap<String, List<SocioEmotionalTestResult>>();
        for (String key : keys) {
            map.put(key, new ArrayList());
        }
        return map;
    }

    private GetDataDashBoardRequest getGetDataDashBoardRequestWithReqeuest(GetDataDashBoardRequest request) {
        GetDataDashBoardRequest getDataDashBoardRequest = new GetDataDashBoardRequest();
        getDataDashBoardRequest.setTimeLine(request.getTimeLine());
        getDataDashBoardRequest.setSocio_emotional_test_question_type_id(request.getSocio_emotional_test_question_type_id());
        getDataDashBoardRequest.setGraphType(request.getGraphType());
        getDataDashBoardRequest.setFromDate(request.getFromDate());
        getDataDashBoardRequest.setToDate(request.getToDate());
        return getDataDashBoardRequest;
    }
}

