/*
 * Decompiled with CFR 0.152.
 */
package com.infinite.focus.server.fcm.service;

import com.infinite.focus.server.fcm.model.PushNotification;
import com.infinite.focus.server.fcm.service.FCMService;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

@Service
public class PushNotificationService {
    private Logger logger = LoggerFactory.getLogger(PushNotificationService.class);
    private FCMService fcmService;

    public PushNotificationService(FCMService fcmService) {
        this.fcmService = fcmService;
    }

    @Async
    public void sendPushNotification(PushNotification request) {
        try {
            this.fcmService.sendMessage(this.getSamplePayloadData(request), request);
        }
        catch (Exception e) {
            this.logger.error(e.getMessage());
        }
    }

    @Async
    public void sendPushNotifications(List<PushNotification> pushNotifications) {
        try {
            this.fcmService.sendMessages(this.getSamplePayloadData(pushNotifications.get(0)), pushNotifications);
        }
        catch (Exception e) {
            this.logger.error(e.getMessage());
        }
    }

    @Async
    public void sendPushNotificationWithoutData(PushNotification request) {
        try {
            this.fcmService.sendMessageWithoutData(request);
        }
        catch (Exception e) {
            this.logger.error(e.getMessage());
        }
    }

    @Async
    public void sendPushNotificationToToken(PushNotification request) {
        try {
            this.fcmService.sendMessageToToken(request);
        }
        catch (Exception e) {
            this.logger.error(e.getMessage());
        }
    }

    private Map<String, String> getSamplePayloadData(PushNotification request) {
        HashMap<String, String> pushData = new HashMap<String, String>();
        pushData.put("messageId", "msgid");
        pushData.put("title", request.getTitle());
        pushData.put("message", request.getMessage());
        pushData.put("screen_type", request.getScreen_type().toString());
        return pushData;
    }
}

