/*
 * Decompiled with CFR 0.152.
 */
package com.infinite.focus.server.home;

import com.infinite.focus.server.auth.AccountRepository;
import com.infinite.focus.server.auth.AvatarRepository;
import com.infinite.focus.server.auth.Instructor;
import com.infinite.focus.server.auth.InstructorRepository;
import com.infinite.focus.server.auth.Message;
import com.infinite.focus.server.auth.School;
import com.infinite.focus.server.auth.SchoolRepository;
import com.infinite.focus.server.auth.Student;
import com.infinite.focus.server.auth.StudentRepository;
import com.infinite.focus.server.home.AppreciationItem;
import com.infinite.focus.server.home.DailyAppreciation;
import com.infinite.focus.server.home.DailyAppreciationRepository;
import com.infinite.focus.server.home.DailyAppreciationStudentWrapper;
import com.infinite.focus.server.home.GetNotificationsRequest;
import com.infinite.focus.server.home.MoodUpdate;
import com.infinite.focus.server.home.MoodUpdateRepository;
import com.infinite.focus.server.home.MoodWrapper;
import com.infinite.focus.server.home.Notification;
import com.infinite.focus.server.home.NotificationRepository;
import com.infinite.focus.server.home.Quote;
import com.infinite.focus.server.home.QuoteRepository;
import com.infinite.focus.server.home.RealTimeMessageService;
import com.infinite.focus.server.lessons.Lesson;
import com.infinite.focus.server.lessons.LessonRecord;
import com.infinite.focus.server.lessons.LessonRecordRepository;
import com.infinite.focus.server.lessons.LessonRepository;
import com.infinite.focus.server.notifications.service.NotificationService;
import com.infinite.focus.server.students.Class;
import com.infinite.focus.server.students.ClassRepository;
import com.infinite.focus.server.tests.SocioEmotionalTestResult;
import com.infinite.focus.server.tests.SocioEmotionalTestResultRepository;
import com.infinite.focus.server.wall.WallPostAttachmentRepository;
import com.infinite.focus.server.wall.WallPostRepository;
import com.infinite.focus.server.wall.WallPostRequestRepository;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.server.ResponseStatusException;

@CrossOrigin(origins={"http://localhost:8383"})
@RestController
@RequestMapping(value={"api/home"})
public class HomeController {
    @Autowired
    NotificationService notificationService;
    private AccountRepository accountRepository;
    private StudentRepository studentRepository;
    private InstructorRepository instructorRepository;
    private AvatarRepository avatarRepository;
    private BCryptPasswordEncoder bCryptPasswordEncoder;
    private WallPostRepository wallPostRepository;
    private WallPostAttachmentRepository wallPostAttachmentRepository;
    private WallPostRequestRepository wallPostRequestRepository;
    private QuoteRepository qouteRepository;
    private MoodUpdateRepository moodUpdateRepository;
    private DailyAppreciationRepository dailyAppreciationRepository;
    private NotificationRepository notificationRepository;
    private SchoolRepository schoolRepository;
    private ClassRepository classRepository;
    private LessonRepository lessonRepository;
    private LessonRecordRepository lessonRecordRepository;
    private SocioEmotionalTestResultRepository socioEmotionalTestResultRepository;
    @Autowired
    private RealTimeMessageService realTimeMessageService;
    public final int ELEMENTARY = 1;
    public final int MIDDLE = 2;
    public final int HIGHSCHOOL = 3;

    public HomeController(SocioEmotionalTestResultRepository socioEmotionalTestResultRepository, LessonRepository lessonRepository, LessonRecordRepository lessonRecordRepository, ClassRepository classRepository, SchoolRepository schoolRepository, RealTimeMessageService realTimeMessageService, NotificationRepository notificationRepository, DailyAppreciationRepository dailyAppreciationRepository, MoodUpdateRepository moodUpdateRepository, QuoteRepository qouteRepository, WallPostRepository wallPostRepository, WallPostAttachmentRepository wallPostAttachmentRepository, WallPostRequestRepository wallPostRequestRepository, AvatarRepository avatarRepository, InstructorRepository instructorRepository, StudentRepository studentRepository, AccountRepository accountRepository, BCryptPasswordEncoder bCryptPasswordEncoder) {
        this.socioEmotionalTestResultRepository = socioEmotionalTestResultRepository;
        this.lessonRecordRepository = lessonRecordRepository;
        this.lessonRepository = lessonRepository;
        this.classRepository = classRepository;
        this.schoolRepository = schoolRepository;
        this.realTimeMessageService = realTimeMessageService;
        this.notificationRepository = notificationRepository;
        this.qouteRepository = qouteRepository;
        this.wallPostRepository = wallPostRepository;
        this.wallPostAttachmentRepository = wallPostAttachmentRepository;
        this.wallPostRequestRepository = wallPostRequestRepository;
        this.avatarRepository = avatarRepository;
        this.bCryptPasswordEncoder = bCryptPasswordEncoder;
        this.instructorRepository = instructorRepository;
        this.studentRepository = studentRepository;
        this.accountRepository = accountRepository;
        this.moodUpdateRepository = moodUpdateRepository;
        this.dailyAppreciationRepository = dailyAppreciationRepository;
    }

    @GetMapping(value={"/get/schools/by/district"})
    public ResponseEntity<List<School>> getSchoolsByDistrict(@RequestParam(value="district_id", defaultValue="aEn24") Long district_id) {
        return new ResponseEntity((Object)this.schoolRepository.findByDistrictId(district_id), HttpStatus.OK);
    }

    @GetMapping(value={"/get/classes/by/school"})
    public ResponseEntity<List<Class>> getClassesBySchool(@RequestParam(value="school_id", defaultValue="aEn24") Long school_id) {
        List list = this.instructorRepository.findBySchoolId(school_id);
        ArrayList cs = new ArrayList();
        for (Instructor i : list) {
            List classes = this.classRepository.findByInstructorId(Long.valueOf(i.getInstructor_id()));
            for (Class c : classes) {
                c.setClass_name(i.getFirst_name() + " " + i.getLast_name() + "'s " + c.getClass_name());
            }
            cs.addAll(classes);
        }
        return new ResponseEntity(cs, HttpStatus.OK);
    }

    @GetMapping(value={"/test/notification"})
    public ResponseEntity<Notification> sendTestNotification(@RequestParam(value="student_id", defaultValue="aEn24") Long student_id) {
        Student s = (Student)this.studentRepository.getOne((Object)student_id);
        if (s == null) {
            new ResponseEntity(HttpStatus.NOT_FOUND);
        }
        Notification n = new Notification();
        n.setInstructor_id(s.getInstructor_id());
        n.setStudent_id(s.getStudent_id());
        n.setText(s.getFirst_name() + " " + s.getLast_name() + " has selected mad or sad for more than 3 days in a row");
        this.notificationRepository.save((Object)n);
        String json_message = "{\"type\":\"NOTIFICATION\",\"message\":\"" + n.getText() + "\"}";
        this.realTimeMessageService.sendMessage(Long.valueOf(s.getInstructor_id()), json_message);
        return new ResponseEntity((Object)n, HttpStatus.OK);
    }

    @GetMapping(value={"/get/notifications"})
    public ResponseEntity<List<Notification>> getNotifications(@RequestParam(value="instructor_id", defaultValue="aEn24") Long instructor_id) {
        return new ResponseEntity((Object)this.notificationRepository.findByInstructorId(instructor_id), HttpStatus.OK);
    }

    @PostMapping(value={"/get/notifications"})
    @ResponseBody
    public ResponseEntity<List<Notification>> getNotifications(@RequestBody GetNotificationsRequest request) {
        return new ResponseEntity((Object)this.notificationService.getNotifications(request), HttpStatus.OK);
    }

    @GetMapping(value={"/get/daily/quote"})
    public ResponseEntity<Quote> getCurrentDailyQuote() {
        Quote qoute = this.qouteRepository.findDailyQuote();
        return new ResponseEntity((Object)qoute, HttpStatus.OK);
    }

    @GetMapping(value={"/delete/daily/quote"})
    public ResponseEntity<Message> deleteQuote(@RequestParam(value="quote_id", defaultValue="aEn24") Long quote_id) {
        Quote quote = (Quote)this.qouteRepository.getOne((Object)quote_id);
        if (quote == null) {
            throw new ResponseStatusException(HttpStatus.NOT_FOUND, "The Quote not found!");
        }
        if (quote.getIsDailyQuote().booleanValue()) {
            throw new ResponseStatusException(HttpStatus.CONFLICT, "The Quote is a Daily Quote, the Daily Quote can not be deleted.");
        }
        this.qouteRepository.deleteById((Object)quote_id);
        Message message = new Message();
        message.setMessage("The Quote is deleted successfully.");
        return new ResponseEntity((Object)message, HttpStatus.OK);
    }

    @GetMapping(value={"/get/all/daily/quotes"})
    public ResponseEntity<List<Quote>> getAllQuotes() {
        return new ResponseEntity((Object)this.qouteRepository.findAllOrderById(), HttpStatus.OK);
    }

    @PostMapping(value={"/create/daily/quote"})
    @ResponseBody
    public ResponseEntity<Quote> createDailyQuote(@RequestBody Quote request) {
        return new ResponseEntity((Object)((Quote)this.qouteRepository.save((Object)request)), HttpStatus.OK);
    }

    @PostMapping(value={"/update/daily/quote"})
    @ResponseBody
    public ResponseEntity<Quote> updateDailyQuote(@RequestBody Quote request) {
        Quote quote = (Quote)this.qouteRepository.getOne((Object)request.getQuote_id());
        quote.setText(request.getText());
        quote.setAuthor(request.getAuthor());
        return new ResponseEntity((Object)((Quote)this.qouteRepository.save((Object)quote)), HttpStatus.OK);
    }

    @PostMapping(value={"/create/mood_update"})
    @ResponseBody
    public ResponseEntity<MoodUpdate> createMoodUpdate(@RequestBody MoodUpdate request) {
        String json_message;
        Notification n;
        Object s;
        List list;
        if (this.containsMood("sad", request.getText()) || this.containsMood("depressed", request.getText())) {
            Student s2 = (Student)this.studentRepository.getOne((Object)request.getStudent_id());
            if (s2 == null) {
                new ResponseEntity(HttpStatus.NOT_FOUND);
            }
            Notification n2 = new Notification();
            n2.setInstructor_id(s2.getInstructor_id());
            n2.setStudent_id(s2.getStudent_id());
            n2.setText(s2.getFirst_name() + " " + s2.getLast_name() + "  is sad/depressed today (" + new SimpleDateFormat("yyyy.MM.dd").format(new Date()) + ").");
            this.notificationRepository.save((Object)n2);
            String json_message2 = "{\"type\":\"NOTIFICATION\",\"message\":\"" + n2.getText() + "\"}";
            this.realTimeMessageService.sendMessage(Long.valueOf(s2.getInstructor_id()), json_message2);
        }
        if (this.containsMood("anxious", request.getText())) {
            list = this.moodUpdateRepository.findByStudentIdInLast3Days(Long.valueOf(request.getStudent_id()));
            int count = 0;
            for (MoodUpdate m : list) {
                if (!this.containsMood("anxious", m.getText())) continue;
                ++count;
            }
            if (count >= 2) {
                s = (Student)this.studentRepository.getOne((Object)request.getStudent_id());
                if (s == null) {
                    new ResponseEntity(HttpStatus.NOT_FOUND);
                }
                n = new Notification();
                n.setInstructor_id(s.getInstructor_id());
                n.setStudent_id(s.getStudent_id());
                n.setText(s.getFirst_name() + " " + s.getLast_name() + " has selected anxious for three days in a row (" + new SimpleDateFormat("yyyy.MM.dd").format(new Date()) + ").");
                this.notificationRepository.save((Object)n);
                json_message = "{\"type\":\"NOTIFICATION\",\"message\":\"" + n.getText() + "\"}";
                this.realTimeMessageService.sendMessage(Long.valueOf(s.getInstructor_id()), json_message);
            }
        }
        if (this.containsMood("mad", request.getText()) || this.containsMood("angry", request.getText())) {
            list = this.moodUpdateRepository.findByStudentIdInLast3Days(Long.valueOf(request.getStudent_id()));
            int count = 0;
            for (MoodUpdate m : list) {
                if (!this.containsMood("mad", m.getText()) && !this.containsMood("angry", m.getText())) continue;
                ++count;
            }
            if (count >= 2) {
                s = (Student)this.studentRepository.getOne((Object)request.getStudent_id());
                if (s == null) {
                    new ResponseEntity(HttpStatus.NOT_FOUND);
                }
                n = new Notification();
                n.setInstructor_id(s.getInstructor_id());
                n.setStudent_id(s.getStudent_id());
                n.setText(s.getFirst_name() + " " + s.getLast_name() + " has selected angry/mad for three days in a row (" + new SimpleDateFormat("yyyy.MM.dd").format(new Date()) + ").");
                this.notificationRepository.save((Object)n);
                json_message = "{\"type\":\"NOTIFICATION\",\"message\":\"" + n.getText() + "\"}";
                this.realTimeMessageService.sendMessage(Long.valueOf(s.getInstructor_id()), json_message);
            }
        }
        if (this.containsMood("sad", request.getText()) || this.containsMood("depressed", request.getText())) {
            list = this.moodUpdateRepository.findByStudentIdInLast3Days(Long.valueOf(request.getStudent_id()));
            int count = 0;
            for (MoodUpdate m : list) {
                if (!this.containsMood("sad", m.getText()) && !this.containsMood("depressed", m.getText())) continue;
                ++count;
            }
            if (count >= 2) {
                s = (Student)this.studentRepository.getOne((Object)request.getStudent_id());
                if (s == null) {
                    new ResponseEntity(HttpStatus.NOT_FOUND);
                }
                n = new Notification();
                n.setInstructor_id(s.getInstructor_id());
                n.setStudent_id(s.getStudent_id());
                n.setText(s.getFirst_name() + " " + s.getLast_name() + " has selected sad/depressed for three days in a row (" + new SimpleDateFormat("yyyy.MM.dd").format(new Date()) + ").");
                this.notificationRepository.save((Object)n);
                json_message = "{\"type\":\"NOTIFICATION\",\"message\":\"" + n.getText() + "\"}";
                this.realTimeMessageService.sendMessage(Long.valueOf(s.getInstructor_id()), json_message);
            }
        }
        return new ResponseEntity((Object)((MoodUpdate)this.moodUpdateRepository.save((Object)request)), HttpStatus.OK);
    }

    @PostMapping(value={"/create/daily_appreciation"})
    @ResponseBody
    public ResponseEntity<DailyAppreciation> createDailyAppreciation(@RequestBody DailyAppreciation request) {
        return new ResponseEntity((Object)((DailyAppreciation)this.dailyAppreciationRepository.save((Object)request)), HttpStatus.OK);
    }

    @GetMapping(value={"/get/daily_appreciation/for/instructor/all"})
    public ResponseEntity<List<DailyAppreciationStudentWrapper>> getAllDailyAppreciationForInstructor(@RequestParam(value="instructor_id", defaultValue="aEn24") Long instructor_id) {
        ArrayList<DailyAppreciationStudentWrapper> list = new ArrayList<DailyAppreciationStudentWrapper>();
        Instructor i = (Instructor)this.instructorRepository.getOne((Object)instructor_id);
        if (i == null) {
            return new ResponseEntity(HttpStatus.CONFLICT);
        }
        List students = this.studentRepository.findByInstructorId(instructor_id);
        for (Student s : students) {
            for (DailyAppreciation d : this.dailyAppreciationRepository.findByStudent(Long.valueOf(s.getStudent_id()))) {
                DailyAppreciationStudentWrapper w = new DailyAppreciationStudentWrapper();
                w.setDailyAppreciation(d);
                w.setStudent(s);
                list.add(w);
            }
        }
        return new ResponseEntity(list, HttpStatus.OK);
    }

    @GetMapping(value={"/get/daily_appreciation/for/instructor/today"})
    public ResponseEntity<List<DailyAppreciation>> getDailyAppreciationForInstructor(@RequestParam(value="instructor_id", defaultValue="aEn24") Long instructor_id) {
        ArrayList list = new ArrayList();
        Instructor i = (Instructor)this.instructorRepository.getOne((Object)instructor_id);
        if (i == null) {
            return new ResponseEntity(HttpStatus.CONFLICT);
        }
        List students = this.studentRepository.findByInstructorId(instructor_id);
        for (Student s : students) {
            list.addAll(this.dailyAppreciationRepository.findByStudentForToday(Long.valueOf(s.getStudent_id())));
        }
        return new ResponseEntity(list, HttpStatus.OK);
    }

    @GetMapping(value={"/get/daily_appreciation/for/student"})
    public ResponseEntity<List<DailyAppreciation>> getAllDailyAppreciationForStudent(@RequestParam(value="student_id", defaultValue="aEn24") Long student_id) {
        return new ResponseEntity((Object)this.dailyAppreciationRepository.findByStudent(student_id), HttpStatus.OK);
    }

    @GetMapping(value={"/get/mood_log/for/student"})
    public ResponseEntity<List<MoodUpdate>> getMoodLogForStudent(@RequestParam(value="student_id", defaultValue="aEn24") Long student_id) {
        return new ResponseEntity((Object)this.moodUpdateRepository.findByStudentId(student_id), HttpStatus.OK);
    }

    @GetMapping(value={"/get/socio/emotional/score"})
    public ResponseEntity<SocioEmotionalTestResult> getSocioEmotionalScore(@RequestParam(value="student_id", defaultValue="aEn24") Long student_id) {
        List list = this.socioEmotionalTestResultRepository.findByStudentId(student_id);
        if (list.size() > 0) {
            return new ResponseEntity((Object)((SocioEmotionalTestResult)list.get(list.size() - 1)), HttpStatus.OK);
        }
        return new ResponseEntity((Object)new SocioEmotionalTestResult(), HttpStatus.OK);
    }

    @GetMapping(value={"/get/lesson/progress/for/student"})
    public ResponseEntity<List<Lesson>> getLessonProgress(@RequestParam(value="student_id", defaultValue="aEn24") Long student_id) {
        Student s = (Student)this.studentRepository.getOne((Object)student_id);
        if (s == null) {
            new ResponseEntity(HttpStatus.NOT_FOUND);
        }
        List allLessons = this.lessonRepository.findByGradeId(Long.valueOf(s.getGrade_id()));
        for (LessonRecord l : this.lessonRecordRepository.findByStudentId(Long.valueOf(s.getStudent_id()))) {
            for (Lesson ln : allLessons) {
                if (ln.getLesson_id() != l.getLesson_id()) continue;
                ln.setCompleted(true);
            }
        }
        return new ResponseEntity((Object)allLessons, HttpStatus.OK);
    }

    private boolean containsMood(String mood, String text) {
        String[] words;
        if (text.toLowerCase().trim().contains(mood.toLowerCase().trim())) {
            return true;
        }
        for (String s : words = text.split("\\s+")) {
            if (this.calculate(s.toLowerCase().trim(), mood.toLowerCase().trim()) >= 2) continue;
            return true;
        }
        return false;
    }

    public int calculate(String x, String y) {
        if (x.isEmpty()) {
            return y.length();
        }
        if (y.isEmpty()) {
            return x.length();
        }
        int substitution = this.calculate(x.substring(1), y.substring(1)) + this.costOfSubstitution(x.charAt(0), y.charAt(0));
        int insertion = this.calculate(x, y.substring(1)) + 1;
        int deletion = this.calculate(x.substring(1), y) + 1;
        return this.min(new int[]{substitution, insertion, deletion});
    }

    public int costOfSubstitution(char a, char b) {
        return a == b ? 0 : 1;
    }

    public int min(int ... numbers) {
        return Arrays.stream(numbers).min().orElse(Integer.MAX_VALUE);
    }

    @GetMapping(value={"/get-appreciation-items"})
    public ResponseEntity<List<AppreciationItem>> getAppreciationItems(@RequestParam(value="grade_id", defaultValue="aEn24") int grade_id) {
        ArrayList<AppreciationItem> appreciationItems = new ArrayList<AppreciationItem>();
        switch (grade_id) {
            case 1: {
                appreciationItems.add(new AppreciationItem("Family", "https://res.cloudinary.com/veedbeta/image/upload/v1546901606/AppreciationIcon-01_d5d2vw.png"));
                appreciationItems.add(new AppreciationItem("Friends", "https://res.cloudinary.com/veedbeta/image/upload/v1546901606/AppreciationIcon-05_wlkkvu.png"));
                appreciationItems.add(new AppreciationItem("School", "https://res.cloudinary.com/veedbeta/image/upload/v1546901606/AppreciationIcon-04_fau1yu.png"));
                appreciationItems.add(new AppreciationItem("Me", "https://res.cloudinary.com/veedbeta/image/upload/v1546843386/AppreciationIcon-03_gjled8.png"));
                appreciationItems.add(new AppreciationItem("My Pets", "https://res.cloudinary.com/veedbeta/image/upload/v1547834966/AppreciationIcon2-04_ongiie.png"));
                appreciationItems.add(new AppreciationItem("My Teacher", "https://res.cloudinary.com/veedbeta/image/upload/v1546901606/AppreciationIcon-06_qfjc0f.png"));
                break;
            }
            case 2: {
                appreciationItems.add(new AppreciationItem("Family", "https://res.cloudinary.com/veedbeta/image/upload/v1546901606/AppreciationIcon-01_d5d2vw.png"));
                appreciationItems.add(new AppreciationItem("Friends", "https://res.cloudinary.com/veedbeta/image/upload/v1546901606/AppreciationIcon-05_wlkkvu.png"));
                appreciationItems.add(new AppreciationItem("School", "https://res.cloudinary.com/veedbeta/image/upload/v1546901606/AppreciationIcon-04_fau1yu.png"));
                appreciationItems.add(new AppreciationItem("Me", "https://res.cloudinary.com/veedbeta/image/upload/v1546843386/AppreciationIcon-03_gjled8.png"));
                appreciationItems.add(new AppreciationItem("A Teacher", "https://res.cloudinary.com/veedbeta/image/upload/v1546901606/AppreciationIcon-06_qfjc0f.png"));
                appreciationItems.add(new AppreciationItem("Technology", "https://res.cloudinary.com/veedbeta/image/upload/v1547835026/AppreciationIcon2-01_1_fyczr2.png"));
                appreciationItems.add(new AppreciationItem("Math", "https://res.cloudinary.com/veedbeta/image/upload/v1547835026/AppreciationIcon2-01_1_fyczr2.png"));
                appreciationItems.add(new AppreciationItem("Music", "https://res.cloudinary.com/veedbeta/image/upload/v1547834969/AppreciationIcon2-02_xjyz5w.png"));
                appreciationItems.add(new AppreciationItem("Art", "https://res.cloudinary.com/veedbeta/image/upload/v1547834971/AppreciationIcon2-03_weelnk.png"));
                break;
            }
            case 3: {
                appreciationItems.add(new AppreciationItem("Family", "https://res.cloudinary.com/veedbeta/image/upload/v1546901606/AppreciationIcon-01_d5d2vw.png"));
                appreciationItems.add(new AppreciationItem("Friends", "https://res.cloudinary.com/veedbeta/image/upload/v1546901606/AppreciationIcon-05_wlkkvu.png"));
                appreciationItems.add(new AppreciationItem("School", "https://res.cloudinary.com/veedbeta/image/upload/v1546901606/AppreciationIcon-04_fau1yu.png"));
                appreciationItems.add(new AppreciationItem("Me", "https://res.cloudinary.com/veedbeta/image/upload/v1546843386/AppreciationIcon-03_gjled8.png"));
                appreciationItems.add(new AppreciationItem("A Teacher", "https://res.cloudinary.com/veedbeta/image/upload/v1546901606/AppreciationIcon-06_qfjc0f.png"));
                appreciationItems.add(new AppreciationItem("Technology", "https://res.cloudinary.com/veedbeta/image/upload/v1547835026/AppreciationIcon2-01_1_fyczr2.png"));
                appreciationItems.add(new AppreciationItem("Math", "https://res.cloudinary.com/veedbeta/image/upload/v1547835026/AppreciationIcon2-01_1_fyczr2.png"));
                appreciationItems.add(new AppreciationItem("Music", "https://res.cloudinary.com/veedbeta/image/upload/v1547834969/AppreciationIcon2-02_xjyz5w.png"));
                appreciationItems.add(new AppreciationItem("Art", "https://res.cloudinary.com/veedbeta/image/upload/v1547834971/AppreciationIcon2-03_weelnk.png"));
                break;
            }
            default: {
                appreciationItems.add(new AppreciationItem("Family", "https://res.cloudinary.com/veedbeta/image/upload/v1546843386/AppreciationIcon-03_gjled8.png"));
                appreciationItems.add(new AppreciationItem("Friends", "https://res.cloudinary.com/veedbeta/image/upload/v1546843386/AppreciationIcon-03_gjled8.png"));
                appreciationItems.add(new AppreciationItem("School", "https://res.cloudinary.com/veedbeta/image/upload/v1546843386/AppreciationIcon-03_gjled8.png"));
                appreciationItems.add(new AppreciationItem("Me", "https://res.cloudinary.com/veedbeta/image/upload/v1546843386/AppreciationIcon-03_gjled8.png"));
                appreciationItems.add(new AppreciationItem("A teacher", "https://res.cloudinary.com/veedbeta/image/upload/v1546843386/AppreciationIcon-03_gjled8.png"));
                appreciationItems.add(new AppreciationItem("Technology", "https://res.cloudinary.com/veedbeta/image/upload/v1546843386/AppreciationIcon-03_gjled8.png"));
                appreciationItems.add(new AppreciationItem("Math", "https://res.cloudinary.com/veedbeta/image/upload/v1546843386/AppreciationIcon-03_gjled8.png"));
                appreciationItems.add(new AppreciationItem("Music", "https://res.cloudinary.com/veedbeta/image/upload/v1546843386/AppreciationIcon-03_gjled8.png"));
                appreciationItems.add(new AppreciationItem("Art", "https://res.cloudinary.com/veedbeta/image/upload/v1546843386/AppreciationIcon-03_gjled8.png"));
            }
        }
        return new ResponseEntity(appreciationItems, HttpStatus.OK);
    }

    @GetMapping(value={"/get-moods"})
    public ResponseEntity<List<MoodWrapper>> getMoods(@RequestParam(value="grade_id", defaultValue="aEn24") int grade_id) {
        ArrayList<MoodWrapper> moods = new ArrayList<MoodWrapper>();
        switch (grade_id) {
            case 1: {
                moods.add(new MoodWrapper("https://res.cloudinary.com/veedbeta/image/upload/v1540272936/Mad_2FAngry_veznqf.jpg", "mad"));
                moods.add(new MoodWrapper("https://res.cloudinary.com/veedbeta/image/upload/v1540272940/happy_bmcjwa.jpg", "happy"));
                moods.add(new MoodWrapper("https://res.cloudinary.com/veedbeta/image/upload/v1540273006/Excited_pa3fkw.jpg", "excited"));
                moods.add(new MoodWrapper("https://res.cloudinary.com/veedbeta/image/upload/v1540273006/annoyed_ebv6bq.jpg", "annoyed"));
                moods.add(new MoodWrapper("https://res.cloudinary.com/veedbeta/image/upload/v1540305076/sad_apgqzd.jpg", "sad"));
                moods.add(new MoodWrapper("https://res.cloudinary.com/veedbeta/image/upload/v1540305061/Scared_svwem3.jpg", "scared"));
                moods.add(new MoodWrapper("https://res.cloudinary.com/veedbeta/image/upload/v1540305065/Shy_2FAnxious_pxwzrj.jpg", "shy"));
                moods.add(new MoodWrapper("https://res.cloudinary.com/veedbeta/image/upload/v1540305090/silly_2Fwrite_my_own_mood_ahpyof.jpg", "silly"));
                break;
            }
            case 2: {
                moods.add(new MoodWrapper("https://res.cloudinary.com/veedbeta/image/upload/v1540272936/Mad_2FAngry_veznqf.jpg", "mad"));
                moods.add(new MoodWrapper("https://res.cloudinary.com/veedbeta/image/upload/v1540272940/happy_bmcjwa.jpg", "happy"));
                moods.add(new MoodWrapper("https://res.cloudinary.com/veedbeta/image/upload/v1540273006/Excited_pa3fkw.jpg", "excited"));
                moods.add(new MoodWrapper("https://res.cloudinary.com/veedbeta/image/upload/v1540305076/sad_apgqzd.jpg", "sad"));
                moods.add(new MoodWrapper("https://res.cloudinary.com/veedbeta/image/upload/v1540305061/Scared_svwem3.jpg", "scared"));
                moods.add(new MoodWrapper("https://res.cloudinary.com/veedbeta/image/upload/v1540305065/Shy_2FAnxious_pxwzrj.jpg", "shy"));
                moods.add(new MoodWrapper("https://res.cloudinary.com/veedbeta/image/upload/v1540305090/silly_2Fwrite_my_own_mood_ahpyof.jpg", "silly"));
                break;
            }
            case 3: {
                moods.add(new MoodWrapper("https://res.cloudinary.com/veedbeta/image/upload/v1540272936/Mad_2FAngry_veznqf.jpg", "mad"));
                moods.add(new MoodWrapper("https://res.cloudinary.com/veedbeta/image/upload/v1540272940/happy_bmcjwa.jpg", "happy"));
                moods.add(new MoodWrapper("https://res.cloudinary.com/veedbeta/image/upload/v1540273006/Excited_pa3fkw.jpg", "excited"));
                moods.add(new MoodWrapper("https://res.cloudinary.com/veedbeta/image/upload/v1540273006/annoyed_ebv6bq.jpg", "annoyed"));
                moods.add(new MoodWrapper("https://res.cloudinary.com/veedbeta/image/upload/v1540305076/sad_apgqzd.jpg", "sad"));
                moods.add(new MoodWrapper("https://res.cloudinary.com/veedbeta/image/upload/v1540305061/Scared_svwem3.jpg", "scared"));
                moods.add(new MoodWrapper("https://res.cloudinary.com/veedbeta/image/upload/v1540305065/Shy_2FAnxious_pxwzrj.jpg", "shy"));
                moods.add(new MoodWrapper("https://res.cloudinary.com/veedbeta/image/upload/v1540305090/silly_2Fwrite_my_own_mood_ahpyof.jpg", "silly"));
                break;
            }
            default: {
                moods.add(new MoodWrapper("https://res.cloudinary.com/veedbeta/image/upload/v1540272936/Mad_2FAngry_veznqf.jpg", "mad"));
                moods.add(new MoodWrapper("https://res.cloudinary.com/veedbeta/image/upload/v1540272940/happy_bmcjwa.jpg", "happy"));
                moods.add(new MoodWrapper("https://res.cloudinary.com/veedbeta/image/upload/v1540273006/Excited_pa3fkw.jpg", "excited"));
                moods.add(new MoodWrapper("https://res.cloudinary.com/veedbeta/image/upload/v1540273006/annoyed_ebv6bq.jpg", "annoyed"));
                moods.add(new MoodWrapper("https://res.cloudinary.com/veedbeta/image/upload/v1540305076/sad_apgqzd.jpg", "sad"));
                moods.add(new MoodWrapper("https://res.cloudinary.com/veedbeta/image/upload/v1540305061/Scared_svwem3.jpg", "scared"));
                moods.add(new MoodWrapper("https://res.cloudinary.com/veedbeta/image/upload/v1540305065/Shy_2FAnxious_pxwzrj.jpg", "shy"));
                moods.add(new MoodWrapper("https://res.cloudinary.com/veedbeta/image/upload/v1540305090/silly_2Fwrite_my_own_mood_ahpyof.jpg", "silly"));
            }
        }
        return new ResponseEntity(moods, HttpStatus.OK);
    }
}

