/*
 * Decompiled with CFR 0.152.
 */
package com.infinite.focus.server.home;

import com.infinite.focus.server.home.Quote;
import com.infinite.focus.server.home.QuoteRepository;
import com.infinite.focus.server.wall.TopPicks;
import com.infinite.focus.server.wall.TopPicksRepository;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Random;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
public class ScheduledTasks {
    private static final Logger log = LoggerFactory.getLogger(ScheduledTasks.class);
    private static final SimpleDateFormat dateFormat = new SimpleDateFormat("HH:mm:ss");
    private QuoteRepository qouteRepository;
    private TopPicksRepository topPicksRepository;

    @Autowired
    public ScheduledTasks(QuoteRepository qouteRepository, TopPicksRepository topPicksRepository) {
        this.qouteRepository = qouteRepository;
        this.topPicksRepository = topPicksRepository;
    }

    @Scheduled(fixedRate=86400000L)
    public void reportCurrentTime() {
        List quotes = this.qouteRepository.findAll();
        for (Quote q : quotes) {
            q.setIsDailyQuote(Boolean.valueOf(false));
            this.qouteRepository.save((Object)q);
        }
        Random randomizer = new Random();
        int random_index = randomizer.nextInt(quotes.size());
        Quote random = (Quote)quotes.get(random_index);
        random.setIsDailyQuote(Boolean.valueOf(true));
        this.qouteRepository.save((Object)random);
        List topPicksList = this.topPicksRepository.findAll();
        for (TopPicks topPicks : topPicksList) {
            topPicks.setCreatedAt(topPicks.getCreatedAt());
            topPicks.setUpdateAt(new Date());
            topPicks.setIsDailyTopPicks(Boolean.valueOf(false));
            this.topPicksRepository.save((Object)topPicks);
        }
        Random randomizerTopPicks = new Random();
        int random_index_topPicks = randomizerTopPicks.nextInt(topPicksList.size());
        TopPicks random_topPicks = (TopPicks)topPicksList.get(random_index_topPicks);
        random_topPicks.setCreatedAt(random_topPicks.getCreatedAt());
        random_topPicks.setIsDailyTopPicks(Boolean.valueOf(true));
        random_topPicks.setUpdateAt(new Date());
        this.topPicksRepository.save((Object)random_topPicks);
    }
}

