/*
 * Decompiled with CFR 0.152.
 */
package com.infinite.focus.server.instructor;

import com.infinite.focus.server.auth.AccessCode;
import com.infinite.focus.server.auth.AccessCodeRepository;
import com.infinite.focus.server.auth.Account;
import com.infinite.focus.server.auth.AccountRepository;
import com.infinite.focus.server.auth.AvatarRepository;
import com.infinite.focus.server.auth.EmailSenderService;
import com.infinite.focus.server.auth.Instructor;
import com.infinite.focus.server.auth.InstructorRepository;
import com.infinite.focus.server.auth.Message;
import com.infinite.focus.server.auth.Status;
import com.infinite.focus.server.auth.StudentRepository;
import com.infinite.focus.server.auth.service.AuthService;
import com.infinite.focus.server.home.DailyAppreciationRepository;
import com.infinite.focus.server.home.MoodUpdateRepository;
import com.infinite.focus.server.home.QuoteRepository;
import com.infinite.focus.server.instructor.SendEmailRequest;
import com.infinite.focus.server.students.ClassRepository;
import com.infinite.focus.server.utils.AppUtils;
import com.infinite.focus.server.wall.WallPostAttachmentRepository;
import com.infinite.focus.server.wall.WallPostRepository;
import com.infinite.focus.server.wall.WallPostRequestRepository;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.mail.SimpleMailMessage;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.server.ResponseStatusException;

@CrossOrigin(origins={"http://localhost:8383"})
@RestController
@RequestMapping(value={"api/instructor"})
public class InstructorController {
    private AccountRepository accountRepository;
    private StudentRepository studentRepository;
    private InstructorRepository instructorRepository;
    private AvatarRepository avatarRepository;
    private BCryptPasswordEncoder bCryptPasswordEncoder;
    private WallPostRepository wallPostRepository;
    private WallPostAttachmentRepository wallPostAttachmentRepository;
    private WallPostRequestRepository wallPostRequestRepository;
    private QuoteRepository qouteRepository;
    private MoodUpdateRepository moodUpdateRepository;
    private DailyAppreciationRepository dailyAppreciationRepository;
    private ClassRepository classRepository;
    private AccessCodeRepository accessCodeRepository;
    private EmailSenderService emailSenderService;
    @Autowired
    AuthService authService;

    public InstructorController(ClassRepository classRepository, DailyAppreciationRepository dailyAppreciationRepository, MoodUpdateRepository moodUpdateRepository, QuoteRepository qouteRepository, WallPostRepository wallPostRepository, WallPostAttachmentRepository wallPostAttachmentRepository, WallPostRequestRepository wallPostRequestRepository, AvatarRepository avatarRepository, InstructorRepository instructorRepository, StudentRepository studentRepository, AccountRepository accountRepository, BCryptPasswordEncoder bCryptPasswordEncoder, AccessCodeRepository accessCodeRepository, EmailSenderService emailSenderService) {
        this.classRepository = classRepository;
        this.qouteRepository = qouteRepository;
        this.wallPostRepository = wallPostRepository;
        this.wallPostAttachmentRepository = wallPostAttachmentRepository;
        this.wallPostRequestRepository = wallPostRequestRepository;
        this.avatarRepository = avatarRepository;
        this.bCryptPasswordEncoder = bCryptPasswordEncoder;
        this.instructorRepository = instructorRepository;
        this.studentRepository = studentRepository;
        this.accountRepository = accountRepository;
        this.moodUpdateRepository = moodUpdateRepository;
        this.dailyAppreciationRepository = dailyAppreciationRepository;
        this.accessCodeRepository = accessCodeRepository;
        this.emailSenderService = emailSenderService;
    }

    @GetMapping(value={"/get/getAccessCodesByInstructorId"})
    public ResponseEntity<Page<AccessCode>> getAccessCodesByInstructorId(@RequestParam(value="instructor_id", defaultValue="aEn24") Long instructor_id, @RequestParam(value="pageNo", defaultValue="0") Integer pageNo, @RequestParam(value="pageSize", defaultValue="10") Integer pageSize, @RequestParam(value="sortBy", defaultValue="access_code_id") String sortBy, @RequestParam(value="status", defaultValue="PENDING") String status) {
        PageRequest paging = PageRequest.of((int)pageNo, (int)pageSize, (Sort)Sort.by((String[])new String[]{sortBy}).ascending());
        Page pagedResult = this.accessCodeRepository.findByInstructorIdAndStatus(instructor_id, status.toString(), (Pageable)paging);
        return new ResponseEntity((Object)pagedResult, (MultiValueMap)new HttpHeaders(), HttpStatus.OK);
    }

    @PostMapping(value={"/approve-access-code"})
    public ResponseEntity<AccessCode> approveAccessCode(@RequestParam(value="instructor_id") long instructor_id, @RequestParam(value="access_code_id") Long access_code_id, @RequestParam(value="status") Status isApproved) {
        AccessCode accessCode = this.accessCodeRepository.findById((Object)access_code_id).orElse(null);
        if (accessCode != null) {
            if (accessCode.getStudent().getInstructor_id() == instructor_id) {
                accessCode.setStatus(isApproved);
                this.accessCodeRepository.save((Object)accessCode);
                Account account = this.accountRepository.findByAccountId(accessCode.getStudent().getAccount_id());
                if (accessCode.getStatus() == Status.ACCEPTED) {
                    SimpleMailMessage mailMessage = new SimpleMailMessage();
                    mailMessage.setTo(account.getUsername());
                    mailMessage.setSubject("Access code");
                    mailMessage.setText("To complete the registration process, please use this otp to verify your account " + accessCode.getAccessCode());
                    this.emailSenderService.sendEmail(mailMessage);
                }
                return new ResponseEntity((Object)accessCode, HttpStatus.OK);
            }
            return new ResponseEntity(HttpStatus.NOT_FOUND);
        }
        return new ResponseEntity(HttpStatus.NOT_FOUND);
    }

    @PostMapping(value={"/send/email/to/all/instructors"})
    public ResponseEntity<Message> sendEmailToAllInstructors(@RequestHeader(value="Authorization") String token, @RequestBody SendEmailRequest sendEmailRequest) {
        this.authService.isAdmin(token);
        if (AppUtils.isNullOrEmpty((String)sendEmailRequest.getSubject())) {
            throw new ResponseStatusException(HttpStatus.CONFLICT, "The subject is required.");
        }
        if (AppUtils.isNullOrEmpty((String)sendEmailRequest.getBody())) {
            throw new ResponseStatusException(HttpStatus.CONFLICT, "The body is required.");
        }
        List instructorsEmails = this.instructorRepository.getAllInstructorsEmailAddresses();
        for (int i = 0; i < instructorsEmails.size(); ++i) {
            String email = (String)instructorsEmails.get(i);
            if (!AppUtils.isNotNullOrEmpty((String)email) || !email.contains("@mailinator.com") && !email.contains("@yopmail.com")) continue;
            System.out.println(email);
            try {
                SimpleMailMessage mailMessage = new SimpleMailMessage();
                mailMessage.setTo(email);
                mailMessage.setSubject(sendEmailRequest.getSubject());
                mailMessage.setText(sendEmailRequest.getBody() + "\n\nThanks,\r\nInfinite Focus Schools");
                this.emailSenderService.sendEmail(mailMessage);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        Message message = new Message("Email has been sent to all Instructors.");
        return new ResponseEntity((Object)message, HttpStatus.OK);
    }

    @PostMapping(value={"/edit/profile"})
    public ResponseEntity<Instructor> editProfile(@RequestHeader(value="Authorization") String token, @RequestBody Instructor instructor) {
        Instructor i = this.authService.isInstructor(token);
        if (i == null) {
            throw new ResponseStatusException(HttpStatus.NOT_FOUND, "The instructor is not found.");
        }
        if (AppUtils.isNullOrEmpty((String)instructor.getFirst_name())) {
            throw new ResponseStatusException(HttpStatus.CONFLICT, "The first name is required.");
        }
        if (AppUtils.isNullOrEmpty((String)instructor.getLast_name())) {
            throw new ResponseStatusException(HttpStatus.CONFLICT, "The last name is required.");
        }
        if (AppUtils.isNullOrEmpty((String)instructor.getState())) {
            throw new ResponseStatusException(HttpStatus.CONFLICT, "The state is required.");
        }
        if (AppUtils.isNullOrEmpty((String)instructor.getCity())) {
            throw new ResponseStatusException(HttpStatus.CONFLICT, "The city is required.");
        }
        i.setFirst_name(instructor.getFirst_name());
        i.setLast_name(instructor.getLast_name());
        i.setGrade_id(instructor.getGrade_id());
        i.setStandard_id(instructor.getStandard_id());
        i.setState(instructor.getState());
        i.setCity(instructor.getCity());
        Instructor instru = (Instructor)this.instructorRepository.save((Object)i);
        return new ResponseEntity((Object)instru, HttpStatus.OK);
    }
}

