/*
 * Decompiled with CFR 0.152.
 */
package com.infinite.focus.server.notifications.service;

import com.infinite.focus.server.home.GetNotificationsRequest;
import com.infinite.focus.server.home.Notification;
import com.infinite.focus.server.home.NotificationRepository;
import com.infinite.focus.server.notifications.service.NotificationService;
import com.infinite.focus.server.utils.AppUtils;
import com.infinite.focus.server.utils.DateUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Order;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class NotificationServiceImpl
implements NotificationService {
    @Autowired
    EntityManager entityManager;
    @Autowired
    NotificationRepository notificationRepository;

    public List<Notification> getNotifications(GetNotificationsRequest request) {
        Predicate genderPredicate;
        CriteriaBuilder qb = this.entityManager.getCriteriaBuilder();
        CriteriaQuery query = qb.createQuery(Notification.class);
        Root root = query.from(Notification.class);
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        if (AppUtils.isNotNullOrEmpty((List)request.getStudentIds())) {
            genderPredicate = qb.in((Expression)root.get("student_id")).value((Object)request.getStudentIds());
            predicates.add(genderPredicate);
        } else {
            genderPredicate = qb.notEqual((Expression)root.get("student_id"), (Object)0);
            predicates.add(genderPredicate);
        }
        predicates.add(qb.equal((Expression)root.get("instructor_id"), (Object)request.getInstructor_id()));
        if (request.getFromDate() != null && request.getToDate() != null) {
            System.out.println("getNotifications FromDate " + DateUtils.dayWitTimeFormat.format(request.getFromDate()) + " - ToDate " + DateUtils.dayWitTimeFormat.format(request.getToDate()));
            predicates.add(qb.between((Expression)root.get("createdAt"), (Comparable)DateUtils.getFromDateWithoutTime((Date)request.getFromDate()), (Comparable)DateUtils.getToDateWithoutTime((Date)request.getToDate())));
        }
        query.where(predicates.toArray(new Predicate[0])).orderBy(new Order[]{qb.desc((Expression)root.get("createdAt"))});
        TypedQuery typedQuery = this.entityManager.createQuery(query);
        List notifications = typedQuery.getResultList();
        System.out.println("Notification Count = " + notifications.size());
        return notifications;
    }
}

