/*
 * Decompiled with CFR 0.152.
 */
package com.infinite.focus.server.students.service;

import com.infinite.focus.server.auth.Instructor;
import com.infinite.focus.server.auth.InstructorRepository;
import com.infinite.focus.server.auth.Student;
import com.infinite.focus.server.auth.StudentRepository;
import com.infinite.focus.server.dashboard.GetDataDashBoardRequest;
import com.infinite.focus.server.grade.GradeRepository;
import com.infinite.focus.server.standard.StandardRepository;
import com.infinite.focus.server.students.ClassRepository;
import com.infinite.focus.server.students.SearchStudentRequest;
import com.infinite.focus.server.students.service.StudentService;
import com.infinite.focus.server.utils.AppUtils;
import com.infinite.focus.server.utils.UnitExpression;
import java.math.BigInteger;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Join;
import javax.persistence.criteria.JoinType;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class StudentServiceImpl
implements StudentService {
    @Autowired
    EntityManager entityManager;
    @Autowired
    GradeRepository gradeRepository;
    @Autowired
    StandardRepository standardRepository;
    @Autowired
    StudentRepository studentRepository;
    @Autowired
    InstructorRepository instructorRepository;
    @Autowired
    ClassRepository classRepository;
    String forwardSlash = "/";

    public List<Long> getStudentByDemographics(GetDataDashBoardRequest request) {
        CriteriaBuilder qb = this.entityManager.getCriteriaBuilder();
        CriteriaQuery c = qb.createQuery(Long.class);
        Root s = c.from(Student.class);
        ArrayList<CriteriaBuilder.In> predicates = new ArrayList<CriteriaBuilder.In>();
        if (AppUtils.isNotNullOrEmpty((List)request.getGenders())) {
            CriteriaBuilder.In genderPredicate = qb.in((Expression)s.get("gender")).value((Object)request.getGenders());
            predicates.add(genderPredicate);
        }
        if (AppUtils.isNotNullOrEmpty((List)request.getAges())) {
            UnitExpression year = new UnitExpression(null, String.class, "YEAR");
            Expression timeInYears = qb.function("TIMESTAMPDIFF", Integer.class, new Expression[]{year, s.get("date_of_birth"), qb.literal((Object)Timestamp.valueOf(LocalDateTime.now()))});
            CriteriaBuilder.In inClause = qb.in(timeInYears);
            for (Integer age : request.getAges()) {
                inClause.value((Object)age);
            }
            predicates.add(inClause);
        }
        if (AppUtils.isNotNullOrEmpty((List)request.getEthnicity())) {
            CriteriaBuilder.In ethnicityPredicate = qb.in((Expression)s.get("ethnicity")).value((Object)request.getEthnicity());
            predicates.add(ethnicityPredicate);
        }
        if (AppUtils.isNotNullOrEmpty((List)request.getGradeIds())) {
            CriteriaBuilder.In gradePredicate = qb.in((Expression)s.get("grade_id")).value((Object)request.getGradeIds());
            predicates.add(gradePredicate);
        }
        if (AppUtils.isNotNullOrEmpty((List)request.getClassIds())) {
            CriteriaBuilder.In classesPredicate = qb.in((Expression)s.get("class_id")).value((Object)request.getClassIds());
            predicates.add(classesPredicate);
        }
        c.select((Selection)s.get("student_id")).where(predicates.toArray(new Predicate[0]));
        TypedQuery typedQuery = this.entityManager.createQuery(c);
        List student_ids = typedQuery.getResultList();
        System.out.println("Student Count = " + student_ids.size());
        return student_ids;
    }

    public List<Student> searchStudentByInstructorAndDemographic(Instructor instructor, SearchStudentRequest request) {
        Predicate genderPredicate;
        CriteriaBuilder qb = this.entityManager.getCriteriaBuilder();
        CriteriaQuery c = qb.createQuery(Student.class);
        Root s = c.from(Student.class);
        Join ac = s.join("account", JoinType.LEFT);
        ArrayList<Object> predicates = new ArrayList<Object>();
        if (instructor != null) {
            genderPredicate = qb.equal((Expression)s.get("instructor_id"), (Object)instructor.getInstructor_id());
            predicates.add(genderPredicate);
        }
        if (AppUtils.isNotNullOrEmpty((String)request.getFirst_name())) {
            genderPredicate = qb.like((Expression)s.get("first_name"), "%" + request.getFirst_name() + "%");
            predicates.add(genderPredicate);
        }
        if (AppUtils.isNotNullOrEmpty((String)request.getLast_name())) {
            genderPredicate = qb.like((Expression)s.get("last_name"), "%" + request.getLast_name() + "%");
            predicates.add(genderPredicate);
        }
        if (AppUtils.isNotNullOrEmpty((String)request.getEmail())) {
            genderPredicate = qb.like((Expression)ac.get("username"), "%" + request.getEmail() + "%");
            predicates.add(genderPredicate);
        }
        if (AppUtils.isNotNullOrEmpty((String)request.getClass_name())) {
            List classIds = this.classRepository.findClassIdsWhereClassNameLike(request.getClass_name());
            if (AppUtils.isNotNullOrEmpty((List)classIds)) {
                ArrayList<Long> ids = new ArrayList<Long>();
                for (int i = 0; i < classIds.size(); ++i) {
                    ids.add(((BigInteger)classIds.get(i)).longValue());
                }
                CriteriaBuilder.In classesPredicate = qb.in((Expression)s.get("class_id")).value(ids);
                predicates.add(classesPredicate);
            } else {
                CriteriaBuilder.In classesPredicate = qb.in((Expression)s.get("class_id")).value((Object)-1);
                predicates.add(classesPredicate);
            }
        }
        c.where(predicates.toArray(new Predicate[0]));
        TypedQuery typedQuery = this.entityManager.createQuery(c);
        List students = typedQuery.getResultList();
        System.out.println("Student Count = " + students.size());
        return students;
    }
}

