/*
 * Decompiled with CFR 0.152.
 */
package com.infinite.focus.server.utils;

import com.infinite.focus.server.dashboard.TimeLine;
import com.infinite.focus.server.utils.DateUtils;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.Period;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.ThreadLocalRandom;

/*
 * Exception performing whole class analysis ignored.
 */
public class DateUtils {
    public static final SimpleDateFormat dayWitTimeFormat = new SimpleDateFormat("MMM dd, yyyy HH:mm:ss", Locale.getDefault());
    public static final SimpleDateFormat dailyDateFormat = new SimpleDateFormat("MMM dd, yyyy", Locale.getDefault());
    public static final SimpleDateFormat weeklyDateFormat = new SimpleDateFormat("MMM dd", Locale.getDefault());
    public static final SimpleDateFormat monthlyDateFormat = new SimpleDateFormat("MMM yyyy", Locale.getDefault());
    public static final SimpleDateFormat yearlyDateFormat = new SimpleDateFormat("yyyy", Locale.getDefault());

    public static Date getToDateByTimeLine(TimeLine timeLine) {
        Date toDate = new Date();
        switch (1.$SwitchMap$com$infinite$focus$server$dashboard$TimeLine[timeLine.ordinal()]) {
            case 1: {
                toDate = DateUtils.getDailyDate();
                break;
            }
            case 2: {
                toDate = DateUtils.getWeeklyDate();
                break;
            }
            case 3: {
                toDate = DateUtils.getMonthlyDate();
                break;
            }
            case 4: {
                toDate = DateUtils.getYearlyDate();
            }
        }
        return toDate;
    }

    public static Date getDailyDate() {
        Calendar c = Calendar.getInstance();
        c.add(6, -14);
        Date startDate = c.getTime();
        return startDate;
    }

    public static Date getWeeklyDate() {
        Calendar c = Calendar.getInstance();
        Date date = new Date();
        c.setTime(date);
        int i = c.get(7) - c.getFirstDayOfWeek();
        c.add(5, -i - 35);
        Date startDate = c.getTime();
        return startDate;
    }

    public static Date getMonthlyDate() {
        Calendar c = Calendar.getInstance();
        Date date = new Date();
        c.setTime(date);
        c.set(5, 1);
        c.add(2, -5);
        Date startDate = c.getTime();
        return startDate;
    }

    public static Date getYearlyDate() {
        Calendar c = Calendar.getInstance();
        Date date = new Date();
        c.setTime(date);
        c.set(5, 1);
        c.add(1, -4);
        Date startDate = c.getTime();
        return startDate;
    }

    public static List<String> getLabelsByTimeLine(TimeLine timeLine) {
        List<String> labels = new ArrayList<String>();
        switch (1.$SwitchMap$com$infinite$focus$server$dashboard$TimeLine[timeLine.ordinal()]) {
            case 1: {
                labels = DateUtils.getDailyLabels();
                break;
            }
            case 2: {
                labels = DateUtils.getWeeklyLabels();
                break;
            }
            case 3: {
                labels = DateUtils.getMonthlyLabels();
                break;
            }
            case 4: {
                labels = DateUtils.getYearlyLabels();
            }
        }
        return labels;
    }

    public static List<String> getDailyLabels() {
        ArrayList<String> labels = new ArrayList<String>();
        Calendar c = Calendar.getInstance();
        for (int i = 0; i < 15; ++i) {
            Date date = new Date();
            c.setTime(date);
            c.add(6, -i);
            labels.add(dailyDateFormat.format(c.getTime()));
        }
        return labels;
    }

    public static String getWeekendByDate(Date date) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        int x = c.get(7) - c.getFirstDayOfWeek();
        c.add(5, -x);
        Date startDate = c.getTime();
        c.add(5, 6);
        Date endDate = c.getTime();
        String weekend = weeklyDateFormat.format(startDate) + " - " + weeklyDateFormat.format(endDate);
        return weekend;
    }

    public static final List<String> getWeeklyLabels() {
        ArrayList<String> labels = new ArrayList<String>();
        Calendar c = Calendar.getInstance();
        for (int i = 0; i < 6; ++i) {
            Date date = new Date();
            c.setTime(date);
            int x = c.get(7) - c.getFirstDayOfWeek();
            c.add(5, -x - 7 * i);
            Date startDate = c.getTime();
            c.add(5, 6);
            Date endDate = c.getTime();
            if (labels.isEmpty()) {
                labels.add(weeklyDateFormat.format(startDate) + " - " + weeklyDateFormat.format(endDate));
                continue;
            }
            labels.add(weeklyDateFormat.format(startDate) + " - " + weeklyDateFormat.format(endDate));
        }
        return labels;
    }

    public static List<String> getMonthlyLabels() {
        ArrayList<String> labels = new ArrayList<String>();
        Calendar c = Calendar.getInstance();
        c.set(5, 1);
        for (int i = 0; i < 6; ++i) {
            Date date = new Date();
            c.setTime(date);
            c.add(2, -i);
            labels.add(monthlyDateFormat.format(c.getTime()));
        }
        return labels;
    }

    public static List<String> getYearlyLabels() {
        ArrayList<String> labels = new ArrayList<String>();
        Calendar c = Calendar.getInstance();
        c.set(5, 1);
        for (int i = 0; i < 5; ++i) {
            Date date = new Date();
            c.setTime(date);
            c.add(1, -i);
            labels.add(yearlyDateFormat.format(c.getTime()));
        }
        return labels;
    }

    public static int getDayCountByFromDateAndToDate(Date fromDate, Date toDate) {
        Calendar c = Calendar.getInstance();
        c.setTime(DateUtils.setTimeToFromDate((Date)fromDate));
        Date endDate = c.getTime();
        String day = dailyDateFormat.format(endDate);
        toDate = DateUtils.setTimeToToDate((Date)toDate);
        int count = 0;
        while (endDate.getTime() <= toDate.getTime()) {
            c.add(5, 1);
            endDate = c.getTime();
            ++count;
        }
        return count;
    }

    public static int getWeekCountByFromDateAndToDate(Date fromDate, Date toDate) {
        Calendar c = Calendar.getInstance();
        Date startDate = DateUtils.getWeekendLastDate((Date)fromDate);
        c.setTime(startDate);
        Date endDate = DateUtils.getWeekendLastDate((Date)toDate);
        String weekend = weeklyDateFormat.format(startDate) + " - " + weeklyDateFormat.format(endDate);
        int count = 0;
        while (startDate.getTime() <= endDate.getTime()) {
            c.add(5, 1);
            startDate = DateUtils.getWeekendLastDate((Date)c.getTime());
            c.setTime(startDate);
            ++count;
        }
        return count;
    }

    public static Date getWeekendFirstDate(Date date) {
        Calendar c = Calendar.getInstance();
        c.setTime(DateUtils.setTimeToFromDate((Date)date));
        int x = c.get(7) - c.getFirstDayOfWeek();
        c.add(5, -x);
        return c.getTime();
    }

    public static Date getWeekendLastDate(Date date) {
        Calendar c = Calendar.getInstance();
        c.setTime(DateUtils.setTimeToFromDate((Date)date));
        int x = c.get(7) - c.getFirstDayOfWeek();
        c.add(5, -x);
        c.add(5, 6);
        return c.getTime();
    }

    public static int getMonthCountByFromDateAndToDate(Date fromDate, Date toDate) {
        Calendar c = Calendar.getInstance();
        c.setTime(DateUtils.setTimeToToDate((Date)toDate));
        c.set(5, 1);
        toDate = c.getTime();
        c.setTime(DateUtils.setTimeToFromDate((Date)fromDate));
        c.set(5, 1);
        Date endDate = c.getTime();
        String month = monthlyDateFormat.format(endDate);
        int count = 0;
        while (endDate.getTime() <= toDate.getTime()) {
            c.add(2, 1);
            endDate = c.getTime();
            ++count;
        }
        return count;
    }

    public static int getYearCountByFromDateAndToDate(Date fromDate, Date toDate) {
        Calendar c = Calendar.getInstance();
        c.setTime(DateUtils.setTimeToToDate((Date)toDate));
        c.set(5, 1);
        c.set(2, 11);
        toDate = c.getTime();
        c.setTime(DateUtils.setTimeToFromDate((Date)fromDate));
        c.set(5, 1);
        c.set(2, 11);
        Date endDate = c.getTime();
        String month = yearlyDateFormat.format(endDate);
        int count = 0;
        while (endDate.getTime() <= toDate.getTime()) {
            c.add(1, 1);
            endDate = c.getTime();
            ++count;
        }
        return count;
    }

    public static Date between(Date startInclusive, Date endExclusive) {
        long startMillis = startInclusive.getTime();
        long endMillis = endExclusive.getTime();
        long randomMillisSinceEpoch = ThreadLocalRandom.current().nextLong(startMillis, endMillis);
        return new Date(randomMillisSinceEpoch);
    }

    public static Date setTimeToFromDate(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        return cal.getTime();
    }

    public static Date setTimeToToDate(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.set(11, 23);
        cal.set(12, 59);
        cal.set(13, 59);
        cal.set(14, 999);
        return cal.getTime();
    }

    public static Period getPeriodByFromAndToDate(Date fromDate, Date toDate) {
        LocalDate pdate = DateUtils.convertToLocalDateViaInstant((Date)DateUtils.setTimeToFromDate((Date)fromDate));
        LocalDate now = DateUtils.convertToLocalDateViaInstant((Date)DateUtils.setTimeToToDate((Date)toDate));
        Period diff = Period.between(pdate, now);
        System.out.printf("\nDifference is %d years, %d months and %d days old\n\n", diff.getYears(), diff.getMonths(), diff.getDays());
        return diff;
    }

    public static LocalDate convertToLocalDateViaInstant(Date dateToConvert) {
        return dateToConvert.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
    }

    public static int getAge(Date dateOfBirth) {
        Calendar today = Calendar.getInstance();
        Calendar birthDate = Calendar.getInstance();
        int age = 0;
        birthDate.setTime(dateOfBirth);
        if (birthDate.after(today)) {
            throw new IllegalArgumentException("Can't be born in the future");
        }
        age = today.get(1) - birthDate.get(1);
        if (birthDate.get(6) - today.get(6) > 3 || birthDate.get(2) > today.get(2)) {
            --age;
        } else if (birthDate.get(2) == today.get(2) && birthDate.get(5) > today.get(5)) {
            --age;
        }
        return age;
    }

    public static Date getFromDateWithoutTime(Date fromDate) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(fromDate);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        return cal.getTime();
    }

    public static Date getToDateWithoutTime(Date toDate) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(toDate);
        cal.set(11, 23);
        cal.set(12, 59);
        cal.set(13, 59);
        cal.set(14, 999);
        return cal.getTime();
    }
}

