/*
 * Decompiled with CFR 0.152.
 */
package com.infinite.focus.server.wall;

import com.cloudinary.Cloudinary;
import com.cloudinary.utils.ObjectUtils;
import com.infinite.focus.server.auth.Account;
import com.infinite.focus.server.auth.AccountRepository;
import com.infinite.focus.server.auth.Admin;
import com.infinite.focus.server.auth.AdminRepository;
import com.infinite.focus.server.auth.AuthenticationController;
import com.infinite.focus.server.auth.AvatarRepository;
import com.infinite.focus.server.auth.Instructor;
import com.infinite.focus.server.auth.InstructorRepository;
import com.infinite.focus.server.auth.Message;
import com.infinite.focus.server.auth.Student;
import com.infinite.focus.server.auth.StudentRepository;
import com.infinite.focus.server.wall.TopPicks;
import com.infinite.focus.server.wall.TopPicksRepository;
import com.infinite.focus.server.wall.WallPost;
import com.infinite.focus.server.wall.WallPostAttachment;
import com.infinite.focus.server.wall.WallPostAttachmentRepository;
import com.infinite.focus.server.wall.WallPostProfileWrapper;
import com.infinite.focus.server.wall.WallPostRepository;
import com.infinite.focus.server.wall.WallPostRequest;
import com.infinite.focus.server.wall.WallPostRequestRepository;
import com.infinite.focus.server.wall.WallPostRequestWrapper;
import com.infinite.focus.server.wall.WallPostWrapper;
import com.infinite.focus.server.wall.WallPostsDeleteRequest;
import io.jsonwebtoken.Claims;
import io.jsonwebtoken.Jwts;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.server.ResponseStatusException;

@CrossOrigin(origins={"http://localhost:8383"})
@RestController
@RequestMapping(value={"api/wall"})
public class WallPostController {
    private AccountRepository accountRepository;
    private StudentRepository studentRepository;
    private InstructorRepository instructorRepository;
    private AvatarRepository avatarRepository;
    private BCryptPasswordEncoder bCryptPasswordEncoder;
    private WallPostRepository wallPostRepository;
    private WallPostAttachmentRepository wallPostAttachmentRepository;
    private WallPostRequestRepository wallPostRequestRepository;
    private AdminRepository adminRepository;
    private TopPicksRepository topPicksRepository;

    public WallPostController(AdminRepository adminRepository, WallPostRepository wallPostRepository, WallPostAttachmentRepository wallPostAttachmentRepository, WallPostRequestRepository wallPostRequestRepository, AvatarRepository avatarRepository, InstructorRepository instructorRepository, StudentRepository studentRepository, AccountRepository accountRepository, TopPicksRepository topPicksRepository, BCryptPasswordEncoder bCryptPasswordEncoder) {
        this.adminRepository = adminRepository;
        this.wallPostRepository = wallPostRepository;
        this.wallPostAttachmentRepository = wallPostAttachmentRepository;
        this.wallPostRequestRepository = wallPostRequestRepository;
        this.avatarRepository = avatarRepository;
        this.bCryptPasswordEncoder = bCryptPasswordEncoder;
        this.instructorRepository = instructorRepository;
        this.studentRepository = studentRepository;
        this.accountRepository = accountRepository;
        this.topPicksRepository = topPicksRepository;
    }

    @GetMapping(value={"/respond/request"})
    public ResponseEntity<WallPost> respondRequest(@RequestParam(value="wall_post_request_id", defaultValue="aEn24") Long wall_post_request_id, @RequestParam(value="response", defaultValue="aEn24") Boolean response) {
        WallPostRequest w = (WallPostRequest)this.wallPostRequestRepository.getOne((Object)wall_post_request_id);
        if (w == null) {
            return new ResponseEntity(HttpStatus.CONFLICT);
        }
        WallPost p = (WallPost)this.wallPostRepository.getOne((Object)w.getWall_post_id());
        if (p == null) {
            return new ResponseEntity(HttpStatus.CONFLICT);
        }
        if (response.booleanValue()) {
            this.wallPostRequestRepository.delete((Object)w);
            p.setIsActive(Boolean.valueOf(true));
            return new ResponseEntity((Object)((WallPost)this.wallPostRepository.save((Object)p)), HttpStatus.OK);
        }
        this.wallPostRequestRepository.delete((Object)w);
        this.wallPostRepository.delete((Object)p);
        return new ResponseEntity((Object)p, HttpStatus.OK);
    }

    @GetMapping(value={"/add/like"})
    public ResponseEntity<WallPost> addLike(@RequestParam(value="wall_post_id", defaultValue="aEn24") Long wall_post_id) {
        WallPost wp = (WallPost)this.wallPostRepository.getOne((Object)wall_post_id);
        if (wp == null) {
            return new ResponseEntity(HttpStatus.NOT_FOUND);
        }
        wp.setLikes(wp.getLikes() + 1);
        return new ResponseEntity((Object)((WallPost)this.wallPostRepository.save((Object)wp)), HttpStatus.OK);
    }

    @GetMapping(value={"/get/requests"})
    public ResponseEntity<List<WallPostRequestWrapper>> getRequests(@RequestParam(value="instructor_id", defaultValue="aEn24") Long instructor_id) {
        ArrayList<WallPostRequestWrapper> list = new ArrayList<WallPostRequestWrapper>();
        for (WallPostRequest r : this.wallPostRequestRepository.findByInstructor(instructor_id)) {
            WallPostRequestWrapper rw = new WallPostRequestWrapper();
            rw.setWallPostRequest(r);
            WallPost wp = (WallPost)this.wallPostRepository.getOne((Object)r.getWall_post_id());
            WallPostWrapper wr = new WallPostWrapper();
            wr.setWallPost(wp);
            wr.setAttachments(this.wallPostAttachmentRepository.findByWallPost(Long.valueOf(wp.getWall_post_id())));
            rw.setWallPost(wr);
            list.add(rw);
        }
        return new ResponseEntity(list, HttpStatus.OK);
    }

    @GetMapping(value={"/get/instructor/posts"})
    public ResponseEntity<List<WallPostProfileWrapper>> getWallPostsByInstructorId(@RequestParam(value="instructor_id", defaultValue="aEn24") Long instructor_id) {
        ArrayList<WallPostProfileWrapper> posts = new ArrayList<WallPostProfileWrapper>();
        List list = this.wallPostRepository.findAllActive();
        for (WallPost w : list) {
            if (w.getIsDeleted() != null && w.getIsDeleted().booleanValue()) continue;
            WallPostProfileWrapper wr = new WallPostProfileWrapper();
            WallPostWrapper wpr = new WallPostWrapper();
            wpr.setWallPost(w);
            wpr.setAttachments(this.wallPostAttachmentRepository.findByWallPost(Long.valueOf(w.getWall_post_id())));
            wr.setWallPost(wpr);
            if (w.getType().toLowerCase().trim().equals("student")) {
                Student student = (Student)this.studentRepository.getOne((Object)w.getStudent_id());
                if (student.getInstructor_id() != instructor_id.longValue()) continue;
                wr.setStudent(student);
            }
            if (w.getType().toLowerCase().trim().equals("instructor")) {
                Instructor instructor = (Instructor)this.instructorRepository.getOne((Object)w.getInstructor_id());
                if (instructor.getInstructor_id() != instructor_id.longValue()) continue;
                wr.setInstructor(instructor);
            }
            posts.add(wr);
        }
        return new ResponseEntity(posts, HttpStatus.OK);
    }

    @GetMapping(value={"/get/all/posts"})
    public ResponseEntity<List<WallPostProfileWrapper>> getWallPosts() {
        ArrayList<WallPostProfileWrapper> posts = new ArrayList<WallPostProfileWrapper>();
        List list = this.wallPostRepository.findAllActive();
        for (WallPost w : list) {
            if (w.getIsDeleted() != null && w.getIsDeleted().booleanValue()) continue;
            WallPostProfileWrapper wr = new WallPostProfileWrapper();
            WallPostWrapper wpr = new WallPostWrapper();
            wpr.setWallPost(w);
            wpr.setAttachments(this.wallPostAttachmentRepository.findByWallPost(Long.valueOf(w.getWall_post_id())));
            wr.setWallPost(wpr);
            if (w.getType().toLowerCase().trim().equals("student")) {
                wr.setStudent((Student)this.studentRepository.getOne((Object)w.getStudent_id()));
            }
            if (w.getType().toLowerCase().trim().equals("instructor")) {
                wr.setInstructor((Instructor)this.instructorRepository.getOne((Object)w.getInstructor_id()));
            }
            posts.add(wr);
        }
        return new ResponseEntity(posts, HttpStatus.OK);
    }

    @PostMapping(value={"/create/post"})
    @ResponseBody
    public ResponseEntity<WallPost> createPost(@RequestBody WallPostWrapper request) {
        Student student = (Student)this.studentRepository.getOne((Object)request.getWallPost().getStudent_id());
        if (student == null) {
            return new ResponseEntity(HttpStatus.CONFLICT);
        }
        request.getWallPost().setType("student");
        request.getWallPost().setIsActive(Boolean.valueOf(false));
        request.getWallPost().setIsDeleted(Boolean.valueOf(false));
        WallPost wallPost = (WallPost)this.wallPostRepository.save((Object)request.getWallPost());
        for (WallPostAttachment w : request.getAttachments()) {
            w.setWall_post_id(wallPost.getWall_post_id());
            this.wallPostAttachmentRepository.save((Object)w);
        }
        WallPostRequest wallPostRequest = new WallPostRequest();
        wallPostRequest.setInstructor_id(student.getInstructor_id());
        wallPostRequest.setWall_post_id(wallPost.getWall_post_id());
        this.wallPostRequestRepository.save((Object)wallPostRequest);
        return new ResponseEntity((Object)wallPost, HttpStatus.OK);
    }

    @PostMapping(value={"/create/post/instructor"})
    @ResponseBody
    public ResponseEntity<WallPost> createPostInstructor(@RequestBody WallPostWrapper request) {
        request.getWallPost().setType("instructor");
        request.getWallPost().setIsActive(Boolean.valueOf(true));
        WallPost wallPost = (WallPost)this.wallPostRepository.save((Object)request.getWallPost());
        for (WallPostAttachment w : request.getAttachments()) {
            w.setWall_post_id(wallPost.getWall_post_id());
            this.wallPostAttachmentRepository.save((Object)w);
        }
        return new ResponseEntity((Object)wallPost, HttpStatus.OK);
    }

    @PostMapping(value={"/update/post"})
    @ResponseBody
    public ResponseEntity<WallPost> updatePost(@RequestHeader(value="Authorization") String token, @RequestBody WallPostWrapper request) {
        String user;
        if (token != null && !token.contains("undefined") && (user = ((Claims)Jwts.parser().setSigningKey("SecretKeyToGenJWTs").parseClaimsJws(token.replace("Bearer ", "")).getBody()).getSubject()) != null) {
            WallPost wp = (WallPost)this.wallPostRepository.getOne((Object)request.getWallPost().getWall_post_id());
            if (wp == null) {
                throw new ResponseStatusException(HttpStatus.NOT_FOUND, "The post is not found!");
            }
            for (WallPostAttachment w : this.wallPostAttachmentRepository.findByWallPost(Long.valueOf(wp.getWall_post_id()))) {
                w.setWall_post_id(wp.getWall_post_id());
                this.wallPostAttachmentRepository.delete((Object)w);
            }
            wp.setText(request.getWallPost().getText());
            for (WallPostAttachment w : request.getAttachments()) {
                w.setWall_post_id(wp.getWall_post_id());
                this.wallPostAttachmentRepository.save((Object)w);
            }
            return new ResponseEntity((Object)((WallPost)this.wallPostRepository.save((Object)wp)), HttpStatus.OK);
        }
        throw new ResponseStatusException(HttpStatus.UNAUTHORIZED, "");
    }

    @PostMapping(value={"/delete/post"})
    @ResponseBody
    public ResponseEntity<WallPost> deletePost(@RequestParam(value="wall_post_id", defaultValue="aEn24") Long wall_post_id, @RequestHeader(value="Authorization") String token) {
        if (token != null && !token.contains("undefined")) {
            String user = ((Claims)Jwts.parser().setSigningKey("SecretKeyToGenJWTs").parseClaimsJws(token.replace("Bearer ", "")).getBody()).getSubject();
            if (user != null) {
                Account a = this.accountRepository.findByUsername(user);
                if (a == null) {
                    return new ResponseEntity(HttpStatus.NOT_FOUND);
                }
                Admin ad = this.adminRepository.findByUserName(user);
                if (ad != null) {
                    WallPost wp = (WallPost)this.wallPostRepository.getOne((Object)wall_post_id);
                    if (wp == null) {
                        throw new ResponseStatusException(HttpStatus.NOT_FOUND, "The post not found!!!.");
                    }
                    wp.setIsDeleted(Boolean.valueOf(true));
                    return new ResponseEntity((Object)((WallPost)this.wallPostRepository.save((Object)wp)), HttpStatus.OK);
                }
                Instructor instructor = this.instructorRepository.findByAccountId(Long.valueOf(a.getAccount_id()));
                if (instructor != null) {
                    WallPost wp = (WallPost)this.wallPostRepository.getOne((Object)wall_post_id);
                    if (wp == null) {
                        throw new ResponseStatusException(HttpStatus.NOT_FOUND, "The post not found!!!.");
                    }
                    wp.setIsDeleted(Boolean.valueOf(true));
                    return new ResponseEntity((Object)((WallPost)this.wallPostRepository.save((Object)wp)), HttpStatus.OK);
                }
                throw new ResponseStatusException(HttpStatus.UNAUTHORIZED, "Admin or Instructor can delete the post.");
            }
            throw new ResponseStatusException(HttpStatus.UNAUTHORIZED, "The user not found!!!.");
        }
        return new ResponseEntity(HttpStatus.UNAUTHORIZED);
    }

    @PostMapping(value={"/delete/posts"})
    @ResponseBody
    public ResponseEntity<WallPostsDeleteRequest> deletePosts(@RequestBody WallPostsDeleteRequest request, @RequestHeader(value="Authorization") String token) {
        if (token != null && !token.contains("undefined")) {
            String user = ((Claims)Jwts.parser().setSigningKey("SecretKeyToGenJWTs").parseClaimsJws(token.replace("Bearer ", "")).getBody()).getSubject();
            if (user != null) {
                Account a = this.accountRepository.findByUsername(user);
                if (a == null) {
                    return new ResponseEntity(HttpStatus.NOT_FOUND);
                }
                Admin ad = this.adminRepository.findByUserName(user);
                if (ad != null) {
                    ArrayList wall_post_ids = request.getWall_post_ids();
                    if (wall_post_ids == null) {
                        throw new ResponseStatusException(HttpStatus.NOT_FOUND, "Require wall_post_ids!!!.");
                    }
                    if (wall_post_ids.isEmpty()) {
                        throw new ResponseStatusException(HttpStatus.NOT_FOUND, "Require wall_post_ids!!!.");
                    }
                    for (Long wall_post_id : wall_post_ids) {
                        WallPost wp = (WallPost)this.wallPostRepository.getOne((Object)wall_post_id);
                        if (wp == null) {
                            throw new ResponseStatusException(HttpStatus.NOT_FOUND, "The post not found!!!.");
                        }
                        wp.setIsDeleted(Boolean.valueOf(true));
                        this.wallPostRepository.save((Object)wp);
                    }
                    request.setMessage("Posts deleted successfully.");
                    return new ResponseEntity((Object)request, HttpStatus.OK);
                }
                throw new ResponseStatusException(HttpStatus.UNAUTHORIZED, "Admin can delete the posts.");
            }
            throw new ResponseStatusException(HttpStatus.UNAUTHORIZED, "The user not found!!!.");
        }
        return new ResponseEntity(HttpStatus.UNAUTHORIZED);
    }

    @PostMapping(value={"/upload/file"})
    @ResponseBody
    public ResponseEntity<WallPostAttachment> uploadImage(@RequestParam(value="file") MultipartFile file, HttpServletResponse response, HttpServletRequest request) throws Exception {
        if (!file.isEmpty()) {
            Cloudinary cloudinary = new Cloudinary(ObjectUtils.asMap((Object[])new Object[]{"cloud_name", "veedbeta", "api_key", "843536583549614", "api_secret", "oCK-t2tOxYm_xofyio5PO2k93Us"}));
            Map uploadResult = cloudinary.uploader().upload((Object)file.getBytes(), ObjectUtils.emptyMap());
            WallPostAttachment w = new WallPostAttachment();
            w.setUrl((String)uploadResult.get("url"));
            return new ResponseEntity((Object)w, HttpStatus.OK);
        }
        return new ResponseEntity(HttpStatus.PARTIAL_CONTENT);
    }

    @GetMapping(value={"/get/post"})
    public ResponseEntity<WallPostProfileWrapper> getWallPostByWallPostId(@RequestParam(value="wall_post_id", defaultValue="aEn24") Long wall_post_id) {
        WallPost wp = (WallPost)this.wallPostRepository.getOne((Object)wall_post_id);
        if (wp == null) {
            throw new ResponseStatusException(HttpStatus.NOT_FOUND, "The post not found.");
        }
        if (wp.getIsDeleted() != null && wp.getIsDeleted().booleanValue()) {
            throw new ResponseStatusException(HttpStatus.NOT_FOUND, "The post is deleted.");
        }
        WallPostProfileWrapper wr = new WallPostProfileWrapper();
        WallPostWrapper wpr = new WallPostWrapper();
        wpr.setWallPost(wp);
        wpr.setAttachments(this.wallPostAttachmentRepository.findByWallPost(Long.valueOf(wp.getWall_post_id())));
        wr.setWallPost(wpr);
        if (wp.getType().toLowerCase().trim().equals("student")) {
            Student student = (Student)this.studentRepository.getOne((Object)wp.getStudent_id());
            wr.setStudent(student);
        }
        if (wp.getType().toLowerCase().trim().equals("instructor")) {
            Instructor instructor = (Instructor)this.instructorRepository.getOne((Object)wp.getInstructor_id());
            wr.setInstructor(instructor);
        }
        return new ResponseEntity((Object)wr, HttpStatus.OK);
    }

    @GetMapping(value={"/get/daily/toppicks"})
    public ResponseEntity<TopPicks> getCurrentDailyTopPicks(@RequestHeader(value="Authorization") String token) {
        AuthenticationController.isAuthenticated((String)token);
        TopPicks topPicks = this.topPicksRepository.findDailyTopPicks();
        if (topPicks == null) {
            throw new ResponseStatusException(HttpStatus.NOT_FOUND, "The daily Top Picks not found!");
        }
        return new ResponseEntity((Object)topPicks, HttpStatus.OK);
    }

    @DeleteMapping(value={"/delete/toppicks/{top_picks_id}"})
    public ResponseEntity<Message> deleteQuote(@RequestHeader(value="Authorization") String token, @PathVariable(value="top_picks_id") Long top_picks_id) {
        AuthenticationController.isAuthenticated((String)token);
        TopPicks topPicks = (TopPicks)this.topPicksRepository.getOne((Object)top_picks_id);
        if (topPicks == null) {
            throw new ResponseStatusException(HttpStatus.NOT_FOUND, "The Top Picks not found!");
        }
        if (topPicks.getIsDailyTopPicks().booleanValue()) {
            throw new ResponseStatusException(HttpStatus.CONFLICT, "The Top Picks is a Daily TopPicks, the Daily TopPicks can not be deleted.");
        }
        this.topPicksRepository.deleteById((Object)top_picks_id);
        Message message = new Message();
        message.setMessage("The TopPicks is deleted successfully.");
        return new ResponseEntity((Object)message, HttpStatus.OK);
    }

    @GetMapping(value={"/get/all/toppicks"})
    public ResponseEntity<List<TopPicks>> getAllQuotes(@RequestHeader(value="Authorization") String token) {
        AuthenticationController.isAuthenticated((String)token);
        return new ResponseEntity((Object)this.topPicksRepository.findAllOrderById(), HttpStatus.OK);
    }

    @PostMapping(value={"/create/toppicks"})
    @ResponseBody
    public ResponseEntity<TopPicks> createDailyQuote(@RequestHeader(value="Authorization") String token, @RequestBody TopPicks request) {
        AuthenticationController.isAuthenticated((String)token);
        return new ResponseEntity((Object)((TopPicks)this.topPicksRepository.save((Object)request)), HttpStatus.OK);
    }

    @PostMapping(value={"/update/toppicks"})
    @ResponseBody
    public ResponseEntity<TopPicks> updateDailyQuote(@RequestHeader(value="Authorization") String token, @RequestBody TopPicks request) {
        AuthenticationController.isAuthenticated((String)token);
        TopPicks topPicks = (TopPicks)this.topPicksRepository.getOne((Object)request.getTop_picks_id());
        topPicks.setQoute(request.getQuote());
        topPicks.setCreatedAt(topPicks.getCreatedAt());
        topPicks.setUpdateAt(new Date());
        return new ResponseEntity((Object)((TopPicks)this.topPicksRepository.save((Object)topPicks)), HttpStatus.OK);
    }

    @GetMapping(value={"/make/daily/toppicks"})
    @ResponseBody
    public ResponseEntity<TopPicks> makeDailyQuote() {
        List topPicksList = this.topPicksRepository.findAll();
        for (TopPicks topPicks : topPicksList) {
            topPicks.setCreatedAt(topPicks.getCreatedAt());
            topPicks.setUpdateAt(new Date());
            topPicks.setIsDailyTopPicks(Boolean.valueOf(false));
            this.topPicksRepository.save((Object)topPicks);
        }
        Random randomizerTopPicks = new Random();
        int random_index_topPicks = randomizerTopPicks.nextInt(topPicksList.size());
        TopPicks random_topPicks = (TopPicks)topPicksList.get(random_index_topPicks);
        random_topPicks.setCreatedAt(random_topPicks.getCreatedAt());
        random_topPicks.setIsDailyTopPicks(Boolean.valueOf(true));
        random_topPicks.setUpdateAt(new Date());
        return new ResponseEntity((Object)((TopPicks)this.topPicksRepository.save((Object)random_topPicks)), HttpStatus.OK);
    }
}

